/*
This program is an experiment to test the use of tuned damped
oscillators to recognise notes present in digital sound input.

Implemented by Martin Richards (c) Novemver 2009

There will be 512 tuners set to the frequencies of midi notes 0 to 127
at intervals of 1/4 of a semitone.

*/

GET "libhdr"

MANIFEST {
root48of2 = 1_014_545_335  // Actually   1.01454533494
}

GLOBAL {
freqtab:ug  // freqtab!(4*n) = frequency of midi note n from 0 to 127
cotab       // Table of tuner coroutines
kv          // Vector of tuner k values
dampv       // Vector of tunes damping values
}

LET init_freqtab() = VALOF
{ LET afrq = 32*440_000 // Frequency of A9 (midi note 129!)
  LET frq  = afrq
  freqtab := getvec(511)
  cotab   := getvec(511)

  IF cotab FOR i = 0 TO 511 DO cotab!i := 0

  UNLESS freqtab & cotab DO
  { writef("More space needed*n")
    RESULTIS FALSE
  }

  FOR i = 0 TO 511 DO freqtab!i := 0

  // Fill in the frequence of A for each octave
  FOR i = 4*129 TO 0 BY -4*12 DO
  { IF i<=511 DO freqtab!i := afrq
    afrq := afrq/2
  }
  // Fill in all entries from freqtab!(4*0+0) to freqtab!(4*127+3)
  FOR i = 4*129 TO 0 BY -1 DO
  { IF i<=511 TEST freqtab!i
              THEN frq := freqtab!i
              ELSE freqtab!i := frq
    //frq := (muldiv(10*frq, 1_000_000_000, root48of2)+5)/10 
    frq := (muldiv(10*frq, 2_000_000_000, 2*root48of2-10)+5)/10 
  }
  newline()
  //writef("freqtab!0      = %5.3d*n", freqtab!0)
  //writef("freqtab!(4x69) = %5.3d*n", freqtab!(4*69))

  kv := TABLE // The table of tuner k values
    1358, 1398, 1438, 1468,   // 4*  0
    0, 0, 0, 0,   // 4*  1
    0, 0, 0, 0,   // 4*  2
    0, 0, 0, 0,   // 4*  3
    0, 0, 0, 0,   // 4*  4
    0, 0, 0, 0,   // 4*  5
    0, 0, 0, 0,   // 4*  6
    0, 0, 0, 0,   // 4*  7
    0, 0, 0, 0,   // 4*  8
    1000000, 0, 0, 0,   // 4*  9
    0, 0, 0, 0,   // 4* 10
    0, 0, 0, 0,   // 4* 11
    0, 0, 0, 0,   // 4* 12
    0, 0, 0, 0,   // 4* 13
    0, 0, 0, 0,   // 4* 14
    0, 0, 0, 0,   // 4* 15
    0, 0, 0, 0,   // 4* 16
    0, 0, 0, 0,   // 4* 17
    0, 0, 0, 0,   // 4* 18
    0, 0, 0, 0,   // 4* 19
    0, 0, 0, 0,   // 4* 20
    1000000, 0, 0, 0,   // 4* 21
    0, 0, 0, 0,   // 4* 22
    0, 0, 0, 0,   // 4* 23
    0, 0, 0, 0,   // 4* 24
    0, 0, 0, 0,   // 4* 25
    0, 0, 0, 0,   // 4* 26
    0, 0, 0, 0,   // 4* 27
    0, 0, 0, 0,   // 4* 28
    0, 0, 0, 0,   // 4* 29
    0, 0, 0, 0,   // 4* 30
    0, 0, 0, 0,   // 4* 31
    0, 0, 0, 0,   // 4* 32
    1000000, 0, 0, 0,   // 4* 33
    0, 0, 0, 0,   // 4* 34
    0, 0, 0, 0,   // 4* 35
    0, 0, 0, 0,   // 4* 36
    0, 0, 0, 0,   // 4* 37
    0, 0, 0, 0,   // 4* 38
    0, 0, 0, 0,   // 4* 39
    0, 0, 0, 0,   // 4* 40
    0, 0, 0, 0,   // 4* 41
    0, 0, 0, 0,   // 4* 42
    0, 0, 0, 0,   // 4* 43
    0, 0, 0, 0,   // 4* 44
    491208, 0, 0, 0,   // 4* 45  A2
    0, 0, 0, 0,   // 4* 46
    0, 0, 0, 0,   // 4* 47
    0, 0, 0, 0,   // 4* 48
    0, 0, 0, 0,   // 4* 49
    0, 0, 0, 0,   // 4* 50
    0, 0, 0, 0,   // 4* 51
    0, 0, 0, 0,   // 4* 52
    0, 0, 0, 0,   // 4* 53
    0, 0, 0, 0,   // 4* 54
    0, 0, 0, 0,   // 4* 55
    0, 0, 0, 0,   // 4* 56
    982415, 0, 0, 0,   // 4* 57  A3
    0, 0, 0, 0,   // 4* 58
    0, 0, 0, 0,   // 4* 59
    0, 0, 0, 0,   // 4* 60
    0, 0, 0, 0,   // 4* 61
    0, 0, 0, 0,   // 4* 62
    0, 0, 0, 0,   // 4* 63
    0, 0, 0, 0,   // 4* 64
    0, 0, 0, 0,   // 4* 65
    0, 0, 0, 0,   // 4* 66
    0, 0, 0, 0,   // 4* 67
    0, 0, 0, 0,   // 4* 68
    3928700, 0, 0, 0,   // 4* 69  A4
    0, 0, 0, 0,   // 4* 70
    0, 0, 0, 0,   // 4* 71
    0, 0, 0, 0,   // 4* 72
    0, 0, 0, 0,   // 4* 73
    0, 0, 0, 0,   // 4* 74
    0, 0, 0, 0,   // 4* 75
    0, 0, 0, 0,   // 4* 76
    0, 0, 0, 0,   // 4* 77
    0, 0, 0, 0,   // 4* 78
    0, 0, 0, 0,   // 4* 79
    0, 0, 0, 0,   // 4* 80
    1000000, 0, 0, 0,   // 4* 81
    0, 0, 0, 0,   // 4* 82
    0, 0, 0, 0,   // 4* 83
    0, 0, 0, 0,   // 4* 84
    0, 0, 0, 0,   // 4* 85
    0, 0, 0, 0,   // 4* 86
    0, 0, 0, 0,   // 4* 87
    0, 0, 0, 0,   // 4* 88
    0, 0, 0, 0,   // 4* 89
    0, 0, 0, 0,   // 4* 90
    0, 0, 0, 0,   // 4* 91
    0, 0, 0, 0,   // 4* 92
    1000000, 0, 0, 0,   // 4* 93
    0, 0, 0, 0,   // 4* 94
    0, 0, 0, 0,   // 4* 95
    0, 0, 0, 0,   // 4* 96
    0, 0, 0, 0,   // 4* 97
    0, 0, 0, 0,   // 4* 98
    0, 0, 0, 0,   // 4* 99
    0, 0, 0, 0,   // 4*100
    0, 0, 0, 0,   // 4*101
    0, 0, 0, 0,   // 4*102
    0, 0, 0, 0,   // 4*103
    0, 0, 0, 0,   // 4*104
    1000000, 0, 0, 0,   // 4*105
    0, 0, 0, 0,   // 4*106
    0, 0, 0, 0,   // 4*107
    0, 0, 0, 0,   // 4*108
    0, 0, 0, 0,   // 4*109
    0, 0, 0, 0,   // 4*110
    0, 0, 0, 0,   // 4*111
    0, 0, 0, 0,   // 4*112
    0, 0, 0, 0,   // 4*113
    0, 0, 0, 0,   // 4*114
    0, 0, 0, 0,   // 4*115
    0, 0, 0, 0,   // 4*116
    1000000, 0, 0, 0,   // 4*117
    0, 0, 0, 0,   // 4*118
    0, 0, 0, 0,   // 4*119
    0, 0, 0, 0,   // 4*120
    0, 0, 0, 0,   // 4*121
    0, 0, 0, 0,   // 4*122
    0, 0, 0, 0,   // 4*123
    0, 0, 0, 0,   // 4*124
    0, 0, 0, 0,   // 4*125
    0, 0, 0, 0,   // 4*126
    0, 0, 0, 1000000    // 4*127
  RESULTIS TRUE
}

LET start() = VALOF
{ 
  UNLESS init_freqtab() GOTO fin

  FOR i = 0 TO 511 IF kv!i DO
  { 
    LET co = initco(tunerfn, 300, i)
  }

fin:
  IF freqtab DO freevec(freqtab)
  IF cotab DO
  { FOR i = 0 TO 511 IF cotab!i DO deleteco(cotab!i)
    freevec(cotab)
  }
  RESULTIS 0
}

AND tunerfn(args) = VALOF
{ LET i = args!0

  FOR j = 0 TO 100 DO
  { LET force   = kv!i + j*10
    LET damping = 0// dampv!i
    LET frq     = freqtab!i

    // First callibrate the oscillator
    LET x = 1_000_000_000/2
    LET xd = 0             // x dot

    LET amp = 0            // Max x during last half cycle
    LET xmax = x           // Max x during this half cycle
    LET count = 0          // Count of half cycles
    LET ticks = 0          // Count of iterations
    LET started = FALSE

    WHILE count<5000 DO
    { LET xdd = - muldiv(x, force, 1_000_000_000)  // x dot dot
      xd := xd + xdd
      x := x + xd
      IF xd > 1_000_000_000 DO x := 1_000_000_000
      TEST x>=0
      THEN { IF x > xmax DO xmax := x
           }
      ELSE { amp := xmax
             x := -x
             xd := -xd
             xmax := x
             count := count+1
             // Initialise ticks and count the first time x passes through zero
             UNLESS started DO started, ticks, count := TRUE, 0, 0
           }
      ticks := ticks+1
    }
    { LET f = muldiv(44100*1000/2, count, ticks)
      writef("%i3: k=%9.6d ticks=%i6/%n frequency=%5.3d desired frequency=%9.3d*n",
            i, force, ticks, count, f, frq)
      IF f>=frq DO
      { abort(1000)
        BREAK
      }
    }
  }
}
