GET "libhdr"

GLOBAL {
  stdin:ug // Standard input
  stdout   // Standard output
  toname   // name of output file
  tostream // Output stream for .wav recording
  format   // 16 = S16_LE
  channels // 1=mono 2=stereo
  rate     // Sample rate
  buf      // Buffer for input samples 
  secs     // Recording time in seconds
  freqtab

  sample_count
  vce1co; vce1fa
  vce2co; vce2fa
  vce3co; vce3fa
  vce4co; vce4fa
  vce5co; vce5fa
}

MANIFEST {
  bufsize = 4096/4
  bufbytes = bufsize * bytesperword
}

LET wr2(a) BE
{ binwrch(a&255)
  binwrch(a>>8)
}

AND wr4(a) BE
{ wr2(a)
  wr2(a>>16)
}

LET start() = VALOF
{ LET argv = VEC 50

  stdin := input()
  stdout := output()

  toname := "junk.wav"
  tostream := 0

  format := 16  // S16_LE
  channels := 1 // Mono
  rate := 44100 // Samples per second
  buf := getvec(bufsize-1)
  secs := 20
  sample_count := 0

  setfreqtab()

  UNLESS rdargs("secs/n,rate/n,to/k", argv, 50) DO
  { writef("Bad args for gensw*n")
    GOTO fin
  }

  IF argv!0 DO secs := !(argv!0)   // secs
  IF argv!1 DO rate := !(argv!1)   // rate
  IF argv!2 DO toname := argv!2    // to

  writef("Generating %n secs of square waves to file %s rate %n*n",
          secs, toname, rate)

  IF toname DO
  { tostream := findoutput(toname)
    UNLESS tostream DO
    { writef("Trouble with file: %s*n", toname)
      GOTO fin
    }
  }

  vce1co := initco(squarefn, 300, freqtab!69, 5000)  // A4
  vce1fa := result2 // -> [freq, amplitude]
  vce2co := initco(squarefn, 300, freqtab!60, 5000)  // C4
  vce2fa := result2 // -> [freq, amplitude]
  vce3co := initco(squarefn, 300, freqtab!72, 5000)  // C5
  vce3fa := result2 // -> [freq, amplitude]
  vce4co := initco(squarefn, 300, freqtab!50, 5000)  // D3
  vce4fa := result2 // -> [freq, amplitude]
  vce5co := initco(squarefn, 300, freqtab!28, 5000)  // F1
  vce5fa := result2 // -> [freq, amplitude]

  UNLESS vce1co & vce2co & vce3co & vce4co & vce5co DO
  { writef("More space needed*n")
    GOTO fin
  }



  IF tostream DO
  { selectoutput(tostream)
    writes("RIFF")        //  0: R I F F
    wr4(36+0)             //  4: size of this file - 8
    writes("WAVE")        //  8: W A V E
    writes("fmt ")        // 12: f m t      sawritef("Recorded %i2 seconds out of %i2*n", i, secs)

    wr4(format)           // 16: fmt subchunk size is 16
    wr2(1)                // 20: 1 = linear quantisation
    wr2(channels)         // 22: 1 = mono, 2=stereo
    wr4(rate)             // 24: samples per second
    wr4(rate*channels*16)        // 28: bytes per second
    wr2(2*channels)       // 32: bits/8 * mode  = 1, 2 or 4
    wr2(16  )             // 34: bits per sample  = 8 or 16
    writes("data")        // 36: d a t a
    //wr4(byte_rate * 1)    // 40: number of bytes of data or zero
    wr4(-1)               // 40: number of bytes of data or -1
  }

  //FOR n = 24 TO 84  DO
//  FOR n = 69 TO 69  DO
//  { LET f = freqtab!n
  //FOR f = 250_000 TO 520_000 BY 1_000 DO
  //FOR f = freqtab!21 TO freqtab!95 BY 1_000 DO
  FOR n = 21 TO 95-1 FOR p = 0 TO 9 DO
  { LET f1, f2 = freqtab!n, freqtab!(n+1)
    LET f = (f1*(10-p) + f2*p)/10

    selectoutput(stdout)
    writef("Time %8.3d: f=%8.3d  f1=%8.3d f2=%8.3d*n", sample_count*10/441, f, f1, f2)
    writef("Time %8.3d: f=%8.3d*n", sample_count*10/441, f)
    //writef("Starting note: %i3  freq %8.3d  name ", n, f)
    //wrnotename(n)
    //newline()
    selectoutput(tostream)
    vce1fa!0 := f
    //vce2fa!0 := 440_000
    //abort(1000)
    //FOR i = 1 TO 44100/4 DO // Generate a wave for 1/4 secs
    FOR i = 1 TO 44100/10 DO // Generate a wave for 1/10 secs
    //FOR i = 1 TO 44100/20 DO // Generate a wave for 1/20 secs
    { LET a = callco(vce1co)
      //LET b = callco(vce2co)
      //LET c = callco(vce3co)
      //LET d = callco(vce4co)
      //LET e = callco(vce5co)
      LET val = a//+b/2+c/2+d/2+e/2
      sample_count := sample_count+1
      wr2(val)
//sawritef("sample %i6: f=%8.3d val=%i5*n", sample_count, f, val)
//abort(1000)
    }
  }

fin:
  IF vce1co DO deleteco(vce1co)
  IF vce2co DO deleteco(vce2co)
  IF vce3co DO deleteco(vce3co)
  IF vce4co DO deleteco(vce4co)
  IF vce5co DO deleteco(vce5co)
  IF tostream DO endstream(tostream)
  RESULTIS 0
}

AND squarefn(args) = VALOF
{ // args!0 = ddd.ddd  scaled frequency
  // args!1 = the amplitude, typically 0..1000
  // The first call return a two word vector holding
  // the frequency and amplitude. These values can be changed
  // anytime by the caller.
  // Subsequent calls (assumed to be at 44100 per second) yield
  // samples representing the square wave at the current frequency
  // and amplitude.
  LET freq, amplitude = args!0, args!1
  LET lastsamp = 0
  LET x = 0
  //sawritef("squarefn: @freq=%n*n", @freq)
  cowait(@freq)  // Return a pointer to [freq, amplitude]
//abort(3000)
  { // Generate square wave samples
    UNTIL x > 44_100*1000/2 DO
    { cowait(amplitude)
      x := x + freq
//sawritef("squarefn: freq=%8.3d x=%8.3d*n", freq, x)
//abort(2000)
    }
    UNTIL x > 44_100*1000 DO
    { cowait(-amplitude)
      x := x + freq
//sawritef("squarefn: freq=%8.3d x=%8.3d*n", freq, x)
//abort(2000)
    }
    x := x - 44_100*1000
  } REPEAT
}

AND setfreqtab() BE
{ // Set freqtab so that freetab!n = 1000 * the note frequency
  // where n is the MIDI note number. n=60 for middle C (C4).

  // Only notes with non zero frequencies will have recognisers.

  freqtab := TABLE
     8_176,   8_662,   9_178,   9_723,  10_301,  10_914, //   0 c-1.. b-1
    11_563,  12_250,  12_979,  13_750,  14_568,  15_434,

    16_352,  17_324,  18_355,  19_446,  20_602,  21_827, //  12 c0 .. b0
    23_125,  24_500,  25_957,  27_500,  29_136,  30_868,

    32_703,  34_648,  36_709,  38_891,  41_204,  43_654, //  24 c1 .. b1
    46_250,  49_000,  51_914,  55_000,  58_271,  61_736,
  
    65_406,  69_296,  73_417,  77_782,  82_407,  87_308, //  36 c2 .. b2
    92_499,  97_999, 103_827, 110_000, 116_541, 123_471,

   130_812, 138_592, 146_833, 155_564, 164_814, 174_615, //  48 c3 .. b3
   184_998, 195_998, 207_653, 220_000, 233_082, 246_942,

   261_623, 277_183, 293_665, 311_127, 329_628, 349_229, //  60 c4 .. b4
   369_995, 391_996, 415_305, 440_000, 466_164, 493_884,

   523_245, 554_366, 587_330, 622_254, 659_255, 698_457, //  72 c5 .. b5
   739_989, 783_991, 830_610, 880_000, 932_328, 987_767,

  1046_489,1108_731,1174_659,1244_508,1318_510,1396_913, //  84 c6 .. b6
  1479_978,1567_982,1661_219,1760_000,1864_655,1975_533,

  2092_978,2217_461,2349_318,2489_016,2637_020,2793_826, //  96 c7 .. b7
  2959_955,3135_963,3322_438,3520_000,3729_310,3951_066,

  4185_955,4434_922,       0,       0,       0,       0, // 108 c8 .. b8
         0,       0,       0,       0,       0,       0,

         0,       0,       0,       0,       0,       0, // 120 c9 .. g9
         0,       0

  // Check the table
  checktab( 98, 2349_318)
  checktab( 99, 2489_016)
  checktab(100, 2637_020)
  checktab(101, 2793_826)
  checktab(102, 2959_955)
  checktab(103, 3135_963)
  checktab(104, 3322_438)
  checktab(105, 3520_000)
  checktab(106, 3729_310)
  checktab(107, 3951_066)
  checktab(108, 4185_955)
  checktab(109, 4434_922)
}

AND checktab(n, f) BE WHILE n>=0 DO
  { UNLESS freqtab!n = f DO
    { writef("note=%i3 change %8.3d to %8.3d*n", n, freqtab!n, f)
      abort(1000)
    }
    n, f := n-12, (f+1)/2
  }


AND wrnotename(n) BE
{ LET oct = n/12 - 1
  LET note = n MOD 12
  UNLESS 0<=n<=127 DO
  {  writef("Bad")
     RETURN
  }

  SWITCHON note INTO
  { DEFAULT: writef("Bad");           RETURN
    CASE  0:  writef( "c%n",  oct);   RETURN
    CASE  1:  writef( "c#%n", oct);   RETURN
    CASE  2:  writef( "d%n",  oct);   RETURN
    CASE  3:  writef( "d#%n", oct);   RETURN
    CASE  4:  writef( "e%n",  oct);   RETURN
    CASE  5:  writef( "f%n",  oct);   RETURN
    CASE  6:  writef( "f#%n", oct);   RETURN
    CASE  7:  writef( "g%n",  oct);   RETURN
    CASE  8:  writef( "g#%n", oct);   RETURN
    CASE  9:  writef( "a%n",  oct);   RETURN
    CASE 10:  writef( "a#%n", oct);   RETURN
    CASE 11:  writef( "b%n",  oct);   RETURN
  }
}           

