// Implementation of BCPL style coroutines in Java
// by Martin Richards (c) April 2005

package Cortn;

public abstract class Cortn extends Thread {
    public String coName;

    public static Cortn currco = null;  // The current coroutine

    protected Cortn parent; // This coroutine's parent
    protected Object val;   // The value given to this coroutine
                            // when it was last given control

    public Cortn(String name) {
    	setName("T_"+name); // Set the thread name
	coName = name;

	Cortn co = currco;
	currco = this;
	parent = co;
	start();

	if (co==null) {
	    // The root coroutine has just been started,
	    // so wait for it to finish.

	    //System.out.println(coName+
	    //                   ": Wait for the root coroutine to finish");
	    try {        // Wait for the root coroutine to finish
		join();
	    } catch(Exception e) {}

	    //System.out.println(coName+": This root coroutine has finished");

	} else {
	    // A non-root coroutine has been started,
	    // so wait until control returns to us.
	    co.currcoWait();
	}
    }

    public void run() {
	// If parent is null, we are the root coroutine,
	// so just call fn.

	if (parent==null) {
	    fn(null);
	} else {
	    // We are a non-rrot coroutine, so just enter the
	    // normal loop

	    Object c = null;
	    while(true) c = fn(cowait(c));
	}
    }

    public abstract Object fn(Object c);

    // Conventional coroutine API

    public Object callco(Cortn target, Object arg) {
	target.parent = this;
	target.val = arg;
	currco = target;

	// Transfer control to the target coroutine.
	target.unwait();
	// Wait until we are the current coroutine
	currcoWait();

	return val;
    }

    public Object resumeco(Cortn target, Object arg) {
	Cortn p = parent;   // Ensure that resumeco can resume itself
	parent = null;      // ie when target==currco
	target.parent = p;
	target.val = arg;
	currco = target;

	System.out.println(coName+": resumeco called => "+target.coName);

	// Transfer control to the target coroutine.
	target.unwait();
	// Wait until we are the current coroutine
	currcoWait();

	return val;
    }

    public Object cowait(Object arg) {
	Cortn target = parent;

	parent = null;
	target.val = arg;
	currco = target;

	// Transfer control to the target coroutine.
	target.unwait();
	// Wait until we are again the current coroutine
	currcoWait();

	return val;
    }

    // Internal support functions

    public synchronized void currcoWait() {
	try {
	    while (currco!=this) wait();
	}
	catch(Exception e) {}
    }

    public synchronized void unwait() {
	// Release all this object's threads.
	// Note that there may be threads other than the waiting
	// coroutine, so notify() alone is not sufficient.
	// If in doubt, try it.
	notifyAll();
    }
}
