/*
This is a Java translation of the BCPL benchmark cobench.b.

Implemented by martin Richards (c) 30 November 2015.

When run on my laptop, with the default setting of k and n, it takes
99.3 secs.

solestreet:$ make bench500
time java Cobench -k 10000 -n 500

Cobench sending 10000 numbers via 500 copy coroutines

Cobench done
99.35user 92.03system 3:39.29elapsed 87%CPU (0avgtext+0avgdata 119824maxresident)k
0inputs+336outputs (0major+8136minor)pagefaults 0swaps
solestreet:$ 

But the BCPL version using Cintcode interpretive code takes
only 1.8 secs.
solestreet:$ make bench
time cintsys -c cobench -k 10000 -n 500

BCPL 32-bit Cintcode System (21 Oct 2015)
0.000> 
Cobench sending 10000 numbers via 500 copy coroutines


Cobench done
1.820> 
1.81user 0.04system 0:02.00elapsed 92%CPU (0avgtext+0avgdata 82944maxresident)k
0inputs+0outputs (0major+5267minor)pagefaults 0swaps
solestreet:$ 

If anyone can tell me why the Java version is so slow I would
love to know.
*/

import Cortn.*;

public class Cobench
{

    static int k = 10000;
    static int n = 500;
    static boolean tracing = false;

    public static void main(String[] args)
    {
	try {

	    for (int i = 0; i < args.length; i++) {
		// System.out.println("arg[i] = " + args[i]);
		if (args[i].equals("-k")) {
		    k = Integer.parseInt(args[++i]);
		    continue;
		}
		
		if (args[i].equals("-n")) {
		    n = Integer.parseInt(args[++i]);
		    continue;
		}

		if (args[i].equals("-t")) {
		    tracing = true;
		    continue;
		}
	    }
	    
	} 
	catch (NumberFormatException e) {
	    System.err.println("Integer argument expected");
	}

	Cortn s = new root("root");

	System.exit(0);
    }
}

abstract class ChannelCortn extends Cortn
{   // This class models Occum style channels.
 
    public ChannelCortn(String name) {
	super(name);
    }

    public Object coread(Channel chan) {
	Cortn cptr = chan.cptr;
        if (cptr!=null) {
	    chan.cptr = null;
	    return resumeco(cptr, this);
	} else {
	    chan.cptr = this;
	    return cowait(null);
	}
    }

    public void cowrite(Channel chan, Object val) {
	Cortn cptr = chan.cptr;
	if(cptr!=null) {
	    chan.cptr = null;
	    callco(cptr, val);
	} else {
	    chan.cptr = this;
	    callco((Cortn)cowait(null), val);
	}
    }
}

class root extends ChannelCortn
{   // This class models the root coroutine.

    public root(String name) {
	super(name);
	coName = name;
    }

    public Object fn(Object c) {
	int k = Cobench.k;
	int n = Cobench.n;
	Cortn cptr;

	System.out.println("\nCobench sending " + k +
                           " numbers via " + n +
                           " copy coroutines");

	cptr = new Sinkfn(this, "sinkco");

        for(int i = 1; i<= n; i++) {
	    Cortn co = new Copyfn(this, "copyco_"+i);
	    // Tell this coroutine where to send values to.
	    callco(co, cptr);
	    cptr = co;
	}

        Cortn source_co = new Sourcefn(this, "sourcefn");
	// Tell this coroutine where to send values to.
        callco(source_co, cptr);

	if(Cobench.tracing)
	    System.out.println("\nAll coroutines created\n");

        callco(source_co, new Integer(k)); // Tell source_co to send k numbers

        System.out.println("\nCobench done");

	return null;
  }
}

class Channel {
    Cortn cptr;
}

class Sourcefn extends ChannelCortn
{
    public Sourcefn(Cortn parent, String name) {
	super(name);
    }

    public Object fn(Object c) {
        Cortn nextco = (Cortn)c;
	Channel channel = new Channel();
	int k = ((Integer)cowait(null)).intValue();
	//if(Cobench.tracing) {
	//    System.out.println("srcefn: k = " + k);
	//}
	callco(nextco, channel);

	for(int i=1; i<=k; i++) {
	    if(Cobench.tracing)
		System.out.println("srcefn: sending number " + i);
	    cowrite(channel, new Integer(i));
	}
	if(Cobench.tracing)
	    System.out.println("srcefn: sending number " + 0);
	cowrite(channel, new Integer(0));
	return null;
    }
}

class Copyfn extends ChannelCortn
{
    public Copyfn(Cortn parent, String name) {
	super(name);
    }

    public Object fn(Object c) {
        Cortn   nextco      = (Cortn) c;
	Channel in_channel  = (Channel) cowait(null);
	Channel out_channel = new Channel();
	if(c==null)
	    System.out.println(coName+": c=null");
	callco(nextco, out_channel);

        while(true) {
	    Object val = coread(in_channel);
	    int k = ((Integer)val).intValue();
	    if(Cobench.tracing)
		System.out.println("copyfn: copying number " + k);
	    cowrite(out_channel, val);
            if(k==0) break;
	}

	return null;
    }
}

class Sinkfn extends ChannelCortn
{
    public Sinkfn(Cortn parent, String name) {
	super(name);
    }

    public Object fn(Object c) {
	Channel in_channel = (Channel)c;

        while(true) {
	    Object val = coread(in_channel);
	    int k = ((Integer)val).intValue();
	    if(Cobench.tracing)
		System.out.println("sinkfn: recving number " + k);
            if(k==0) break;
	}

	return null;
    }
}

