// This is a BCPL style coroutine package implemented
// in C using setjmp and longjmp and some Intel assembler.

// Implemented by Jeremy Singer
// Modified by Martin Richards 21/6/04

#include <stdlib.h>
#include <stdio.h>
#include <setjmp.h>
#include <assert.h>

typedef struct cobase *cortn;

struct cobase
{
  int id;     /* integer id for debugging */
  cortn parent;  /* parent coroutine */
  jmp_buf env;     /* program counter */
};

typedef union  // Coroutine argument variations
{ int     i;   // An integer
  cortn   c;   // A coroutine pointer
  cortn  *p;   // A pointer to a coroutine pointer
} coval;


typedef coval (*cofn)(coval);

// We really need one currco_val and currco per thread, if using threads.
coval currco_val;  /* global var to pass values between coroutines */
cortn currco; /* global var holding currently executing coroutine */

int nextid=1;  // Used for the id field of new coroutines.

int globalvar1;   // global vars for use when switching stacks.
int globalvar2;   // (local vars get corrupted!)
int globalvar3;


coval cowait(coval arg) {
  if (setjmp(currco->env) == 0) {
    // need to suspend coroutine
    currco_val = arg;
    //assert (currco->parent != NULL);
    currco = currco->parent;
    longjmp(currco->env, -1);
  }
  else {
    // reach here via longjmp - when coroutine resumes
    return currco_val;

  }
}


coval callco(cortn cptr, coval arg) {
  if (setjmp(currco->env) == 0) {
    // need to suspend coroutine
    cptr->parent = currco;
    currco_val = arg;
    currco = cptr;
    longjmp(cptr->env, -1);
  }
  else {
    // reach here when coroutine resumes
    return currco_val;
  }
}

coval resumeco(cortn cptr, coval arg) {
  if (setjmp(currco->env) == 0) {
    // suspend current coroutine,
    // give its parent to cptr.
    // It must work even when currco==cptr.
    cortn p = currco->parent;
    currco->parent = NULL;
    cptr->parent = p;
    currco_val = arg;
    currco = cptr;
    longjmp(cptr->env, -1);
  }
  else {
    // reach here when coroutine resumes
    return currco_val;
  }
}

/***
 * createco() - creates a new coroutine
 * Allocates a new area of stack space,
 * the size is specified (in ints) by the size parameter.
 * The coroutine body function specified by the fn parameter.
 */

cortn createco(volatile cofn fn, int size) {

  int bytes = sizeof(struct cobase) + sizeof(int[size]);

  // create new coroutine
  volatile cortn cptr = (cortn)malloc(bytes);
  coval c = (coval) cptr;

  cptr->parent = currco;
  cptr->id = nextid++;

  assert (currco != NULL);
  if (setjmp(currco->env) == 0) {
    // suspend current coroutine
    currco = cptr;
    // and switch stack to new coroutine
    
    globalvar1 =
      (int)((char*)cptr + bytes - 48); // leave space above ebp for args!!
    globalvar2 = globalvar1 - 20; // leave space below ebp for locals!!
    
    globalvar3 = (int)fn;

    asm ("movl %0, %%esp;"
	 "movl %1, %%ebp;"
	 ::"g"(globalvar2), "g"(globalvar1)
	 );
    
    fn = (cofn)globalvar3;  // restore argument to be preserved!
    
    while (1) { c = fn(cowait(c)); }
  }
  else {
    // resume here with longjmp
    return cptr;
  } 
}

coval deleteco(coval cptr) {
  free(cptr.p);
}

coval startrootco(cofn fn) {
  // When there is no parent coroutine...
  // i.e. for first coroutine to be created...

  // create new coroutine
  cortn cptr = (cortn)malloc(sizeof(struct cobase));
  cptr->parent = NULL;
  cptr->id = nextid++;
  
  currco = cptr;

  // JDS31 - let initial coroutine continue to run in C stack,
  // since we do want to return from the initco() fn properly...
  
  return fn((coval)-1);  /* JDS31 - not allowed to call cowait here!!
		         * since currco has no parent
  		         */
}
