/*
** This is CLIB for BCPL compiled into native code
**
** It is based on cintmain.c from the BCPL Cintcode system and is
** meant to run on most machines with a Unix-like C libraries.
**
** (c) Copyright:  Martin Richards  21 April 2004
**
** This code contains many improvements suggested by Colin Liebenrood.
**
*/

/*
21/4/04  Made many changes and improvements suggested by Colin Liebenrood
7/11/96  Systematic changes to allow 64 bit implementation on the ALPHA
23/7/96  First implementation
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/timeb.h>
#include <signal.h>

/* bcpl.h contains machine/system dependent #defines  */
#include "bcpl.h"

static WORD result2;
static WORD prefix;
WORD *rootnode;
static char *parms;  // vector of command-line arguments
static WORD ttyinp;  // true if stdin is a tty

/* prototypes for forward references */
static WORD muldiv(WORD a, WORD b, WORD c);
static char *b2c_fname(WORD bstr, char *cstr);
static char *b2c_str(WORD bstr, char *cstr);
static WORD c2b_str(char *cstr, WORD bstr);

/* Function defined in graphics.c  */
extern INT32 sysGraphics(INT32 *p);
INT32 sysGraphics(INT32 *p) { return 0; } /* Dummy definition */

#define Globword  0xEFEF0000L
#define Gn_result2    10

int badimplementation(void)
{ int bad = 0, A='A';
  SIGNEDCHAR c = 255;
  if(sizeof(WORD)!=BPW || A!=65) bad = 1;
  if (c/-1 != 1) { printf("There is a problem with SIGNEDCHAR\n");
                   bad = 1;
                 }
  return bad;
}

void initfpvec(void)    { return; }
WORD newfno(FILE *fp)   { return WD fp; }
WORD freefno(WORD fno) { return fno; }
FILE *findfp(WORD fno)  { return (FILE *)fno; }

/* storage for SIGINT handler */
void (*old_handler)(int);

void handler(int sig)
{ 
  printf("SIGINT received\n");
  old_handler = signal(SIGINT, old_handler);
  close_keyb();
  exit(20);
}

int main(int argc, char *argv[])
{ WORD i;      /* for FOR loops  */

  if ( badimplementation() )
  { printf("This implementation of C is not suitable\n");
    return 20;
  }

  /* Try to reconstruct the command line arguments from argv */
  parms = (char *)(MALLOC(256));

  { int p=0;
    parms[0] = 0;

    for (i=1; i<argc; i++) {
      char *arg = argv[i];
      int len = strlen(arg);
      int j;
      int is_string = 0;
      //printf("clib: getting command line, len=%d\n", len);
      for (j=0; j<len; j++) if( arg[j]==' ' || arg[j]=='\n') is_string = 1;
      //printf("clib: getting command line, is_string=%d\n", is_string);
      parms[p++] = ' ';
      if(is_string)
      { parms[p++] = '"';
      for (j=0; j<len; j++)
        { int ch = arg[j];
          if(ch=='\n') { parms[p++] = '*'; parms[p++] = 'n'; }
	  else parms[p++] = ch;
        }
        parms[p++] = '"';
      } else {
        for (j=0; j<len; j++) parms[p++] = arg[j];
      }
      parms[0] = p-1; // Fill in the BCPL string length
    }
    //printf("clib: args: len=%d\n", parms[0]);
    //for(i=1; i<=parms[0];i++) printf("parm[%d]=%d\n", i, parms[i]);
    //printf("\n");
  }

  //  parms = (WORD *)(MALLOC(argc+1));
  //parms[0] = argc > 1 ? argc : 0;
  //for (i = 0; i < argc; i++) {
  //  WORD v = (WORD)(MALLOC(1+strlen(argv[i]) / BPW)) >> B2Wsh;
  //  c2b_str(argv[i], v);
  //  parms[1+i] = v;
  //}

  old_handler = signal(SIGINT, handler);
  initfpvec();

  WORD *globbase  = (WORD *)(calloc((gvecupb +1), BPW));
  if(globbase==0) 
    { printf("unable to allocate space for globbase\n");
      exit(20);
    }

  WORD *stackbase = (WORD *)(calloc((stackupb+1), BPW));
  if(stackbase==0) 
    { printf("unable to allocate space for stackbase\n");
      exit(20);
    }

  globbase[0] = gvecupb;

  for (i=1;i<=gvecupb;i++) globbase[i] = Globword + i;
  for (i=0;i<=stackupb;i++) stackbase[i] = 0;

  //  printf("clib: gvecupb=%d stackupb=%d\n", gvecupb, stackupb);
  initsections(globbase);
  ttyinp = init_keyb();

  /* Enter BCPL start function: callstart is defined in mlib.s */
  WORD res = callstart(stackbase, globbase);

  close_keyb();

  if (res) printf("\nExecution finished, return code %ld\n", (long)res);

  free(globbase);
  free(stackbase);
  free(parms);

  return res;
}


WORD muldiv(WORD a, WORD b, WORD c)
{ unsigned WORD q=0, r=0, qn, rn;
  unsigned WORD ua, ub, uc;
  int qneg=0, rneg=0;
  /*  printf("muldiv: a=%d b=%d c=%d\n", a, b, c); */
  if(c==0) c=1;
  if(a<0) { qneg=!qneg; rneg=!rneg; ua = -a; }
  else                              ua =  a;
  if(b<0) { qneg=!qneg; rneg=!rneg; ub = -b; }
  else                              ub =  b;
  if(c<0) { qneg=!qneg;             uc = -c; }
  else                              uc =  c;
  
  qn = ub / uc;
  rn = ub % uc;
  
  while(ua)
  { if(ua&1) { q += qn;
               r += rn;
               if(r>=c) { q++; r -= uc; }
             }
    ua >>= 1;
    qn <<= 1;
    rn <<= 1;
    if(rn>=uc) {qn++; rn -= uc; }
  }
  result2 = rneg ? -r : r;
  return qneg ? -q : q;
}

static char chbuf[256], chbuf2[256]; /* to hold filenames */

int relfilename(char *name)
{ if(name[0]==FILE_SEP_CH ||
     /* The following is fiddle for MSDOS/Windows */
     FILE_SEP_CH=='\\' && 'A'<=name[0] && name[0]<='Z' && name[1]==':')
       return 0; /* Absolute file names don't use paths */
  return 1; 
}

FILE *pathinput(char *name, char *pathname)
{ FILE *fp = fopen(name, "r");
  char filename[1024];
  int itemsep = FILE_SEP_CH=='/' ? ':' : ';';
  if (fp==0)
  { if (pathname && relfilename(name))
    { char *path = getenv(pathname);
      while(path && fp==0)
      { char *f=filename,
             *n=name;
        while(*path==itemsep) path++;
        if(*path==0) break;
        while(*path!=0 && *path!=itemsep) *f++ = *path++;
        if(f[-1]!=FILE_SEP_CH) *f++ = FILE_SEP_CH;
        while(*n) *f++ = *n++;
        *f = 0;
        fp = fopen(filename, "r");
      }
    }
  }
  return fp;
}

/* dosys(P, G) called from mlib.s in response to
** BCPL call res := sys(n, x, y, ....). Arguments p & g are the
** OCODE stack-pointer P and Global vector pointer G. The arguments
** to sys() are n = p[3], x = p[4] ....
** sys(0, r) is trapped in mlib.s
*/

WORD dosys(register WORD *p, register WORD *g)
{ register WORD i;

  switch((int)(p[3]))
  {  default: printf("\nBad sys %ld\n", (long)p[3]);  return p[3];
  
     // case Sys_setcount: set count               -- done in cinterp
     // case Sys_quit:     return from interpreter -- done in cinterp

     // case Sys_rti:      sys(Sys_rti, regs)      -- done in cinterp  Cintpos
     // case Sys_saveregs: sys(Sys_saveregs, regs) -- done in cinterp  Cintpos
     // case Sys_setst:    sys(Sys_setst, st)      -- done in cinterp  Cintpos
     //case Sys_tracing:  // sys(Sys_tracing, b)
     //        tracing = W[p+4];
     //        return 0;
     // case Sys_watch:    sys(Sys_watch, addr)    -- done in cinterp

     //case  Sys_tally:         /* sys(Sys_tally, flag)     */
     //        if(W[p+4]) {
     //           tallylim = tallyupb;
     //           for(i=1; i<=tallylim; i++) tallyv[i] = 0;
     //         } else {
     //           tallylim = 0;
     //         }
     //         return 0;
     
     //case Sys_interpret: /* call interpreter (recursively) */
     //        { WORD regsv = W[p+4];
     //          if(W[regsv+7]<0) return CINTASM  (regsv, W);
     //          return interpret(regsv, W);
     //        }

     case Sys_sardch:
              { WORD ch = Readch();
                if (ttyinp) {  // echo tty input only
                   if (ch>=0) putchar((char)ch);
                   if(ch==13) { ch = 10; putchar(10); }
                   fflush(stdout);
		}
                return ch;
              }

     case Sys_sawrch:
              if(p[4] == 10) putchar(13);
              putchar((char)p[4]);
              fflush(stdout);
              return 0;

     case Sys_read:  // bytesread := sys(Sys_read, fp, buf, bytecount)
              { FILE *fp = findfp(p[4]);
                char *bbuf = (char *)(p[5]<<B2Wsh);
                WORD len   = p[6];
                len = fread(bbuf, (size_t)1, (size_t)len, fp);
                return len;
              }

     case Sys_write:
              { FILE *fp = findfp(p[4]);
                char *bbuf = (char *)(p[5]<<B2Wsh);
                WORD len = p[6];
                len = WD fwrite(bbuf, (size_t)1, (size_t)len, fp);
                fflush(fp);
                return len;
              }

     case Sys_openread:
              { FILE *fp = pathinput(b2c_fname(p[4], chbuf),
                                     b2c_fname(p[5], chbuf2));
                if (fp==0) return 0L;
                return newfno(fp);
              }

     case Sys_openwrite:
              { FILE *fp = fopen(b2c_fname(p[4], chbuf), "w");
                if(fp==0) return 0L;
                return newfno(fp);
              }

     case Sys_openreadwrite:
              { FILE *fp = fopen(b2c_fname(p[4], chbuf), "r+");
                if(fp==0) fp = fopen(b2c_fname(p[4], chbuf), "w+");
                if(fp==0) return 0L;
                return newfno(fp);
              }

     case Sys_close:
              { WORD res = ! fclose(findfp(p[4]));
                freefno(p[4]);
                return res;
              }

     case Sys_deletefile:
              return ! REMOVE(b2c_str(p[4], chbuf));

     case Sys_renamefile:
              REMOVE(b2c_str(p[5], chbuf2));
              return ! rename(b2c_str(p[4], chbuf), chbuf2);

     case Sys_getvec:
              return ((WORD)(malloc((1+p[4])*BPW)))>>B2Wsh;

     case Sys_freevec:
              free((void *)(p[4]<<B2Wsh)); return -1;
/*
     case Sys_loadseg:
              return loadseg(b2c_str(p[4], chbuf));
     case Sys_globin:
              return globin(p[4], g);
     case Sys_unloadseg:
              unloadseg(p[4]);                    return 0;
*/

     case Sys_muldiv:
              { WORD res =  muldiv(p[4], p[5], p[6]);
                g[Gn_result2] = result2;
                return res;
              }

     case Sys_intflag:
                return intflag() ? -1L : 0L;

/*
     case Sys_setraster:
              return setraster(p[4], p[5]);
*/

     case Sys_cputime: /* Return CPU time in milliseconds  */
              return muldiv(clock(), 1000, TICKS_PER_SEC);

     case Sys_filemodtime: /* Return time of last modification of file
                              whose name is in p[4]  */
              { struct stat buf;
                if (stat(b2c_str(p[4], chbuf), &buf)) return 0;
                return buf.st_mtime;
              }

     case Sys_setprefix: /* Set the file prefix string  */
              prefix = p[4];
              return prefix;

     case Sys_getprefix: /* Return the file prefix string  */
              return prefix;

     case Sys_graphics: /* Perform an operation on the graphics window  */
              return sysGraphics(p);

     case Sys_seek:  /* res := seek(fd, pos)   */
              { FILE *fp = findfp(p[4]);
                WORD res = fseek(fp, (long)p[5], SEEK_SET);
		//printf("fseek => res=%d errno=%d\n", res, errno);
                //g[Gn_result2] = errno;
                return res==0 ? -1 : 0; /* res=0 succ, res=-1 error  */
	      }

     case Sys_tell: /* pos := sys(Sys_tell,fd)  */
              { FILE *fp = findfp(p[4]);
                WORD pos = ftell(fp);
                //g[Gn_result2] = errno;
                return pos; // >=0 succ, -1=error */
	      }

     case Sys_waitirq: /* Wait for irq */
                //pthread_mutex_lock  (         &irq_mutex);
                //pthread_cond_wait   (&irq_cv, &irq_mutex);
                //pthread_mutex_unlock(         &irq_mutex);
                return 0;

     case Sys_lockirq:   // Stop all devices from modifying
                         // packets or generating interrupts
                //pthread_mutex_lock  (         &irq_mutex);
                return 0;

     case Sys_unlockirq: // Allow devices to modify packets
                         // and generate interrput
                //pthread_mutex_unlock(         &irq_mutex);
                return 0;

     case Sys_devcom: /* res := sys(Sys_devcom, com, arg) */
                return 0; //devcommand(W[p+4], W[p+5], W[p+6]);

     case Sys_ftime: /* return result of calling ftime */
              { struct timeb tb;
                WORD *v = (WORD*)(p[4]<<2);
                ftime(&tb);

                // **************** BEWARE ************************
                // The date will OVERFLOW on 19-Jan-2038 at 3:14:07
                v[0] = 0; //(WORD)(tb.time>>32);
                v[1] = (WORD)tb.time; // Seconds since epoch
                v[2] = tb.millitm;     // milli-seconds
                v[3] = tb.timezone;    // Minutes west of Greenwich
                v[4] = tb.dstflag;     // non zero => Daylight saving time applies

                daylight = 1;          // Fudge for windows
                daylight = 0;          // Fudge for windows MR 31/10/03
                tzset(); // Should be done separately
		//printf("cintpos: timezone=%d daylight=%d %s %s\n",
                //        (WORD)timezone,(WORD)daylight, tzname[0],
		//        tzname[1]);
                if(((WORD)timezone)%3600==0) // Fudge for windows
                  v[1] -= (WORD)timezone;    // Correct for timezone
		if (daylight) v[1] += 60*60;  // Add one hour in DST
                v[1] += rootnode[Rtn_adjclock] * 60; // Add adjustment
                return 0;
              }

     case Sys_usleep: /* usleep for some micro-seconds */
                return usleep(p[4]);
              
     case Sys_filesize:  /* res := sys(Sys_filesize, fd)   */
              { FILE *fp   = findfp(p[4]);
                WORD pos  = ftell(fp);
                WORD rc   = fseek(fp, 0, SEEK_END);
                WORD size = ftell(fp);
                rc  = fseek(fp, pos, SEEK_SET);
                if (rc) size = -1;
                return size; /* >=0 succ, -1=error  */
	      }

    case Sys_getsysval: /* res := sys(Sys_getsysval, addr) */
              { WORD *addr = (WORD*)p[4];
                return *addr;
              }

    case Sys_putsysval: /* res := sys(Sys_putsysval, addr, val) */
              { WORD *addr = (WORD*)p[4];
                *addr = p[5];
                return 0;
              }

    case Sys_shellcom: /* res := sys(Sys_shellcom, comstr) */
              { char *comstr = (char*)(p[4]<<2);
	        int i;
                char com[256];
                int len = strlen(comstr);
                for(i=0; i<len; i++) com[i] = comstr[i+1];
                com[len] = 0;
		//printf("\ncintpos: calling shell command %s\n", com);
                return system(com);
              }

    case Sys_getpid: /* res := sys(Sys_getpid) */
                return getpid();

    case Sys_dumpmem: /* sys(Sys_dumpmem, context) */
                printf("\nCintpos memory not dumped to DUMP.mem\n");
                return 0;

    case Sys_callnative:
              { // Call native code.
                int(*rasmfn)(void) = (int(*)(void))&p[4];
                return rasmfn();
              }              

    case 135: { /* Return system date and time in VEC 5 */
                time_t clk = time(0);
	        struct tm *now = gmtime(&clk);
	        WORD *arg = PT(p[4] << B2Wsh);
                arg[0] = now->tm_year+1900;
	        arg[1] = now->tm_mon+1;
	        arg[2] = now->tm_mday;
	        arg[3] = now->tm_hour;
	        arg[4] = now->tm_min;
	        arg[5] = now->tm_sec;
                return 0;
              }

     case 136:  /* Return current directory in VEC 1 + 256/bytesperword */
              { getcwd(chbuf, 256);
                c2b_str(chbuf, p[4]);
                return 0;
              }

    case 137:   return (WORD)parms >> B2Wsh;
  }
} 

/* b2c_fname converts the BCPL string for a file name to a C character
** string.  The character '/' (or '\') is treated as a separator and is
** converted to FILE_SEP_CH ('/' for unix, '\' for MSDOS or ':' for MAC).
** If prefix is set and the filename is relative, the prefix is prepended.
*/
char *b2c_fname(INT32 bstr, char * cstr)
{  char *bp = (char*)(bstr<<2);
   int len;
   int i=0;
   if (bstr==0) return 0; /* No path given */
   len = *bp++;
   if (prefix && relfilename((char*)bstr))
   { // Prepend the filename with prefix
     char *pfxp = (char*)(prefix<<2);
     int pfxlen = *pfxp++;
     while(pfxlen--)
     { char ch = *pfxp++;
       if(ch=='/' || ch=='\\' || ch==':') ch = FILE_SEP_CH;
       cstr[i++] = ch;
     }
     if (cstr[i-1] != FILE_SEP_CH) cstr[i++] = FILE_SEP_CH;
   }

   while (len--)
   { char ch = *bp++;
     if(ch=='/' || ch=='\\' || ch==':') ch = FILE_SEP_CH;
     cstr[i++] = ch;
   }
   cstr[i] = 0;
   //if (prefix) printfs("filename = %s\n", cstr);
   //printfs("b2c_fname: cstr = %s\n", cstr);
   return cstr;
}

/* b2c_str converts the BCPL string for a file name to a C character
** string.  The character '/' (or '\') is treated as a separator and is
** converted to FILE_SEP_CH ('/' for unix, '\' for MSDOS or ':' for MAC)
*/
char *b2c_str(WORD bstr, char * cstr)
{  char *bp, i, len;
   if (bstr==0) return 0;
   bp = (char *)(bstr<<B2Wsh);
   len = *bp++;
   for(i = 0; i<len; i++)
   { char ch = *bp++;
     if(ch=='/' || ch=='\\') ch = FILE_SEP_CH;
     cstr[i] = ch;
   }
   cstr[len] = 0;
   return cstr;
} 

/*
** c2b_str converts a C string into a BCPL string
*/
WORD c2b_str(char *cstr, WORD bstr) {
  char *bp = (char *)(bstr << B2Wsh);
  int len = 0;
  while (cstr[len]) {
    bp[len+1] = cstr[len];
      ++len;
  }
  bp[0] = len;
  return bstr;
}
