/* This header file contains machine/system dependent #defines
** These are dependent on the -D parameter specified in Makefile.
** The possible -D parameters are:
**
**  -DforMAC           for Apple MAC (not recently tested)
**  -DforMIPS          for DEC R2000/3000 Workstations under Ultrix 4.3
**  -DforLINUX         for Linux
**  -DforSUN4          for Sun4m under SunOS 4.1.3
**  -DforSPARC         for Sun4m spac under SunOS 5.4
**  -DforALPHA         for DEC Alpha under OSF1 V3.2 17 (64 bit wordsize)
**  -DforMSDOS         for MSDOS 32 bit protected mode using Borland C v4.0
**  -DforOS2           for OS/2 V2.1 using Cset/2 and Borland Tasm
*/

/* The MAC version just about works on a Power Macitosh 7100/66
** using Symantec Think C 6.0
** I used cintmain.c cinterp.c kblib.c and nullrastlib.c linked
** with the standard libraries ANSI and unix. The partition size was 5000K
** and #define forMAC was edited into this file. (I don't know how to
** get Think C to do that #definition for me).
** The command command files bc bs bp bco and bso had to be edited to
** change /s to :s and ../ to :: etc. These versions are in sys/MAC.
** If someone would suggest how to get a visible cursor I would be grateful.
*/

/*
** Cintmain and cinterp need the type signed char but this is
** not available on all implementations of C. On some the type char
** is signed, and on some (if fact most) signed char is allowed.
** Comment out of the following definitions of SIGNEDCHAR. A test in
** the function badimplementation in cintmain.c will determine whether
** you have made the right choice.
*/

#define SIGNEDCHAR signed char
/* #define SIGNEDCHAR char */

#ifdef forMAC
#include <unix.h>
#include <time.h.h>
#define WORD long
#define B2Wsh 2
#define BPW 4
#define MALLOC(n) malloc((n)*BPW)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM interpret
#define REMOVE unlink
#define FILE_SEP_CH ':'
#define BIGENDER
#endif

#ifdef forMIPS
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#define WORD long
#define B2Wsh 2
#define BPW 4
#define MALLOC(n) malloc((n)*BPW)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM interpret
#define REMOVE unlink
#define FILE_SEP_CH '/'
#endif

#ifdef forLINUX
#include <sys/stat.h>
#include <time.h>
#define WORD long
#define B2Wsh 2
#define BPW 4
#define MALLOC(n) malloc((n)*BPW)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '/'
#endif

#ifdef forSUN4
#include <sys/stat.h>
#define WORD long
#define B2Wsh 2
#define BPW 4
#define MALLOC(n) malloc((n)*BPW)
#define TICKS_PER_SEC (1000000)
#define CINTASM interpret
#define REMOVE unlink
#define FILE_SEP_CH '/'
#define BIGENDER
#endif

#ifdef forSPARC
#include <sys/stat.h>
#include <time.h>
#define WORD long
#define B2Wsh 2
#define BPW 4
#define MALLOC(n) malloc((n)*BPW)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM interpret
#define REMOVE unlink
#define FILE_SEP_CH '/'
#define BIGENDER
#endif

#ifdef forALPHA
#include <sys/stat.h>
#include <stdlib.h>
#define WORD long long
#define B2Wsh 3
#define BPW 8
#define MALLOC(n) malloc((n)*BPW)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '/'
#endif

#ifdef forMSDOS
#include <sys\stat.h>
#include <time.h>
#define WORD long
#define B2Wsh 2
#define BPW 4
#define MALLOC(n) malloc((n)*BPW)
#define TICKS_PER_SEC (CLK_TCK)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '\\'
#endif

#ifdef forOS2
#include <sys\stat.h>
#define WORD long
#define B2Wsh 2
#define BPW 4
#define MALLOC(n) malloc((n)*BPW)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM interpret
#define REMOVE remove
#define FILE_SEP_CH '\\'
#endif


typedef WORD *INT32pt;
typedef WORD INT32;

#define printfs printf
#define printfd printf

#define WD (WORD)
#define UWD (unsigned WORD)
#define PT (WORD *)
#define BP (unsigned char *)
#define SBP (SIGNEDCHAR *)
#define HP (unsigned short *)
#define SHP (short *)

#define Gn_sys         3
#define Gn_currco      7
#define Gn_result2    10

/* Functions defined in kblib.c  */
extern int Readch(void);
extern int init_keyb(void);
extern int close_keyb(void);
extern int intflag(void);

/* externals defined in init*.c  */
extern WORD stackupb;
extern WORD gvecupb;
extern void initsections(WORD *);

#define Rtn_tasktab     1L
#define Rtn_devtab      2L
#define Rtn_blklist     4L
#define Rtn_tallyv      5L
#define Rtn_clkintson   6L
#define Rtn_lastch      7L
#define Rtn_insadebug   8L

#define Rtn_membase    12L
#define Rtn_memsize    13L
#define Rtn_sys        15L
#define Rtn_boot       16L
#define Rtn_klib       17L
#define Rtn_blib       18L
#define Rtn_vecstatsv  21L
#define Rtn_dumpflag   22L
#define Rtn_envlist    23L
#define Rtn_abortcode  24L
#define Rtn_context    25L
#define Rtn_lastp      26L
#define Rtn_lastg      27L
#define Rtn_idletcb    28L
#define Rtn_adjclock   29L

#define Rtn_upb        40L

// SYS functions

#define Sys_setcount      (-1)
#define Sys_quit            0
#define Sys_rti             1
#define Sys_saveregs        2
#define Sys_setst           3
#define Sys_tracing         4
#define Sys_watch           5
#define Sys_tally           6
#define Sys_interpret       7

#define Sys_sardch         10
#define Sys_sawrch         11
#define Sys_read           12
#define Sys_write          13
#define Sys_openread       14
#define Sys_openwrite      15
#define Sys_close          16
#define Sys_deletefile     17
#define Sys_renamefile     18

#define Sys_getvec         21
#define Sys_freevec        22
#define Sys_loadseg        23
#define Sys_globin         24
#define Sys_unloadseg      25
#define Sys_muldiv         26
#define Sys_intflag        28
#define Sys_setraster      29
#define Sys_cputime        30
#define Sys_filemodtime    31
#define Sys_setprefix      32
#define Sys_getprefix      33
#define Sys_graphics       34       // Windows CE only

#define Sys_seek           38
#define Sys_tell           39
#define Sys_waitirq        40
#define Sys_lockirq        41
#define Sys_unlockirq      42
#define Sys_devcom         43
#define Sys_ftime          44
#define Sys_usleep         45
#define Sys_filesize       46
#define Sys_openreadwrite  47

#define Sys_getsysval      48
#define Sys_putsysval      49
#define Sys_shellcom       50
#define Sys_getpid         51
#define Sys_dumpmem        52
#define Sys_callnative     53

