
// cobench.c
// Jeremy Singer
// 13 Mar 04
// Modified to use colib by Martin Richards 21/6/04

#include <stdio.h>
#include "cohdr.h"

int tracing = 0;

coval coread(cortn *ptr)
{
  cortn cptr = *ptr;
  if (cptr != NULL) {
    *ptr = NULL;
    return resumeco(cptr, (coval)currco);
  }
  else {
    *ptr = currco;
    return cowait(0);
  }
}
    

void cowrite(cortn *ptr, coval val) {
  cortn cptr = *ptr;
  if (cptr != NULL) {
    *ptr = 0;
    callco(cptr, val);
  }
  else {
    *ptr = currco;
    callco((cortn)cowait(0), val);
  }
}

cortn kill_co;

void die() { resumeco(kill_co, 0); }

coval sourcefn(coval nextco) {
  int i;  // loop counter
  int k = (int)cowait(0);
  cortn channel = NULL;
  cortn *out_chan_ptr = &channel;

  callco((cortn)nextco, (coval)out_chan_ptr);
  
  //if (tracing) printf("srcefn: out_chan_ptr=%d k=%d\n\n",
  //	      (int)out_chan_ptr, k);

  for (i=1; i <= k; i++)
  { if(tracing) printf("srcefn: sending number %d\n", i);
    cowrite(out_chan_ptr, (coval)i);
  }
  if(tracing) printf("srcefn: sending number %d\n", 0);
  cowrite(out_chan_ptr, 0);
  if(tracing) printf("srcefn: dying\n");
  die();
  return 0;
}

coval copyfn(coval nextco)
{
  cortn channel = NULL;
  cortn *in_chan_ptr = (cortn *)cowait(0);
  cortn *out_chan_ptr = &channel;
  callco((cortn)nextco, (coval)out_chan_ptr);
  
  //if(tracing) printf("copyfn:   in_chan_ptr=%d out_chan_ptr=%d\n",
  //                    in_chan_ptr, out_chan_ptr);



  while (1) {
    coval val = coread(in_chan_ptr);
    if(tracing) printf("copyfn: copying number %d\n", val);
    cowrite(out_chan_ptr, val);
    if (val == 0) break;
  }

  if(tracing) printf("copyfn: dying\n");
  die();
  return (coval)0;
}

coval sinkfn(coval in_chan_ptr)
{ //if(tracing) printf("sinkfn:   in_chan_ptr=%d\n", in_chan_ptr);

  while (1) {
    coval val = coread((cortn*)in_chan_ptr);
    if(tracing) printf("sinkfn: recving number %d\n", val);
    if (val == 0) break;
  }

  if(tracing) printf("sinkfn: dying\n");

  die();
  return 0;
}


// two global vars - params for benchmark test

int k;
int n;

coval rootfn(coval);

int main(int argc, char *argv[])
{ cortn root = createco(rootfn, 300);
  int i;

  k = 10000;
  n = 500;
  
  for(i=1; i<argc; i++) {
    if     (strcmp(argv[i], "-k")==0)  k = atoi(argv[++i]);
    else if(strcmp(argv[i], "-n")==0)  n = atoi(argv[++i]);
    else if(strcmp(argv[i], "-t")==0)  tracing = 1;
    else { printf("Bad arguments\n"); exit(0); }
  }
  printf("\nCobench sending %d numbers via %d copy coroutines\n", k, n);

  kill_co = createco((cofn)deleteco, 150);

  callco(root, 0);

  return 0;
}


coval rootfn(coval x)
{
  cortn cptr = createco(sinkfn, 2000);
  cortn source_co;

  int i;
  for (i = 0; i < n; i++) {
    cortn co = createco(copyfn, 2000);
    callco(co, (coval)cptr);
    cptr = co;
  }

  source_co = createco(sourcefn, 2000);
  callco(source_co, (coval)cptr);

  if(tracing) printf("\nAll coroutines created\n\n");

  callco(source_co, (coval)k);  // tell sourceco to send k numbers

  printf("\nCobench done\n");

  return (coval)0;
}



