// This tests the functionality java versions of the
// BCPL coroutine functions: callco, cowait and resumeco.

// Implemented by Martin Richards (c) April 2005

import Cortn.*;

public class Cotest
{
    public static Cortn a_co;
    public static Cortn b_co;
    public static Cortn c_co;
    public static Cortn d_co;

    public static void main(String[] args)
    {
	Cortn testroot = new testroot("testroot");
	System.exit(0);
    }
}

class testroot extends Cortn
{
    public testroot(String name) {
	super(name);
    }

    public Object fn(Object c) {
	Cotest.a_co = new A_co("a_co");
	Cotest.b_co = new B_co("b_co");
	Cotest.c_co = new C_co("c_co");
	Cotest.d_co = new D_co("d_co");

	System.out.println("\nTest: root -> a -> root");
	System.out.println("root: calling callco(a_co,  100)");
        int res =  ((Integer)callco(Cotest.a_co, new Integer(100))).intValue();
	System.out.println("root: callco(a_co,  100) => " + res);


        System.out.println("\nTest: root -> a -> root, " +
                           " ie check: c:=fn(cowait(c)) REPEAT");
        System.out.println("root: calling callco(a_co,  200)");
        res =  ((Integer)callco(Cotest.a_co, new Integer(200))).intValue();
	System.out.println("root: callco(a_co,  200) => " + res);

	System.out.println("\nTest: root -> b -> a -> b -> root");
	System.out.println("root: calling callco(b_co,  300)");
        res =  ((Integer)callco(Cotest.b_co, new Integer(300))).intValue();
	System.out.println("root: callco(b_co,  300) => " + res);

	System.out.println("\nTest: root -> b -> a -> b -> root  again");
	System.out.println("root: calling callco(b_co,  400)");
        res =  ((Integer)callco(Cotest.b_co, new Integer(400))).intValue();
	System.out.println("root: callco(b_co,  400) => " + res);

        System.out.println("\nTest: root -> c -> a -> root," +
                           " ie check resumeco in c_co");
        System.out.println("root: calling callco(c_co,  500)");
        res =  ((Integer)callco(Cotest.c_co, new Integer(500))).intValue();
	System.out.println("root: callco(c_co,  500) => " + res);

	System.out.println("\nTest: root -> c -> root");
	System.out.println("root: calling callco(c_co,  600)");
        res =  ((Integer)callco(Cotest.c_co, new Integer(600))).intValue();
	System.out.println("root: callco(c_co,  600) => " + res);

	System.out.println("\nTest: root -> d -> d -> root,"+
			   " ie can resumeco call itself");
	System.out.println("root: calling callco(d_co,  700)");
        res =  ((Integer)callco(Cotest.d_co, new Integer(700))).intValue();
	System.out.println("root: callco(c_co,  700) => " + res);

	System.out.println("\nEnd of test");

	return null;
    }
}

class A_co extends Cortn
{
    public A_co(String name) {
	super(name);
    }

    public Object fn(Object c) {
	//System.out.println(coName+": fn entered");
	int x = ((Integer)c).intValue();
	System.out.println("a_co: entered with value " + x);
	System.out.println("a_co: returning " + (x+10));
	return new Integer(x+10);
    }
}


class B_co extends Cortn
{
    public B_co(String name) {
	super(name);
    }

    public Object fn(Object c) {
	int x = ((Integer)c).intValue();
	int res;
	System.out.println("b_co: entered with value " + x);
	System.out.println("b_co: calling callco(a_co, 2000)");
	res = ((Integer) callco(Cotest.a_co,new Integer(2000))).intValue();
	System.out.println("b_co: callco(a_co, 2000) => " + res);
	System.out.println("b_co: returning " + (x+20));
	return new Integer(x+20);
    }
}


class C_co extends Cortn
{
    public C_co(String name) {
	super(name);
    }

    public Object fn(Object c) {
	int x = ((Integer)c).intValue();
	int res;
	System.out.println("c_co: entered with value " + x);
	System.out.println("c_co: calling resumeco(a_co, 3000)");
	res = ((Integer) resumeco(Cotest.a_co, new Integer(3000))).intValue();
	System.out.println("c_co: resumeco(a_co, 3000) => " + res);
	System.out.println("c_co: returning " + (x+30));
	return new Integer(x+30);
    }
}

class D_co extends Cortn
{
    public D_co(String name) {
	super(name);
    }

    public Object fn(Object c) {
	int x = ((Integer)c).intValue();
	int res;
	System.out.println("d_co: entered with value " + x);
	System.out.println("d_co: calling resumeco(d_co, 4000)");
	res = ((Integer) resumeco(Cotest.d_co, new Integer(4000))).intValue();
	System.out.println("d_co: resumeco(d_co, 4000) => " + res);
	System.out.println("d_co: returning " + (x+40));
	return new Integer(x+40);
    }
}


/* This program should generate the following output:

Test: root -> a -> root
root: calling callco(a_co,  100)
a_co: entered with value 100
a_co: returning 110
root: callco(a_co,  100) => 110

Test: root -> a -> root,  ie check: c:=fn(cowait(c)) REPEAT
root: calling callco(a_co,  200)
a_co: entered with value 200
a_co: returning 210
root: callco(a_co,  200) => 210

Test: root -> b -> a -> b -> root
root: calling callco(b_co,  300)
b_co: entered with value 300
b_co: calling callco(a_co, 2000)
a_co: entered with value 2000
a_co: returning 2010
b_co: callco(a_co, 2000) => 2010
b_co: returning 320
root: callco(b_co,  300) => 320

Test: root -> b -> a -> b -> root  again
root: calling callco(b_co,  400)
b_co: entered with value 400
b_co: calling callco(a_co, 2000)
a_co: entered with value 2000
a_co: returning 2010
b_co: callco(a_co, 2000) => 2010
b_co: returning 420
root: callco(b_co,  400) => 420

Test: root -> c -> a -> root, ie check resumeco in c_co
root: calling callco(c_co,  500)
c_co: entered with value 500
c_co: calling resumeco(a_co, 3000)
a_co: entered with value 3000
a_co: returning 3010
root: callco(c_co,  500) => 3010

Test: root -> c -> root
root: calling callco(c_co,  600)
c_co: resumeco(a_co, 3000) => 600
c_co: returning 530
root: callco(c_co,  600) => 530

Test: root -> d -> d -> root, ie can resumeco call itself
root: calling callco(d_co,  700)
d_co: entered with value 700
d_co: calling resumeco(d_co, 4000)
d_co: resumeco called => d_co
d_co: resumeco(d_co, 4000) => 4000
d_co: returning 740
root: callco(c_co,  700) => 740

End of test
*/




