# 1 "colib.S"
# 1 "<built-in>"
# 1 "<command line>"
# 1 "colib.S"
# You may need to prefix external references with an underlines,
# e.g. change malloc to _malloc and free to _free. This may be needed
# for cygwin and old versions of Linux, Cygwin and FreeBSD. This
# can be done by defining the macro UNDERLINES.

# #define UNDERLINES

# Linkage:
# On entry 0(%esp) is the return address
# $ 4(%esp) is the first argument
# $ 8(%esp) is the second argument
# etc

# %ebp, %ebx, %edi and %esi must be preserved

# result in %eax

# flag DF clear on entry and exit

.globl currco
.globl _currco
 .data
 .align 4
currco:
_currco:
 .long 0 # Initialised by the first call of createco

rootcp:
 .long 0 # Root coroutine system space
 .long -1
 .long 0
 .long 0
 .long 0
 .long 0

 .text

    .p2align 2,,3
.globl cowait
.globl _cowait
cowait:
_cowait:
   pushl %ebp
   pushl %ebx
   pushl %edi
   pushl %esi

   movl currco,%esi
   movl %esp,0(%esi) # save the current stack pointer

   movl 4(%esi),%edi # find the parent coroutine
   xorl %eax,%eax
   movl %eax,4(%esi) # clear its parent link

   movl 20(%esp),%eax # get the value to pass (first argument)
   movl %edi,currco # change to target coroutine
   movl 0(%edi),%esp # retore its stack pointer

# and then return with result
   popl %esi
   popl %edi
   popl %ebx
   popl %ebp
   ret

 .p2align 2,,3

.globl callco
.globl _callco
callco:
_callco:
   pushl %ebp
   pushl %ebx
   pushl %edi
   pushl %esi

   movl 20(%esp),%edi # target coroutine (first argument)

   movl currco,%esi
   movl %esp,0(%esi) # save the current stack pointer

   movl %esi,4(%edi) # update the target s parent link

   movl 24(%esp),%eax # get the value to pass (second argument)
   movl %edi,currco # change to destination coroutine
   movl 0(%edi),%esp # restore its stack pointer

# and then return with result
cc1:
   popl %esi
   popl %edi
   popl %ebx
   popl %ebp
#l: jmp l
   ret

 .p2align 2,,3
.globl resumeco
.globl _resumeco
resumeco:
_resumeco:
   pushl %ebp
   pushl %ebx
   pushl %edi
   pushl %esi

   movl 20(%esp),%edi # target coroutine (first argument)

   movl currco,%esi
   movl %esp,0(%esi) # save the current stack pointer

   xorl %eax,%eax # move the parent link to the destination
   xchgl %eax,4(%esi) # coroutine, clearing the source parent link
   movl %eax,4(%edi)

   movl 24(%esp),%eax # get the value to pass (second argument)
   movl %edi,currco # change to destination coroutine
   movl 0(%edi),%esp # restore its stack pointer

# and then return with result
   popl %esi
   popl %edi
   popl %ebx
   popl %ebp
   ret

 .p2align 2,,3
.globl createco
.globl _createco
createco:
_createco:
   pushl %ebp
   pushl %ebx
   pushl %edi
   pushl %esi

   movl currco,%eax
   orl %eax,%eax
   jne crc0
   movl $rootcp,currco # Initialise currco

crc0:
   movl 20(%esp),%ebp # fn (first argument)
   movl 24(%esp),%eax # size (second argument)
   addl $3000,%eax # Add 3000 for use by C programs!

   addl $6,%eax
   sall $2,%eax
   pushl %eax




   call malloc


   popl %ebx
   addl %eax,%ebx # address of far end

   orl %eax,%eax
   je crc1 # return is malloc failed

   sub $20,%ebx # leave room for dump
   movl $crloop,16(%ebx)
   movl %ebp,12(%ebx)
   movl %ebx,8(%ebx)
   movl %edi,4(%ebx)
   movl %esi,0(%ebx)

   movl %ebx,0(%eax) # save the resumption point
   movl $0,4(%eax) # null parent link
   movl %ebp,8(%eax) # save fn in the coroutine stack

# and then return
crc1:
   popl %esi
   popl %edi
   popl %ebx
   popl %ebp
   ret

crloop:
   pushl %eax
   movl currco,%edx # find current coroutine
   movl 8(%edx),%edx # get its main function
   call *%edx # call it with arg %eax

   movl %eax,0(%esp) # call cowait
   call cowait
   popl %edx # undo the earlier push
   jmp crloop

 .p2align 2,,3
.globl deleteco
.globl _deleteco
deleteco:
_deleteco:
   ret
   pushl %ebp
   pushl %ebx
   pushl %edi
   pushl %esi

   pushl 20(%esp) # get first argument




   call free


   popl %ebx

   movl $1, %eax

   popl %esi
   popl %edi
   popl %ebx
   popl %ebp
   ret
