// This is a benchmark program for the coroutine mechanism

// Translated into MCPL by Martin Richards (c) April 2004

MODULE cobench

GET "mcpl.h"

GLOBAL
  kill_co: Ug,        // The killer coroutine
  source_co,
  tracing


FUN start : =>
  LET argv = VEC 50
  LET k    = 10_000
  LET n    = 500
  LET cptr = 0

  UNLESS rdargs("-k,-n,-t/S", argv, 50) DO
  { writef "Bad arguments for cobench\n"
    RETURN
  }

  IF argv!0 DO k := str2numb(argv!0) // -k
  IF argv!1 DO n := str2numb(argv!1) // -n
  tracing := argv!2                  // -t

  writef("\nCobench sending %d numbers via %d copy coroutines\n\n", k, n)

  kill_co := createco(deleteco, 150)

  cptr := createco(sinkfn, 150)

  FOR i = 1 TO n DO
  { LET co = createco(copyfn, 150)
    callco(co, cptr)
    cptr := co
  }

  source_co := createco(sourcefn, 150)
  callco(source_co, cptr)

  IF tracing DO writef "All coroutines created\n\n"

  callco(source_co, k) // Tell sourceco to send k numbers 

  deleteco kill_co

  writef "\nCobench done\n"
  RETURN 0
.

FUN sourcefn : nextco =>
  LET k = cowait()
  LET channel = 0
  LET out_chan_ptr = @channel

  callco(nextco, out_chan_ptr)
 
  IF tracing DO
    writef("sourcefn: co=%d out_chan_ptr=%d k=%d\n\n", currco, out_chan_ptr, k)

  FOR val = 1 TO k DO
  { IF tracing DO writef("sourcefn: co=%d sending number %d\n", currco, val)
    cowrite(out_chan_ptr, val)
  }
  IF tracing DO writef("sourcefn: co=%d sending number %d\n", currco, 0)
  cowrite(out_chan_ptr, 0)
  IF tracing DO writef("sourcefn: co=%d dying\n", currco)
  die()
.

FUN copyfn : nextco =>
  LET channel = 0
  LET in_chan_ptr  = cowait()
  LET out_chan_ptr = @channel
  callco(nextco, out_chan_ptr)
  IF tracing DO writef("copyfn:   co=%d in_chan_ptr=%d out_chan_ptr=%d\n",
                        currco, in_chan_ptr, out_chan_ptr)

  { LET val = coread(in_chan_ptr)
    IF tracing DO writef("copyfn:   co=%d copying number %d\n", currco, val)
    cowrite(out_chan_ptr, val)
    UNLESS val BREAK
  } REPEAT

  IF tracing DO writef("copyfn:   co=%d dying\n", currco)
  die()
.

FUN sinkfn : in_chan_ptr =>
  IF tracing DO writef("sinkfn:   co=%d in_chan_ptr=%d\n", currco, in_chan_ptr)

  { LET val = coread in_chan_ptr
    IF tracing DO writef("sinkfn:   co=%d recving number %d\n", currco, val)
    UNLESS val BREAK
  } REPEAT

  IF tracing DO writef("sinkfn:   co=%d dying\n", currco)

  die()
.

FUN coread
: [cptr=0] => cptr := currco         // Set channel word to this coroutine
              cowait()               // Wait for value from cowrite
: [cptr  ] => cptr := 0              // Clear the channel word
              resumeco(cptr, currco)
.

FUN  cowrite
: [cptr=0], val => cptr := currco
                   callco(cowait(), val)
: [cptr  ], val => LET co = cptr
                   cptr := 0
                   callco(co,       val) // Send val to coread
.

FUN die : => resumeco(kill_co, currco)
.

