// This tests the functionality of the coroutine 
// functions: callco, cowait and resumeco.

// Implemented by Martin Richards (c) April 2005



#include "cortn.c"

cortn a_co;
cortn b_co;
cortn c_co;
cortn d_co;

coval a_fn(coval x)
{
  printf("a_co: entered with value %d\n", x.i);
  printf("a_co: returning %d\n", x.i+10);
  return (coval)(x.i+10);
}

coval b_fn(coval x)
{
  printf("b_co: entered with value %d\n", x.i);
  printf("b_co: calling callco(a_co, 2000)\n");
  printf("b_co: callco(a_co, 2000) => %d\n", callco(a_co, (coval)2000));
  printf("b_co: returning %d\n", x.i+20);
  return (coval)(x.i+20);
}

coval c_fn(coval x)
{
  printf("c_co: entered with value %d\n", x.i);
  printf("c_co: calling resumeco(a_co, 3000)\n");
  printf("c_co: resumeco(a_co, 3000) => %d\n", resumeco(a_co,(coval)3000));
  printf("c_co: returning %d\n", x.i+30);
  return (coval)(x.i+30);
}

coval d_fn(coval x)
{
  printf("d_co: entered with value %d\n", x.i);
  printf("d_co: calling resumeco(d_co, 4000)\n");
  printf("d_co: resumeco(d_co, 4000) => %d\n", resumeco(d_co,(coval)4000));
  printf("d_co: returning %d\n", x.i+40);
  return (coval)(x.i+40);
}

coval rootfn(coval x)
{
  a_co = createco(a_fn, 20000);
  b_co = createco(b_fn, 20000);
  c_co = createco(c_fn, 20000);
  d_co = createco(d_fn, 20000);

  printf("\nTest: root -> a -> root\n");
  printf("root: calling callco(a_co,  100)\n");
  printf("root: callco(a_co,  100) => %d\n", callco(a_co, (coval)100));

  printf("\nTest: root -> a -> root, ie check: c:=fn(cowait(c)) REPEAT\n");
  printf("root: calling callco(a_co,  200)\n");
  printf("root: callco(a_co,  200) => %d\n", callco(a_co, (coval)200));

  printf("\nTest: root -> b -> a -> b -> root\n");
  printf("root: calling callco(b_co,  300)\n");
  printf("root: callco(a_co,  300) => %d\n", callco(b_co, (coval)300));

  printf("\nTest: root -> b -> a -> b -> root  again\n");
  printf("root: calling callco(b_co,  400)\n");
  printf("root: callco(b_co,  400) => %d\n", callco(b_co, (coval)400));

  printf("\nTest: root -> c -> a -> root, ie check resumeco in c_co\n");
  printf("root: calling callco(c_co,  500)\n");
  printf("root: callco(c_co,  500) => %d\n", callco(c_co, (coval)500));

  printf("\nTest: root -> c -> root\n");
  printf("root: calling callco(c_co,  600)\n");
  printf("root: callco(c_co,  600) => %d\n", callco(c_co, (coval)600));

  printf("\nTest: root -> d -> d -> root, ie can resumeco call itself\n");
  printf("root: calling callco(d_co,  700)\n");
  printf("root: callco(d_co,  700) => %d\n", callco(d_co, (coval)700));

  //deleteco(a_co);
  //deleteco(b_co);
  //deleteco(c_co);
  //deleteco(d_co);

  printf("\nEnd of test\n");

  return (coval)0;
}

int main()
{
  currco = 0;
  startrootco(rootfn);

  return 0;
}


/* This program should generate the following output:

Test: root -> a -> root
root: calling callco(a_co,  100)
a_co: entered with value 100
a_co: returning 110
root: callco(a_co,  100) => 110

Test: root -> a -> root, ie check: c:=fn(cowait(c)) REPEAT
root: calling callco(a_co,  200)
a_co: entered with value 200
a_co: returning 210
root: callco(a_co,  200) => 210

Test: root -> b -> a -> b -> root
root: calling callco(b_co,  300)
b_co: entered with value 300
b_co: calling callco(a_co, 2000)
a_co: entered with value 2000
a_co: returning 2010
b_co: callco(a_co, 2000) => 2010
b_co: returning 320
root: callco(a_co,  300) => 320

Test: root -> b -> a -> b -> root  again
root: calling callco(b_co,  400)
b_co: entered with value 400
b_co: calling callco(a_co, 2000)
a_co: entered with value 2000
a_co: returning 2010
b_co: callco(a_co, 2000) => 2010
b_co: returning 420
root: callco(b_co,  400) => 420

Test: root -> c -> a -> root, ie check resumeco in c_co
root: calling callco(c_co,  500)
c_co: entered with value 500
c_co: calling resumeco(a_co, 3000)
a_co: entered with value 3000
a_co: returning 3010
root: callco(c_co,  500) => 3010

Test: root -> c -> root
root: calling callco(c_co,  600)
c_co: resumeco(a_co, 3000) => 600
c_co: returning 530
root: callco(c_co,  600) => 530

Test: root -> d -> d -> root, ie can resumeco call itself
root: calling callco(d_co,  700)
d_co: entered with value 700
d_co: calling resumeco(d_co, 4000)
d_co: resumeco(d_co, 4000) => 4000
d_co: returning 740
root: callco(d_co,  700) => 740

End of test
*/





