
#  Python version of the systems programming language benchmark 
#  translated from the C version by Martin Richards 2 Nov 2006
#
#  ############ This is work in progress ######################
#

# #ifdef bench100
#   Count           10000*100
#   Qpktcountval    2326410
#   Holdcountval     930563
# #else
#   Count           10000
#   Qpktcountval    23246
#   Holdcountval     9297
# #endif

class I: # Task identifiers
  IDLE         = 1
  WORK         = 2
  HANDLERA     = 3
  HANDLERB     = 4
  DEVA         = 5
  DEVB         = 6

class B: # Status bits
  PKT          = 1   # 001
  WAIT         = 2   # 010
  HOLD         = 4   # 100
  NOTPKT       = 6   # 110
  NOTWAIT      = 5   # 101
  NOTHOLD      = 3   # 011

class S: # Status values
  RUN          = 0
  RUNPKT       = 1
  WAIT         = 2
  WAITPKT      = 3
  HOLD         = 4
  HOLDPKT      = 5
  HOLDWAIT     = 6
  HOLDWAITPKT  = 7

class K: # Packet kinds
  DEV  = 1000
  WORK = 1001

class P:  # Packet fields
  link
  id
  kind
  a1
  a2[4]

class T: # Task fields
    link   # Pointer to the next task in the priority chain
    id     # The task's id
    pri    # The priority
    wkq    # The work queue
    state  # The task's state
    fn     # The task's main function
    v1     # Two private variables
    v2

class G: # Global constants and state
  alphabet = "0ABCDEFGHIJKLMNOPQRSTUVWXYZ"
  tasktab  =  (10,0,0,0,0,0,0,0,0,0,0)
  tasklist =  0
  tcb = 0
  taskid = 0
  v1 = 0
  v2 = 0
  qpktcount    =  0
  holdcount    =  0
  tracing      =  1
  layout       =  0
  TRUE = 1
  FALSE = 0
  MAXINT = 32767
  BUFSIZE = 3


def append(pkt, ptr):
    pkt.link = 0
    while ( ptr.link ):
        ptr = ptr.link;
    ptr.link = pkt;

def createtask(id, pri, wkq, state, fn, v1, v2):
    t = T()
    t.link   = G.tasklist
    t.id     = id
    t.pri    = pri
    t.wkq    = wkq
    t.state  = state
    t.fn     = fn
    t.v1     = v1
    t.v2     = v2
    G.tasktab[id] = G.tasklist = t

def pkt(link, id, kind):
    p = P()

    for i in range(0, BUFSIZE+1):
        p.a2[i] = 0

    p.link = link
    p.id = id
    p.kind = kind
    p.a1 = 0

    return p


def trace(a):
    layout -= 1
    if layout <= 0 :
        print
        layout = 50;
    print a


def schedule():
    while tcb != 0 :
        pkt=0;

        switch ( tcb->t_state )
        {
            case S_WAITPKT:
                pkt = tcb->t_wkq;
                tcb->t_wkq = pkt->p_link;
                tcb->t_state = tcb->t_wkq == 0 ? S_RUN : S_RUNPKT;

            case S_RUN:
            case S_RUNPKT:
                taskid = tcb->t_id;
                v1 = tcb->t_v1;
                v2 = tcb->t_v2;
                if (tracing==TRUE) trace(taskid+'0');

                newtcb = (*(tcb->t_fn))(pkt);
                tcb->t_v1 = v1;
                tcb->t_v2 = v2;
                tcb = newtcb;
                break;

            case S_WAIT:
            case S_HOLD:
            case S_HOLDPKT:
            case S_HOLDWAIT:
            case S_HOLDWAITPKT:
                tcb = tcb->t_link;
                break;

            default:
                return;
        }
    }
}

def wait():
    tcb->t_state |= WAITBIT
    return tcb

struct task *holdself(void)
{
    ++holdcount;
    tcb->t_state |= HOLDBIT;
    return (tcb->t_link) ;
}

struct task *findtcb(int id)
{
    struct task *t = 0;

    if (1<=id && id<=(long)tasktab[0])
    t = tasktab[id];
    if (t==0) printf("\nBad task id %d\n", id);
    return(t);
}

struct task *release(int id)
{
    struct task *t;

    t = findtcb(id);
    if ( t==0 ) return (0);

    t->t_state &= NOTHOLDBIT;
    if ( t->t_pri > tcb->t_pri ) return (t);

    return (tcb) ;
}


struct task *qpkt(struct packet *pkt)
{
    struct task *t;

    t = findtcb(pkt->p_id);
    if (t==0) return (t);

    qpktcount++;

    pkt->p_link = 0;
    pkt->p_id = taskid;

   if (t->t_wkq==0)
    {
        t->t_wkq = pkt;
        t->t_state |= PKTBIT;
        if (t->t_pri > tcb->t_pri) return (t);
    }
    else
    {
        append(pkt, (struct packet *)&(t->t_wkq));
    }

    return (tcb);
}

struct task *idlefn(struct packet *pkt)
{
    --v2;
    if ( v2==0 ) return ( holdself() );

    if ( (v1&1) == 0 )
    {
        v1 = ( v1>>1) & MAXINT;
        return ( release(I_DEVA) );
    }
    else
    {
        v1 = ( (v1>>1) & MAXINT) ^ 0XD008;
        return ( release(I_DEVB) );
    }
}

struct task *workfn(struct packet *pkt)
{
    if ( pkt==0 ) return ( wait() );
    else
    {
        int i;

        v1 = I_HANDLERA + I_HANDLERB - v1;
        pkt->p_id = v1;

        pkt->p_a1 = 0;
        for (i=0; i<=BUFSIZE; i++)
        {
            v2++;
            if ( v2 > 26 ) v2 = 1;
            (pkt->p_a2)[i] = alphabet[v2];
        }
        return ( qpkt(pkt) );
    }
}

struct task *handlerfn(struct packet *pkt)
{
   if ( pkt!=0) append(pkt, 
                      (struct packet *)(pkt->p_kind==K_WORK ? &v1 : &v2));

   if ( v1!=0 )
    {
        int count;
        struct packet *workpkt = (struct packet *)v1;
        count = workpkt->p_a1;

        if ( count > BUFSIZE )
        {
           v1 = (long)(((struct packet *)v1)->p_link);
           return ( qpkt(workpkt) );
        }

        if ( v2!=0 )
        {
            struct packet *devpkt;

            devpkt = (struct packet *)v2;
            v2 = (long)(((struct packet *)v2)->p_link);
            devpkt->p_a1 = workpkt->p_a2[count];
            workpkt->p_a1 = count+1;
            return( qpkt(devpkt) );
        }
    }
    return ( wait() );
}

struct task *devfn(struct packet *pkt)
{
    if ( pkt==0 )
    {
        if ( v1==0 ) return ( wait() );
        pkt = (struct packet *)v1;
        v1 = 0;
        return ( qpkt(pkt) );
    }
    else
    {
        v1 = (long)pkt;
        if (tracing==TRUE) trace(pkt->p_a1);
        return ( holdself() );
    }
}

int main()
{
    struct packet *wkq = 0;

    printf("Bench mark starting\n");

    createtask(I_IDLE, 0, wkq, S_RUN, idlefn, 1, Count);

    wkq = pkt(0, 0, K_WORK);
    wkq = pkt(wkq, 0, K_WORK);

    createtask(I_WORK, 1000, wkq, S_WAITPKT, workfn, I_HANDLERA, 0);

    wkq = pkt(0, I_DEVA, K_DEV);
    wkq = pkt(wkq, I_DEVA, K_DEV);
    wkq = pkt(wkq, I_DEVA, K_DEV);

    createtask(I_HANDLERA, 2000, wkq, S_WAITPKT, handlerfn, 0, 0);

    wkq = pkt(0, I_DEVB, K_DEV);
    wkq = pkt(wkq, I_DEVB, K_DEV);
    wkq = pkt(wkq, I_DEVB, K_DEV);

    createtask(I_HANDLERB, 3000, wkq, S_WAITPKT, handlerfn, 0, 0);

    wkq = 0;
    createtask(I_DEVA, 4000, wkq, S_WAIT, devfn, 0, 0);
    createtask(I_DEVB, 5000, wkq, S_WAIT, devfn, 0, 0);

    tcb = tasklist;

    qpktcount = holdcount = 0;

    printf("Starting\n");

    tracing = FALSE;
    layout = 0;

    schedule();

    printf("finished\n");

    printf("qpkt count = %d  holdcount = %d\n",
           qpktcount, holdcount);

    printf("These results are ");
    if (qpktcount == Qpktcountval && holdcount == Holdcountval)
        printf("correct");
    else printf("incorrect");

    printf("\nend of run\n");
    return 0;
}

