/* This header file contains machine/system dependent #defines
** These are dependent on the -D parameter specified in Makefile.
** The possible -D parameters are:
**
**  -DforMAC           for Apple MAC (not recently tested)
**  -DforMIPS          for DEC R2000/3000 Workstations under Ultrix 4.3
**  -DforSGI           for SGI MIPS machines under Ultrix
**  -DforARM           for ARM under RISC OS (under development)
**  -DforLINUX         for Linux
**  -DforLINUXPPC      for Linux on a PowerMac G4
**  -DforSUN4          for Sun4m under SunOS 4.1.3
**  -DforSPARC         for Sun4m spac under SunOS 5.4
**  -DforALPHA         for DEC Alpha under OSF1 V3.2 17
**  -DforMSDOS         for MSDOS 32 bit protected mode usinf Borland C v4.0
**  -DforOS2           for OS/2 V2.1 using Cset/2 and Borland Tasm
**  -DforWin32         for Windows 95/98/NT using Microsoft Visual C
**  -DforCYGWIN32      for Windows 95/98/NT using GNU Cygnus Solutions
**  -DforBC4           for Windows 95/98/NT using Borland C 4.0 and TASM
**  -DforOS2           for OS/2 V2.1 using Cset/2 and Borland Tasm
*/

/* The MAC version just about works on a Power Macitosh 7100/66
** using Symantec Think C 6.0
** I used cintmain.c cinterp.c kblib.c and nullrastlib.c linked
** with the standard libraries ANSI and unix. The partition size was 5000K
** and #define forMAC was edited into this file. (I don't know how to
** get Think C to do that #definition for me).
** The command command files bc bs bp bco and bso had to be edited to
** change /s to :s and ../ to :: etc. These versions are in sys/MAC.
** If someone would suggest how to get a visible cursor I would be grateful.
*/

/*
** Cintmain and cinterp need the type signed char but this is
** not available on all implementations of C. On some the type char
** is signed, and on some (if fact most) signed char is allowed.
** Comment out of the following definitions of SIGNEDCHAR. A test in
** the function badimplementation in cintmain.c will determine whether
** you have made the right choice.
**
** Note that
**   #define CINTASM cintasm        will use a hand written cintcode
**                                  interpreter in addition to the
**                                  one implemented in C.
**   #define CINTASM interpreter    will only use the interperter
**                                  written in C, this typically runs
**                                  2-3 times slower.
*/

#define SIGNEDCHAR signed char
/* #define SIGNEDCHAR char */

#ifdef forMAC
#include <unix.h>
#include <time.h.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM interpret
#define REMOVE unlink
#define FILE_SEP_CH ':'
#define BIGENDER
#endif

#ifdef forMIPS
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM interpret
#define REMOVE unlink
#define FILE_SEP_CH '/'
#endif

#ifdef forSGI
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM interpret
#define REMOVE unlink
#define FILE_SEP_CH '/'
#endif

#ifdef forARM
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM interpret
#define REMOVE unlink
#define FILE_SEP_CH '/'
#endif

#ifdef forLINUX
#include <sys/stat.h>
#include <time.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '/'
#endif

#ifdef forLINUXPPC
#include <sys/stat.h>
#include <time.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '/'
#define BIGENDER
#endif

#ifdef forSUN4
#include <sys/stat.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (1000000)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '/'
#define BIGENDER
#endif

#ifdef forSPARC
#include <sys/stat.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '/'
#define BIGENDER
#endif

#ifdef forALPHA
#include <sys/stat.h>
#include <stdlib.h>
#define INT32 int
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '/'
#endif

#ifdef forMSDOS
#include <sys\stat.h>
#include <time.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLK_TCK)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '\\'
#endif

#ifdef forBC4
#include <sys\stat.h>
#include <time.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLK_TCK)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '\\'
#endif

#ifdef forOS2
#include <sys\stat.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLOCKS_PER_SEC)
#define CINTASM interpret
#define REMOVE remove
#define FILE_SEP_CH '\\'
#endif

#ifdef forCYGWIN32
#include <sys\stat.h>
#include <time.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLK_TCK)
#define CINTASM cintasm
#define REMOVE unlink
#define FILE_SEP_CH '\\'
#endif

#ifdef forWIN32
#include <sys\stat.h>
#include <time.h>
#define INT32 long
#define MALLOC(n) malloc((n)<<2)
#define TICKS_PER_SEC (CLK_TCK)
#define CINTASM interpret
#define REMOVE unlink
#define FILE_SEP_CH '\\'
#endif


typedef INT32 *INT32pt;
typedef FILE *FILEPT;

#define printfd printf

#define WD (INT32)
#define UWD (unsigned INT32)
#define PT (INT32 *)
#define BP (unsigned char *)
#define SBP (SIGNEDCHAR *)
#define HP (unsigned short *)
#define SHP (short *)

