// (c) Copyright M. Richards, 21 may 2001

/* Change log

21/5/2001
Changed manifest cli_initialstack to 50000 in CLIHDR (previously 5000)
*/

SECTION "CLI"

GET "libhdr"
GET "CLIHDR"

MANIFEST $(
namemax    = 25
promptmax  = 15
filemax    = 10
$)

LET start() BE
$( LET prompt      = VEC promptmax
   LET commandname = VEC namemax
   LET commandfile = VEC filemax
   LET globbase    = @globsize
   LET initprompt = "%n> "
   
   cli_prompt      := prompt
   cli_commandname := commandname
   cli_commandfile := commandfile

   FOR i = 0 TO initprompt%0 DO
       cli_prompt%i := initprompt%i
   cli_standardinput := input()
   cli_currentinput := cli_standardinput
   cli_standardoutput := output()
   cli_commandname%0 := 0
   cli_commandfile%0 := 0
   cli_defaultstack := cli_initialstack
   cli_returncode := 0
   cli_result2 := 0
   cli_module := 0
   cli_preloadlist := 0
   cli_tallyflag := FALSE

   $( LET ch, item = 0, ?

      writef(cli_prompt, 0)

      $( // Start of main command loop
         LET msecs = 0
         cli_interactive :=  cli_currentinput=cli_standardinput

         item := rditem(cli_commandname, namemax)

         SWITCHON item INTO
         $( CASE 0: // eof
                    IF cli_currentinput=cli_standardinput DO sys(0, 0)
                    BREAK

            CASE 1: // unquoted name
            CASE 2: // quoted name
              $( LET p, coptr = cli_preloadlist, 0

                 UNTIL p=0 DO            // Search in preloadlist.
                 $( IF compstring(cli_commandname, @p!2)=0 DO
                    $( cli_module := p!1
                       BREAK             // Module found.
                    $)
                    p := !p
                 $)

                 IF cli_module=0 DO
                    cli_module := loadseg(cli_commandname)

                 start := globword+1 // Unset start
                 UNLESS globin(cli_module)=0 DO
                    coptr := createco(clihook, cli_defaultstack)

                 TEST coptr=0
                 THEN $( cli_result2 := result2
                         writef("Can't load %s*n", cli_commandname)
                      $)
                 ELSE $( msecs := sys(30)
                         IF cli_tallyflag DO
                         $( cli_tallyflag := FALSE
                            sys(4)             // Turn on tallying
                         $)

                         // Transfer control to the command.
                         cli_returncode := callco(coptr, 0)

                         sys(5)                // Turn off tallying
                         cli_result2 := result2

                         msecs := sys(30) - msecs

                         // Unset user globals
                         FOR i = ug TO globsize DO
                              globbase!i := globword + i

                         // Restore the library globals
                         globin(rootnode!rtn_syslib)
                         globin(rootnode!rtn_blib)
                         globin(rootnode!rtn_cli)

                         deleteco(coptr)
                         selectinput (cli_currentinput)
                         selectoutput(cli_standardoutput)

                         UNLESS cli_returncode < cli_faillevel DO
                            writef("%s failed returncode %n*n",
                                    cli_commandname, cli_returncode)
                      $)

                 IF p=0 & cli_module~=0 DO unloadseg(cli_module)
                 cli_module := 0
              $)

            CASE 3:  // *n
            CASE 4:  // ;
                     ENDCASE

            DEFAULT:  
                writes("Error in command name*n")
         $)

         ch := '*n'
         IF unrdch() DO ch := rdch()
         // Skip to end of line unless last command terminated by nl or ;
         UNTIL ch='*n' | ch=';' | ch=endstreamch DO ch := rdch()
         IF ch='*n' & cli_currentinput=cli_standardinput DO
            writef(cli_prompt, msecs)

         IF intflag() DO $( writes("****BREAK - CLI*N")
                            BREAK
                         $)
      $) REPEAT

      UNLESS cli_currentinput=cli_standardinput DO
      $( endread()
         UNLESS cli_commandfile%0=0 DO $( deletefile(cli_commandfile)
                                          cli_commandfile%0 := 0
                                       $)
         cli_currentinput := cli_standardinput
         selectinput(cli_currentinput)
      $)
   $) REPEAT
$)
