// (c) Copyright: Martin Richards   June 1991

SECTION "BOOT"

GET "libhdr"

GLOBAL $(
checkaddr: 150
cont:      151
debug:     152
error:     153
gb:        154
gh:        155
gsb:       156
gsh:       157
gw:        158
instrtype: 159
isfun:     160
nextpc:    161
praddr:    162
prinstr:   163
print:     164
rdval:     165
rdvaraddr: 166
rch:       167
wrcortn:   168
wrframe:   169
writearg:  170

bpt:       180
bpt_addr:  181
bpt_instr: 183
brkstep:   184
ch:        185
cptr:      186
fsize:     187
gptr:      188
hilim:     189
lch:       190
lolim:     191
membase:   192
memlim:    193
oldcount:  194
pptr:      195
recp:      196
recl:      197
regs:      198
style:     199
snglstep:  200
val:       201
vars:      202
$)

MANIFEST
$(
g_globsize=0; g_sys=3; g_currco=7; g_colist=8; g_rootnode=9

globword  = #xEFEF0000
entryword = #x0000DFDF

f_brk   = 2

r_a     = 0
r_b     = 1
r_c     = 2
r_p     = 3
r_g     = 4
r_st    = 5
r_pc    = 6
r_count = 7
r_upb   = 7
$)

LET start() BE 
$( LET regv = VEC r_upb
   LET g = getvec(1000)  // The CLI global vector
   LET p = getvec(206)   // The CLI root coroutine stack
   
   rdch, wrch := sardch, sawrch
   writes("*nBCPL Cintcode System (24 Sept 2003)*n")

   FOR i = 0 TO 206 DO p!i := 0
   FOR i = 0 TO 1000 DO g!i := globword + i;
   g!g_globsize := 1000
   g!g_sys      := sys
   g!g_rootnode := rootnodeaddr
   g!g_currco   := 0          // These are initialised to simplify
   g!g_colist   := 0          // the initial debugging of cintasm.
   
   regs         := regv   
   regs!r_a     := 0          // A
   regs!r_b     := 0          // B
   regs!r_c     := 0          // C
   regs!r_p     := p<<2       // P
   regs!r_g     := g<<2       // G
   regs!r_st    := 0          // ST
   regs!r_pc    := startcli   // PC
   regs!r_count := -1         // Count  (-1 = infinity)

   membase      := rootnodeaddr!rtn_membase
   memlim       := membase + rootnodeaddr!rtn_memsize
   lolim, hilim := membase, memlim
   vars         := TABLE 0,0,0,0,0,0,0,0,0,0
   bpt_addr     := TABLE 0,0,0,0,0,0,0,0,0,0
   bpt_instr    := TABLE 0,0,0,0,0,0,0,0,0,0
   style        := 'F'
   val          := 0
   brkstep, snglstep := FALSE, FALSE

   $( LET res = sys(1, regs)  // Call the interpreter
      IF res=0 DO sys(0, 0)

      IF res=-1 LOOP // Re-enter the interpreter immediately

      debug(res)
   $) REPEAT
$)

AND startcli() BE
$( LET f, size, c = startcli, 200, 0
   currco := @f-3          // Initialise the coroutine environment
   colist := currco
   currco!co_pptr   := 0
   currco!co_parent := -1  // Mark as root coroutine.
   currco!co_list   := 0

   sys(24, rootnode!rtn_syslib)  // globin(syslib)
   sys(24, rootnode!rtn_blib)    // globin(blib)
   
   rootnode!rtn_keyboard := 0
   rootnode!rtn_screen   := 0
//FOR k = 'A' TO 'Z' DO sys(11, k)
//sys(11, '*n')
   selectinput(findinput("**"))
   selectoutput(findoutput("**"))
      
   rootnode!rtn_cli := globin(loadseg("CLI"))
   
   start()
   sys(0, 0)
$)

LET debug(code) BE
$( recp  := @code-3 << 2 // level() without using BLIB.
   recl  := recover
   bpt   := -1
   gptr  := regs!r_g >> 2
   cptr  := gptr!g_currco
   pptr  := regs!r_p >> 2
   fsize := cptr + 6 + cptr!co_size
   val   := regs!r_pc

   IF code=3 DO  // Zero count.
   $( IF brkstep DO
      $( brkstep := FALSE  // Breakpoint continuation.
         IF oldcount>=0 DO oldcount := oldcount-1
         regs!r_count := oldcount
         GOTO ret  // Restore BRK instructions and continue.
      $)
      IF snglstep DO
      $( snglstep := FALSE // Single step.
         IF oldcount>=0 DO oldcount := oldcount-1
         regs!r_count := oldcount
         writes("A="); print(regs!r_a)
         writes("B="); print(regs!r_b)
         prinstr(val)
         newline()
         GOTO recover
      $)
   $)

   FOR i = 0 TO 9 DO            // Remove all BRK instructions
   $( LET ba = bpt_addr!i
      IF ba~=0 & 0%ba=f_brk DO 0%ba := bpt_instr!i
   $)

   IF code=2 DO  // BRK instruction
      FOR i = 0 TO 9 IF bpt_addr!i=val DO
      $( bpt := i
         writef("*n!! BPT %n:  ", bpt)
         writearg(val)
         writes("*n   ")
         writes("A="); print(regs!r_a)
         writes("B="); print(regs!r_b)
         prinstr(val)
         newline()
         GOTO recover
      $)

  IF code=10 DO // Cintasm single step
  $(  writes("A="); print(regs!r_a)
      writes("B="); print(regs!r_b)
      prinstr(val)
      newline()
      GOTO recover
   $)
   
   $( LET gn = regs!r_pc - globword
      LET mess =  VALOF SWITCHON code INTO
                  $( CASE   1: RESULTIS "Illegal instruction"
                     CASE   2: RESULTIS "BRK instruction"
                     CASE   3: RESULTIS "Zero count"
                     CASE   4: TEST 0<=gn<=gptr!0
                               THEN RESULTIS "G%n unassigned"
                               ELSE RESULTIS "Negative pc"
                     CASE   5: RESULTIS "Division by zero"
                     CASE  10: RESULTIS "Cintasm single step"
                     CASE  99: RESULTIS "User requested"
                     CASE 110: RESULTIS "Callco fault"
                     CASE 111: RESULTIS "Resumeco fault"
                     CASE 112: RESULTIS "Deleteco fault"
                     CASE 186: RESULTIS "Selectinput fault"
                     CASE 187: RESULTIS "Selectoutput fault"
                     CASE 189: RESULTIS "Wrch fault"
                     CASE 190: RESULTIS "Endread fault"
                     CASE 191: RESULTIS "Endwrite fault"
                     CASE 197: RESULTIS "Store chain fault"
                     DEFAULT:  RESULTIS "Unknown fault"
                  $)
      writef("*n!! ABORT %n: ", code)
      writef(mess, gn)
      newline()
   $)
recover:
   ch := '*n'
nxt:                       // Main loop for debug commands
   IF ch='*n' DO writes("** ")
   rch()
sw:SWITCHON ch INTO

   $( DEFAULT: error()
      
      CASE '*s':
      CASE '*t':
      CASE '*n': GOTO nxt

      CASE '?':
          writes("*n?     Print list of debug commands*n")
          writes("Gn Pn Rn Vn           Variables*n")
          writes("G  P  R  V            Pointers*n")
          writes("ddd #odd #xhh #hh 'c  Constants*n")
          writes("**e /e %e +e -e |e &e Dyadic operators*n")
          writes("< > !                 Postfixed operators*n")
          writes("SGn SPn SRn SVn       Store in variable*n")
          writes("=     Print current value*n")
          writes("Tn    Print n consecutive locations*n")
          writes("$c    Set print style C, D, F, O, S, U or X*n")
          writes("LL LH Set Low and High store limits*n")
          writes("I     Print current instruction*n")
          writes("N     Print next instruction*n")
          writes("Q     Quit*n")
          writes("B 0Bn eBn  List, Unset or Set breakpoints*n")
          writes("C          Continue execution*n")
          writes("X          Equivalent to G4B9C*n")
          writes("Z          Equivalent to P1B9C*n")
          writes("\          Execute one instruction*n")
          writes(",          Move down one stack frame*n")
          writes(".          Move to current coroutine*n")
          writes(";          Move to parent coroutine*n")
          writes("[          Move to first coroutine*n")
          writes("]          Move to next coroutine*n")
          GOTO recover

      CASE '0': CASE '1': CASE '2':
      CASE '3': CASE '4': CASE '5':
      CASE '6': CASE '7': CASE '8':
      CASE '9': CASE '#': CASE '*'':
      CASE 'G': CASE 'P': CASE 'R':
      CASE 'V':
                val := rdval();                 GOTO sw

      CASE '+': rch(); val := val  +  rdval();  GOTO sw
      CASE '-': rch(); val := val  -  rdval();  GOTO sw
      CASE '**':rch(); val := val  *  rdval();  GOTO sw
      CASE '/': rch(); val := val  /  rdval();  GOTO sw
      CASE '%': rch(); val := val REM rdval();  GOTO sw
      CASE '|': rch(); val := val  |  rdval();  GOTO sw
      CASE '&': rch(); val := val  &  rdval();  GOTO sw

      CASE '<': val := val << 1;                GOTO nxt
      CASE '>': val := val >> 1;                GOTO nxt
      CASE '!': val := !val;                    GOTO nxt

      CASE '=': print(val); newline();          GOTO recover

      CASE 'S': $( LET type = rch()
                   rch()
                   !rdvaraddr(type) := val
                   GOTO sw
                $)

      CASE 'T': rch()
                FOR i=0 TO rdn()-1 DO
                $( IF i REM 5 = 0 DO praddr(val)
                   print(cont(val))
                   val := val+1
                $)
                newline()
                GOTO sw

      CASE '$': rch(); style := ch;             GOTO nxt

      CASE 'Q': sys(0, 0)   // Quit
         
      CASE 'L': rch()
                IF ch='L' DO $( lolim := val; GOTO nxt  $)
                IF ch='H' DO $( hilim := val; GOTO nxt  $)
                error()
         
      CASE 'N': val := nextpc(val)
      CASE 'I': prinstr(val); newline(); GOTO recover

      CASE 'X':  // Equivalent to G4B9C
         val := gptr!4  // set break point 9 at clihook
      CASE 'Z':  // Equivalent to P1B9C
         IF ch='Z' DO val := pptr!1
      CASE 'B':  // Set, clear or display breakpoints.
      $( LET comch = ch
         TEST comch='B' THEN rch() ELSE ch := '9'
         IF '0'<=ch<='9' DO
         $( LET n = ch - '0'  // Set or Clear a break point.
            bpt_addr!n := 0
            IF val=0 GOTO nxt
            checkaddr(val>>2)
            FOR i = 0 TO 9 DO
               IF bpt_addr!i=val DO bpt_addr!i := 0
            bpt_addr!n  := val
            bpt_instr!n := 0%val
            IF comch='B' GOTO nxt
            GOTO resume
         $)
         UNLESS ch='*n' DO newline()
         FOR i = 0 TO 9 DO  // List break points.
         $( LET ba=bpt_addr!i
            UNLESS ba=0 DO
            $( writef("%n:  ", i)
               writearg(ba)
               newline()
            $)
         $)
         GOTO recover
      $)

      resume:
      CASE 'C': // Continue execution.
             $( LET pc = regs!r_pc
                newline()
                FOR i = 0 TO 9 IF pc=bpt_addr!i DO
                $( oldcount := regs!r_count
                   regs!r_count := 1
                   brkstep := TRUE
                   RETURN  // Execute the instruction at the break point
                $)
                GOTO ret  // Resume normal execution.
             $)

      CASE '\': oldcount := regs!r_count // Single step execution.
                regs!r_count := 1
                snglstep := TRUE
                RETURN

      CASE ',':  // Move down one stack frame and output it.
             $( LET a = pptr!0>>2
                IF a=cptr DO $( writef(" Base of stack*n")
                                GOTO recover
                             $)
                fsize := pptr-a
                pptr := a
                wrframe()
                GOTO recover
             $)

      CASE ';': IF cont(cptr+co_parent)<0 DO
                $( writef(" End of parent chain*n")
                   GOTO recover
                $)
                cptr := cont(cptr+co_parent)
                GOTO newc
      CASE '.': cptr := cont(gptr+g_currco)
                GOTO newc
      CASE ']': cptr := cont(cptr+co_list)
                IF cptr=0 DO $( writef(" End of coroutine list*n")
                                GOTO recover
                             $)
                GOTO newc
      CASE '[': cptr := cont(gptr+g_colist)

 newc:          TEST cptr=cont(gptr+g_currco)
                THEN pptr := regs!r_p>>2
                ELSE pptr := cont(cptr+co_pptr)>>2
                fsize := cptr + 6 + cptr!co_size
                wrcortn()
                GOTO recover

      CASE endstreamch: newline(); GOTO ret 
    $)

ret:FOR i = 0 TO 9 DO $( LET ba=bpt_addr!i // Set all breakpoints.
                         UNLESS ba=0 DO 0%ba := f_brk
                      $)
$)

AND wrcortn() BE
$( LET size = cont(cptr+co_size)
   LET hwm = size+6
   writef(" %i7: ", cptr)
   TEST cptr!co_parent=-1
   THEN      writes("   Root")
   ELSE TEST cptr!co_parent=0
        THEN writes("Dormant")
        ELSE writes(" Active")
   writes(" coroutine ")
   writearg(cont(cptr+co_fn))
   WHILE cont(cptr+hwm)=0 DO hwm:=hwm-1
   writef("  Size %i5  Hwm %i5*n   ", size, hwm-6)
   wrframe()
$)

AND wrframe() BE
$( LET n = fsize
   IF n>6 DO n := 6
   writef(" %i7:", pptr)
   IF pptr=cptr DO $( writes("   Base of stack*n"); RETURN $)
   writearg(pptr!2)
   FOR i=3 TO n DO print(cont(pptr+i))
   newline()
$)

AND writearg(n) BE TEST isfun(n)
                   THEN writef("    %s ", (n>>2)-2)
                   ELSE TEST globword<=n<=globword+999
                        THEN writef("    GLOB%i3 ", n-globword)
                        ELSE writef(" %iA ", n)

AND isfun(f) = VALOF
$( LET a = f>>2
   UNLESS (f&3)=0 & membase+3<=a<=memlim RESULTIS FALSE
   IF a!-3=entryword & (a-2)%0=7 RESULTIS TRUE 
   RESULTIS FALSE
$)

AND rdn() = VALOF
$( LET res = 0
   WHILE '0'<=ch<='9' DO $( res := res*10 + ch - '0'; rch() $)
   RESULTIS res
$)

AND rdvaraddr(type) = VALOF
$( LET base, lim, n = ?, ?, ?
   UNLESS '0'<=ch<='9' DO error()
   n := rdn()
   SWITCHON type INTO
   $( DEFAULT:   error()
      CASE 'G': base, lim := gptr, gptr!g_globsize; ENDCASE
      CASE 'P': base, lim := pptr, fsize-1;         ENDCASE
      CASE 'R': base, lim := regs, 7;               ENDCASE
      CASE 'V': base, lim := vars, 9;               ENDCASE
   $)
   UNLESS 0<=n<=lim DO error()
   RESULTIS base + n
$)

AND rdval() = VALOF
$( LET res, radix = 0, 10

   SWITCHON ch INTO
   $( DEFAULT:   error()

      CASE 'G':  rch()
                 IF '0'<=ch<='9' RESULTIS !rdvaraddr('G')
                 RESULTIS gptr

      CASE 'P':  rch()
                 IF '0'<=ch<='9' RESULTIS !rdvaraddr('P')
                 RESULTIS pptr

      CASE 'R':  rch()
                 IF '0'<=ch<='9' RESULTIS !rdvaraddr('R')
                 RESULTIS regs

      CASE 'V':  rch()
                 IF '0'<=ch<='9' RESULTIS !rdvaraddr('V')
                 RESULTIS vars

      CASE '*'': rch(); res := lch; rch();  RESULTIS res

      CASE '#':  radix := 16
                 rch()
                 IF ch='O' DO $( radix := 8; rch() $)

      CASE '0': CASE '1': CASE '2': CASE '3': CASE '4': 
      CASE '5': CASE '6': CASE '7': CASE '8': CASE '9': 
                 $( LET d = 100
                    IF '0'<=ch<='9' DO d := ch-'0'
                    IF 'A'<=ch<='F' DO d := ch-'A'+10
                    IF d>=radix RESULTIS res
                    res := res*radix+d
                    rch()
                 $) REPEAT
   $)
$)

AND praddr(a) BE
$( LET type = 'A'
   IF gptr<=a<=gptr+gptr!g_globsize DO type, a := 'G', a-gptr
   IF pptr<=a<=pptr+fsize           DO type, a := 'P', a-pptr
   IF regs<=a<=regs+7               DO type, a := 'R', a-regs
   IF vars<=a<=vars+9               DO type, a := 'V', a-vars
   writef("*n%c%i3:", type, a)
$)

AND print(n) BE SWITCHON style INTO
$( DEFAULT:   error();                 RETURN
   CASE 'C':  $( LET p = @n
                 writef(" %C%C%C%C ", p%0, p%1, p%2, p%3)
                 RETURN
              $)
   CASE 'D':  writef( " %IA ", n);     RETURN
   CASE 'F':  writearg(n);             RETURN
   CASE 'O':  writef( " %OC ", n);     RETURN
   CASE 'S':  writef( " %S ",  n);     RETURN
   CASE 'U':  writef( " %UA ", n);     RETURN
   CASE 'X':  writef( " %X8 ", n);     RETURN
$)

AND checkaddr(a) = VALOF
$( UNLESS lolim<=a<=hilim DO error()
   RESULTIS a
$)

AND cont(a) = !checkaddr(a)

AND error() BE $( writes("  ??*n"); longjump(recp, recl) $)

AND rch() BE $( lch := rdch(); ch := capitalch(lch) $)

AND wrfcode(f) BE
$( LET s = VALOF SWITCHON f&31 INTO
   $( DEFAULT:
      CASE  0: RESULTIS "     -     K   LLP     L    LP    SP    AP     A"
      CASE  1: RESULTIS "     -    KH  LLPH    LH   LPH   SPH   APH    AH"
      CASE  2: RESULTIS "   BRK    KW  LLPW    LW   LPW   SPW   APW    AW"
      CASE  3: RESULTIS "    K3   K3G  K3G1  K3GH   LP3   SP3   AP3  L0P3"
      CASE  4: RESULTIS "    K4   K4G  K4G1  K4GH   LP4   SP4   AP4  L0P4"
      CASE  5: RESULTIS "    K5   K5G  K5G1  K5GH   LP5   SP5   AP5  L0P5"
      CASE  6: RESULTIS "    K6   K6G  K6G1  K6GH   LP6   SP6   AP6  L0P6"
      CASE  7: RESULTIS "    K7   K7G  K7G1  K7GH   LP7   SP7   AP7  L0P7"
      CASE  8: RESULTIS "    K8   K8G  K8G1  K8GH   LP8   SP8   AP8  L0P8"
      CASE  9: RESULTIS "    K9   K9G  K9G1  K9GH   LP9   SP9   AP9  L0P9"
      CASE 10: RESULTIS "   K10  K10G K10G1 K10GH  LP10  SP10  AP10 L0P10"
      CASE 11: RESULTIS "   K11  K11G K11G1 K11GH  LP11  SP11  AP11 L0P11"
      CASE 12: RESULTIS "    LF   S0G  S0G1  S0GH  LP12  SP12  AP12 L0P12"
      CASE 13: RESULTIS "   LF$   L0G  L0G1  L0GH  LP13  SP13 XPBYT     S"
      CASE 14: RESULTIS "    LM   L1G  L1G1  L1GH  LP14  SP14   LMH    SH"
      CASE 15: RESULTIS "   LM1   L2G  L2G1  L2GH  LP15  SP15   BTC  MDIV"
      CASE 16: RESULTIS "    L0    LG   LG1   LGH  LP16  SP16   NOP CHGCO"
      CASE 17: RESULTIS "    L1    SG   SG1   SGH   SYS    S1    A1   NEG"
      CASE 18: RESULTIS "    L2   LLG  LLG1  LLGH   SWB    S2    A2   NOT"
      CASE 19: RESULTIS "    L3    AG   AG1   AGH   SWL    S3    A3  L1P3"
      CASE 20: RESULTIS "    L4   MUL   ADD    RV    ST    S4    A4  L1P4"
      CASE 21: RESULTIS "    L5   DIV   SUB   RV1   ST1   XCH    A5  L1P5"
      CASE 22: RESULTIS "    L6   REM   LSH   RV2   ST2  GBYT  RVP3  L1P6"
      CASE 23: RESULTIS "    L7   XOR   RSH   RV3   ST3  PBYT  RVP4  L2P3"
      CASE 24: RESULTIS "    L8    SL   AND   RV4  STP3   ATC  RVP5  L2P4"
      CASE 25: RESULTIS "    L9   SL$    OR   RV5  STP4   ATB  RVP6  L2P5"
      CASE 26: RESULTIS "   L10    LL   LLL   RV6  STP5     J  RVP7  L3P3"
      CASE 27: RESULTIS "  FHOP   LL$  LLL$   RTN  GOTO    J$ ST0P3  L3P4"
      CASE 28: RESULTIS "   JEQ   JNE   JLS   JGR   JLE   JGE ST0P4  L4P3"
      CASE 29: RESULTIS "  JEQ$  JNE$  JLS$  JGR$  JLE$  JGE$ ST1P3  L4P4"
      CASE 30: RESULTIS "  JEQ0  JNE0  JLS0  JGR0  JLE0  JGE0 ST1P4     -"
      CASE 31: RESULTIS " JEQ0$ JNE0$ JLS0$ JGR0$ JLE0$ JGE0$     -     -"
   $)
   LET n = f>>5 & 7
   FOR i = 6*n+1 TO 6*(n+1) DO wrch(s%i)
$)

AND prinstr(pc) BE
$( LET a = 0
   writef(" %i7: ", pc)
   checkaddr(pc>>2)
   wrfcode(0%pc)
   SWITCHON instrtype(0%pc) INTO
   $( DEFAULT:
      CASE '0':                                      RETURN
      CASE '1': a  := gb(pc+1);                      ENDCASE
      CASE '2': a  := gh(pc+1);                      ENDCASE
      CASE '4': a  := gw(pc+1);                      ENDCASE
      CASE 'R': a  := pc+1 + gsb(pc+1);              ENDCASE
      CASE 'I': pc := pc+1 + 2*gb(pc+1) & #xFFFFFFFE
                a  := pc + gsh(pc);                  ENDCASE
   $)
   writef("  %n", a)
   vars!9 := a
$)

AND gb(pc) = 0%pc

AND gsb(pc) = 0%pc<=127 -> 0%pc, 0%pc-256

AND gsh(pc) = VALOF
$( LET h = gh(pc)
   RESULTIS h<=#x7FFF -> h, h - #x10000
$)

AND gh(pc) = VALOF
$( LET w = ?
   LET p = @w  // Designed to work on both Big and Little Ender M/Cs.
   p%0, p%1, p%2, p%3 := 0%pc, 0%(pc+1), 0%pc, 0%(pc+1)
   RESULTIS w & #xFFFF
$)

AND gw(pc) = VALOF
$( LET w = ?
   LET p = @w  // Designed to work on both Big and Little Ender M/Cs.
   p%0, p%1, p%2, p%3 := 0%pc, 0%(pc+1), 0%(pc+2), 0%(pc+3)
   RESULTIS w
$)

AND instrtype(f) = "?0000000000RI10000000000000RIRI*
                  *124111111111111111110000RIRIRIRI*
                  *12411111111111111111000000RIRIRI*
                  *1242222222222222222200000000RIRI*
                  *124000000000000000BL00000000RIRI*
                  *12400000000000000000000000RIRIRI*
                  *1240000000000?2?000000000000000?*
                  *124000000000012?00000000000000??"%f

AND nextpc(pc) = VALOF SWITCHON instrtype(0%pc) INTO
                       $( DEFAULT:
                          CASE '0': RESULTIS pc+1
                          CASE '1':
                          CASE 'R':
                          CASE 'I': RESULTIS pc+2
                          CASE '2': RESULTIS pc+3
                          CASE '4': RESULTIS pc+5
                          CASE 'B': pc := pc+2 & #xFFFFFFFE
                                    RESULTIS pc + 4*gh(pc) + 6
                          CASE 'L': pc := pc+2 & #xFFFFFFFE
                                    RESULTIS pc + 2*gh(pc) + 6
                       $)

