SECTION "sial-alpha"

GET "libhdr"

GET "sial.h"

/*
 # It uses the following linkage conventions:
 #
 # $0       v0       The returned value
 # $1-$8    t0 - t7  Temporary registers
 # $9-$15   s0 - s6  Must be preserved
 # $16-$21  a0 - a5  The first six conforming arguments
 # $22-$25  t8 - t11 Temporary registers
 # $26      ra       The return address
 # $27      t12      Temporary registers (or procedure value)
 # $28      at       May be used by the assembler
 # $29      gp       Global pointer
 # $30      sp       Points to stack location of first argument on entry
 # $31      zero     Always has value zero


	
 # The register usage is as follows:

 # s0   A
 # s1   B
 # s2   C
 # s3   m/c addr P
 # s4   m/c addr G
 # s5   bcpl pointer G
 # s6   m/c addr PC

 # t8   m/c address of base of Cintcode memory -- saved in 48(sp)

*/


GLOBAL $(
sialin:   200
asmout:   201
stdin:    202
stdout:   203

rdf:      210
rdp:      211
rdg:      212
rdk:      213
rdw:      215
rdl:      216
rdc:      218
rdcode:   219

pval:     220
gval:     221
kval:     222
wval:     224
lval:     225
mval:     226

scan:     230
cvf:      231
cvfp:     232
cvfg:     233
cvfk:     234
cvfw:     236
cvfl:     237

sectname: 250
modletter:251
charv:    252
labnumber:253
$)

LET start() = VALOF
$( LET argv = VEC 20
   LET v    = VEC 20
   LET cv   = VEC 256/bytesperword

   sectname := v
   sectname%0 := 0
   modletter := 'A'
   charv := cv
   labnumber := 0

   asmout := 0
   stdout := output()
   IF rdargs("FROM,TO/K", argv, 20)=0 DO
   $( writes("Bad args for sial-alpha*n")
      RESULTIS 20
   $)
   IF argv!0=0 DO argv!0 := "prog.sial"
   IF argv!1=0 DO argv!1 := "prog.s"
   sialin := findinput(argv!0)
   IF sialin=0 DO
   $( writef("Trouble with file %s*n", argv!0)
      RESULTIS 20
   $)
   asmout := findoutput(argv!1)
   
   IF asmout=0 DO
   $( writef("Trouble with file %s*n", argv!1)
      RESULTIS 20
   $)
   
   writef("Converting %s to %s*n", argv!0, argv!1)
   selectinput(sialin)
   selectoutput(asmout)

   writef(" # Code generated by sial-alpha*n*n")
   writef("#include <regdef.h>*n")
   writef(".text*n.align 4*n")

   scan()
   endread()
   UNLESS asmout=stdout DO endwrite()
   selectoutput(stdout)
   writef("Conversion complete*n")
   RESULTIS 0
$)

AND nextlab() = VALOF
{ labnumber := labnumber+1
  RESULTIS labnumber
}

// argument may be of form Ln
AND rdcode(let) = VALOF
$( LET a, ch, neg = 0, ?, FALSE

   ch := rdch() REPEATWHILE ch='*s' | ch='*n'

   IF ch=endstreamch RESULTIS -1

   UNLESS ch=let DO error("Bad item, looking for %c found %c*n", let, ch)

   ch := rdch()

   IF ch='-' DO { neg := TRUE; ch := rdch() }

   WHILE '0'<=ch<='9' DO $( a := 10*a + ch - '0'; ch := rdch()  $)

   RESULTIS neg -> -a, a
$)

AND rdf() = rdcode('F')
AND rdp() = VALOF { pval := rdcode('P'); RESULTIS pval }
AND rdg() = VALOF { gval := rdcode('G'); RESULTIS gval }
AND rdk() = VALOF { kval := rdcode('K'); RESULTIS kval }
AND rdw() = VALOF { wval := rdcode('W'); RESULTIS wval }
AND rdl() = VALOF { lval := rdcode('L'); RESULTIS lval }
AND rdm() = VALOF { mval := rdcode('M'); RESULTIS mval }
AND rdc() = rdcode('C')

AND error(mess, a, b, c) BE
$( LET out = output()
   UNLESS out=stdout DO
   $( selectoutput(stdout)
      writef(mess, a, b, c)
      selectoutput(out)
   $)
   writef(mess, a, b, c)
$)

AND scan() BE
$( LET op = rdf()

   SWITCHON op INTO

   $( DEFAULT:       error(" # Bad op %n*n", op); LOOP

      CASE -1:       RETURN
     
      CASE f_lp:     cvfp("LP") // a := P!n
                     writef("*n ldq s0,%n(s3)", 8*pval)
                     ENDCASE
      CASE f_lg:     cvfg("LG") // a := G!n
                     writef("*n ldq s0,%n(s4)", 8*gval)
                     ENDCASE
      CASE f_ll:     cvfl("LL") // a := !Ln
                     writef("*n ldq s0,L%c%n", modletter, lval)
                     ENDCASE

      CASE f_llp:    cvfp("LLP") // a := @ P!n
                     writef("*n lda s0,%n(s3)", 8*pval)
                     writef("*n srl s0,3,s0")
                     ENDCASE
      CASE f_llg:    cvfg("LLG") // a := @ G!n
                     writef("*n lda s0,%n(s4)", 8*gval)
                     writef("*n srl s0,3,s0")
                     ENDCASE
      CASE f_lll:    cvfl("LLL") // a := @ !Ln
                     writef("*n lda s0,L%c%n", modletter, lval)
                     writef("*n srl s0,3,s0")
                     ENDCASE
      CASE f_lf:     cvfl("LF") // a := byte address of Ln
                     writef("*n lda s0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_lw:     cvfm("LW")
                     writef("*n ldq s0,M%c%n", modletter, mval)
                     ENDCASE

      CASE f_l:      cvfk("L") // a := n
                     IF kval=0 DO { writef("*n bis zero,zero,s0"); ENDCASE }
                     writef("*n ldiq s0,%n", kval)
                     ENDCASE
      CASE f_lm:     cvfk("LM") // a := -n
                     writef("*n ldiq s0,-%n", kval)
                     ENDCASE

      CASE f_sp:     cvfp("SP") // P!n := a
                     writef("*n stq s0,%n(s3)", 8*pval)
                     ENDCASE
      CASE f_sg:     cvfg("SG") // G!n := a
                     writef("*n stq s0,%n(s4)", 8*gval)
                     ENDCASE
      CASE f_sl:     cvfl("SL") // !Ln := a
                     writef("*n stq s0,L%c%n", modletter, lval)
                     ENDCASE

      CASE f_ap:     cvfp("AP") // a := a + P!n
                     writef("*n ldq t0,%n(s3)", 8*pval)
                     writef("*n addq s0,t0,s0")
                     ENDCASE
      CASE f_ag:     cvfg("AG") // a := a + G!n
                     writef("*n ldq t0,%n(s4)", 8*gval)
                     writef("*n addq s0,t0,s0")
                     ENDCASE
      CASE f_a:      cvfk("A") // a := a + n
                     IF kval=0 ENDCASE
                     writef("*n ldil t0,%n", kval)
                     writef("*n addq s0,t0,s0")
                     ENDCASE
      CASE f_s:      cvfk("S")  // a := a - n
                     IF kval=0 ENDCASE
                     writef("*n ldil t0,%n", kval)
                     writef("*n subq s0,t0,s0")
                     ENDCASE

      CASE f_lkp:    cvfkp("LKP") // a := P!n!k
                     writef("*n ldq t0,%n(s3)", 8*pval)
                     writef("*n s8addq t0,zero,t0")
                     writef("*n ldq s0,%n(t0)", 8*kval)
                     ENDCASE
      CASE f_lkg:    cvfkg("LKG") // a := G!n!k
                     writef("*n ldq t0,%n(s4)", 8*gval)
                     writef("*n s8addq t0,zero,t0")
                     writef("*n ldq s0,%n(t0)", 8*kval)
                     ENDCASE
      CASE f_rv:     cvf("RV")  // a := ! a
                     writef("*n s8addq s0,zero,t0")
                     writef("*n ldq s0,0(t0)")
                     ENDCASE
      CASE f_rvp:    cvfp("RVP") // a := P!n!a
                     writef("*n ldq t0,%n(s3)", 8*pval)
                     writef("*n addq s0,t0,t0")
                     writef("*n s8addq t0,zero,t0")
                     writef("*n ldq s0,0(t0)")
                     ENDCASE
      CASE f_rvk:    cvfk("RVK") // a := a!k
                     writef("*n s8addq s0,zero,t0")
                     writef("*n ldq s0,%n(t0)", 8*kval)
                     ENDCASE
      CASE f_st:     cvf("ST") // !a := b
                     writef("*n s8addq s0,zero,t0")
                     writef("*n stq s1,0(t0)")
                     ENDCASE
      CASE f_stp:    cvfp("STP") // P!n!a := b
                     writef("*n ldq t0,%n(s3)", 8*pval)
                     writef("*n addq s0,t0,t0")
                     writef("*n s8addq t0,zero,t0")
                     writef("*n stq s1,0(t0)")
                     ENDCASE
      CASE f_stk:    cvfk("STK") // a!n := b
                     writef("*n s8addq s0,zero,t0")
                     writef("*n stq s1,%n(t0)", 8*kval)
                     ENDCASE
      CASE f_stkp:   cvfkp("STKP")  // P!n!k := a
                     writef("*n ldq t0,%n(s3)", 8*pval)
                     writef("*n s8addq t0,zero,t0")
                     writef("*n stq s0,%n(t0)", 8*kval)
                     ENDCASE
      CASE f_skg:    cvfkg("SKG") // G!n!k := a
                     writef("*n ldq t0,%n(s4)", 8*gval)
                     writef("*n s8addq t0,zero,t0")
                     writef("*n stq s0,%n(t0)", 8*kval)
                     ENDCASE
      CASE f_xst:    cvf("XST") // !b := a
                     writef("*n s8addq s1,zero,t0")
                     writef("*n stq s0,0(t0)")
                     ENDCASE

      CASE f_k:      cvfp("K") // Call  a(b,...) incrementing P by n
                     writef("*n mov s0,t1")
                     writef("*n mov s1,s0")
                     writef("*n lda t0,%n(s3)", 8*pval)
                     writef("*n jsr ra,(t1),1")
                     ENDCASE
      CASE f_kpg:    cvfpg("KPG") // Call Gg(a,...) incrementing P by n
                     writef("*n ldq t1,%n(s4)", 8*gval)
                     writef("*n lda t0,%n(s3)", 8*pval)
                     writef("*n jsr ra,(t1),1")
                     ENDCASE

      CASE f_neg:    cvf("NEG") // a := - a
                     writef("*n subq zero,s0,s0") 
                     ENDCASE
      CASE f_not:    cvf("NOT") // a := ~ a
                     writef("*n ornot zero,s0,s0") 
                     ENDCASE
      CASE f_abs:    cvf("ABS") // a := ABS a
                   { LET l = nextlab()
                     writef("*n bge s0,S%c%n", modletter, l)
                     writef("*n subq zero,s0,s0")
                     writef("*nS%c%n:", modletter, l)
                     ENDCASE
                   }

      CASE f_xdiv:   cvf("XDIV") // a := a / b
                     writef("*n divq s0,s1,s0")
                     ENDCASE
      CASE f_xrem:   cvf("XREM") // a := a REM b
                     writef("*n remq s0,s1,s0")
                     ENDCASE
      CASE f_xsub:   cvf("XSUB") // a := a - b
                     writef("*n subq s0,s1,s0")
                     ENDCASE

      CASE f_mul:    cvf("MUL") // a := b * a; c := ?
                     writef("*n mulq s1,s0,s0")
                     ENDCASE
      CASE f_div:    cvf("DIV")  // a := b / a; c := ?
                     writef("*n divq s1,s0,s0")
                     ENDCASE
      CASE f_rem:    cvf("REM") // a := b REM a; c := ?
                     writef("*n remq s1,s0,s0")
                     ENDCASE
      CASE f_add:    cvf("ADD") // a := b + a
                     writef("*n addq s1,s0,s0")
                     ENDCASE
      CASE f_sub:    cvf("SUB") // a := b - a
                     writef("*n subl s1,s0,s0")
                     ENDCASE

      CASE f_eq:     cvf("EQ") // a := b = a
                     writef("*n cmpeq s1,s0,s0")
                     writef("*n subq zero,s0,s0")
                     ENDCASE
      CASE f_ne:     cvf("NE") // a := b ~= a
                     writef("*n cmpeq s1,s0,s0")
                     writef("*n subq s0,1,s0")
                     ENDCASE
      CASE f_ls:     cvf("LS") // a := b < a
                     writef("*n cmplt s1,s0,s0")
                     writef("*n subq zero,s0,s0")
                     ENDCASE
      CASE f_gr:     cvf("GR") // a := b > a
                     writef("*n cmplt s0,s1,s0")
                     writef("*n subq zero,s0,s0")
                     ENDCASE
      CASE f_le:     cvf("LE") // a := b <= a
                     writef("*n cmple s1,s0,s0")
                     writef("*n subq zero,s0,s0")
                     ENDCASE
      CASE f_ge:     cvf("GE") // a := b >= a
                     writef("*n cmple s0,s1,s0")
                     writef("*n subq zero,s0,s0")
                     ENDCASE

      CASE f_eq0:    cvf("EQ0") // a := a = 0
                     writef("*n cmpeq s0,zero,s0")
                     writef("*n subq zero,s0,s0")
                     ENDCASE
      CASE f_ne0:    cvf("NE0") // a := a ~= 0
                     writef("*n cmpeq s0,zero,s0")
                     writef("*n subq s0,1,s0")
                     ENDCASE
      CASE f_ls0:    cvf("LS0") // a := a < 0
                     writef("*n sra s0,63,s0")
                     ENDCASE
      CASE f_gr0:    cvf("GR0") // a := a > 0
                     writef("*n cmplt zero,s0,s0")
                     writef("*n subq zero,s0,s0")
                     ENDCASE
      CASE f_le0:    cvf("LE0") // a := a <= 0
                     writef("*n cmple s0,zero,s0")
                     writef("*n subq zero,s0,s0")
                     ENDCASE
      CASE f_ge0:    cvf("GE0") // a := a >= 0
                     writef("*n cmple zero,s0,s0")
                     writef("*n subq zero,s0,s0")
                     ENDCASE

      CASE f_lsh:    cvf("LSH") // a := b << a
                     writef("*n cmpule s0,63,t0")
                     writef("*n subq zero,t0,t0")
                     writef("*n and s1,t0,t0")
                     writef("*n sll t0,s0,s0")
                     ENDCASE
      CASE f_rsh:    cvf("RSH") // a := b >> a 
                     writef("*n cmpule s0,63,t0")
                     writef("*n subq zero,t0,t0")
                     writef("*n and s1,t0,t0")
                     writef("*n srl t0,s0,s0")
                     ENDCASE
      CASE f_and:    cvf("AND") // a := b & a 
                     writef("*n and s1,s0,s0") 
                     ENDCASE
      CASE f_or:     cvf("OR") // a := b | a 
                     writef("*n or s1,s0,s0") 
                     ENDCASE
      CASE f_xor:    cvf("XOR") // a := b NEQV a
                     writef("*n xor s1,s0,s0") 
                     ENDCASE
      CASE f_eqv:    cvf("EQV") // a := b EQV a 
                     writef("*n xor s1,s0,s0") 
                     writef("*n ornot zero,s0,s0") 
                     ENDCASE

      CASE f_gbyt:   cvf("GBYT") // a := b % a
                     writef("*n s8addq s1,s0,v0") 
                     writef("*n ldq_u s0,0(v0)") 
                     writef("*n extbl s0,v0,s0") 
                     ENDCASE
      CASE f_xgbyt:  cvf("XGBYT") // a := a % b 
                     writef("*n s8addq s0,s1,v0") 
                     writef("*n ldq_u s0,0(v0)") 
                     writef("*n extbl s0,v0,s0") 
                     ENDCASE
      CASE f_pbyt:   cvf("PBYT") // b % a := c
                     writef("*n s8addq s1,s0,v0") 
                     writef("*n ldq_u a0,0(v0)") 
                     writef("*n insbl s2,v0,t2") 
                     writef("*n mskbl a0,v0,a0") 
                     writef("*n bis a0,t2,a0") 
                     writef("*n stq_u a0,0(v0)") 
                     ENDCASE
      CASE f_xpbyt:  cvf("XPBYT") // a % b := c 
                     writef("*n s8addq s0,s1,v0") 
                     writef("*n ldq_u a0,0(v0)") 
                     writef("*n insbl s2,v0,t2") 
                     writef("*n mskbl a0,v0,a0") 
                     writef("*n bis a0,t2,a0") 
                     writef("*n stq_u a0,0(v0)") 
                     ENDCASE

// swb       Kn Ld K1 L1 ... Kn Ln   Binary chop switch, Ld default
      CASE f_swb:    cvswb()
                     ENDCASE

// swl       Kn Ld L1 ... Ln         Label vector switch, Ld default
      CASE f_swl:    cvswl()
                     ENDCASE

      CASE f_xch:    cvf("XCH") // swap a and b
                     writef("*n mov s0,v0")
                     writef("*n mov s1,s0")
                     writef("*n mov v0,s1")
                     ENDCASE
      CASE f_atb:    cvf("ATB") // b := a
                     writef("*n mov s0,s1")
                     ENDCASE
      CASE f_atc:    cvf("ATC") // c := a
                     writef("*n mov s0,s2")
                     ENDCASE
      CASE f_bta:    cvf("BTA") // a := b
                     writef("*n mov s1,s0")
                     ENDCASE
      CASE f_btc:    cvf("BTC") // c := b
                     writef("*n mov s1,s2")
                     ENDCASE
      CASE f_atblp:  cvfp("ATBLP") // b := a; a := P!n
                     writef("*n mov s0,s1")
                     writef("*n ldq s0,%n(s3)", 8*pval)
                     ENDCASE
      CASE f_atblg:  cvfg("ATBLG") // b := a; a := G!n
                     writef("*n mov s0,s1")
                     writef("*n ldq s0,%n(s4)", 8*gval)
                     ENDCASE
      CASE f_atbl:   cvfk("ATBL") // b := a; a := k
                     writef("*n mov s0,s1")
                     writef("*n ldiq s0,%n", kval)
                     ENDCASE

      CASE f_j:      cvfl("J") // jump to Ln
                     writef("*n br L%c%n", modletter, lval)
                     ENDCASE
      CASE f_rtn:    cvf("RTN") // procedure return
                     writef("*n ldq ra,8(s3)")
                     writef("*n ldq s3,0(s3)")
                     writef("*n ret zero,(ra),1")
                     ENDCASE
      CASE f_goto:   cvf("GOTO") // jump to a
                     writef("*n jmp zero,(s0)")
                     ENDCASE

      CASE f_ikp:    cvfkp("IKP") // a := P!n + k; P!n := a
                     writef("*n ldq s0,%n(s3)", 8*pval)
                     writef("*n addq s0,%n,s0", kval)
                     writef("*n stq s0,%n(s3)", 8*pval)
                     ENDCASE
      CASE f_ikg:    cvfkg("IKG") // a := G!n + k; G!n := a
                     writef("*n ldq s0,%n(s4)", 8*gval)
                     writef("*n addq s0,%n,s0", kval)
                     writef("*n stq s0,%n(s4)", 8*gval)
                     ENDCASE
      CASE f_ikl:    cvfkl("IKL") // a := !Ln + k; !Ln := a
                     writef("*n ldq s0,L%c%n", modletter, lval)
                     writef("*n addq s0,%n,s0", kval)
                     writef("*n stq s0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_ip:     cvfp("IP") // a := P!n + a; P!n := a
                     writef("*n ldq t0,%n(s3)", 8*pval)
                     writef("*n addq s0,t0,s0")
                     writef("*n stq s0,%n(s3)")
                     ENDCASE
      CASE f_ig:     cvfg("IG") // a := G!n + a; G!n := a
                     writef("*n ldq t0,%n(s4)", 8*gval)
                     writef("*n addq s0,t0,s0")
                     writef("*n stq s0,%n(s4)", 8*gval)
                     ENDCASE
      CASE f_il:     cvfl("IL") // a := !Ln + a; !Ln := a
                     writef("*n ldq t0,L%c%n", modletter, lval)
                     writef("*n addq s0,t0,s0")
                     writef("*n stq s0,L%c%n", modletter, lval)
                     ENDCASE

      CASE f_jeq:    cvfl("JEQ") // Jump to Ln if b = a
                     writef("*n cmpeq s1,s0,t0")
                     writef("*n bne t0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jne:    cvfl("JNE") // Jump to Ln if b ~= a
                     writef("*n cmpeq s1,s0,t0")
                     writef("*n beq t0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jls:    cvfl("JLS") // Jump to Ln if b < a
                     writef("*n cmplt s1,s0,t0")
                     writef("*n bne t0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jgr:    cvfl("JGR") // Jump to Ln if b > a
                     writef("*n cmplt s0,s1,t0")
                     writef("*n bne t0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jle:    cvfl("JLE") // Jump to Ln if b <= a
                     writef("*n cmple s1,s0,t0")
                     writef("*n bne t0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jge:    cvfl("JGE") // Jump to Ln if b >= a
                     writef("*n cmple s0,s1,t0")
                     writef("*n bne t0,L%c%n", modletter, lval)
                     ENDCASE

      CASE f_jeq0:   cvfl("JEQ0") // Jump to Ln if a = 0
                     writef("*n beq s0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jne0:   cvfl("JNE0") // Jump to Ln if a ~= 0
                     writef("*n bne s0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jls0:   cvfl("JLS0") // Jump to Ln if a < 0
                     writef("*n blt s0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jgr0:   cvfl("JGR0") // Jump to Ln if a > 0
                     writef("*n bgt s0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jle0:   cvfl("JLE0") // Jump to Ln if a <= 0
                     writef("*n ble s0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jge0:   cvfl("JGE0") // Jump to Ln if a >= 0
                     writef("*n bge s0,L%c%n", modletter, lval)
                     ENDCASE
      CASE f_jge0m:  cvfm("JGE0M") // Jump to Mn if a >= 0
                     writef("*n bge s0,M%c%n", modletter, mval)
                     ENDCASE

      // The following five opcodes are never generated by
      // the BCPL compiler
      CASE f_brk:    cvf("BRK") // Breakpoint instruction
                     writef("*n unimplemented")
                     ENDCASE
      CASE f_nop:    cvf("NOP") // No operation
                     ENDCASE
      CASE f_chgco:  cvf("CHGCO") // Change coroutine
                     writef("*n unimplemented")
                     ENDCASE
      CASE f_mdiv:   cvf("MDIV") // a := Muldiv(P!3, P!4, P!5) 
                     writef("*n unimplemented")
                     ENDCASE
      CASE f_sys:    cvf("SYS") // System function
                     writef("*n unimplemented")
                     ENDCASE

      CASE f_section:  cvfs("SECTION") // Name of section
                       FOR i = 0 TO charv%0 DO sectname%i := charv%i
                       ENDCASE
      CASE f_modstart: cvf("MODSTART") // Start of module  
                       sectname%0 := 0
                       ENDCASE
      CASE f_modend:   cvf("MODEND") // End of module 
                       modletter := modletter+1
                       ENDCASE
      CASE f_global:   cvglobal() // Global initialisation data
                       ENDCASE
      CASE f_string:   cvstring() // String constant
                       ENDCASE
      CASE f_const:    cvconst() // Large integer constant
                       ENDCASE

      CASE f_static:   cvstatic() // Static variable or table
                       ENDCASE
      CASE f_mlab:     cvfm("MLAB") // Destination of jge0m
                       writef("*nM%c%n:", modletter, mval)
                       ENDCASE
      CASE f_lab:      cvfl("LAB") // Program label
                       writef("*nL%c%n:", modletter, lval)
                       ENDCASE
      CASE f_lstr:     cvfm("LSTR") // a := Mn   (pointer to string)
                       writef("*n lda s0,M%c%n", modletter, mval)
                       writef("*n srl s0,3,s0")
                       ENDCASE
      CASE f_entry:    cventry() // Start of a function
                       ENDCASE
   $)

   newline()
$) REPEAT

AND cvf(s)  BE writef(" # %s", s)
AND cvfp(s) BE writef(" # %t7 P%n", s, rdp())
AND cvfkp(s) BE writef(" # %t7 K%n P%n", s, rdk(), rdp())
AND cvfg(s) BE writef(" # %t7 G%n", s, rdg())
AND cvfkg(s) BE writef(" # %t7 K%n G%n", s, rdk(), rdg())
AND cvfkl(s) BE writef(" # %t7 K%n L%n", s, rdk(), rdl())
AND cvfpg(s) BE writef(" # %t7 P%n G%n", s, rdp(), rdg())
AND cvfk(s) BE writef(" # %t7 K%n", s, rdk())
AND cvfw(s) BE writef(" # %t7 W%n", s, rdw())
AND cvfl(s) BE writef(" # %t7 L%n", s, rdl())
AND cvfm(s) BE writef(" # %t7 M%n", s, rdm())

AND cvswl() BE
$( LET n = rdk()
   LET l = rdl()
   LET lab = nextlab()
   writef(" # SWL K%n L%n", n, l)
   writef("*n blt s0,L%c%n", modletter, l)
   writef("*n cmplt s0,%n,t0", n)
   writef("*n beq t0,L%c%n", modletter, l)
   writef("*n lda t0,S%c%n", modletter,lab)
   writef("*n s8addq s0,t0,t0")
   writef("*n ldq t0,0(t0)")
   writef("*n jmp zero,(t0)")
   writef("*n .data")
   writef("*n .align 3")
   writef("*nS%c%n:", modletter, lab)
   FOR i = 1 TO n DO
   { writef("*n # L%n", rdl())
     writef("*n .quad L%c%n", modletter, lval)
   }
   writef("*n .text")
$)

AND cvswb() BE
$( LET n = rdk()
   LET l = rdl()
   writef(" # SWB K%n L%n", n, l)
   FOR i = 1 TO n DO 
   $( LET k = rdk()
      LET l = rdl()
      writef("*n # K%n L%n", k, l)
      writef("*n cmpeq s0,%n,t0", k)
      writef("*n bne t0,L%c%n", modletter, l)
   $)
   writef("*n br L%c%n", modletter, l)
$)

AND cvglobal() BE
$( LET n = rdk()
   writef(" # GLOBAL K%n*n", n)
   IF sectname%0=0 FOR i = 0 TO 4 DO sectname%i := "prog"%i
   writef("*n.globl %s*n", sectname)
   writef("%s:*n", sectname)
   FOR i = 1 TO n DO
   $( LET g = rdg()
      LET n = rdl()
      writef(" # G%n L%n*n", g, n)
      writef(" lda t0,L%c%n*n", modletter, n)
      writef(" stq t0,%n(a0)*n", 8*g)
   $)
   writef(" # G%n", rdg())
   writef("*n ret zero,(ra),1*n")
$)

AND rdchars() = VALOF
{ LET n = rdk()
  charv%0 := n
  FOR i = 1 TO n DO charv%i := rdc()
  RESULTIS n
}

AND cvstring() BE
$( LET lab = rdm()
   LET n = rdchars()
   writef(" # STRING  M%n K%n", lab, n)
   FOR i = 1 TO n DO writef(" C%n", charv%i)
   writef("*n.data")
   writef("*n .align 3")
   writef("*nM%c%n:", modletter, lab)
   FOR i = 0 TO n DO writef("*n .byte %n", charv%i)
   writef("*n .text")
$)

AND cvconst() BE
$( LET lab = rdm()
   LET w = rdw()
   writef(" # CONST   M%n W%n", lab, w)
   writef("*n.data")
   writef("*n .align 3")
   writef("*nM%c%n:", modletter, lab)
   writef("*n .quad %n", w)
   writef("*n .text")
$)

AND cvstatic() BE
$( LET lab = rdl()
   LET n = rdk()
   writef(" # STATIC  L%n K%n", lab, n)
   writef("*n.data")
   writef("*n .align 3")
   writef("*nL%c%n:", modletter, lab)
   FOR i = 1 TO n DO { writef("*n # W%n", rdw())
                       writef("*n .quad %n", wval)
                     }
   writef("*n .text")
$)

AND cvfs(s) BE
$( LET n = rdchars()
   writef(" # %t7 K%n", s, n)
   FOR i = 1 TO n DO writef(" C%n", charv%i)
$)

AND cventry() BE
$( LET n = rdchars()
   LET op = rdf()
   LET lab = rdl()
   writef("*n # Entry to: %s*n", charv)
   writef(" # %t7 K%n", "ENTRY", n)
   FOR i = 1 TO n DO writef(" C%n", charv%i)
   newline()
   TEST op=f_lab THEN writef(" # LAB     L%n*n", lab)
                 ELSE writef(" # Bad op F%n L%n*n", op, lab)
   writef("*nL%c%n:", modletter, lab)
   writef("*n stq s3,0(t0)")   // NP!0 := P
   writef("*n mov t0,s3")      // P    := NP
   writef("*n stq ra,8(s3)")   // P!1  := return address
   writef("*n stq t1,16(s3)")  // P!2  := entry address
   writef("*n stq s0,24(s3)")  // P!3  := arg1
$)
