SECTION "procode"

GET "libhdr"

MANIFEST
$(
// OCODE keywords
s_true=4; s_false=5
s_rv=8; s_fnap=10
s_mult=11; s_div=12; s_rem=13
s_plus=14; s_minus=15; s_query=16; s_neg=17; s_abs=19
s_eq=20; s_ne=21; s_ls=22; s_gr=23; s_le=24; s_ge=25
s_not=30; s_lshift=31; s_rshift=32; s_logand=33
s_logor=34; s_eqv=35; s_neqv=36
s_lf=39; s_lp=40; s_lg=41; s_ln=42; s_lstr=43
s_ll=44; s_llp=45; s_llg=46; s_lll=47
s_needs=48; s_section=49
s_rtap=51; s_goto=52
s_finish=68
s_switchon=70
s_global=76
s_sp=80; s_sg=81; s_sl=82; s_stind=83
s_jump=85; s_jt=86; s_jf=87
s_lab=90; s_stack=91; s_store=92; s_rstack=93; s_entry=94
s_save=95; s_fnrn=96; s_rtrn=97; s_res=98
s_datalab=100; s_itemn=102; s_endproc=103
s_getbyte=120; s_putbyte=121
$)


LET start() = VALOF
$( LET argv = VEC 20
   LET ocodein = ?
   AND ocodeprn = 0
   LET sysprint = output()
   IF rdargs("FROM,TO/K", argv, 20)=0 DO
   $( writes("Bad args for procode*n")
      RESULTIS 20
   $)
   IF argv!0=0 DO argv!0 := "OCODE"
   IF argv!1=0 DO argv!1 := "**"
   ocodein := findinput(argv!0)
   IF ocodein=0 DO
   $( writef("Trouble with file %s*n", argv!0)
      RESULTIS 20
   $)
   ocodeprn := findoutput(argv!1)
   
   IF ocodeprn=0 DO
   $( writef("Trouble with file %s*n", argv!1)
      RESULTIS 20
   $)
   
   writef("Converting %s to %s*n", argv!0, argv!1)
   selectinput(ocodein)
   selectoutput(ocodeprn)
   scan()
   endread()
   UNLESS ocodeprn=sysprint DO endwrite()
   selectoutput(sysprint)
   writef("Conversion complete*n")
   RESULTIS 0
$)

// argument may be of form Ln
AND rdn() = VALOF
$( LET a, ch, sign = 0, ?, '+'

   ch := rdch() REPEATWHILE ch='*S' | ch='*n'

   IF ch=endstreamch RESULTIS 0

   IF ch='-' DO $( sign := '-'; ch := rdch() $)

   WHILE '0'<=ch<='9' DO $( a := 10*a + ch - '0'; ch := rdch()  $)

   IF sign='-' RESULTIS -a
   RESULTIS a
$)


AND scan() BE
$( LET ocodeop = rdn()
   LET op0, op1, op1l, len = 0, 0, 0, -1

   SWITCHON ocodeop INTO

   $( DEFAULT:         writef("Bad OCODE op %n*n", ocodeop); LOOP

      CASE 0:          RETURN
      
      CASE s_section:  op0, len := "SECTION", rdn(); ENDCASE
      CASE s_needs:    op0, len := "NEEDS",   rdn(); ENDCASE

      CASE s_lp:       op1 := "LP";            ENDCASE
      CASE s_lg:       op1 := "LG";            ENDCASE
      CASE s_ln:       op1 := "LN";            ENDCASE

      CASE s_lstr:     op0, len := "LSTR", rdn(); ENDCASE

      CASE s_true:     op0 := "TRUE";          ENDCASE
      CASE s_false:    op0 := "FALSE";         ENDCASE

      CASE s_llp:      op1 := "LLP";           ENDCASE
      CASE s_llg:      op1 := "LLG";           ENDCASE

      CASE s_sp:       op1 := "SP";            ENDCASE
      CASE s_sg:       op1 := "SG";            ENDCASE

      CASE s_lf:       op1l := "LF";           ENDCASE
      CASE s_ll:       op1l := "LL";           ENDCASE
      CASE s_lll:      op1l := "LLL";          ENDCASE
      CASE s_sl:       op1l := "SL";           ENDCASE
      
      CASE s_stind:    op0 := "STIND";         ENDCASE

      CASE s_rv:       op0 := "RV";            ENDCASE

      CASE s_mult:     op0 := "MULT";          ENDCASE
      CASE s_div:      op0 := "DIV";           ENDCASE
      CASE s_rem:      op0 := "REM";           ENDCASE
      CASE s_plus:     op0 := "PLUS";          ENDCASE
      CASE s_minus:    op0 := "MINUS";         ENDCASE
      CASE s_eq:       op0 := "EQ";            ENDCASE
      CASE s_ne:       op0 := "NE";            ENDCASE
      CASE s_ls:       op0 := "LS";            ENDCASE
      CASE s_gr:       op0 := "GR";            ENDCASE
      CASE s_le:       op0 := "LE";            ENDCASE
      CASE s_ge:       op0 := "GE";            ENDCASE
      CASE s_lshift:   op0 := "LSHIFT";        ENDCASE
      CASE s_rshift:   op0 := "RSHIFT";        ENDCASE
      CASE s_logand:   op0 := "LOGAND";        ENDCASE
      CASE s_logor:    op0 := "LOGOR";         ENDCASE
      CASE s_eqv:      op0 := "EQV";           ENDCASE
      CASE s_neqv:     op0 := "NEQV";          ENDCASE
      CASE s_not:      op0 := "NOT";           ENDCASE
      CASE s_neg:      op0 := "NEG";           ENDCASE
      CASE s_abs:      op0 := "ABS";           ENDCASE

      CASE s_jt:       op1l := "JT";           ENDCASE
      CASE s_jf:       op1l := "JF";           ENDCASE

      CASE s_goto:     op0 := "GOTO";          ENDCASE

      CASE s_lab:      op1l := "LAB";          ENDCASE

      CASE s_query:    op0 := "QUERY";         ENDCASE

      CASE s_stack:    op1 := "STACK";         ENDCASE

      CASE s_store:    op0 := "STORE";         ENDCASE

      CASE s_entry:    $( LET l = rdn()
                          len := rdn()
                          writef("ENTRY L%n", l)
                          ENDCASE
                       $)

      CASE s_save:     op1 := "SAVE";          ENDCASE

      CASE s_fnap:     op1 := "FNAP";          ENDCASE
      CASE s_rtap:     op1 := "RTAP";          ENDCASE

      CASE s_fnrn:     op0 := "FNRN";          ENDCASE
      CASE s_rtrn:     op0 := "RTRN";          ENDCASE

      CASE s_endproc:  op0 := "ENDPROC";       ENDCASE // no args now

      CASE s_res:      op1l := "RES";          ENDCASE
      CASE s_jump:     op1l := "JUMP";         ENDCASE

      CASE s_rstack:   op1 := "RSTACK";        ENDCASE

      CASE s_finish:   op0 := "FINISH";        ENDCASE

      CASE s_switchon: $( LET n = rdn()
                          writef("SWITCHON %n L%n*n", n, rdn())
                          FOR i = 1 TO n DO
                          $( writef("%i8   ", rdn())
                             writef("L%n*n", rdn())
                          $)
                          newline()
                          LOOP
                       $)

      CASE s_getbyte:  op0 := "GETBYTE";       ENDCASE
      CASE s_putbyte:  op0 := "PUTBYTE";       ENDCASE

      CASE s_global:   $( LET n = rdn()
                          writef("GLOBAL %n*n", n)
                          FOR i = 1 TO n DO
                          $( writef("%i8   ", rdn())
                             writef("L%n*n", rdn())
                          $)
                          newline()
                          LOOP
                       $)


      CASE s_datalab:  op1l := "DATALAB";      ENDCASE
      CASE s_itemn:    op1  := "ITEMN";        ENDCASE
   $)

   UNLESS op0=0   DO writef("%S",     op0)
   UNLESS op1=0   DO writef("%S %n",  op1,  rdn())
   UNLESS op1l=0  DO writef("%S L%n", op1l, rdn())
   IF len>=0 DO $( writef(" %n ", len)
                   FOR i = 1 TO len DO
                   $( LET ch = rdn()
                      IF i REM 15 = 0 DO newline()
                      TEST 32<=ch<=127 THEN writef(" '%c'", ch)
                                       ELSE writef(" %i3 ", ch)
                   $)
                $)

   newline()
$) REPEAT

