// (C) Copyright 1978 Tripos Research Group
//     University of Cambridge
//     Computer Laboratory

// Modified by MR for Cintcode
// CASECH [FROM] input [TO] output [DICT dictionary] [L] [U] [A]

SECTION "CASECH"

GET "libhdr"

GLOBAL {
upper      : ug + 0
lower      : ug + 1
ch         : ug + 2
wordv      : ug + 3
wch        : ug + 4
wordsize   : ug + 5
charv      : ug + 6
treevec    : ug + 7
treep      : ug + 8
linecount  : ug + 9
nametree   : ug + 10
wordnode   : ug + 11
word       : ug + 12
echo       : ug + 13
settag     : ug + 14
mstream    : ug + 15
}


LET readprog() BE
{ SWITCHON ch INTO

  { CASE '*p':
    CASE '*n': linecount := linecount+1
    CASE '*t':
    CASE '*s': rch(echo) REPEATWHILE ch='*s'
               LOOP

    CASE '0':CASE '1':CASE '2':CASE '3':CASE '4':
    CASE '5':CASE '6':CASE '7':CASE '8':CASE '9':
         readnumber(10)
         LOOP

    CASE 'a':CASE 'b':CASE 'c':CASE 'd':CASE 'e':
    CASE 'f':CASE 'g':CASE 'h':CASE 'i':CASE 'j':
    CASE 'k':CASE 'l':CASE 'm':CASE 'n':CASE 'o':
    CASE 'p':CASE 'q':CASE 'r':CASE 's':CASE 't':
    CASE 'u':CASE 'v':CASE 'w':CASE 'x':CASE 'y':
    CASE 'z':
    CASE 'A':CASE 'B':CASE 'C':CASE 'D':CASE 'E':
    CASE 'F':CASE 'G':CASE 'H':CASE 'I':CASE 'J':
    CASE 'K':CASE 'L':CASE 'M':CASE 'N':CASE 'O':
    CASE 'P':CASE 'Q':CASE 'R':CASE 'S':CASE 'T':
    CASE 'U':CASE 'V':CASE 'W':CASE 'X':CASE 'Y':
    CASE 'Z':
         rdtag()
         writetag()
         LOOP

    CASE '$': rch(echo)
              TEST ch='(' | ch=')' THEN { rdtag()
                                           writetag()
                                        }
                                   ELSE rch(echo)
              LOOP

    CASE '/':
       rch(echo)
       IF ch='\'  DO { rch(echo) ;        LOOP }
       IF ch='**' DO { readcomment('/') ; LOOP }
       UNLESS ch='/' LOOP
    Comment:
       rch(echo) REPEATUNTIL iscc(ch) | ch=endstreamch
       LOOP

    CASE '|':
       rch(echo)
       IF ch='|' THEN GOTO Comment
       UNLESS ch='**' THEN LOOP
       readcomment('|')
       LOOP

    CASE '#':
       { LET radix = 8
          rch(echo)
          IF ch='B' DO { radix := 2  ; rch(echo) }
          IF ch='X' DO { radix := 16 ; rch(echo) }
          readnumber(radix)
          LOOP }

    CASE '"': rch(echo)
              FOR I = 1 TO 255 DO { IF ch='"' BREAK
                                     rdstrch()
                                  }
              rch(echo)
              LOOP

    CASE '*'':rch(echo)
              rdstrch()
              rch(echo)
              LOOP

    DEFAULT:  rch(echo)
              LOOP

    CASE endstreamch: RETURN
  }
} REPEAT

AND iscc(ch)= (ch='*n') | (ch='*p')

AND readcomment(term) BE
{
   rch(echo)
   {
      IF iscc(ch)
      THEN linecount := linecount + 1
      IF ch='**' THEN
      {
         rch(echo)
         UNLESS ch=term LOOP
         rch(echo)
         RETURN
      }
      IF ch=endstreamch THEN error("Endstreamch in comment*n")
      rch(echo)
   } REPEAT
}

AND lookupword(makenew) = VALOF
{ LET p = @nametree

   wordnode := !p

   UNTIL wordnode=0 DO
   { LET cmp = compstring(wordv, wordnode+2)
     IF cmp=0 RESULTIS wordnode+2
     p := wordnode + (cmp<0->0,1)
     wordnode := !p
   }

   IF makenew DO
   {
     wordnode := newvec(wordsize+2)
     wordnode!0, wordnode!1 := 0, 0
     FOR I = 0 TO wordsize DO wordnode!(I+2) := wordv!I
     !p:=wordnode
   }
   RESULTIS 0
}

AND declsyswords() BE
{
    d("ABS/AND/*
      *BE/BREAK/BY/*
      *CASE/*
      *DO/DEFAULT/*
      *EQ/EQV/ELSE/ENDCASE/*
      *FALSE/FIX/FLOAT/FOR/FINISH/*
      *GOTO/GE/GR/GLOBAL/GET/*
      *IF/INTO/*
      *LET/LV/LE/LS/LOGOR/LOGAND/LOOP/LSHIFT//")

    d("MANIFEST/*
      *NEEDS/NE/NOT/NEQV/*
      *OR/*
      *RESULTIS/RETURN/REM/RSHIFT/RV/*
      *REPEAT/REPEATWHILE/REPEATUNTIL/*
      *SECTION/SWITCHON/STATIC/*
      *TO/TEST/TRUE/THEN/TABLE/*
      *UNTIL/UNLESS/*
      *VEC/VALOF/*
      *WHILE//")
}

AND d(words) BE
{ LET i, length = 1, 0

  { LET ch = words%i
    TEST ch='/'
    THEN { IF length=0 RETURN
           charv!0 := length
           wordsize := packstring(charv, wordv)
           lookupword(TRUE)
           length := 0
         }
    ELSE { length := length + 1
           charv!length := ch
         }
    i := i + 1
  } REPEAT
}

AND rch(echo) BE
{
  IF echo DO wch(ch)
  ch:=rdch()
}

AND rdtag() BE
{ LET n = 1
  charv!1 := ch

  { rch(FALSE)
    UNLESS 'A'<=ch<='Z' |
           'a'<=ch<='z' |
           '0'<=ch<='9' |
            ch='.' BREAK
    n := n+1
    charv!n := ch
  } REPEAT

  charv!0 := n
  wordsize := packstring(charv, wordv)
 }


AND writetag() BE
{ LET mode=lookupword(settag)
  TEST mode=0 THEN
  {
    IF upper DO
    {
      FOR I=1 TO charv!0 DO
      {
         LET ch=charv!I
         IF 'a'<=ch<='z' THEN charv!I:=ch-'a'+'A'
      }
      packstring(charv, wordv)
    }
    IF lower FOR I=1 TO charv!0 DO
    {
      LET ch=charv!I
      IF 'A'<=ch<='Z' THEN charv!I:=ch-'A'+'a'
    }
    IF echo FOR I=1 TO charv!0 DO wch(charv!I)
  }
  ELSE IF echo DO writes(mode)
}

AND allupperwrch(ch) BE
{
  IF 'a'<=ch<='z' THEN ch:=ch-'a'+'A'
  wrch(ch)
}

AND readnumber(radix) BE UNTIL value(ch)>=radix & ch~='_' DO rch(echo)

AND value(ch) = '0'<=ch<='9' -> ch-'0',
                'a'<=ch<='f' -> ch-'a'+10,
                'A'<=ch<='F' -> ch-'A'+10,
                100

AND rdstrch() = VALOF
{ LET k = ch

  rch(echo)

  IF k='*n' DO error("Bad string")

  IF k='**' DO
  { IF ch='*n' | ch='*s' | ch='*t' DO
    { { IF ch='*n' DO linecount := linecount+1
        rch(echo)
      } REPEATWHILE ch='*n' | ch='*s' | ch='*t'
      rch(echo)
      RESULTIS rdstrch()
    }

    rch(echo)
  }

  RESULTIS k
}

AND newvec(n) = VALOF
{ treep := treep - n - 1
  IF treep<=treevec DO
  { error("Program too large")
    stop(20)
  }
  RESULTIS treep
}


AND error(Mess) BE
{ LET oldout=output()
  selectoutput(mstream)
  writef("Line %N %S*n", linecount, Mess)
  selectoutput(oldout)
}

AND start() = VALOF
{ LET v1 = VEC 50
  AND v2 = VEC 100
  LET argv = VEC 40
  AND instream, outstream = 0, 0
  AND dictstream = 0
  LET stdout = output()
  mstream := stdout
  linecount:=0
  wordv := v1
  charv := v2
  treevec := getvec(5000)
  treep   := treevec+5000

  IF treevec = 0
  THEN { writes("No space for tree*n"); RESULTIS 20 }

  upper, lower, wch := TRUE, FALSE, wrch
  IF rdargs("FROM/A,TO/A,DICT/K,U/S,L/S,A/S", argv, 40) = 0
  THEN { writes("Args no good*n"); RESULTIS 20 }

  instream := findinput(argv!0)
  IF instream = 0
  THEN { writef("Can't open %S*n", argv!0); RESULTIS 20 }

  outstream := findoutput(argv!1)
  IF outstream = 0
  THEN { writef("Can't open %S*n",argv!1); RESULTIS 20 }
  selectoutput(outstream)

  TEST argv!4
  THEN lower, upper := TRUE, FALSE
  ELSE IF argv!5
       THEN wch := allupperwrch

  TEST argv!2 = 0
  THEN dictstream := 0
  ELSE dictstream := findinput(argv!2)

  nametree:=0
  declsyswords()
  UNLESS dictstream=0
  DO { echo:=FALSE; settag:=TRUE
       selectinput(dictstream)
       rch(FALSE)
       readprog()
       endread()
     }
  echo:=TRUE
  settag:=FALSE
  selectinput(instream)
  rch(FALSE)
  readprog()
  endread()
  UNLESS outstream=stdout DO endwrite()
  freevec(treevec)
  RESULTIS 0
}
