GET "libhdr"

STATIC   $( v=0; w=0  $)

LET start() = VALOF
$( LET data  = VEC 15
   AND roots = VEC 15
   v, w := data, roots

   FOR i = 0 TO 15 DO v!i := i
   pr(v, 15)
// prints  -- Original data
//    0     1     2     3     4     5     6     7 ...

   w!0 := 1
   FOR i = 1 TO 15 DO w!i := mult(w!(i-1), 2)  // roots of unity
   fft16(v)
   pr(v, 15)
// prints   -- Transformed data
//  120    16    91    39   121   100    90    75 ...

   w!15 := 2
   FOR i = 14 TO 1 BY -1 DO w!i := mult(w!(i+1), 2) // inv roots of unity
   fft16(v)
   pr(v, 15)
// prints  -- 16 * original data
//    0    16    32    48    64    80    96   112 ...
   RESULTIS 0
$)

AND fft16(v) BE $( fft(16, v, 0, #b1000)
                   reorder(v, v, #B1000, #B0001)
                $)

AND reorder(p, q, bp, bq) BE TEST bp=0
                             THEN IF p<q DO $( LET t = !p
                                               !p := !q
                                               !q := t
                                            $)
                             ELSE $( LET bp1, bq1 = bp>>1, bq<<1
                                     reorder(p+bp, q+bq, bp1, bq1)
                                     reorder(p,    q,    bp1, bq1)
                                  $)

AND fft(nn, i, pp, bit) BE $( LET n, p = nn>>1, pp>>1
                              FOR j = i TO i+n-1 DO butterfly(j, j+n, w!p)
                              IF n=1 RETURN
                              fft(n,   i,     p, bit)
                              fft(n, i+n, p+bit, bit)
                           $)

AND butterfly(i, j, x) BE $( LET a, b = !i, mult(!j, x)
                             !i, !j := plus(a, b), diff(a, b)
                          $)

AND plus(a, b) = (a + b)       REM 257

AND diff(a, b) = (a + 257 - b) REM 257

AND mult(a, b) = (a * b)       REM 257

AND pr(v, upb) BE
$( FOR i = 0 TO upb DO
   $( writef("%I5 ", v!i)
      IF i REM 8 = 7 DO newline()
   $)
   newline()
$)



