/*

This is a simple demonstration of the RSA mechanism for
public key encryption.

Implemented in BCPL by Martin Richards (c) Sept 2000
*/

GET "libhdr"

GLOBAL {
p:ug; q    // Private key
N; e       // Public key
d          // Inverse of e mod (p-1)*(q-1)
M; C; M1   // Message, Crypted message, decoded message

}


LET start() = VALOF
{ 
  p, q, e, M :=   5,  11,   7,   2
//p, q, e, M := 541, 883, 691, 113

  N  := p*q

  writef("RSA demo*n")
  writef("Private key:  p=%n q=%n*n", p, q)
  writef("Public key:   pq=%n  e=%n*n", N, e)

  UNLESS e<(p-1)*(q-1) & gcd((p-1)*(q-1), e)=1 DO
  { writef("e is too large or not co-prime with (p-1)**(q-1)*n")
    RESULTIS 20
  }

  d := inv(e, (p-1)*(q-1))

  writef("Inverse of e mod (p-1)**(q-1) is %n (=d)*n", d)

  writef("*nMessage:         %i9 (=M)*n", M)

  C := exp(M, e, N) // M**e mod pq

  writef("M****e mod pq:     %i9 (=C)*n", C)

  M1 := exp(C, d, N) // C**d mod pq

  writef("C****d mod pq:     %i9*n", M1)
  RESULTIS 0
}

AND gcd(x, y) = x=y -> x,
                x<y -> gcd(x, y-x), gcd(x-y, y)
                

// Modular arithmetic functions

AND dv(a, m, b, n) = a=1 -> m,
                     a=0 -> m-n,
                     a<b -> dv(a, m, b REM a, m*(b/a)+n),
                     dv(a REM b, m+n*(a/b), b, n)

AND inv(x, m) = dv(x, 1, m-x, 1)

AND add(x, y, m) = VALOF
{ LET a = x+y
  IF a<m RESULTIS a
  RESULTIS a-m
}

AND sub(x, y, m) = add(x, neg(y), m)

AND neg(x, m)    = m-x

AND ovr(x, y, m) = mul(x, inv(y,m), m)

AND mul(x, y, m) = y=0 -> 0,
                   (y&1)=0 -> mul(add(x,x,m), y>>1, m),
                   add(x, mul(add(x,x,m), y>>1, m), m)

AND exp(x, y, m) = y=0 -> 1,
                   (y&1)=0 -> exp(mul(x,x,m), y>>1, m),
                   mul(x, exp(mul(x,x,m), y>>1, m), m)

