GET "libhdr"
GET "chk8.h"

LET bug(mess, a,b,c) BE
{ writef(mess, a, b, c)
  abort(999)
}

AND mk2(x, y) = VALOF
{ LET res = ?
//writef("mk2: x=%n y=%n*n", x,y)
  UNLESS freepairs DO
  { freepairs := getvec(4000)
    UNLESS freepairs DO
    { writef("out of space*n")
      abort(999)
      RESULTIS 0
    }
    !freepairs := pairblks
    pairblks := freepairs

    //writef("pair block %n allocated*n", pairblks)
    // Form free list of pairs
    res := pairblks+4000-1
    freepairs := 0
    UNTIL res<=pairblks DO
    { res!0, res!1 := freepairs, 0
      freepairs := res
      res := res-2
    }
  }
  res := freepairs
  freepairs := !freepairs
  res!0, res!1 := x, y
  RESULTIS res
}

AND unmk2(p) BE
{ !p := freepairs
  freepairs := p
}

LET rdrels(name) = VALOF
{ // Reads the specified file of relations. Each relation consists of 8
  // hex numbers for the 256-bit pattern followed by 8 non negative
  // integers specifying the variables.
  // The result is TRUE if successful, FALSE otherwise.
  // reln is set to the number of relations read
  // relv!1 to relv!reln pointer to the relation nodes.
  // The relation nodes are placed in relspace.
  LET res = FALSE
  LET p = 1 // The position in relspace of the next relation.
  LET oldin = input()
  LET data = findinput(name)
  LET value = ?

  reln := 0  // Number of relations read

  UNLESS data GOTO fin
  selectinput(data)
  ch := rdch()
  lex()

  UNTIL token=s_eof DO
  { LET rel = @relspace!p
    LET v, w = @rel!r_v0, @rel!r_w0
    UNLESS token=s_bits BREAK

    // Allocate a new relation
    p := p + r_upb + 1
    IF p > relspaceupb DO
    { writef("Insufficient space*n")
      BREAK
    }
    reln := reln+1
    relv!reln := rel
    FOR i = 0 TO r_upb DO rel!i := 0

    w!0 := lexval
    lex()

    FOR i = 1 TO 7 DO      // Read the bit pattern words
    { UNLESS token=s_bits BREAK
      w!i := lexval
      lex()
    }

    UNLESS token=s_var DO
    { writef("Bad relation data -- variable expected*n")
      BREAK
    }

    FOR i = 0 TO 7 DO      // Read the variable identifiers
    { UNLESS token=s_var BREAK
      v!i := lexval
      lex()
    }

    // Fill in the relation properties
    rel!r_instack := FALSE  // changed
    rel!r_weight := 9999    // weight -- dummy value
    rel!r_varcount := 8     // varcount
    rel!r_numb := reln      // Relation number
  }

fin:
  IF data UNLESS data=oldin DO endread()
  selectinput(oldin)
  RESULTIS reln>0
}

AND lex() BE
{ SWITCHON ch INTO
  { DEFAULT:  writef("Bad relation data, ch=%n '%c'*n", ch, ch)

    CASE endstreamch:
               token := s_eof
               RETURN

    CASE '*s':                              // White space
    CASE '*n': ch := rdch()
               LOOP

    CASE '#':                               // Comment
              ch := rdch() REPEATUNTIL ch='*n' | ch=endstreamch
              LOOP

    CASE 'v':                               // A variable
    CASE 'V': ch := rdch()
              lexval := rdnum()
              token := s_var
              RETURN

    CASE 'a':CASE 'b':CASE 'c':CASE 'd':CASE 'e':CASE 'f':
    CASE 'A':CASE 'B':CASE 'C':CASE 'D':CASE 'E':CASE 'F':
    CASE '0':CASE '1':CASE '2':CASE '3':CASE '4':
    CASE '5':CASE '6':CASE '7':CASE '8':CASE '9':
              lexval := rdhex()
              token := s_bits
              RETURN
  }
} REPEAT


// Read a hexadecimal number
AND rdhex() = VALOF
{ LET res = 0

  { LET dig = -1
    IF '0'<=ch<='9' DO dig := ch - '0'
    IF 'A'<=ch<='F' DO dig := ch - 'A' + 10
    IF 'a'<=ch<='f' DO dig := ch - 'a' + 10
    IF dig<0 BREAK
    res := (res<<4) + dig
    ch := rdch()
  } REPEAT

  RESULTIS res
} REPEAT

// Read a decimal number
AND rdnum() = VALOF
{ LET res = 0

  { LET dig = -1
    IF '0'<=ch<='9' DO dig := ch - '0'
    IF dig<0 BREAK
    res := res*10 + dig
    ch := rdch()
  } REPEAT

  RESULTIS res
} REPEAT

// Write out all the relations
AND wrrels(verbose) BE
{ FOR i = 1 TO reln DO wrrel(relv!i, verbose)
  newline()
}

// Write out a particular relation
AND wrrel(r, verbose) BE
{ LET upb = 7
  WHILE upb>0 DO
  { IF r!(r_w0+upb) BREAK
    upb := upb-1
  }

  IF FALSE DO
  { writes("*na7  ")
    FOR i = 0 TO upb DO writef((i&4)=0 -> "00000000 ", "11111111 ")
    writes("*na6  ")
    FOR i = 0 TO upb DO writef((i&2)=0 -> "00000000 ", "11111111 ")
    writes("*na5  ")
    FOR i = 0 TO upb DO writef((i&1)=0 -> "00000000 ", "11111111 ")
    writes("*na4  ")
    FOR i = 0 TO upb DO writef("11110000 ")
    writes("*na3  ")
    FOR i = 0 TO upb DO writef("11001100 ")
    writes("*na2  ")
    FOR i = 0 TO upb DO writef("10101010 ")
    newline()
  }

  IF verbose DO writef("%i2: ", r!r_numb)

  FOR i = r_w0 TO r_w0+upb DO writef("%x8 ", r!i)
  //IF upb>5 DO newline()

  upb := 7
  WHILE upb>0 DO
  { IF r!(r_v0+upb) BREAK
    upb := upb-1
  }

  FOR i = r_v0 TO r_v0+upb DO writef("v%n ",  origid(r!i))

  IF tracing DO writef(" S:%n W:%n N:%n",
                        r!r_instack,  r!r_weight, r!r_varcount)
  newline()
}

AND wrvars() BE
{ FOR id = 1 TO maxid DO
  { LET rl, count = refs!id, refcount!id
    LET info = varinfo!id
    LET i = info/2
    writef("v%n: ", origid(id))
    SWITCHON info INTO
    { DEFAULT:  IF info>0 DO
                { writef("%cv%n ", info REM 2 -> '~', ' ', origid(info/2))
                  ENDCASE
                }
                writef("???? "); ENDCASE
      CASE -2:  writef("X    "); ENDCASE
      CASE -1:  writef("     "); ENDCASE
      CASE  0:  writef("0    "); ENDCASE
      CASE  1:  writef("1    "); ENDCASE
    }
    WHILE rl DO
    { writef("  %i3", rl!1!r_numb)
      rl := !rl
    }
    newline()
  }
}

AND origid(id) = VALOF
{ LET tab = id2orig
  WHILE tab DO
  { id := tab!id
    tab := !tab
  }
  RESULTIS id
}

// formlists will construct the following vectors from
// the given set of relations.
// refs        refs!id is the list of relations using id
// refcount    hold the number of uses of each new id
// id2orig     a vector mapping new ids to old ids
// varinfo     a vector holding information about each new ids

AND formlists(rv, n) BE // rv!1 to rv!n are the given relations
{ LET iduses, maxoldid, old2new = 0, 0, 0

  // Find maxoldid
  FOR i = 1 TO n DO
  { LET rel = rv!i
    LET v = @rel!r_v0
    FOR j = 0 TO 7 DO
    { LET id = v!j  // Look at every variable used by every relation
      UNLESS id LOOP
      IF maxoldid<id DO maxoldid := id  // Maximum old identifier
    }
  }
  writef("Max old id = %n*n", maxoldid)

  old2new   := getvec(maxoldid)

  UNLESS old2new DO
  { writef("More space needed for old2new*n")
    abort(999)
    GOTO fin
  }

  // Mark all identifiers that have been used
  FOR id = 0 TO maxoldid DO old2new!id := 0
  FOR r = 1 TO n DO // Look at every relation
  { LET rel = rv!r
    LET v = @rel!r_v0
    FOR arg = 0 TO 7 DO // Look at every relation argument
    { LET id = v!arg
      IF id DO old2new!id := -1 // This old id has been used
    }
  }

  // Fill in the old2new table entries and calculate maxid
  maxid := 0
  old2new!0 := 0 // Identifier 0 always maps to zero
  FOR id = 1 TO maxoldid IF old2new!id DO
  { maxid := maxid+1
    old2new!id := maxid
  }

  writef("Max new id = %n*n", maxid)

  // Allocate the refs vector and others
  refs     := getvec(maxid)
  refcount := getvec(maxid)
  id2orig  := getvec(maxid)
  varinfo  := getvec(maxid)

  UNLESS refs & refcount & id2orig & varinfo DO
  { writef("More space needed*n")
    abort(999)
    GOTO fin
  }

  FOR id = 0 TO maxid DO
    id2orig!id, varinfo!id, refs!id, refcount!id := 0, -1, 0, 0

  // Construct the refs lists
  FOR r = 1 TO n DO // Look at every relation
  { LET rel = rv!r
    LET v = @rel!r_v0
    FOR arg = 0 TO 7 DO // Look at every relation argument
    { LET id = v!arg
      IF id DO
      { LET newid = old2new!id
        v!arg := newid       // Renumber identifier in the relation
        id2orig!newid := id  // Remember the mapping
        refs!newid := mk2(refs!newid, rel) // add to refs list
      }
    }
  }

  // Set the refcount values
  FOR id = 1 TO maxid DO refcount!id := length(refs!id)

  setweights()

fin:
  IF old2new  DO freevec(old2new)
}

AND length(p) = VALOF
{ LET res = 0
  WHILE p DO res, p := res+1, !p
  RESULTIS res
}

AND sortpairs(v, w, upb) BE  // (v!i,w!i) is the key for item i
{ LET m = 1
  UNTIL m>upb DO m := m*3 + 1  // Find first suitable value in the
                               // series:  1, 4, 13, 40, 121, 364, ...
  { m := m/3
    FOR i = m+1 TO upb DO
    { LET vi, wi = v!i, w!i
      LET j = i
      { LET k = j - m
        IF k<=0 | v!k < vi | v!k=vi & w!k<wi BREAK
        v!j, w!j := v!k, w!k
        j := k
      } REPEAT
      v!j, w!j := vi, wi
    }
  } REPEATUNTIL m=1
}

AND prpairs(v, w, upb) BE FOR i = 1 TO upb DO
  writef("%i3:  %i4  %i4*n", i, v!i, w!i)

AND setweights() BE FOR r = 1 TO reln IF relv!r DO
{ LET rel = relv!r
  LET v = @rel!r_v0
  LET weight, count = 0, 0
  FOR arg = 0 TO 7 DO
  { LET id = v!arg
    UNLESS id LOOP
    count := count + 1
    weight := weight + refcount!id
  }
  rel!r_varcount := count
  rel!r_weight   := weight
}

AND pushrel(r) BE UNLESS r!r_instack DO
{
  r!r_instack := TRUE
  IF relstackp>=relstackupb DO
  { writef("relstack too small*n")
    abort(999)
    RETURN
  }
  relstackp := relstackp + 1
  relstack!relstackp := r

  //newline()
  //wrrel(r, TRUE)
  //writef("pushrel:  ")
  //FOR i = 1 TO relstackp DO writef(" %n", relstack!i!r_numb)
  //newline()
//abort(4444)
}

AND poprel() = VALOF
{ LET rel = relstack!relstackp
  UNLESS relstackp RESULTIS 0
  rel!r_instack := FALSE

  //writef("*npoprel:   ")
  //FOR i = 1 TO relstackp DO writef(" %n", relstack!i!r_numb)
  //newline()
//wrrel(rel, TRUE)
//abort(4444)
  relstackp := relstackp -1
  RESULTIS rel
}

// Unlink one reference to rel in refs!id
AND rmref(rel, id) BE
{ LET a = @refs!id
  //wrrel(rel, TRUE)
  //writef("rmref: rel %n v%n*n", rel!r_numb, id)
//abort(5555)
  WHILE !a DO
  { LET rl = !a
    LET next = !rl
    IF rl!1=rel DO
    { // Reference to rel found
      !a, refcount!id := next, refcount!id -1 
      RETURN
    }
    rl := !next
  }
  writef("rmrel: relation not found, numb=%n v%n*n", rel!r_numb, id)
  abort(999)
}

AND andrelbits1(rel, w0) BE
{ LET w = @rel!r_w0
  w!0 := w!0 & w0
  w!1 := w!1 & w0
  w!2 := w!2 & w0
  w!3 := w!3 & w0
  w!4 := w!4 & w0
  w!5 := w!5 & w0
  w!6 := w!6 & w0
  w!7 := w!7 & w0
}

AND andrelbits2(rel, w0, w1) BE
{ LET w = @rel!r_w0
  w!0 := w!0 & w0
  w!1 := w!1 & w1
  w!2 := w!2 & w0
  w!3 := w!3 & w1
  w!4 := w!4 & w0
  w!5 := w!5 & w1
  w!6 := w!6 & w0
  w!7 := w!7 & w1
}

AND andrelbits4(rel, w0, w1, w2, w3) BE
{ LET w = @rel!r_w0
  w!0 := w!0 & w0
  w!1 := w!1 & w1
  w!2 := w!2 & w2
  w!3 := w!3 & w3
  w!4 := w!4 & w0
  w!5 := w!5 & w1
  w!6 := w!6 & w2
  w!7 := w!7 & w3
}

AND andrelbits8v(rel, v) BE
{ LET w = @rel!r_w0
  w!0 := w!0 & v!0
  w!1 := w!1 & v!1
  w!2 := w!2 & v!2
  w!3 := w!3 & v!3
  w!4 := w!4 & v!4
  w!5 := w!5 & v!5
  w!6 := w!6 & v!6
  w!7 := w!7 & v!7
}


