// Unit transformations on a single relation

// exchargs(rel, i, j)    exchange the positions of arguments i and j
// ignorearg(rel, i)         remove arg i assuming it is unconstrained
// standardise(rel)       sort arguments and remove duplicates

// split(rel)             split rel into two if possible

SECTION "trans1"

GET "libhdr"
GET "chk8.h"

// Exchange arguments i and j in a relation
LET exchargs(rel, i, j) BE
// Assume i and j are in the range 0..7
{ LET a, b, c, d = rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3
  LET e, f, g, h = rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7
  LET v = @rel!r_v0
  LET t = v!i
newline()
wrrel(rel)
writef("exchargs: args %n %n*n", i, j)
  v!i := v!j    // Swap variable identifiers
  v!j := t

  // Adjust the bit pattern
  SWITCHON i*8 + j INTO
  { DEFAULT:
      ENDCASE  // Either i=j or an error
    CASE #76: CASE #67:
      rel!r_w2, rel!r_w3, rel!r_w4, rel!r_w5 := e, f, c, d
      ENDCASE
    CASE #75: CASE #57:
      rel!r_w1, rel!r_w3, rel!r_w4, rel!r_w6 := e, g, b, d
      ENDCASE
    CASE #74: CASE #47:
      rel!r_w0 := a&#x0000FFFF | e<<16
      rel!r_w1 := b&#x0000FFFF | f<<16
      rel!r_w2 := c&#x0000FFFF | g<<16
      rel!r_w3 := d&#x0000FFFF | h<<16
      rel!r_w4 := e&#xFFFF0000 | a>>16
      rel!r_w5 := f&#xFFFF0000 | b>>16
      rel!r_w6 := g&#xFFFF0000 | c>>16
      rel!r_w7 := h&#xFFFF0000 | d>>16
      ENDCASE
    CASE #73: CASE #37:
      rel!r_w0 := a&#x00FF00FF | e<<8 & #xFF00FF00
      rel!r_w1 := b&#x00FF00FF | f<<8 & #xFF00FF00
      rel!r_w2 := c&#x00FF00FF | g<<8 & #xFF00FF00
      rel!r_w3 := d&#x00FF00FF | h<<8 & #xFF00FF00
      rel!r_w4 := e&#xFF00FF00 | a>>8 & #x00FF00FF
      rel!r_w5 := f&#xFF00FF00 | b>>8 & #x00FF00FF
      rel!r_w6 := g&#xFF00FF00 | c>>8 & #x00FF00FF
      rel!r_w7 := h&#xFF00FF00 | d>>8 & #x00FF00FF
      ENDCASE
    CASE #72: CASE #27:
      rel!r_w0 := a&#x0F0F0F0F | e<<4 & #xF0F0F0F0
      rel!r_w1 := b&#x0F0F0F0F | f<<4 & #xF0F0F0F0
      rel!r_w2 := c&#x0F0F0F0F | g<<4 & #xF0F0F0F0
      rel!r_w3 := d&#x0F0F0F0F | h<<4 & #xF0F0F0F0
      rel!r_w4 := e&#xF0F0F0F0 | a>>4 & #x0F0F0F0F
      rel!r_w5 := f&#xF0F0F0F0 | b>>4 & #x0F0F0F0F
      rel!r_w6 := g&#xF0F0F0F0 | c>>4 & #x0F0F0F0F
      rel!r_w7 := h&#xF0F0F0F0 | d>>4 & #x0F0F0F0F
      ENDCASE
    CASE #71: CASE #17:
      rel!r_w0 := a&#x33333333 | e<<2 & #xCCCCCCCC
      rel!r_w1 := b&#x33333333 | f<<2 & #xCCCCCCCC
      rel!r_w2 := c&#x33333333 | g<<2 & #xCCCCCCCC
      rel!r_w3 := d&#x33333333 | h<<2 & #xCCCCCCCC
      rel!r_w4 := e&#xCCCCCCCC | a>>2 & #x33333333
      rel!r_w5 := f&#xCCCCCCCC | b>>2 & #x33333333
      rel!r_w6 := g&#xCCCCCCCC | c>>2 & #x33333333
      rel!r_w7 := h&#xCCCCCCCC | d>>2 & #x33333333
      ENDCASE
    CASE #70: CASE #07:
      rel!r_w0 := a&#x55555555 | e<<1 & #xAAAAAAAA
      rel!r_w1 := b&#x55555555 | f<<1 & #xAAAAAAAA
      rel!r_w2 := c&#x55555555 | g<<1 & #xAAAAAAAA
      rel!r_w3 := d&#x55555555 | h<<1 & #xAAAAAAAA
      rel!r_w4 := e&#xAAAAAAAA | a>>1 & #x55555555
      rel!r_w5 := f&#xAAAAAAAA | b>>1 & #x55555555
      rel!r_w6 := g&#xAAAAAAAA | c>>1 & #x55555555
      rel!r_w7 := h&#xAAAAAAAA | d>>1 & #x55555555
      ENDCASE
    CASE #65: CASE #56:
      rel!r_w1, rel!r_w2, rel!r_w5, rel!r_w6 := c, b, g, f
      ENDCASE
    CASE #64: CASE #46:
      rel!r_w0 := a&#x0000FFFF | c<<16
      rel!r_w1 := b&#x0000FFFF | d<<16
      rel!r_w2 := c&#xFFFF0000 | a>>16
      rel!r_w3 := d&#xFFFF0000 | b>>16
      rel!r_w4 := e&#x0000FFFF | g<<16
      rel!r_w5 := f&#x0000FFFF | h<<16
      rel!r_w6 := g&#xFFFF0000 | e>>16
      rel!r_w7 := h&#xFFFF0000 | f>>16
      ENDCASE
    CASE #63: CASE #36:
      rel!r_w0 := a&#x00FF00FF | c<<8 & #xFF00FF00
      rel!r_w1 := b&#x00FF00FF | d<<8 & #xFF00FF00
      rel!r_w2 := c&#xFF00FF00 | a>>8 & #x00FF00FF
      rel!r_w3 := d&#xFF00FF00 | b>>8 & #x00FF00FF
      rel!r_w4 := e&#x00FF00FF | g<<8 & #xFF00FF00
      rel!r_w5 := f&#x00FF00FF | h<<8 & #xFF00FF00
      rel!r_w6 := g&#xFF00FF00 | e>>8 & #x00FF00FF
      rel!r_w7 := h&#xFF00FF00 | f>>8 & #x00FF00FF
      ENDCASE
    CASE #62: CASE #26:
      rel!r_w0 := a&#x0F0F0F0F | c<<4 & #xF0F0F0F0
      rel!r_w1 := b&#x0F0F0F0F | d<<4 & #xF0F0F0F0
      rel!r_w2 := c&#xF0F0F0F0 | a>>4 & #x0F0F0F0F
      rel!r_w3 := d&#xF0F0F0F0 | b>>4 & #x0F0F0F0F
      rel!r_w4 := e&#x0F0F0F0F | g<<4 & #xF0F0F0F0
      rel!r_w5 := f&#x0F0F0F0F | h<<4 & #xF0F0F0F0
      rel!r_w6 := g&#xF0F0F0F0 | e>>4 & #x0F0F0F0F
      rel!r_w7 := h&#xF0F0F0F0 | f>>4 & #x0F0F0F0F
      ENDCASE
    CASE #61: CASE #16:
      rel!r_w0 := a&#x33333333 | c<<2 & #xCCCCCCCC
      rel!r_w1 := b&#x33333333 | d<<2 & #xCCCCCCCC
      rel!r_w2 := c&#xCCCCCCCC | a>>2 & #x33333333
      rel!r_w3 := d&#xCCCCCCCC | b>>2 & #x33333333
      rel!r_w4 := e&#x33333333 | g<<2 & #xCCCCCCCC
      rel!r_w5 := f&#x33333333 | h<<2 & #xCCCCCCCC
      rel!r_w6 := g&#xCCCCCCCC | e>>2 & #x33333333
      rel!r_w7 := h&#xCCCCCCCC | f>>2 & #x33333333
      ENDCASE
    CASE #60: CASE #06:
      rel!r_w0 := a&#x55555555 | c<<1 & #xAAAAAAAA
      rel!r_w1 := b&#x55555555 | d<<1 & #xAAAAAAAA
      rel!r_w2 := c&#xAAAAAAAA | a>>1 & #x55555555
      rel!r_w3 := d&#xAAAAAAAA | b>>1 & #x55555555
      rel!r_w4 := e&#x55555555 | g<<1 & #xAAAAAAAA
      rel!r_w5 := f&#x55555555 | h<<1 & #xAAAAAAAA
      rel!r_w6 := g&#xAAAAAAAA | e>>1 & #x55555555
      rel!r_w7 := h&#xAAAAAAAA | f>>1 & #x55555555
      ENDCASE
    CASE #54: CASE #45:
      rel!r_w0 := a&#x0000FFFF | b<<16
      rel!r_w2 := c&#x0000FFFF | d<<16
      rel!r_w4 := e&#x0000FFFF | f<<16
      rel!r_w6 := g&#x0000FFFF | h<<16
      rel!r_w1 := b&#xFFFF0000 | a>>16
      rel!r_w3 := d&#xFFFF0000 | c>>16
      rel!r_w5 := f&#xFFFF0000 | e>>16
      rel!r_w7 := h&#xFFFF0000 | g>>16
      ENDCASE
    CASE #53: CASE #35:
      rel!r_w0 := a&#x00FF00FF | b<<8 & #xFF00FF00
      rel!r_w1 := b&#xFF00FF00 | a>>8 & #x00FF00FF
      rel!r_w2 := c&#x00FF00FF | d<<8 & #xFF00FF00
      rel!r_w3 := d&#xFF00FF00 | c>>8 & #x00FF00FF
      rel!r_w4 := e&#x00FF00FF | f<<8 & #xFF00FF00
      rel!r_w5 := f&#xFF00FF00 | e>>8 & #x00FF00FF
      rel!r_w6 := g&#x00FF00FF | h<<8 & #xFF00FF00
      rel!r_w7 := h&#xFF00FF00 | g>>8 & #x00FF00FF
      ENDCASE
    CASE #52: CASE #25:
      rel!r_w0 := a&#x0F0F0F0F | b<<4 & #xF0F0F0F0
      rel!r_w1 := b&#xF0F0F0F0 | a>>4 & #x0F0F0F0F
      rel!r_w2 := c&#x0F0F0F0F | d<<4 & #xF0F0F0F0
      rel!r_w3 := d&#xF0F0F0F0 | c>>4 & #x0F0F0F0F
      rel!r_w4 := e&#x0F0F0F0F | f<<4 & #xF0F0F0F0
      rel!r_w5 := f&#xF0F0F0F0 | e>>4 & #x0F0F0F0F
      rel!r_w6 := g&#x0F0F0F0F | h<<4 & #xF0F0F0F0
      rel!r_w7 := h&#xF0F0F0F0 | g>>4 & #x0F0F0F0F
      ENDCASE
    CASE #51: CASE #15:
      rel!r_w0 := a&#x33333333 | b<<2 & #xCCCCCCCC
      rel!r_w1 := b&#xCCCCCCCC | a>>2 & #x33333333
      rel!r_w2 := c&#x33333333 | d<<2 & #xCCCCCCCC
      rel!r_w3 := d&#xCCCCCCCC | c>>2 & #x33333333
      rel!r_w4 := e&#x33333333 | f<<2 & #xCCCCCCCC
      rel!r_w5 := f&#xCCCCCCCC | e>>2 & #x33333333
      rel!r_w6 := g&#x33333333 | h<<2 & #xCCCCCCCC
      rel!r_w7 := h&#xCCCCCCCC | g>>2 & #x33333333
      ENDCASE
    CASE #50: CASE #05:
      rel!r_w0 := a&#x55555555 | b<<1 & #xAAAAAAAA
      rel!r_w1 := b&#xAAAAAAAA | a>>1 & #x55555555
      rel!r_w2 := c&#x55555555 | d<<1 & #xAAAAAAAA
      rel!r_w3 := d&#xAAAAAAAA | c>>1 & #x55555555
      rel!r_w4 := e&#x55555555 | f<<1 & #xAAAAAAAA
      rel!r_w5 := f&#xAAAAAAAA | e>>1 & #x55555555
      rel!r_w6 := g&#x55555555 | h<<1 & #xAAAAAAAA
      rel!r_w7 := h&#xAAAAAAAA | g>>1 & #x55555555
      ENDCASE
    CASE #43: CASE #34:
      rel!r_w0 := a&#xFF0000FF | a<<8 & #x00FF0000 | a>>8 & #x0000FF00
      rel!r_w1 := b&#xFF0000FF | b<<8 & #x00FF0000 | b>>8 & #x0000FF00
      rel!r_w2 := c&#xFF0000FF | c<<8 & #x00FF0000 | c>>8 & #x0000FF00
      rel!r_w3 := d&#xFF0000FF | d<<8 & #x00FF0000 | d>>8 & #x0000FF00
      rel!r_w4 := e&#xFF0000FF | e<<8 & #x00FF0000 | e>>8 & #x0000FF00
      rel!r_w5 := f&#xFF0000FF | f<<8 & #x00FF0000 | f>>8 & #x0000FF00
      rel!r_w6 := g&#xFF0000FF | g<<8 & #x00FF0000 | g>>8 & #x0000FF00
      rel!r_w7 := h&#xFF0000FF | h<<8 & #x00FF0000 | h>>8 & #x0000FF00
      ENDCASE
    CASE #42: CASE #24:
      rel!r_w0 := a&#xF0F00F0F | a<<12 & #x0F0F0000 | a>>12 & #x0000F0F0
      rel!r_w1 := b&#xF0F00F0F | b<<12 & #x0F0F0000 | b>>12 & #x0000F0F0
      rel!r_w2 := c&#xF0F00F0F | c<<12 & #x0F0F0000 | c>>12 & #x0000F0F0
      rel!r_w3 := d&#xF0F00F0F | d<<12 & #x0F0F0000 | d>>12 & #x0000F0F0
      rel!r_w4 := e&#xF0F00F0F | e<<12 & #x0F0F0000 | e>>12 & #x0000F0F0
      rel!r_w5 := f&#xF0F00F0F | f<<12 & #x0F0F0000 | f>>12 & #x0000F0F0
      rel!r_w6 := g&#xF0F00F0F | g<<12 & #x0F0F0000 | g>>12 & #x0000F0F0
      rel!r_w7 := h&#xF0F00F0F | h<<12 & #x0F0F0000 | h>>12 & #x0000F0F0
      ENDCASE
    CASE #41: CASE #14:
      rel!r_w0 := a&#xCCCC3333 | a<<14 & #x33330000 | a>>14 & #x0000CCCC
      rel!r_w1 := b&#xCCCC3333 | b<<14 & #x33330000 | b>>14 & #x0000CCCC
      rel!r_w2 := c&#xCCCC3333 | c<<14 & #x33330000 | c>>14 & #x0000CCCC
      rel!r_w3 := d&#xCCCC3333 | d<<14 & #x33330000 | d>>14 & #x0000CCCC
      rel!r_w4 := e&#xCCCC3333 | e<<14 & #x33330000 | e>>14 & #x0000CCCC
      rel!r_w5 := f&#xCCCC3333 | f<<14 & #x33330000 | f>>14 & #x0000CCCC
      rel!r_w6 := g&#xCCCC3333 | g<<14 & #x33330000 | g>>14 & #x0000CCCC
      rel!r_w7 := h&#xCCCC3333 | h<<14 & #x33330000 | h>>14 & #x0000CCCC
      ENDCASE
    CASE #40: CASE #04:
      rel!r_w0 := a&#xAAAA5555 | a<<15 & #x55550000 | a>>15 & #x0000AAAA
      rel!r_w1 := b&#xAAAA5555 | b<<15 & #x55550000 | b>>15 & #x0000AAAA
      rel!r_w2 := c&#xAAAA5555 | c<<15 & #x55550000 | c>>15 & #x0000AAAA
      rel!r_w3 := d&#xAAAA5555 | d<<15 & #x55550000 | d>>15 & #x0000AAAA
      rel!r_w4 := e&#xAAAA5555 | e<<15 & #x55550000 | e>>15 & #x0000AAAA
      rel!r_w5 := f&#xAAAA5555 | f<<15 & #x55550000 | f>>15 & #x0000AAAA
      rel!r_w6 := g&#xAAAA5555 | g<<15 & #x55550000 | g>>15 & #x0000AAAA
      rel!r_w7 := h&#xAAAA5555 | h<<15 & #x55550000 | h>>15 & #x0000AAAA
      ENDCASE
    CASE #32: CASE #23:
      rel!r_w0 := a&#xF00FF00F | a<<4 & #x0F000F00 | a>>4 & #x00F000F0
      rel!r_w1 := b&#xF00FF00F | b<<4 & #x0F000F00 | b>>4 & #x00F000F0
      rel!r_w2 := c&#xF00FF00F | c<<4 & #x0F000F00 | c>>4 & #x00F000F0
      rel!r_w3 := d&#xF00FF00F | d<<4 & #x0F000F00 | d>>4 & #x00F000F0
      rel!r_w4 := e&#xF00FF00F | e<<4 & #x0F000F00 | e>>4 & #x00F000F0
      rel!r_w5 := f&#xF00FF00F | f<<4 & #x0F000F00 | f>>4 & #x00F000F0
      rel!r_w6 := g&#xF00FF00F | g<<4 & #x0F000F00 | g>>4 & #x00F000F0
      rel!r_w7 := h&#xF00FF00F | h<<4 & #x0F000F00 | h>>4 & #x00F000F0
      ENDCASE
    CASE #31: CASE #13:
      rel!r_w0 := a&#xCC33CC33 | a<<6 & #x33003300 | a>>6 & #x00CC00CC
      rel!r_w1 := b&#xCC33CC33 | b<<6 & #x33003300 | b>>6 & #x00CC00CC
      rel!r_w2 := c&#xCC33CC33 | c<<6 & #x33003300 | c>>6 & #x00CC00CC
      rel!r_w3 := d&#xCC33CC33 | d<<6 & #x33003300 | d>>6 & #x00CC00CC
      rel!r_w4 := e&#xCC33CC33 | e<<6 & #x33003300 | e>>6 & #x00CC00CC
      rel!r_w5 := f&#xCC33CC33 | f<<6 & #x33003300 | f>>6 & #x00CC00CC
      rel!r_w6 := g&#xCC33CC33 | g<<6 & #x33003300 | g>>6 & #x00CC00CC
      rel!r_w7 := h&#xCC33CC33 | h<<6 & #x33003300 | h>>6 & #x00CC00CC
      ENDCASE
    CASE #30: CASE #03:
      rel!r_w0 := a&#xAA55AA55 | a<<7 & #x55005500 | a>>7 & #x00AA00AA
      rel!r_w1 := b&#xAA55AA55 | b<<7 & #x55005500 | b>>7 & #x00AA00AA
      rel!r_w2 := c&#xAA55AA55 | c<<7 & #x55005500 | c>>7 & #x00AA00AA
      rel!r_w3 := d&#xAA55AA55 | d<<7 & #x55005500 | d>>7 & #x00AA00AA
      rel!r_w4 := e&#xAA55AA55 | e<<7 & #x55005500 | e>>7 & #x00AA00AA
      rel!r_w5 := f&#xAA55AA55 | f<<7 & #x55005500 | f>>7 & #x00AA00AA
      rel!r_w6 := g&#xAA55AA55 | g<<7 & #x55005500 | g>>7 & #x00AA00AA
      rel!r_w7 := h&#xAA55AA55 | h<<7 & #x55005500 | h>>7 & #x00AA00AA
      ENDCASE
    CASE #21: CASE #12:
      rel!r_w0 := a&#xC3C3C3C3 | a<<2 & #x30303030 | a>>2 & #x0C0C0C0C
      rel!r_w1 := b&#xC3C3C3C3 | b<<2 & #x30303030 | b>>2 & #x0C0C0C0C
      rel!r_w2 := c&#xC3C3C3C3 | c<<2 & #x30303030 | c>>2 & #x0C0C0C0C
      rel!r_w3 := d&#xC3C3C3C3 | d<<2 & #x30303030 | d>>2 & #x0C0C0C0C
      rel!r_w4 := e&#xC3C3C3C3 | e<<2 & #x30303030 | e>>2 & #x0C0C0C0C
      rel!r_w5 := f&#xC3C3C3C3 | f<<2 & #x30303030 | f>>2 & #x0C0C0C0C
      rel!r_w6 := g&#xC3C3C3C3 | g<<2 & #x30303030 | g>>2 & #x0C0C0C0C
      rel!r_w7 := h&#xC3C3C3C3 | h<<2 & #x30303030 | h>>2 & #x0C0C0C0C
      ENDCASE
    CASE #20: CASE #02:
      rel!r_w0 := a&#xA5A5A5A5 | a<<3 & #x50505050 | a>>3 & #x0A0A0A0A
      rel!r_w1 := b&#xA5A5A5A5 | b<<3 & #x50505050 | b>>3 & #x0A0A0A0A
      rel!r_w2 := c&#xA5A5A5A5 | c<<3 & #x50505050 | c>>3 & #x0A0A0A0A
      rel!r_w3 := d&#xA5A5A5A5 | d<<3 & #x50505050 | d>>3 & #x0A0A0A0A
      rel!r_w4 := e&#xA5A5A5A5 | e<<3 & #x50505050 | e>>3 & #x0A0A0A0A
      rel!r_w5 := f&#xA5A5A5A5 | f<<3 & #x50505050 | f>>3 & #x0A0A0A0A
      rel!r_w6 := g&#xA5A5A5A5 | g<<3 & #x50505050 | g>>3 & #x0A0A0A0A
      rel!r_w7 := h&#xA5A5A5A5 | h<<3 & #x50505050 | h>>3 & #x0A0A0A0A
      ENDCASE
    CASE #10: CASE #01:
      rel!r_w0 := a&#x99999999 | a<<1 & #x44444444 | a>>1 & #x22222222
      rel!r_w1 := b&#x99999999 | b<<1 & #x44444444 | b>>1 & #x22222222
      rel!r_w2 := c&#x99999999 | c<<1 & #x44444444 | c>>1 & #x22222222
      rel!r_w3 := d&#x99999999 | d<<1 & #x44444444 | d>>1 & #x22222222
      rel!r_w4 := e&#x99999999 | e<<1 & #x44444444 | e>>1 & #x22222222
      rel!r_w5 := f&#x99999999 | f<<1 & #x44444444 | f>>1 & #x22222222
      rel!r_w6 := g&#x99999999 | g<<1 & #x44444444 | g>>1 & #x22222222
      rel!r_w7 := h&#x99999999 | h<<1 & #x44444444 | h>>1 & #x22222222
      ENDCASE
  }
wrrel(rel)
}

AND ignorearg(rel, i) BE
{ LET a, b, c, d = rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3
  LET e, f, g, h = rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7
  LET sh, mask = ?, ?

//newline()
//wrrel(rel)
writef("ignorearg: %n*n", i)
  SWITCHON i INTO
  { DEFAULT:  RETURN
    CASE 7: rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3 := a|e, b|f, c|g, d|h
            rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7 :=    0,  0,   0,   0
            GOTO ret
    CASE 6: rel!r_w0, rel!r_w1, rel!r_w4, rel!r_w5 := a|c, b|d, e|g, f|h
            rel!r_w2, rel!r_w3, rel!r_w6, rel!r_w7 :=   0,   0,   0,   0
            GOTO ret
    CASE 5: rel!r_w0, rel!r_w2, rel!r_w4, rel!r_w6 := a|b, c|d, e|f, g|h
            rel!r_w1, rel!r_w3, rel!r_w5, rel!r_w7 :=   0,   0,   0,   0
            GOTO ret
    CASE 4: sh, mask := 16, #x0000FFFF; ENDCASE
    CASE 3: sh, mask :=  8, #x00FF00FF; ENDCASE
    CASE 2: sh, mask :=  4, #x0F0F0F0F; ENDCASE
    CASE 1: sh, mask :=  2, #x33333333; ENDCASE
    CASE 0: sh, mask :=  2, #x55555555
  }
//writef("ignorearg: i=%n sh=%n mask=%n*n", i, sh, mask)

  rel!r_w0 := (a | a>>sh) & mask
  rel!r_w1 := (b | b>>sh) & mask
  rel!r_w2 := (c | c>>sh) & mask
  rel!r_w3 := (d | d>>sh) & mask
  rel!r_w4 := (e | e>>sh) & mask
  rel!r_w5 := (f | f>>sh) & mask
  rel!r_w6 := (g | g>>sh) & mask
  rel!r_w7 := (h | h>>sh) & mask
ret:
  rmref(rel, i)
  wrrel(rel)
}

AND dontcare(rel, i) = VALOF
{ LET res = dontcare1(rel, i)
  //writef("dontcase => %n*n", res)
  RESULTIS res
}

AND dontcare1(rel, i) = VALOF
{ LET a, b, c, d = rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3
  LET e, f, g, h = rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7
  LET sh, mask = ?, ?

//wrrel(rel);newline()
//writef("dontcare: %n*n", i)
  SWITCHON i INTO
  { DEFAULT:  bug("dontcase: Bad argument number %n*n", i)
              RESULTIS FALSE
    CASE 7:   RESULTIS a=e & b=f & c=g & d=h -> TRUE, FALSE
    CASE 6:   RESULTIS a=c & b=d & e=g & f=h -> TRUE, FALSE
    CASE 5:   RESULTIS a=b & c=d & e=f & g=h -> TRUE, FALSE
    CASE 4:   sh, mask := 16, #x0000FFFF; ENDCASE
    CASE 3:   sh, mask :=  8, #x00FF00FF; ENDCASE
    CASE 2:   sh, mask :=  4, #x0F0F0F0F; ENDCASE
    CASE 1:   sh, mask :=  2, #x33333333; ENDCASE
    CASE 0:   sh, mask :=  1, #x55555555
  }
//writef("dontcare: i=%n sh=%n mask=%n*n", i, sh, mask)

  RESULTIS ((a XOR a>>sh) & mask) = 0 &
           ((b XOR b>>sh) & mask) = 0 &
           ((c XOR c>>sh) & mask) = 0 &
           ((d XOR d>>sh) & mask) = 0 &
           ((e XOR e>>sh) & mask) = 0 &
           ((f XOR f>>sh) & mask) = 0 &
           ((g XOR g>>sh) & mask) = 0 &
           ((h XOR h>>sh) & mask) = 0 -> TRUE, FALSE
}

AND standardise(rel) BE
{ LET v = @rel!r_v0

//wrvars()

writef("standardise:*n")
//wrrel(rel, TRUE)

  // Remove irrelevant arguments
  FOR i = 0 TO 7 IF v!i & dontcare(rel, i) DO
  { 
//writef("standardise: remove irrelevant variable v%n*n", origid(v!i))
    //rmref(rel, v!i)
    v!i := 0
  }
//writef("standardise: irrelevant variables (if any) removed*n")

  FOR i = 0 TO 6 DO
  { LET min, p = maxint, -1
    // Find the next smallest variable
    FOR j = i TO 7 DO
    { LET var = v!j
      IF var & var<min DO min, p := var, j
    }
//writef("min = %n*n", min)
    IF p<0 BREAK // No more variables

    UNLESS v!i=v!p DO
    { //writef("exchange arg%n=v%n with arg%n=v%n*n", 
      //         i, origid(v!i), p, origid(v!p))
      exchargs(rel, i, p)
    }
    // Check whether there are any repetitions
    FOR j = p+1 TO 7 IF v!j=min DO
    { apeq(rel, i, j)
      ignorearg(rel, j)
//writef("arg%n = arg%n = v%n*n", i, j, origid(v!i))
    }
  }

//writef("standardise: clear unused bits in the bit pattern*n")
  
  // Clear unused bits of the bit pattern
  IF v!7 DO { wrrel(rel, TRUE); RETURN }

  rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7 := 0, 0, 0, 0
  IF v!6 DO { wrrel(rel, TRUE); RETURN }
  rel!r_w2, rel!r_w3 := 0, 0
  IF v!5 DO { wrrel(rel, TRUE); RETURN }
  rel!r_w1 := 0
  IF v!4 DO { wrrel(rel, TRUE); RETURN }
  IF v!3 DO { rel!r_w0 := rel!r_w0 & #x0000FFFF; wrrel(rel, TRUE); RETURN }
  IF v!2 DO { rel!r_w0 := rel!r_w0 & #x000000FF; wrrel(rel, TRUE); RETURN }
  IF v!1 DO { rel!r_w0 := rel!r_w0 & #x0000000F; wrrel(rel, TRUE); RETURN }
  IF v!0 DO { rel!r_w0 := rel!r_w0 & #x00000003; wrrel(rel, TRUE); RETURN }
  rel!r_w0 := rel!r_w0 & #x00000001
  wrrel(rel, TRUE)
}

// Split attempts to factorise rel into the conjuction of
// two relations each containing at least 3 variables and
// having no variables in common. It return TRUE if successful.
AND split(rel) = VALOF
{ standardise(rel)
  UNLESS rel!r_v3 RESULTIS FALSE // Too few variables

// The search is based on the following sequence of quartets

// 4567 4067 4167 4267 4207 4217 4237 4037 4057 5047 7045 7145 7105 7125 7135
// 7035 7065 7061 7021 7321 7301 7341 7340 7320 7420 7460 7462 7432 7532 7542
// 7546 7536 7534 7634 7630 7631 7621 7651 7641 7041 7241 2741 2701 2731 2751
// 2753 2743 2763 7263 7260 7250 7256 6257 6457 6427 2467

// 05 0123 4567  67  567  4567
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 0, 5)
// 15 5123 4067      067  0467
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 1, 5)
// 25 5023 4167      167  1467
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 5)
// 16 5013 4267      267  2467
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 1, 6)
// 26 5613 4207  07  027  0247
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 6)
// 36 5603 4217  17  127  1247
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 3, 6)
// 25 5601 4237  37  237  2347
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 5)
// 06 5621 4037      037  0347
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 0, 6)
// 46 3621 4057  57  057  0457
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 4, 6)
// 47 3621 5047  47  047
  IF cansplit2(rel) | cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 4, 7)
// 35 3621 7045  45  045
  IF cansplit2(rel) | cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 3, 5)
// 36 3620 7145      145  1457
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 3, 6)
// 26 3624 7105  05  015  0157
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 6)
// 06 3604 7125  25  125  1257
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 0, 6)
// 25 2604 7135  35  135  1357
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 5)
// 16 2614 7035      035  0357
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 1, 6)
// 27 2314 7065  56  056  0567
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 7)
// 06 2354 7061  16  016  0167
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 0, 6)
// 15 6354 7021  12  012  0127
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 1, 5)
// 16 6054 7321      123  1237
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 1, 6)
// 36 6254 7301  01  013  0137
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 3, 6)
// 37 6250 7341  14  134  1347
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 3, 7)
// 16 6251 7340  04  034
  IF cansplit2(rel) | cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 1, 6)
// 15 6451 7320  02  023  0237
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 1, 5)
// 06 6351 7420      024
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 0, 6)
// 07 2351 7460  06  046
  IF cansplit2(rel) | cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 0, 7)
// 16 0351 7462  26  246
  IF cansplit2(rel) | cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 1, 6)
// 25 0651 7432  23  234
  IF cansplit2(rel) | cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 2, 5)
// 26 0641 7532      235  2357
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 6)
// 17 0631 7542  24  245  2457
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 1, 7)
// 26 0231 7546  46  456  
  IF cansplit2(rel) | cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 2, 6)
// 27 0241 7536  36  356  3567
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 7)
// 25 0261 7534  34  345  3457
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 5)
// 07 0251 7634      346  3467
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 0, 7)
// 37 4251 7630  03  036  0367
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 3, 7)
// 16 4250 7631  13  136  1367
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 1, 6)
// 26 4350 7621      126  1267
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 6)
// 06 4320 7651  15  156  1567
  IF cansplit2(rel) | cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 0, 6)
// 35 5320 7641      146
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 3, 5)
// 25 5326 7041      014  0147
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 5)
// 45 5306 7241      124
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 4, 5)
// 26 5306 2741      147
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 2, 6)
// 16 5346 2701      017
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 1, 6)
// 06 5046 2731      137
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 0, 6)
// 07 3046 2751      157
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 0, 7)
// 26 1046 2753      357
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 2, 6)
// 36 1056 2743      347
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 3, 6)
// 45 1054 2763      367  2367
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 4, 5)
// 17 1054 7263      236
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 1, 7)
// 26 1354 7260      026  0267
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 6)
// 27 1364 7250      025  0257
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 2, 7)
// 47 1304 7256      256  2567
  IF cansplit3(rel) | cansplit4(rel) RESULTIS TRUE
  exchargs(rel, 4, 7)
// 35 1304 6257      257
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 3, 5)
// 36 1302 6457      457
  IF cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 3, 6)
// 46 1305 6427  27  247
  IF cansplit2(rel) | cansplit3(rel) RESULTIS TRUE
  exchargs(rel, 4, 6)
//    1305 2467      467
  IF cansplit3(rel) RESULTIS TRUE
  RESULTIS FALSE
}

AND cansplit2(rel, sw) = VALOF
{ LET w = @rel!r_w0
  LET x, y, i = ?, ?, 0
  // set x,y to first non zero pair
  UNTIL i>7 DO
  { x, y := w!i, w!(i+1)
    IF x | y BREAK
    i := i+2
  }

  // Check all other words are either zero or
  // equal to first
  FOR j = i+2 TO 7 BY 2 DO
  { LET a, b = w!j, w!(j+1)
//writef("cansplit2: x=%x8 y=%x8   a=%x8 b=%x8*n", x, y, a, b)
    UNLESS (a|b)=0 | a=x & b=y RESULTIS FALSE
  }
//writef("Split2 possible*n")
//wrrel(rel); newline()
//abort(1002)
  RESULTIS TRUE
}

AND cansplit3(rel, sw) = VALOF
{ LET w = @rel!r_w0
  LET x, i = ?, 0
  // set first to first non zero wi
  UNTIL i>7 DO
  { x := w!i
    IF x BREAK
    i := i+1
  }

  // Check all other words are either zero or
  // equal to first
  FOR j = i+1 TO 7 DO
  { LET a = w!j
//writef("cansplit3: x=%x8 a=%x8*n", x, a)
    UNLESS a=0 | a=x RESULTIS FALSE
  }
writef("Split3 possible*n")
wrrel(rel); newline()
abort(1003)
  RESULTIS TRUE
}

AND cansplit4(rel, sw) = VALOF
{ LET w = @rel!r_w0
  LET x, y, z, i = ?, ?, ?, 0
  // set x to first non zero value
  UNTIL i>7 DO
  { x := w!i
    IF x BREAK
    i := i+1
  }
  // Form three pair
  x := (x | x>>16) & #x0000FFFF     // 0000abcd
  y := x <<16                       // abcd0000
  z := x | y                        // abcdabcd

  // Check all other words are either zero or
  // equal to first
  FOR j = i TO 7 DO
  { LET a = w!j
//writef("cansplit4: x=%x8 y=%x8 z=%x8   a=%x8*n", x, y, z, a)
    UNLESS a=0 | a=x | a=y | a=z RESULTIS FALSE
  }

//writef("Split4 possible*n")
//wrrel(rel); newline()
//abort(1004)
  RESULTIS TRUE
}
