// Tests on relations chk8

GET "libhdr"
GET "chk8.h"

// Discover all the relations of the form 
// vi -> vj, vi->~vj, ~vi->vj and ~vi->~vj
// implied by relation rel. For any such discovery it calls
// bm_setbitpp(vi, vj), bm_setbitpp(vi, vj), bm_setbitpp(vi, vj)
// bm_setbitnn(vi, vj).
LET findimps(rel) BE
// rel need not be in standard form, ie the variables can be
// in any order and any may be zero
{ LET a, b, c, d = rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3
  LET e, f, g, h = rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7
  LET v0, v1, v2, v3 = rel!r_v0, rel!r_v1, rel!r_v2, rel!r_v3
  LET v4, v5, v6, v7 = rel!r_v4, rel!r_v5, rel!r_v6, rel!r_v7
  LET abcd, efgh = a|b|c|d, e|f|g|h
  LET abef, cdgh = a|b|e|f, c|d|g|h
  LET aceg, bdfh = a|c|e|g, b|d|f|h
  LET abcdefgh = abcd|efgh

  //writef("abcdefgh = %x8*n", abcdefgh)

  IF v7 DO
  { IF abcd=0 DO bm_setvar1(v7)  // v7 must be one
    IF efgh=0 DO bm_setvar0(v7)  // v7 must be zero
    IF v6 DO // Find implications involving v7 and v6
    { IF (c|d)=0 DO bm_setbitpp(v6, v7) //  v6 -> v7
      IF (g|h)=0 DO bm_setbitpn(v6, v7) //  v6 ->~v7
      IF (a|b)=0 DO bm_setbitnp(v6, v7) // ~v6 -> v7
      IF (e|f)=0 DO bm_setbitnn(v6, v7) // ~v6 ->~v7
    }
    IF v5 DO // Find implications involving v7 and v5
    { IF (b|d)=0 DO bm_setbitpp(v5, v7) //  v5 -> v7
      IF (f|h)=0 DO bm_setbitpn(v5, v7) //  v5 ->~v7
      IF (a|c)=0 DO bm_setbitnp(v5, v7) // ~v5 -> v7
      IF (e|g)=0 DO bm_setbitnn(v5, v7) // ~v5 ->~v7
    }
    IF v4 DO // Find implications involving v7 and v4
    { IF (abcd&#xFFFF0000)=0 DO bm_setbitpp(v4, v7) //  v4 -> v7
      IF (efgh&#xFFFF0000)=0 DO bm_setbitpn(v4, v7) //  v4 ->~v7
      IF (abcd&#x0000FFFF)=0 DO bm_setbitnp(v4, v7) // ~v4 -> v7
      IF (efgh&#x0000FFFF)=0 DO bm_setbitnn(v4, v7) // ~v4 ->~v7
    }
    IF v3 DO // Find implications involving v7 and v3
    { IF (abcd&#xFF00FF00)=0 DO bm_setbitpp(v3, v7) //  v3 -> v7
      IF (efgh&#xFF00FF00)=0 DO bm_setbitpn(v3, v7) //  v3 ->~v7
      IF (abcd&#x00FF00FF)=0 DO bm_setbitnp(v3, v7) // ~v3 -> v7
      IF (efgh&#x00FF00FF)=0 DO bm_setbitnn(v3, v7) // ~v3 ->~v7
    }
    IF v2 DO // Find implications involving v7 and v2
    { IF (abcd&#xF0F0F0F0)=0 DO bm_setbitpp(v2, v7) //  v2 -> v7
      IF (efgh&#xF0F0F0F0)=0 DO bm_setbitpn(v2, v7) //  v2 ->~v7
      IF (abcd&#x0F0F0F0F)=0 DO bm_setbitnp(v2, v7) // ~v2 -> v7
      IF (efgh&#x0F0F0F0F)=0 DO bm_setbitnn(v2, v7) // ~v2 ->~v7
    }
    IF v1 DO // Find implications involving v7 and v1
    { IF (abcd&#xCCCCCCCC)=0 DO bm_setbitpp(v1, v7) //  v1 -> v7
      IF (efgh&#xCCCCCCCC)=0 DO bm_setbitpn(v1, v7) //  v1 ->~v7
      IF (abcd&#x33333333)=0 DO bm_setbitnp(v1, v7) // ~v1 -> v7
      IF (efgh&#x33333333)=0 DO bm_setbitnn(v1, v7) // ~v1 ->~v7
    }
    IF v0 DO // Find implications involving v7 and v0
    { IF (abcd&#xAAAAAAAA)=0 DO bm_setbitpp(v0, v7) //  v0 -> v7
      IF (efgh&#xAAAAAAAA)=0 DO bm_setbitpn(v0, v7) //  v0 ->~v7
      IF (abcd&#x55555555)=0 DO bm_setbitnp(v0, v7) // ~v0 -> v7
      IF (efgh&#x55555555)=0 DO bm_setbitnn(v0, v7) // ~v0 ->~v7
    }
  }
  IF v6 DO
  { IF abef=0 DO bm_setvar1(v6)  // v6 must be one
    IF cdgh=0 DO bm_setvar0(v6)  // v6 must be zero
    IF v5 DO // Find implications involving v6 and v5
    { IF (b|f)=0 DO bm_setbitpp(v5, v6) //  v5 -> v6
      IF (d|h)=0 DO bm_setbitpn(v5, v6) //  v5 ->~v6
      IF (a|e)=0 DO bm_setbitnp(v5, v6) // ~v5 -> v6
      IF (c|g)=0 DO bm_setbitnn(v5, v6) // ~v5 ->~v6
    }
    IF v4 DO // Find implications involving v6 and v4
    { IF (abef&#xFFFF0000)=0 DO bm_setbitpp(v4, v6) //  v4 -> v6
      IF (cdgh&#xFFFF0000)=0 DO bm_setbitpn(v4, v6) //  v4 ->~v6
      IF (abef&#x0000FFFF)=0 DO bm_setbitnp(v4, v6) // ~v4 -> v6
      IF (cdgh&#x0000FFFF)=0 DO bm_setbitnn(v4, v6) // ~v4 ->~v6
    }
    IF v3 DO // Find implications involving v6 and v3
    { IF (abef&#xFF00FF00)=0 DO bm_setbitpp(v3, v6) //  v3 -> v6
      IF (cdgh&#xFF00FF00)=0 DO bm_setbitpn(v3, v6) //  v3 ->~v6
      IF (abef&#x00FF00FF)=0 DO bm_setbitnp(v3, v6) // ~v3 -> v6
      IF (cdgh&#x00FF00FF)=0 DO bm_setbitnn(v3, v6) // ~v3 ->~v6
    }
    IF v2 DO // Find implications involving v6 and v2
    { IF (abef&#xF0F0F0F0)=0 DO bm_setbitpp(v2, v6) //  v2 -> v6
      IF (cdgh&#xF0F0F0F0)=0 DO bm_setbitpn(v2, v6) //  v2 ->~v6
      IF (abef&#x0F0F0F0F)=0 DO bm_setbitnp(v2, v6) // ~v2 -> v6
      IF (cdgh&#x0F0F0F0F)=0 DO bm_setbitnn(v2, v6) // ~v2 ->~v6
    }
    IF v1 DO // Find implications involving v6 and v1
    { IF (abef&#xCCCCCCCC)=0 DO bm_setbitpp(v1, v6) //  v1 -> v6
      IF (cdgh&#xCCCCCCCC)=0 DO bm_setbitpn(v1, v6) //  v1 ->~v6
      IF (abef&#x33333333)=0 DO bm_setbitnp(v1, v6) // ~v1 -> v6
      IF (cdgh&#x33333333)=0 DO bm_setbitnn(v1, v6) // ~v1 ->~v6
    }
    IF v0 DO // Find implications involving v6 and v0
    { IF (abef&#xAAAAAAAA)=0 DO bm_setbitpp(v0, v6) //  v0 -> v6
      IF (cdgh&#xAAAAAAAA)=0 DO bm_setbitpn(v0, v6) //  v0 ->~v6
      IF (abef&#x55555555)=0 DO bm_setbitnp(v0, v6) // ~v0 -> v6
      IF (cdgh&#x55555555)=0 DO bm_setbitnn(v0, v6) // ~v0 ->~v6
    }
  }
  IF v5 DO
  { IF aceg=0 DO bm_setvar1(v5)  // v5 must be one
    IF bdfh=0 DO bm_setvar0(v5)  // v5 must be zero
    IF v4 DO // Find implications involving v5 and v4
    { IF (aceg&#xFFFF0000)=0 DO bm_setbitpp(v4, v5) //  v4 -> v5
      IF (bdfh&#xFFFF0000)=0 DO bm_setbitpn(v4, v5) //  v4 ->~v5
      IF (aceg&#x0000FFFF)=0 DO bm_setbitnp(v4, v5) // ~v4 -> v5
      IF (bdfh&#x0000FFFF)=0 DO bm_setbitnn(v4, v5) // ~v4 ->~v5
    }
    IF v3 DO // Find implications involving v5 and v3
    { IF (aceg&#xFF00FF00)=0 DO bm_setbitpp(v3, v5) //  v3 -> v5
      IF (bdfh&#xFF00FF00)=0 DO bm_setbitpn(v3, v5) //  v3 ->~v5
      IF (aceg&#x00FF00FF)=0 DO bm_setbitnp(v3, v5) // ~v3 -> v5
      IF (bdfh&#x00FF00FF)=0 DO bm_setbitnn(v3, v5) // ~v3 ->~v5
    }
    IF v2 DO // Find implications involving v5 and v2
    { IF (aceg&#xF0F0F0F0)=0 DO bm_setbitpp(v2, v5) //  v2 -> v5
      IF (bdfh&#xF0F0F0F0)=0 DO bm_setbitpn(v2, v5) //  v2 ->~v5
      IF (aceg&#x0F0F0F0F)=0 DO bm_setbitnp(v2, v5) // ~v2 -> v5
      IF (bdfh&#x0F0F0F0F)=0 DO bm_setbitnn(v2, v5) // ~v2 ->~v5
    }
    IF v1 DO // Find implications involving v5 and v1
    { IF (aceg&#xCCCCCCCC)=0 DO bm_setbitpp(v1, v5) //  v1 -> v5
      IF (bdfh&#xCCCCCCCC)=0 DO bm_setbitpn(v1, v5) //  v1 ->~v5
      IF (aceg&#x33333333)=0 DO bm_setbitnp(v1, v5) // ~v1 -> v5
      IF (bdfh&#x33333333)=0 DO bm_setbitnn(v1, v5) // ~v1 ->~v5
    }
    IF v0 DO // Find implications involving v5 and v0
    { IF (aceg&#xAAAAAAAA)=0 DO bm_setbitpp(v0, v5) //  v0 -> v5
      IF (bdfh&#xAAAAAAAA)=0 DO bm_setbitpn(v0, v5) //  v0 ->~v5
      IF (aceg&#x55555555)=0 DO bm_setbitnp(v0, v5) // ~v0 -> v5
      IF (bdfh&#x55555555)=0 DO bm_setbitnn(v0, v5) // ~v0 ->~v5
    }
  }
  IF abcdefgh=#xFFFFFFFF RETURN
  IF v4 DO
  { IF (abcdefgh&#xFFFF0000)=0 DO bm_setvar0(v4)  // v4 must be zero
    IF (abcdefgh&#x0000FFFF)=0 DO bm_setvar1(v4)  // v4 must be one
    IF v3 DO // Find implications involving v4 and v3
    { IF (abcdefgh&#x0000FF00)=0 DO bm_setbitpp(v3, v4) //  v3 -> v4
      IF (abcdefgh&#xFF000000)=0 DO bm_setbitpn(v3, v4) //  v3 ->~v4
      IF (abcdefgh&#x000000FF)=0 DO bm_setbitnp(v3, v4) // ~v3 -> v4
      IF (abcdefgh&#x00FF0000)=0 DO bm_setbitnn(v3, v4) // ~v3 ->~v4
    }
    IF v2 DO // Find implications involving v4 and v2
    { IF (abcdefgh&#x0000F0F0)=0 DO bm_setbitpp(v2, v4) //  v2 -> v4
      IF (abcdefgh&#xF0F00000)=0 DO bm_setbitpn(v2, v4) //  v2 ->~v4
      IF (abcdefgh&#x00000F0F)=0 DO bm_setbitnp(v2, v4) // ~v2 -> v4
      IF (abcdefgh&#x0F0F0000)=0 DO bm_setbitnn(v2, v4) // ~v2 ->~v4
    }
    IF v1 DO // Find implications involving v4 and v1
    { IF (abcdefgh&#x0000CCCC)=0 DO bm_setbitpp(v1, v4) //  v1 -> v4
      IF (abcdefgh&#xCCCC0000)=0 DO bm_setbitpn(v1, v4) //  v1 ->~v4
      IF (abcdefgh&#x00003333)=0 DO bm_setbitnp(v1, v4) // ~v1 -> v4
      IF (abcdefgh&#x33330000)=0 DO bm_setbitnn(v1, v4) // ~v1 ->~v4
    }
    IF v0 DO // Find implications involving v4 and v0
    { IF (abcdefgh&#x0000AAAA)=0 DO bm_setbitpp(v0, v4) //  v0 -> v4
      IF (abcdefgh&#xAAAA0000)=0 DO bm_setbitpn(v0, v4) //  v0 ->~v4
      IF (abcdefgh&#x00005555)=0 DO bm_setbitnp(v0, v4) // ~v0 -> v4
      IF (abcdefgh&#x55550000)=0 DO bm_setbitnn(v0, v4) // ~v0 ->~v4
    }
  }
  IF v3 DO
  { IF (abcdefgh&#xFF00FF00)=0 DO bm_setvar0(v3)  // v3 must be zero
    IF (abcdefgh&#x00FF00FF)=0 DO bm_setvar1(v3)  // v3 must be one
    IF v2 DO // Find implications involving v3 and v2
    { IF (abcdefgh&#x00F000F0)=0 DO bm_setbitpp(v2, v3) //  v2 -> v3
      IF (abcdefgh&#xF000F000)=0 DO bm_setbitpn(v2, v3) //  v2 ->~v3
      IF (abcdefgh&#x000F000F)=0 DO bm_setbitnp(v2, v3) // ~v2 -> v3
      IF (abcdefgh&#x0F000F00)=0 DO bm_setbitnn(v2, v3) // ~v2 ->~v3
    }
    IF v1 DO // Find implications involving v3 and v1
    { IF (abcdefgh&#x00CC00CC)=0 DO bm_setbitpp(v1, v3) //  v1 -> v3
      IF (abcdefgh&#xCC00CC00)=0 DO bm_setbitpn(v1, v3) //  v1 ->~v3
      IF (abcdefgh&#x00330033)=0 DO bm_setbitnp(v1, v3) // ~v1 -> v3
      IF (abcdefgh&#x33003300)=0 DO bm_setbitnn(v1, v3) // ~v1 ->~v3
    }
    IF v0 DO // Find implications involving v3 and v0
    { IF (abcdefgh&#x00AA00AA)=0 DO bm_setbitpp(v0, v3) //  v0 -> v3
      IF (abcdefgh&#xAA00AA00)=0 DO bm_setbitpn(v0, v3) //  v0 ->~v3
      IF (abcdefgh&#x00550055)=0 DO bm_setbitnp(v0, v3) // ~v0 -> v3
      IF (abcdefgh&#x55005500)=0 DO bm_setbitnn(v0, v3) // ~v0 ->~v3
    }
  }
  IF v2 DO
  { IF (abcdefgh&#xF0F0F0F0)=0 DO bm_setvar0(v2)  // v2 must be zero
    IF (abcdefgh&#x0F0F0F0F)=0 DO bm_setvar1(v2)  // v2 must be one
    IF v1 DO // Find implications involving v2 and v1
    { IF (abcdefgh&#x0C0C0C0C)=0 DO bm_setbitpp(v1, v2) //  v1 -> v2
      IF (abcdefgh&#xC0C0C0C0)=0 DO bm_setbitpn(v1, v2) //  v1 ->~v2
      IF (abcdefgh&#x03030303)=0 DO bm_setbitnp(v1, v2) // ~v1 -> v2
      IF (abcdefgh&#x30303030)=0 DO bm_setbitnn(v1, v2) // ~v1 ->~v2
    }
    IF v0 DO // Find implications involving v2 and v0
    { IF (abcdefgh&#x0A0A0A0A)=0 DO bm_setbitpp(v0, v2) //  v0 -> v2
      IF (abcdefgh&#xA0A0A0A0)=0 DO bm_setbitpn(v0, v2) //  v0 ->~v2
      IF (abcdefgh&#x05050505)=0 DO bm_setbitnp(v0, v2) // ~v0 -> v2
      IF (abcdefgh&#x50505050)=0 DO bm_setbitnn(v0, v2) // ~v0 ->~v2
    }
  }
  IF v1 DO
  { IF (abcdefgh&#xCCCCCCCC)=0 DO bm_setvar0(v1)  // v1 must be zero
    IF (abcdefgh&#x33333333)=0 DO bm_setvar1(v1)  // v1 must be one
    IF (abcdefgh&#x66666666)=0 DO bm_setvareq(v1, v0)  // v1=v0
    IF (abcdefgh&#x99999999)=0 DO bm_setvarne(v1, v0)  // v1=~v0
    IF v0 DO // Find implications involving v1 and v0
    { IF (abcdefgh&#x22222222)=0 DO bm_setbitpp(v0, v1) //  v0 -> v1
      IF (abcdefgh&#x88888888)=0 DO bm_setbitpn(v0, v1) //  v0 ->~v1
      IF (abcdefgh&#x11111111)=0 DO bm_setbitnp(v0, v1) // ~v0 -> v1
      IF (abcdefgh&#x44444444)=0 DO bm_setbitnn(v0, v1) // ~v0 ->~v1
    }
  }
  IF v0 DO
  { IF (abcdefgh&#xAAAAAAAA)=0 DO bm_setvar0(v0)  // v0 must be zero
    IF (abcdefgh&#x55555555)=0 DO bm_setvar1(v0)  // v0 must be one
  }
}


// Attempts to factorise a relation over 6 or more variables into
// the conjunction of two relations one of which is over 3 variables.
// If successful it returns TRUE and permutes the variables
// so that one of the factors is over variables v0, v1 and v2.
// The bit pattern then consists of 32 sub-bit patterns each of
// length 8 that are each either zero or equal to the same non zero
// value.
// If a relation can be factorised, it can be usefully split into
// two independent relations.
AND factor3(rel) = VALOF
{
  RESULTIS FALSE
}

// Attempts to factorise a relation over 8 variables into
// the conjunction of two relations over 4 variables.
// If successful it returns TRUE and permutes the variables
// so that one of the factors is over variables v0, v1, v2 and v3.
// The bit pattern then consists of 16 sub-bit patterns each of
// length 16 that are each either zero or equal to the same non zero
// value.
// If a relation can be factorised, it can be usefully split into
// two independent relations.
AND factor4(rel) = VALOF
{
  RESULTIS FALSE
}








