/*
This program converts .sat terms into .cnf terms.

The command:

cnf2rel x.sat to x.cnf

will, for instance, convert the file x.sat:

5 8
5  100  1 -2  3  4 -5
3  212  2  3 -4
4  133  3 -4  5 -6
6   98 -1 -2  3 -4  5  6

to the file x.cng:

  1 -2  3  4 -5 0
  2  3 -4 0
  3 -4  5 -6 0
 -1 -2  3 -4  5  6 0


Implemented in BCPL by Martin Richards (c) July 2003
*/

/*
The sat file starts with the number of terms and the number of
variable. It is followed by each term consisting of:
The number of variables in the term, the weight, and then the
n variable as signed integers.

Each cnf term is a sequence of signed integers terminated by a zero.

*/

GET "libhdr"

GLOBAL {
  cnfv1 : ug
}

LET start() = VALOF
{ LET retcode = 0
  LET cnfname = "data/jnh307.sat"
  LET relname = "data/jnh307.cnf"
  LET oldin = input()
  LET oldout = output()
  LET cnfstream = 0
  LET relstream = 0

  LET argv = VEC 50
  LET cnfv = VEC 200

  UNLESS rdargs("from,to/k",argv, 50) DO
  { writef("Bad arguments for cnf2rel*n")
    RESULTIS 0
  }

  IF argv!0 DO cnfname := argv!0
  IF argv!1 DO relname := argv!1

  cnfstream := findinput(cnfname)
  relstream := findoutput(relname)

  UNLESS cnfstream DO
  { writef("Unable to open %s*n", cnfname)
    RESULTIS FALSE
  }

  UNLESS relstream DO
  { writef("Unable to open %s*n", relname)
    RESULTIS FALSE
  }

  selectinput(cnfstream)
  selectoutput(relstream)

  rdn() // Read the number of terms
  rdn() // Read the number of variables

  WHILE sat2cnf() LOOP

fin:
  IF cnfstream DO { selectinput(cnfstream); endread() }
  IF relstream DO { selectoutput(relstream); endwrite() }

  selectinput(oldin)
  selectoutput(oldout)

  writef("*nAll done*n")
  RESULTIS retcode
}

AND sat2cnf() = VALOF
{ LET n = 0
  LET val = 0

  UNLESS rdn() RESULTIS FALSE
  n := result2  // the number of variables in the term
  rdn()         // Ignore the weight
  FOR i = 1 TO n DO
  { UNLESS rdn() RESULTIS FALSE
    writef("%n ", result2)
    IF i REM 50 = 0 DO newline()
  }
  writes("0*n")
  RESULTIS TRUE
}

AND rdn() = VALOF
{ LET res, neg = 0, FALSE
  LET ch = ?

  // Ignore white space
  ch := rdch() REPEATWHILE ch=' ' | ch='*n' 

  // Ignore comments
  IF ch='#' | 'A'<=ch<='Z' | 'a'<=ch<='z' DO
  { UNTIL ch='*n' | ch=endstreamch DO ch := rdch()
    LOOP
  }

  IF ch=endstreamch RESULTIS FALSE

  IF ch='-' DO { neg := TRUE; ch := rdch() }
  UNLESS '0'<=ch<='9' RESULTIS FALSE

  { res := 10*res + ch - '0'
    ch := rdch()
  } REPEATWHILE '0'<=ch<='9'

  unrdch()
  IF neg DO res := -res
  result2 := res
  RESULTIS TRUE
} REPEAT

