/*
This module contains debugging aids to test various  functions
in the a tautology checker.

Implemented in BCPL by Martin Richards (c) July 2003
*/

SECTION "debug"

GET "libhdr"
GET "chk8.h"

LET check1() BE
{ bm_setbitpp(1,  2);   bm_findnewinfo()
  bm_setbitpp(2,  3);   bm_findnewinfo()
  bm_setbitpp(4,  5);   bm_findnewinfo()
  bm_setbitpp(5,  6);   bm_findnewinfo()
  bm_setvar1(1);        bm_findnewinfo()
  bm_setbitpp(3,  4);   bm_findnewinfo()
  bm_setbitpn(6,  2);   bm_findnewinfo()
  bm_setbitnp(33, 34);  bm_findnewinfo()
  bm_setbitnp(33, 35);  bm_findnewinfo()
  bm_setbitpn(35, 33);  bm_findnewinfo()
}

AND check2() BE
{ // test the exchargs function
  FOR i = 1 TO 100 DO
  { LET rel = relv!1
    LET v, w = @rel!r_v0, @rel!r_w0
    LET ws = VEC 7
    // Set up a relation
    FOR i = 0 TO 7 DO
    { LET word = randno(1000000) XOR randno(1000000)<<16
      v!i, w!i, ws!i := 10+i, word, word
    }
    FOR a = 0 TO 5 FOR b = a+1 TO 6 DO
    //FOR a = 4 TO 4 FOR b = 6 TO 6 DO
    { LET ok = TRUE
//wrrel(rel); newline()
//writef("*nexch  %n and %n*n", 7, a)
      exchargs(rel, 7, a)
//wrrel(rel); newline()
//writef("*nexch  %n and %n*n", a, b)
      exchargs(rel, a, b)
//wrrel(rel); newline()
//writef("*nexch  %n and %n*n", 7, b)
      exchargs(rel, 7, b)
//wrrel(rel); newline()
//writef("*nexch  %n and %n*n", a, b)
      exchargs(rel, a, b)
//wrrel(rel); newline()
      FOR i = 0 TO 7 UNLESS v!i=10+i & w!i=ws!i DO ok := FALSE
      UNLESS ok DO writef("error: a=%n b=%n*n", a, b)
    }      
  }
}

AND check3() BE
{ FOR i = 1 TO 10 DO
  { LET r1, r2 = relv!1, relv!2
    FOR j = 0 TO r_upb DO r2!j := r1!j
    bm_clrmat(mata, matb, matc, matd)
    bm_clrmat(mataprev, matbprev, matcprev, matdprev)
    IF i=1 DO {
      wrrel(r2); newline()
      apeq(r2, 7, 6)
      wrrel(r2); newline()
    }
    findimps(r2); bm_findnewinfo()
  }
}

AND check4() BE
{ // Test standardise and split
  FOR a = 0 TO 7 DO
  FOR b = 1 TO 7 DO
  FOR c = 2 TO 7 DO
  FOR d = 3 TO 7 DO
  FOR e = 4 TO 7 DO
  FOR f = 5 TO 7 DO
  FOR g = 6 TO 7 DO
  { LET r = relv!1
    LET x = #x1C340000
    LET y = #x00001C34
    LET z = #x1C341C34
    LET t = #xACBDEF01
    FOR i = 0 TO 7 DO r!(r_w0+i) := 0
    //r!r_w1, r!r_w2, r!r_w4, r!r_w5, r!r_w6 := x,z,y,y,x  // split4
    //r!r_w1, r!r_w2, r!r_w4, r!r_w5, r!r_w6 := t,t,t,t,t  // split3
    r!r_w0, r!r_w1, r!r_w6, r!r_w7 := z,t,z,t              // split2

    exchargs(r, 0, a)
    exchargs(r, 1, b)
    exchargs(r, 2, c)
    exchargs(r, 3, d)
    IF a=5 & b=3 & c=3 & d=7 & e=6 & f=6 & g=7 DO
      r!r_w5 := r!r_w5 + 1  // stop one of them being splitable
    exchargs(r, 4, e)
    exchargs(r, 5, f)
    exchargs(r, 6, g)
    FOR i = 0 TO 7 DO r!(r_v0+i) := 20+i
    //wrrel(r); newline()
    //standardise(r)
    //wrrel(r); newline()
    UNLESS split(r) DO
    { writef("Can't split*n")
      wrrel(r); newline()
      abort(9999)
    }
    //wrrel(r); newline()
  }
}

AND check5() BE
{ LET rel = relv!1
  LET v, w = @rel!r_v0, @rel!r_w0
  LET wv = VEC 7
  FOR i = 0 TO 7 DO
  { LET word = randno(1000000) XOR randno(1000000)<<16
    wv!i := word
   }

  // test apimppp, apimppn, apimpnp and apimpnn
  FOR i = 0 TO 7 FOR j = 0 TO 7 DO
  { // Set up a relation
    FOR i = 0 TO 7 DO v!i, w!i := 10+i, wv!i
    bm_clrmat(mata, matb, matc, matd)
    bm_clrmat(mataprev, matbprev, matcprev, matdprev)
    apimppp(rel, i, j)
    writef("testing v%n -> v%n*n", i, j)
    wrrel(rel, FALSE)
    findimps(rel)//; bm_findnewinfo()
    newline()

    FOR i = 0 TO 7 DO v!i, w!i := 10+i, wv!i
    bm_clrmat(mata, matb, matc, matd)
    bm_clrmat(mataprev, matbprev, matcprev, matdprev)
    apimppn(rel, i, j)
    writef("testing v%n ->~v%n*n", i, j)
    wrrel(rel, FALSE)
    findimps(rel)//; bm_findnewinfo()
    newline()

    FOR i = 0 TO 7 DO v!i, w!i := 10+i, wv!i
    bm_clrmat(mata, matb, matc, matd)
    bm_clrmat(mataprev, matbprev, matcprev, matdprev)
    apimpnp(rel, i, j)
    writef("testing ~v%n -> v%n*n", i, j)
    wrrel(rel, FALSE)
    findimps(rel)//; bm_findnewinfo()
    newline()

    FOR i = 0 TO 7 DO v!i, w!i := 10+i, wv!i
    bm_clrmat(mata, matb, matc, matd)
    bm_clrmat(mataprev, matbprev, matcprev, matdprev)
    apimpnn(rel, i, j)
    writef("testing ~v%n -> ~v%n*n", i, j)
    wrrel(rel, FALSE)
    findimps(rel)//; bm_findnewinfo()
    newline()
    abort(1000)
  }
}

AND check6() BE
{ LET rel = relv!1
  LET v, w = @rel!r_v0, @rel!r_w0
  LET wv = VEC 7
  FOR i = 0 TO 7 DO
  { LET word = randno(1000000) XOR randno(1000000)<<16
    wv!i := word
   }

  // test exchargs with apimppp, apimppn, apimpnp and apimpnn
  FOR i = 0 TO 7 FOR j = 0 TO 7 DO
  { // Set up a relation
    FOR i = 0 TO 7 DO v!i, w!i := 10+i, wv!i
    bm_clrmat(mata, matb, matc, matd)
    bm_clrmat(mataprev, matbprev, matcprev, matdprev)
    apimppp(rel, i, j)
    exchargs(rel, i, j)
    writef("testing v%n -> v%n*n", i, j)
    wrrel(rel, FALSE)
    findimps(rel)//; bm_findnewinfo()
    newline()

    FOR i = 0 TO 7 DO v!i, w!i := 10+i, wv!i
    bm_clrmat(mata, matb, matc, matd)
    bm_clrmat(mataprev, matbprev, matcprev, matdprev)
    apimppn(rel, i, j)
    exchargs(rel, i, j)
    writef("testing v%n ->~v%n*n", i, j)
    wrrel(rel, FALSE)
    findimps(rel)//; bm_findnewinfo()
    newline()

    FOR i = 0 TO 7 DO v!i, w!i := 10+i, wv!i
    bm_clrmat(mata, matb, matc, matd)
    bm_clrmat(mataprev, matbprev, matcprev, matdprev)
    apimpnp(rel, i, j)
    exchargs(rel, i, j)
    writef("testing ~v%n -> v%n*n", i, j)
    wrrel(rel, FALSE)
    findimps(rel)//; bm_findnewinfo()
    newline()

    FOR i = 0 TO 7 DO v!i, w!i := 10+i, wv!i
    bm_clrmat(mata, matb, matc, matd)
    bm_clrmat(mataprev, matbprev, matcprev, matdprev)
    apimpnn(rel, i, j)
    exchargs(rel, i, j)
    writef("testing ~v%n -> ~v%n*n", i, j)
    wrrel(rel, FALSE)
    findimps(rel)//; bm_findnewinfo()
    newline()
    abort(1000)
  }
}

AND check7() BE
{ LET rel1 = VEC r_upb
  LET rel2 = VEC r_upb
  FOR i = 0 TO r_upb DO rel1!i := 0
  FOR i = 0 TO 7 DO
  { rel1!(r_w0+i) := randno(1000000) XOR randno(1000000)<<16
    //rel1!(r_v0+i) := i+1             // 1..8
    rel1!(r_v0+i) := randno(9) - 1 // 0..8 random
  }
  wrrel(rel1, FALSE)
  FOR a = 0 TO 7 FOR b = 0 TO 7 DO
  { FOR i = 0 TO r_upb DO rel2!i := rel1!i
    //writef("Testing exchargs %n %n*n", a, b)
    exchargs(rel2, a, b)
    //writef("Testing standardise*n", a, b)
    //wrrel(rel2, FALSE)
    //writef("Cost of standardise %n*n", instrcount(standardise, rel2))
    standardise(rel2)
    //writef("Cost of standardise %n*n", instrcount(standardise, rel2))
    //wrrel(rel2, FALSE)
    //rel2!r_w0 := rel2!r_w0  XOR #X00040000
 
    checkeqv(rel1, rel2)
    //abort(2222)
  }   
}

AND evalrel(rel, e) = VALOF
{ // Evaluate the relation assuming the variable settings
  // set in e. For each variable vi, e!vi (or vi!e) holds
  // its value (0 or 1).
  LET v = @rel!r_v0
  LET i = v!7!e* 4 + v!6!e*2 + v!5!e
  LET s = v!4!e*16 + v!3!e*8 + v!2!e*4 + v!1!e*2 + v!0!e
  RESULTIS rel!(r_w0+i)>>s & 1
}

AND checkeqv(rel1, rel2) BE
{ LET env = VEC 8
  env!0 := 0
  FOR a = 0 TO 1 DO
  { env!1 := a
    FOR b = 0 TO 1 DO
    { env!2 := b
      FOR c = 0 TO 1 DO
      { env!3 := c
        FOR d = 0 TO 1 DO
        { env!4 := d
          FOR e = 0 TO 1 DO
          { env!5 := e
            FOR f = 0 TO 1 DO
            { env!6 := f
              FOR g = 0 TO 1 DO
              { env!7 := g
                FOR h = 0 TO 1 DO
                { env!8 := h
                  UNLESS evalrel(rel1, env)=evalrel(rel2, env) DO
                  { writef("abcdefgh=%n%n%n%n%n%n%n%n rel1=>%n rel2=>%n*n",
                            a,b,c,d,e,f,g,h,
                            evalrel(rel1, env), evalrel(rel2, env))
                    wrrel(rel1, FALSE)
                    wrrel(rel2, FALSE)
                    newline()
                    abort(999)
                  }
                }
              }
            }
          }
        }
      }
    }
  }  
}






