/*
This program converts .cnf terms into .rel terms.

The command:

cnf2rel x.cnf to x.rel

will, for instance, convert the file x.cnf:

1 -2 3 4 -5 0
2 3 -4 0
3 -4 5 -6 0
-1 -2 3 -4 5 6 0

to the file x.rel:

1287681723 1231876 12873612 187631 128733  287613 817263 18763
v1 v2 v3 v4 v5

1287681723 1231876 12873612 187631 128733  287613 817263 18763
v1 v2 v3 v4 v5

1287681723 1231876 12873612 187631 128733  287613 817263 18763
v1 v2 v3 v4 v5

1287681723 1231876 12873612 187631 128733  287613 817263 18763
v1 v2 v3 v4 v5

This is suitable input for the chk8 satisfiability tester.


Implemented in BCPL by Martin Richards (c) July 2003
*/

/*
Each cnf term is a sequence of signed integers terminated by a zero.

A rel term is a 256-bit pattern followed by eight non negative integers.

eg:
   abcdefgh   ....   stuvwxyz
v0 01010101          01010101     
v1 00110011          00110011
v2 00001111          00001111
v3 00000000          11111111
v4 .....      ....
v5
v6
v7 00000000          11111111
*/

GET "libhdr"

GLOBAL {
  nextvar : ug
  maxvar
}

LET start() = VALOF
{ LET retcode = 0
  LET cnfname = "data/t1.cnf"
  LET relname = "data/t1.rel"
  LET oldin = input()
  LET oldout = output()
  LET cnfstream = 0
  LET relstream = 0

  LET argv = VEC 50
  LET cnfv = VEC 200

  UNLESS rdargs("from,to/k",argv, 50) DO
  { writef("Bad arguments for cnf2rel*n")
    RESULTIS 0
  }

  IF argv!0 DO cnfname := argv!0
  IF argv!1 DO relname := argv!1

  cnfstream := findinput(cnfname)
  relstream := findoutput(relname)

  UNLESS cnfstream DO
  { writef("Unable to open %s*n", cnfname)
    RESULTIS FALSE
  }

  UNLESS relstream DO
  { writef("Unable to open %s*n", relname)
    RESULTIS FALSE
  }

  selectinput(cnfstream)
  selectoutput(relstream)

  maxvar, nextvar := 0, 10000 // May need to be larger
  //Generated variables are given numbers 9999, 9998, ...

  WHILE rdcnf(cnfv, 200) DO cnf2rel(cnfv+1, cnfv!0-1)

fin:
  IF cnfstream DO { selectinput(cnfstream); endread() }
  IF relstream DO { selectoutput(relstream); endwrite() }

  selectinput(oldin)
  selectoutput(oldout)

  writef("*nAll done*n")
  RESULTIS retcode
}

AND rdcnf(v, upb) = VALOF
{ LET n = 0
  LET val = 0

  WHILE rdn() & result2 DO
  { n := n+1
    IF n<=upb v!n := result2
  }
  v!0 := n
  IF 1<=n<=upb RESULTIS TRUE
  RESULTIS FALSE
}

AND rdn() = VALOF
{ LET res, neg = 0, FALSE
  LET ch = ?

  // Ignore white space
  ch := rdch() REPEATWHILE ch=' ' | ch='*n' 

  // Ignore comments
  IF ch='#' | 'A'<=ch<='Z' | 'a'<=ch<='z' DO
  { UNTIL ch='*n' | ch=endstreamch DO ch := rdch()
    LOOP
  }

  IF ch=endstreamch RESULTIS FALSE

  IF ch='-' DO { neg := TRUE; ch := rdch() }
  UNLESS '0'<=ch<='9' RESULTIS FALSE

  { res := 10*res + ch - '0'
    ch := rdch()
  } REPEATWHILE '0'<=ch<='9'

  unrdch()
  IF neg DO res := -res
  result2 := res
  RESULTIS TRUE
} REPEAT

AND cnf2rel(v, upb) BE // Cnf variables are in v!0 to v!upb
{ wrch('#')
  FOR i = 0 TO upb DO writef(" %n", v!i)
  newline()

  WHILE upb>7 DO
  { LET newvar = nextvar-1
    nextvar := newvar
    upb := upb-6
    v!(upb+7) := newvar
    cnf2rel8(v+upb, 7)
    v!upb := -newvar
  }
  cnf2rel8(v, upb)
  newline()
}

AND cnf2rel8(v, upb) BE // upb is known to be less than 8
{ LET w = VEC 7
  FOR i = upb+1 TO 7 DO v!i := 0
  FOR i = 0 TO 7 DO w!i := 0

  IF upb>=0 DO
  { // Variable v0
    LET bits = #xAAAAAAAA
    IF v!0<0 DO v!0, bits := -v!0, ~bits
    FOR i = 0 TO 7 DO w!i := w!i | bits
  }

  IF upb>=1 DO
  { // Variable v1
    LET bits = #xCCCCCCCC
    IF v!1<0 DO v!1, bits := -v!1, ~bits
    FOR i = 0 TO 7 DO w!i := w!i | bits
  }

  IF upb>=2 DO
  { // Variable v2
    LET bits = #xF0F0F0F0
    IF v!2<0 DO v!2, bits := -v!2, ~bits
    FOR i = 0 TO 7 DO w!i := w!i | bits
  }

  IF upb>=0 DO
  { // Variable v3
    LET bits = #xFF00FF00
    IF v!3<0 DO v!3, bits := -v!3, ~bits
    FOR i = 0 TO 7 DO w!i := w!i | bits
  }

  IF upb>=0 DO
  { // Variable v4
    LET bits = #xFFFF0000
    IF v!4<0 DO v!4, bits := -v!4, ~bits
    FOR i = 0 TO 7 DO w!i := w!i | bits
  }

  IF upb>=0 DO
  { // Variable v5
    LET bits = #xFFFFFFFF
    TEST v!5<0
    THEN w!0, w!2, w!4, w!6 := w!0|bits, w!2|bits, w!4|bits, w!6|bits
    ELSE w!1, w!3, w!5, w!7 := w!1|bits, w!3|bits, w!5|bits, w!7|bits
    v!5 := ABS v!5
  }

  IF upb>=0 DO
  { // Variable v6
    LET bits = #xFFFFFFFF
    TEST v!6<0
    THEN w!0, w!1, w!4, w!5 := w!0|bits, w!1|bits, w!4|bits, w!5|bits
    ELSE w!2, w!3, w!6, w!7 := w!2|bits, w!3|bits, w!6|bits, w!7|bits
    v!6 := ABS v!6
  }

  IF upb>=0 DO
  { // Variable v7
    LET bits = #xFFFFFFFF
    TEST v!7<0
    THEN w!0, w!1, w!2, w!3 := w!0|bits, w!1|bits, w!2|bits, w!3|bits
    ELSE w!4, w!5, w!6, w!7 := w!4|bits, w!5|bits, w!6|bits, w!7|bits
    v!7 := ABS v!7
  }

  UNLESS v!7 DO w!4, w!5, w!6, w!7 := 0, 0, 0, 0
  UNLESS v!6 DO w!2, w!3, w!6, w!7 := 0, 0, 0, 0
  UNLESS v!5 DO w!1, w!3, w!5, w!7 := 0, 0, 0, 0
  UNLESS v!4 FOR i = 0 TO 7 DO w!i := w!i & #x0000FFFF
  UNLESS v!3 FOR i = 0 TO 7 DO w!i := w!i & #x00FF00FF
  UNLESS v!2 FOR i = 0 TO 7 DO w!i := w!i & #x0F0F0F0F
  UNLESS v!1 FOR i = 0 TO 7 DO w!i := w!i & #x33333333
  UNLESS v!0 FOR i = 0 TO 7 DO w!i := w!i & #x55555555


  { LET last = 7
    WHILE last DO
    { IF w!last BREAK
      last := last-1
    }
    FOR i = 0 TO last DO writef("%x8 ", w!i)
    IF last>5 DO newline()
  }

  FOR i = 0 TO upb   DO writef("v%n ", v!i)
  newline()
  newline()
}


