/*
This is a tautology checker based on the analysis of the
conjunction of a set of relations over 8 Boolean variables.

Implemented in BCPL by Martin Richards (c) July 2003
*/

SECTION "chk8"

GET "libhdr"
GET "chk8.h"

LET start() = VALOF
{ LET name = "data/tst2.rel"
  //LET name = "data/greaves.rel"
  //LET name = "data/mul4.rel"
  LET argv = VEC 50

  trans1, apfns, tests, bmat, utils, debug := 0, 0, 0, 0, 0, 0

  relspace := 0
  relv := 0
  refs := 0
  refcount := 0
  id2orig := 0
  varinfo := 0
  relstack := 0
  pairblks := 0
  freepairs := 0


  mata, mataprev := 0, 0
  matb, matbprev := 0, 0
  matc, matcprev := 0, 0
  matd, matdprev := 0, 0

  UNLESS rdargs("DATA,-t/s", argv, 50) DO
  { writef("Bad arguments for chk8*n")
    RESULTIS 20
  }

  IF argv!0 DO name := argv!0
  tracing := argv!1

  writef("chk8 processing file %s*n", name)

  trans1 := globin(loadseg("trans1"))
  apfns  := globin(loadseg("apfns"))
  apvar  := globin(loadseg("apvar"))
  tests  := globin(loadseg("tests"))
  bmat   := globin(loadseg("bmat"))
  engine := globin(loadseg("engine"))
  utils  := globin(loadseg("utils"))

  UNLESS trans1 & apfns & apvar & tests & bmat & utils DO
  { writef("Unable to load trans1, apfns, apvar, tests, bmat, engine and utils*n")
    GOTO fin 
  }

  relspaceupb := 50000
  relspace    := getvec(relspaceupb)
  relvupb     := 10000
  relv        := getvec(relvupb)
  relstackupb := 10000
  relstack    := getvec(relstackupb)
  relstackp   := 0

  UNLESS relspace & relv & relstack DO
  { writef("More memory needed*n")
    GOTO fin
  }

  UNLESS rdrels(name) DO
  { writef("Format of file %s wrong*n", name)
  }

  writef("Number of relations read = %n*n", reln)

  formlists(relv, reln)

  newline()
  wrrels(TRUE)
  wrvars()
  newline()

  bm_setmatsize(maxid<32 -> 32, maxid)

  mata     := bm_mkmat()
  matb     := bm_mkmat()
  matc     := bm_mkmat()
  matd     := bm_mkmat()

  mataprev := bm_mkmat()
  matbprev := bm_mkmat()
  matcprev := bm_mkmat()
  matdprev := bm_mkmat()

  IF FALSE DO  // Self test functions
  { debug := globin(loadseg("debug"))
    UNLESS debug DO
    { writef("Unable to load debug module*n")
      GOTO fin
    }

    //check1() // test findnewinfo
    //check2() // Test exchargs
    //check3() // Test findimps
    //check4() // Test standardise and split
    //check5()
    //check6()
    //check7()
    { LET rel = relv!1
      FOR i = 0 TO 7 DO rel!(r_w0+i), rel!(r_v0+i) := 0, i+1
      rel!r_w0 := #x08100003
      rel!r_w3 := #xAB00007F
      wrrel(rel, FALSE)
      findimps(rel)
      bm_findnewinfo()
    }

    writef("End of test*n")
    GOTO fin
  }

  //bm_prmat(mata,matb,matc,matd)

  //writef("*nApplying Warshall*n")
  //bm_warshall(mata, matb, matc, matd)
  //bm_prmat(mata,matb,matc,matd)

  // Start of algorithm

  FOR i = 1 TO reln DO standardise(relv!i)

  writef("*n*nThe resulting relations are*n*n")

  wrrels(TRUE)
  wrvars()

abort(1000)

writef("calling explore %n*n", explore)
  explore(relv, reln, maxid, mata, matb, matc, matd)

  writef("*n*nThe resulting relations are*n*n")

  wrrels(TRUE)
  wrvars()

fin:
  WHILE pairblks DO
  { LET next = !pairblks
    //writef("Freeing pair block %n*n", pairblks)
    freevec(pairblks)
    pairblks := next
  }

  IF mata     DO freevec(mata)
  IF matb     DO freevec(matb)
  IF matc     DO freevec(matc)
  IF matd     DO freevec(matd)
  IF mataprev DO freevec(mataprev)
  IF matbprev DO freevec(matbprev)
  IF matcprev DO freevec(matcprev)
  IF matdprev DO freevec(matdprev)

  IF relspace DO freevec(relspace)
  IF relv     DO freevec(relv)
  IF relstack DO freevec(relstack)
  IF refs     DO freevec(refs)
  IF refcount DO freevec(refcount)
  IF id2orig  DO freevec(id2orig)
  IF varinfo  DO freevec(varinfo)

  IF trans1   DO unloadseg(trans1)
  IF apfns    DO unloadseg(apfns)
  IF apvar    DO unloadseg(apvar)
  IF tests    DO unloadseg(tests)
  IF bmat     DO unloadseg(bmat)
  IF engine   DO unloadseg(engine)
  IF utils    DO unloadseg(utils)
  IF debug    DO unloadseg(debug)
  RESULTIS 0
}


