// The apply functions on a single relation

// apnot(rel, i)         apply the NOT operator to argument i
// ignore(rel, i)        remove arg i assuming it is unconstrained

// apset1(rel, i)        apply  ai  =   1,   eliminate ai
// apset0(rel, i)        apply  ai  =   0,   eliminate ai
// apeq(rel, i, j)       apply  ai  =  aj,   eliminate aj
// apne(rel, i, j)       apply  ai  = ~aj,   eliminate aj

// apimppp(rel, i, j)    apply  ai ->  aj
// apimppn(rel, i, j)    apply  ai -> ~aj
// apimpnp(rel, i, j)    apply ~ai ->  aj
// apimpnn(rel, i, j)    apply ~ai -> ~aj

SECTION "applyfns"

GET "libhdr"
GET "chk8.h"

LET apnot(rel, i) BE
{ LET a, b, c, d = rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3
  LET e, f, g, h = rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7
  LET sh, m1, m2 = ?, ?, ?

  //wrrel(rel, TRUE)
  writef("apnot: arg %n*n", i)

  SWITCHON i INTO
  { DEFAULT: writef("apnot error*n"); abort(999)
             RETURN

    CASE 7:  rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3 := e, f, g, h
             rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7 := a, b, c, d
             wrrel(rel, TRUE)
             RETURN
    CASE 6:  rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3 := c, d, a, b
             rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7 := g, h, e, f
             wrrel(rel, TRUE)
             RETURN
    CASE 5:  rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3 := b, a, d, c
             rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7 := f, e, h, g
             wrrel(rel, TRUE)
             RETURN
    CASE 4:  rel!r_w0 := a<<16 | a>>16 // Assume 32-bit implementation
             rel!r_w1 := b<<16 | b>>16
             rel!r_w2 := c<<16 | c>>16
             rel!r_w3 := d<<16 | d>>16
             rel!r_w4 := e<<16 | e>>16
             rel!r_w5 := f<<16 | f>>16
             rel!r_w6 := g<<16 | g>>16
             rel!r_w7 := h<<16 | h>>16
             wrrel(rel, TRUE)
             RETURN
    CASE 3:  sh := 8
             m1 := #xFF00FF00
             m2 := #x00FF00FF
             ENDCASE
    CASE 2:  sh := 4
             m1 := #xF0F0F0F0
             m2 := #x0F0F0F0F
             ENDCASE
    CASE 1:  sh := 2
             m1 := #xCCCCCCCC
             m2 := #x33333333
             ENDCASE
    CASE 0:  sh := 1
             m1 := #xAAAAAAAA
             m2 := #x55555555
             ENDCASE
  }
  rel!r_w0 := a<<sh & m1 | a>>sh & m2
  rel!r_w1 := b<<sh & m1 | b>>sh & m2
  rel!r_w2 := c<<sh & m1 | c>>sh & m2
  rel!r_w3 := d<<sh & m1 | d>>sh & m2
  rel!r_w4 := e<<sh & m1 | e>>sh & m2
  rel!r_w5 := f<<sh & m1 | f>>sh & m2
  rel!r_w6 := g<<sh & m1 | g>>sh & m2
  rel!r_w7 := h<<sh & m1 | h>>sh & m2
  wrrel(rel, TRUE)
}

// Apply  argument i is known to be 1
AND apset1(rel, i) BE
{ LET v = @rel!r_v0

  //wrrel(rel, TRUE)
  writef("apset1: arg %n*n", i)
  SWITCHON i INTO
  { DEFAULT: bug("Error in apset1: i=%n*n", i)
             RETURN
    CASE 7:  rel!r_w0, rel!r_w1, rel!r_w2, rel!r_w3 := 0, 0, 0, 0
             ENDCASE
    CASE 6:  rel!r_w0, rel!r_w1, rel!r_w4, rel!r_w5 := 0, 0, 0, 0
             ENDCASE
    CASE 5:  rel!r_w0, rel!r_w2, rel!r_w4, rel!r_w6 := 0, 0, 0, 0
             ENDCASE
    CASE 4:  andrelbits1(rel, #xFFFF0000); ENDCASE
    CASE 3:  andrelbits1(rel, #xFF00FF00); ENDCASE
    CASE 2:  andrelbits1(rel, #xF0F0F0F0); ENDCASE
    CASE 1:  andrelbits1(rel, #xCCCCCCCC); ENDCASE
    CASE 0:  andrelbits1(rel, #xAAAAAAAA); ENDCASE
  }
  apnot(rel, i)
  rmref(rel, v!i)
  v!i := 0
  wrrel(rel, TRUE)
}

// Apply  argument i is known to be 0
AND apset0(rel, i) BE
{ LET v = @rel!r_v0

  //wrrel(rel, TRUE)
  writef("apset0: arg %n*n", i)

  SWITCHON i INTO
  { DEFAULT: bug("Error in apset0: i=%n*n", i)
             RETURN
    CASE 7:  rel!r_w4, rel!r_w5, rel!r_w6, rel!r_w7 := 0, 0, 0, 0
             ENDCASE
    CASE 6:  rel!r_w2, rel!r_w3, rel!r_w6, rel!r_w7 := 0, 0, 0, 0
             ENDCASE
    CASE 5:  rel!r_w1, rel!r_w3, rel!r_w5, rel!r_w7 := 0, 0, 0, 0
             ENDCASE
    CASE 4:  andrelbits1(rel, #x0000FFFF); ENDCASE
    CASE 3:  andrelbits1(rel, #x00FF00FF); ENDCASE
    CASE 2:  andrelbits1(rel, #x0F0F0F0F); ENDCASE
    CASE 1:  andrelbits1(rel, #x33333333); ENDCASE
    CASE 0:  andrelbits1(rel, #x55555555); ENDCASE
  }
  rmref(rel, v!i)
  v!i := 0
  wrrel(rel, TRUE)
}

// Apply  ai = aj
AND apeq(rel, i, j) BE
{ LET v = @rel!r_v0

  //newline()
  //wrrel(rel, TRUE)
  writef("apeq: args %n %n*n", i, j)

  SWITCHON i*8+j INTO
  { DEFAULT:            ENDCASE  // Either i=j or an error
    CASE #76: CASE #67: rel!r_w2, rel!r_w3, rel!r_w4, rel!r_w5 := 0, 0, 0, 0
                        ENDCASE
    CASE #75: CASE #57: rel!r_w1, rel!r_w3, rel!r_w4, rel!r_w6 := 0, 0, 0, 0
                        ENDCASE
    CASE #74: CASE #47: andrelbits8v(rel, TABLE #x0000FFFF, #x0000FFFF,
                                                #x0000FFFF, #x0000FFFF,
                                                #xFFFF0000, #xFFFF0000,
                                                #xFFFF0000, #xFFFF0000)
                        ENDCASE
    CASE #73: CASE #37: andrelbits8v(rel, TABLE #x00FF00FF, #x00FF00FF,
                                                #x00FF00FF, #x00FF00FF,
                                                #xFF00FF00, #xFF00FF00,
                                                #xFF00FF00, #xFF00FF00)
                        ENDCASE
    CASE #72: CASE #27: andrelbits8v(rel, TABLE #x0F0F0F0F, #x0F0F0F0F,
                                                #x0F0F0F0F, #x0F0F0F0F,
                                                #xF0F0F0F0, #xF0F0F0F0,
                                                #xF0F0F0F0, #xF0F0F0F0)
                        ENDCASE
    CASE #71: CASE #17: andrelbits8v(rel, TABLE #x33333333, #x33333333,
                                                #x33333333, #x33333333,
                                                #xCCCCCCCC, #xCCCCCCCC,
                                                #xCCCCCCCC, #xCCCCCCCC)
                        ENDCASE
    CASE #70: CASE #07: andrelbits8v(rel, TABLE #x55555555, #x55555555,
                                                #x55555555, #x55555555,
                                                #xAAAAAAAA, #xAAAAAAAA,
                                                #xAAAAAAAA, #xAAAAAAAA)
                        ENDCASE

    CASE #65: CASE #56: rel!r_w1, rel!r_w2, rel!r_w5, rel!r_w6 := 0, 0, 0, 0
                        ENDCASE
    CASE #64: CASE #46: andrelbits4(rel, #x0000FFFF, #x0000FFFF,
                                         #xFFFF0000, #xFFFF0000); ENDCASE
    CASE #63: CASE #36: andrelbits4(rel, #x00FF00FF, #x00FF00FF,
                                         #xFF00FF00, #xFF00FF00); ENDCASE
    CASE #62: CASE #26: andrelbits4(rel, #x0F0F0F0F, #x0F0F0F0F,
                                         #xF0F0F0F0, #xF0F0F0F0); ENDCASE
    CASE #61: CASE #16: andrelbits4(rel, #x33333333, #x33333333,
                                         #xCCCCCCCC, #xCCCCCCCC); ENDCASE
    CASE #60: CASE #06: andrelbits4(rel, #x55555555, #x55555555,
                                         #xAAAAAAAA, #xAAAAAAAA); ENDCASE

    CASE #54: CASE #45: andrelbits2(rel, #x0000FFFF, #xFFFF0000); ENDCASE
    CASE #53: CASE #35: andrelbits2(rel, #x00FF00FF, #xFF00FF00); ENDCASE
    CASE #52: CASE #25: andrelbits2(rel, #x0F0F0F0F, #xF0F0F0F0); ENDCASE
    CASE #51: CASE #15: andrelbits2(rel, #x33333333, #xCCCCCCCC); ENDCASE
    CASE #50: CASE #05: andrelbits2(rel, #x55555555, #xAAAAAAAA); ENDCASE

    CASE #43: CASE #34: andrelbits1(rel, #xFF0000FF);             ENDCASE
    CASE #42: CASE #24: andrelbits1(rel, #xF0F00F0F);             ENDCASE
    CASE #41: CASE #14: andrelbits1(rel, #xCCCC3333);             ENDCASE
    CASE #40: CASE #04: andrelbits1(rel, #xAAAA5555);             ENDCASE

    CASE #32: CASE #23: andrelbits1(rel, #xF00FF00F);             ENDCASE
    CASE #31: CASE #13: andrelbits1(rel, #xCC33CC33);             ENDCASE
    CASE #30: CASE #03: andrelbits1(rel, #xAA55AA55);             ENDCASE

    CASE #21: CASE #12: andrelbits1(rel, #xC3C3C3C3);             ENDCASE
    CASE #20: CASE #02: andrelbits1(rel, #xA5A5A5A5);             ENDCASE

    CASE #10: CASE #01: andrelbits1(rel, #x99999999);             ENDCASE
  }
  wrrel(rel, TRUE)
  ignorearg(rel, j)
}

// Apply  ai ~= aj
AND apne(rel, i, j) BE
{ LET v = @rel!r_v0

  //newline()
  //wrrel(rel, TRUE)
  writef("apne: args %n %n*n", i, j)

  SWITCHON i*8+j INTO
  { DEFAULT:            ENDCASE  // an error

    CASE #77: CASE #66:
    CASE #55: CASE #44:
    CASE #33: CASE #22:
    CASE #11: CASE #00:  andrelbits1(rel, #x00000000);            ENDCASE

    CASE #76: CASE #67: rel!r_w0, rel!r_w1, rel!r_w6, rel!r_w7 := 0, 0, 0, 0
                        ENDCASE
    CASE #75: CASE #57: rel!r_w0, rel!r_w2, rel!r_w5, rel!r_w7 := 0, 0, 0, 0
                        ENDCASE
    CASE #74: CASE #47: andrelbits8v(rel, TABLE #xFFFF0000, #xFFFF0000,
                                                #xFFFF0000, #xFFFF0000,
                                                #x0000FFFF, #x0000FFFF,
                                                #x0000FFFF, #x0000FFFF)
                        ENDCASE
    CASE #73: CASE #37: andrelbits8v(rel, TABLE #xFF00FF00, #xFF00FF00,
                                                #xFF00FF00, #xFF00FF00,
                                                #x00FF00FF, #x00FF00FF,
                                                #x00FF00FF, #x00FF00FF)
                        ENDCASE
    CASE #72: CASE #27: andrelbits8v(rel, TABLE #xF0F0F0F0, #xF0F0F0F0,
                                                #xF0F0F0F0, #xF0F0F0F0,
                                                #x0F0F0F0F, #x0F0F0F0F,
                                                #x0F0F0F0F, #x0F0F0F0F)
                        ENDCASE
    CASE #71: CASE #17: andrelbits8v(rel, TABLE #xCCCCCCCC, #xCCCCCCCC,
                                                #xCCCCCCCC, #xCCCCCCCC,
                                                #x33333333, #x33333333,
                                                #x33333333, #x33333333)
                        ENDCASE
    CASE #70: CASE #07: andrelbits8v(rel, TABLE #xAAAAAAAA, #xAAAAAAAA,
                                                #xAAAAAAAA, #xAAAAAAAA,
                                                #x55555555, #x55555555,
                                               #x55555555, #x55555555)
                        ENDCASE

    CASE #65: CASE #56: rel!r_w0, rel!r_w3, rel!r_w4, rel!r_w7 := 0, 0, 0, 0
                        ENDCASE
    CASE #64: CASE #46: andrelbits4(rel, #xFFFF0000, #xFFFF0000,
                                         #x0000FFFF, #x0000FFFF); ENDCASE
    CASE #63: CASE #36: andrelbits4(rel, #xFF00FF00, #xFF00FF00,
                                         #x00FF00FF, #x00FF00FF); ENDCASE
    CASE #62: CASE #26: andrelbits4(rel, #xF0F0F0F0, #xF0F0F0F0,
                                         #x0F0F0F0F, #x0F0F0F0F); ENDCASE
    CASE #61: CASE #16: andrelbits4(rel, #xCCCCCCCC, #xCCCCCCCC,
                                         #x33333333, #x33333333); ENDCASE
    CASE #60: CASE #06: andrelbits4(rel, #xAAAAAAAA, #xAAAAAAAA,
                                         #x55555555, #x55555555); ENDCASE

    CASE #54: CASE #45: andrelbits2(rel, #xFFFF0000, #x0000FFFF); ENDCASE
    CASE #53: CASE #35: andrelbits2(rel, #xFF00FF00, #x00FF00FF); ENDCASE
    CASE #52: CASE #25: andrelbits2(rel, #xF0F0F0F0, #x0F0F0F0F); ENDCASE
    CASE #51: CASE #15: andrelbits2(rel, #xCCCCCCCC, #x33333333); ENDCASE
    CASE #50: CASE #05: andrelbits2(rel, #xAAAAAAAA, #x55555555); ENDCASE

    CASE #43: CASE #34: andrelbits1(rel, #x00FFFF00);             ENDCASE
    CASE #42: CASE #24: andrelbits1(rel, #x0F0FF0F0);             ENDCASE
    CASE #41: CASE #14: andrelbits1(rel, #x3333CCCC);             ENDCASE
    CASE #40: CASE #04: andrelbits1(rel, #x5555AAAA);             ENDCASE

    CASE #32: CASE #23: andrelbits1(rel, #x0FF00FF0);             ENDCASE
    CASE #31: CASE #13: andrelbits1(rel, #x33CC33CC);             ENDCASE
    CASE #30: CASE #03: andrelbits1(rel, #x55AA55AA);             ENDCASE

    CASE #21: CASE #12: andrelbits1(rel, #x3C3C3C3C);             ENDCASE
    CASE #20: CASE #02: andrelbits1(rel, #x5A5A5A5A);             ENDCASE

    CASE #10: CASE #01: andrelbits1(rel, #x66666666);             ENDCASE
  }
  wrrel(rel, TRUE)
  ignorearg(rel, j)
}

// Apply  ai -> aj
AND apimppp(rel, i, j)  BE
{ LET v = @rel!r_v0

  //newline()
  //wrrel(rel, TRUE)
  writef("apimppp: args %n %n*n", i, j)

  SWITCHON i*8+j INTO
  { DEFAULT:  ENDCASE  // an error

    CASE #77:                                                  ENDCASE
    CASE #76: rel!r_w4, rel!r_w5 := 0, 0;                      ENDCASE
    CASE #75: rel!r_w4, rel!r_w6 := 0, 0;                      ENDCASE
    CASE #74: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFF0000, #xFFFF0000,
                                      #xFFFF0000, #xFFFF0000); ENDCASE
    CASE #73: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFF00FF00, #xFF00FF00,
                                      #xFF00FF00, #xFF00FF00); ENDCASE
    CASE #72: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xF0F0F0F0, #xF0F0F0F0,
                                      #xF0F0F0F0, #xF0F0F0F0); ENDCASE
    CASE #71: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xCCCCCCCC, #xCCCCCCCC,
                                      #xCCCCCCCC, #xCCCCCCCC); ENDCASE
    CASE #70: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xAAAAAAAA, #xAAAAAAAA,
                                      #xAAAAAAAA, #xAAAAAAAA); ENDCASE

    CASE #67: rel!r_w2, rel!r_w3 := 0, 0;                      ENDCASE
    CASE #66:                                                  ENDCASE
    CASE #65: rel!r_w2, rel!r_w6 := 0, 0;                      ENDCASE
    CASE #64: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #xFFFF0000, #xFFFF0000);        ENDCASE
    CASE #63: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #xFF00FF00, #xFF00FF00);        ENDCASE
    CASE #62: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #xF0F0F0F0, #xF0F0F0F0);        ENDCASE
    CASE #61: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #xCCCCCCCC, #xCCCCCCCC);        ENDCASE
    CASE #60: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #xAAAAAAAA, #xAAAAAAAA);        ENDCASE

    CASE #57: rel!r_w1, rel!r_w3 := 0, 0;                      ENDCASE
    CASE #56: rel!r_w1, rel!r_w5 := 0, 0;                      ENDCASE
    CASE #55:                                                  ENDCASE
    CASE #54: andrelbits2(rel, #xFFFFFFFF, #xFFFF0000);        ENDCASE
    CASE #53: andrelbits2(rel, #xFFFFFFFF, #xFF00FF00);        ENDCASE
    CASE #52: andrelbits2(rel, #xFFFFFFFF, #xF0F0F0F0);        ENDCASE
    CASE #51: andrelbits2(rel, #xFFFFFFFF, #xCCCCCCCC);        ENDCASE
    CASE #50: andrelbits2(rel, #xFFFFFFFF, #xAAAAAAAA);        ENDCASE

    CASE #47: andrelbits8v(rel, TABLE #x0000FFFF, #x0000FFFF,
                                      #x0000FFFF, #x0000FFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #46: andrelbits4(rel, #x0000FFFF, #x0000FFFF,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #45: andrelbits2(rel, #x0000FFFF, #xFFFFFFFF);        ENDCASE
    CASE #44:                                                  ENDCASE
    CASE #43: andrelbits1(rel, #xFF00FFFF);                    ENDCASE
    CASE #42: andrelbits1(rel, #xF0F0FFFF);                    ENDCASE
    CASE #41: andrelbits1(rel, #xCCCCFFFF);                    ENDCASE
    CASE #40: andrelbits1(rel, #xAAAAFFFF);                    ENDCASE

    CASE #37: andrelbits8v(rel, TABLE #x00FF00FF, #x00FF00FF,
                                      #x00FF00FF, #x00FF00FF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #36: andrelbits4(rel, #x00FF00FF, #x00FF00FF,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #35: andrelbits2(rel, #x00FF00FF, #xFFFFFFFF);        ENDCASE
    CASE #34: andrelbits1(rel, #xFFFF00FF);                    ENDCASE
    CASE #33:                                                  ENDCASE
    CASE #32: andrelbits1(rel, #xF0FFF0FF);                    ENDCASE
    CASE #31: andrelbits1(rel, #xCCFFCCFF);                    ENDCASE
    CASE #30: andrelbits1(rel, #xAAFFAAFF);                    ENDCASE

    CASE #27: andrelbits8v(rel, TABLE #x0F0F0F0F, #x0F0F0F0F,
                                      #x0F0F0F0F, #x0F0F0F0F,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #26: andrelbits4(rel, #x0F0F0F0F, #x0F0F0F0F,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #25: andrelbits2(rel, #x0F0F0F0F, #xFFFFFFFF);        ENDCASE
    CASE #24: andrelbits1(rel, #xFFFF0F0F);                    ENDCASE
    CASE #23: andrelbits1(rel, #xFF0FFF0F);                    ENDCASE
    CASE #22:                                                  ENDCASE
    CASE #21: andrelbits1(rel, #XCFCFCFCF);                    ENDCASE
    CASE #20: andrelbits1(rel, #xAFAFAFAF);                    ENDCASE

    CASE #17: andrelbits8v(rel, TABLE #x33333333, #x33333333,
                                      #x33333333, #x33333333,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #16: andrelbits4(rel, #x33333333, #x33333333,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #15: andrelbits2(rel, #x33333333, #xFFFFFFFF);        ENDCASE
    CASE #14: andrelbits1(rel, #xFFFF3333);                    ENDCASE
    CASE #13: andrelbits1(rel, #xFF33FF33);                    ENDCASE
    CASE #12: andrelbits1(rel, #xF3F3F3F3);                    ENDCASE
    CASE #11:                                                  ENDCASE
    CASE #10: andrelbits1(rel, #xBBBBBBBB);                    ENDCASE

    CASE #07: andrelbits8v(rel, TABLE #x55555555, #x55555555,
                                      #x55555555, #x55555555,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #06: andrelbits4(rel, #x55555555, #x55555555,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #05: andrelbits2(rel, #x55555555, #xFFFFFFFF);        ENDCASE
    CASE #04: andrelbits1(rel, #xFFFF5555);                    ENDCASE
    CASE #03: andrelbits1(rel, #xFF55FF55);                    ENDCASE
    CASE #02: andrelbits1(rel, #xF5F5F5F5);                    ENDCASE
    CASE #01: andrelbits1(rel, #xDDDDDDDD);                    ENDCASE
    CASE #00:                                                  ENDCASE
  }
  wrrel(rel, TRUE)
}

// Apply  ai -> ~aj
AND apimppn(rel, i, j) BE
{ LET v = @rel!r_v0

  //newline()
  //wrrel(rel, TRUE)
  writef("apimppn: args %n %n*n", i, j)

  SWITCHON i*8+j INTO
  { DEFAULT:  ENDCASE  // an error

    CASE #77: rel!r_w4,rel!r_w5,rel!r_w6,rel!r_w7 := 0,0,0,0;  ENDCASE
    CASE #76: rel!r_w6, rel!r_w7 := 0, 0;                      ENDCASE
    CASE #75: rel!r_w5, rel!r_w7 := 0, 0;                      ENDCASE
    CASE #74: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x0000FFFF, #x0000FFFF,
                                      #x0000FFFF, #x0000FFFF); ENDCASE
    CASE #73: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x00FF00FF, #x00FF00FF,
                                      #x00FF00FF, #x00FF00FF); ENDCASE
    CASE #72: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x0F0F0F0F, #x0F0F0F0F,
                                      #x0F0F0F0F, #x0F0F0F0F); ENDCASE
    CASE #71: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x33333333, #x33333333,
                                      #x33333333, #x33333333); ENDCASE
    CASE #70: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x55555555, #x55555555,
                                      #x55555555, #x55555555); ENDCASE

    CASE #67: rel!r_w6, rel!r_w7 := 0, 0;                      ENDCASE
    CASE #66: rel!r_w2,rel!r_w3,rel!r_w6,rel!r_w7 := 0,0,0,0;  ENDCASE
    CASE #65: rel!r_w3, rel!r_w7 := 0, 0;                      ENDCASE
    CASE #64: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x0000FFFF, #x0000FFFF);        ENDCASE
    CASE #63: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x00FF00FF, #x00FF00FF);        ENDCASE
    CASE #62: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x0F0F0F0F, #x0F0F0F0F);        ENDCASE
    CASE #61: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x33333333, #x33333333);        ENDCASE
    CASE #60: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x55555555, #x55555555);        ENDCASE

    CASE #57: rel!r_w5, rel!r_w7 := 0, 0;                      ENDCASE
    CASE #56: rel!r_w3, rel!r_w7 := 0, 0;                      ENDCASE
    CASE #55: rel!r_w1,rel!r_w3,rel!r_w1,rel!r_w7 := 0,0,0,0;  ENDCASE
    CASE #54: andrelbits2(rel, #xFFFFFFFF, #x0000FFFF);        ENDCASE
    CASE #53: andrelbits2(rel, #xFFFFFFFF, #x00FF00FF);        ENDCASE
    CASE #52: andrelbits2(rel, #xFFFFFFFF, #x0F0F0F0F);        ENDCASE
    CASE #51: andrelbits2(rel, #xFFFFFFFF, #x33333333);        ENDCASE
    CASE #50: andrelbits2(rel, #xFFFFFFFF, #x55555555);        ENDCASE

    CASE #47: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x0000FFFF, #x0000FFFF,
                                      #x0000FFFF, #x0000FFFF); ENDCASE
    CASE #46: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x0000FFFF, #x0000FFFF);        ENDCASE
    CASE #45: andrelbits2(rel, #xFFFFFFFF, #x0000FFFF);        ENDCASE
    CASE #44: andrelbits1(rel, #xFFFF0000);                    ENDCASE
    CASE #43: andrelbits1(rel, #x00FFFFFF);                    ENDCASE
    CASE #42: andrelbits1(rel, #x0F0FFFFF);                    ENDCASE
    CASE #41: andrelbits1(rel, #x3333FFFF);                    ENDCASE
    CASE #40: andrelbits1(rel, #x5555FFFF);                    ENDCASE

    CASE #37: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x00FF00FF, #x00FF00FF,
                                      #x00FF00FF, #x00FF00FF); ENDCASE
    CASE #36: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x00FF00FF, #x00FF00FF);        ENDCASE
    CASE #35: andrelbits2(rel, #xFFFFFFFF, #x00FF00FF);        ENDCASE
    CASE #34: andrelbits1(rel, #x00FFFFFF);                    ENDCASE
    CASE #33: andrelbits1(rel, #xFF00FF00);                    ENDCASE
    CASE #32: andrelbits1(rel, #x0FFF0FFF);                    ENDCASE
    CASE #31: andrelbits1(rel, #x33FF33FF);                    ENDCASE
    CASE #30: andrelbits1(rel, #x55FF55FF);                    ENDCASE

    CASE #27: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x0F0F0F0F, #x0F0F0F0F,
                                      #x0F0F0F0F, #x0F0F0F0F); ENDCASE
    CASE #26: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x0F0F0F0F, #x0F0F0F0F);        ENDCASE
    CASE #25: andrelbits2(rel, #xFFFFFFFF, #x0F0F0F0F);        ENDCASE
    CASE #24: andrelbits1(rel, #x0F0FFFFF);                    ENDCASE
    CASE #23: andrelbits1(rel, #x0FFF0FFF);                    ENDCASE
    CASE #22: andrelbits1(rel, #XF0F0F0F0);                    ENDCASE
    CASE #21: andrelbits1(rel, #X3F3F3F3F);                    ENDCASE
    CASE #20: andrelbits1(rel, #x5F5F5F5F);                    ENDCASE

    CASE #17: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x33333333, #x33333333,
                                      #x33333333, #x33333333); ENDCASE
    CASE #16: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x33333333, #x33333333);        ENDCASE
    CASE #15: andrelbits2(rel, #xFFFFFFFF, #x33333333);        ENDCASE
    CASE #14: andrelbits1(rel, #x3333FFFF);                    ENDCASE
    CASE #13: andrelbits1(rel, #x33FF33FF);                    ENDCASE
    CASE #12: andrelbits1(rel, #x3F3F3F3F);                    ENDCASE
    CASE #11: andrelbits1(rel, #xCCCCCCCC);                    ENDCASE
    CASE #10: andrelbits1(rel, #x77777777);                    ENDCASE

    CASE #07: andrelbits8v(rel, TABLE #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #x55555555, #x55555555,
                                      #x55555555, #x55555555); ENDCASE
    CASE #06: andrelbits4(rel, #xFFFFFFFF, #xFFFFFFFF,
                               #x55555555, #x55555555);        ENDCASE
    CASE #05: andrelbits2(rel, #xFFFFFFFF, #x55555555);        ENDCASE
    CASE #04: andrelbits1(rel, #x5555FFFF);                    ENDCASE
    CASE #03: andrelbits1(rel, #x55FF55FF);                    ENDCASE
    CASE #02: andrelbits1(rel, #x5F5F5F5F);                    ENDCASE
    CASE #01: andrelbits1(rel, #x77777777);                    ENDCASE
    CASE #00: andrelbits1(rel, #xAAAAAAAA);                    ENDCASE
  }
  wrrel(rel, TRUE)
}


// Apply ~ai -> aj
AND apimpnp(rel, i, j) BE
{ LET v = @rel!r_v0

  //newline()
  //wrrel(rel, TRUE)
  writef("apimpnp: args %n %n*n", i, j)

  SWITCHON i*8+j INTO
  { DEFAULT:  ENDCASE  // an error

    CASE #77: rel!r_w0,rel!r_w1,rel!r_w2,rel!r_w3 := 0,0,0,0;  ENDCASE
    CASE #76: rel!r_w0, rel!r_w1 := 0, 0;                      ENDCASE
    CASE #75: rel!r_w0, rel!r_w2 := 0, 0;                      ENDCASE
    CASE #74: andrelbits8v(rel, TABLE #xFFFF0000, #xFFFF0000,
                                      #xFFFF0000, #xFFFF0000,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #73: andrelbits8v(rel, TABLE #xFF00FF00, #xFF00FF00,
                                      #xFF00FF00, #xFF00FF00,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #72: andrelbits8v(rel, TABLE #xF0F0F0F0, #xF0F0F0F0,
                                      #xF0F0F0F0, #xF0F0F0F0,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #71: andrelbits8v(rel, TABLE #xCCCCCCCC, #xCCCCCCCC,
                                      #xCCCCCCCC, #xCCCCCCCC,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #70: andrelbits8v(rel, TABLE #xAAAAAAAA, #xAAAAAAAA,
                                      #xAAAAAAAA, #xAAAAAAAA,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE

    CASE #67: rel!r_w0, rel!r_w1 := 0, 0;                      ENDCASE
    CASE #66: rel!r_w0,rel!r_w1,rel!r_w4,rel!r_w5 := 0,0,0,0;  ENDCASE
    CASE #65: rel!r_w0, rel!r_w4 := 0, 0;                      ENDCASE
    CASE #64: andrelbits4(rel, #xFFFF0000, #xFFFF0000,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #63: andrelbits4(rel, #xFF00FF00, #xFF00FF00,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #62: andrelbits4(rel, #xF0F0F0F0, #xF0F0F0F0,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #61: andrelbits4(rel, #xCCCCCCCC, #xCCCCCCCC,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #60: andrelbits4(rel, #xAAAAAAAA, #xAAAAAAAA,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE

    CASE #57: rel!r_w1, rel!r_w3 := 0, 0;                      ENDCASE
    CASE #56: rel!r_w0, rel!r_w4 := 0, 0;                      ENDCASE
    CASE #55: rel!r_w0,rel!r_w2,rel!r_w4,rel!r_w6 := 0,0,0,0;  ENDCASE
    CASE #54: andrelbits2(rel, #xFFFF0000, #xFFFFFFFF);        ENDCASE
    CASE #53: andrelbits2(rel, #xFF00FF00, #xFFFFFFFF);        ENDCASE
    CASE #52: andrelbits2(rel, #xF0F0F0F0, #xFFFFFFFF);        ENDCASE
    CASE #51: andrelbits2(rel, #xCCCCCCCC, #xFFFFFFFF);        ENDCASE
    CASE #50: andrelbits2(rel, #xAAAAAAAA, #xFFFFFFFF);        ENDCASE

    CASE #47: andrelbits8v(rel, TABLE #xFFFF0000, #xFFFF0000,
                                      #xFFFF0000, #xFFFF0000,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #46: andrelbits4(rel, #xFFFF0000, #xFFFF0000,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #45: andrelbits2(rel, #xFFFF0000, #xFFFFFFFF);        ENDCASE
    CASE #44: andrelbits1(rel, #x0000FFFF);                    ENDCASE
    CASE #43: andrelbits1(rel, #xFFFFFF00);                    ENDCASE
    CASE #42: andrelbits1(rel, #xFFFFF0F0);                    ENDCASE
    CASE #41: andrelbits1(rel, #xFFFFCCCC);                    ENDCASE
    CASE #40: andrelbits1(rel, #xFFFFAAAA);                    ENDCASE

    CASE #37: andrelbits8v(rel, TABLE #xFF00FF00, #xFF00FF00,
                                      #xFF00FF00, #xFF00FF00,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #36: andrelbits4(rel, #xFF00FF00, #xFF00FF00,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #35: andrelbits2(rel, #xFF00FF00, #xFFFFFFFF);        ENDCASE
    CASE #34: andrelbits1(rel, #xFFFFFF00);                    ENDCASE
    CASE #33: andrelbits1(rel, #x00FF00FF);                    ENDCASE
    CASE #32: andrelbits1(rel, #xFFF0FFF0);                    ENDCASE
    CASE #31: andrelbits1(rel, #xFFCCFFCC);                    ENDCASE
    CASE #30: andrelbits1(rel, #xFFAAFFAA);                    ENDCASE

    CASE #27: andrelbits8v(rel, TABLE #xF0F0F0F0, #xF0F0F0F0,
                                      #xF0F0F0F0, #xF0F0F0F0,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #26: andrelbits4(rel, #xF0F0F0F0, #xF0F0F0F0,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #25: andrelbits2(rel, #xF0F0F0F0, #xFFFFFFFF);        ENDCASE
    CASE #24: andrelbits1(rel, #xFFFFF0F0);                    ENDCASE
    CASE #23: andrelbits1(rel, #xFFF0FFF0);                    ENDCASE
    CASE #22: andrelbits1(rel, #X0F0F0F0F);                    ENDCASE
    CASE #21: andrelbits1(rel, #XFCFCFCFC);                    ENDCASE
    CASE #20: andrelbits1(rel, #xFAFAFAFA);                    ENDCASE

    CASE #17: andrelbits8v(rel, TABLE #xCCCCCCCC, #xCCCCCCCC,
                                      #xCCCCCCCC, #xCCCCCCCC,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #16: andrelbits4(rel, #xCCCCCCCC, #xCCCCCCCC,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #15: andrelbits2(rel, #xCCCCCCCC, #xFFFFFFFF);        ENDCASE
    CASE #14: andrelbits1(rel, #xFFFFCCCC);                    ENDCASE
    CASE #13: andrelbits1(rel, #xFFCCFFCC);                    ENDCASE
    CASE #12: andrelbits1(rel, #xFCFCFCFC);                    ENDCASE
    CASE #11: andrelbits1(rel, #x33333333);                    ENDCASE
    CASE #10: andrelbits1(rel, #xEEEEEEEE);                    ENDCASE

    CASE #07: andrelbits8v(rel, TABLE #xAAAAAAAA, #xAAAAAAAA,
                                      #xAAAAAAAA, #xAAAAAAAA,
                                      #xFFFFFFFF, #xFFFFFFFF,
                                      #xFFFFFFFF, #xFFFFFFFF); ENDCASE
    CASE #06: andrelbits4(rel, #xAAAAAAAA, #xAAAAAAAA,
                               #xFFFFFFFF, #xFFFFFFFF);        ENDCASE
    CASE #05: andrelbits2(rel, #xAAAAAAAA, #xFFFFFFFF);        ENDCASE
    CASE #04: andrelbits1(rel, #xFFFFAAAA);                    ENDCASE
    CASE #03: andrelbits1(rel, #xFFAAFFAA);                    ENDCASE
    CASE #02: andrelbits1(rel, #xFAFAFAFA);                    ENDCASE
    CASE #01: andrelbits1(rel, #xEEEEEEEE);                    ENDCASE
    CASE #00: andrelbits1(rel, #x55555555);                    ENDCASE
  }
  wrrel(rel, TRUE)
}


// Apply ~ai -> ~aj
AND apimpnn(rel, i, j) BE apimppp(rel, j, i)




