/*
This will be modified to convert graph data generated by playmus
into a .bmp picture to show how well the synchronisation mechanism
works.

Implemented by Martin Richards (c) September 2011

Usage:

playgraph "FROM,TO/K,X/N,Y/N,TEXT/K"

FROM    if given is the graphdata file. Default is gdata.
TO      is the filename for the .bmp picture -- default pic.bmp
X       X size in pixels, default 2000
Y       Y size in pixels, default 1500
TEXT    give the title of the graph

Change history

13/09/2011
Started implementation, based on anawav.b.

*/

GET "libhdr"

GLOBAL {
  fromname:ug
  tostream
  stdin
  stdout
  debug
  toname
  tostream
  toname
  minrt
  maxrt
  minmt
  maxmt
  flag
  rtrange
  mtrange
  rtscale
  mtscale
  oer
  oem
  erate

  title
}

// Insert the graphics library
//MANIFEST { g_grbase=450 }

GET "graphics.h"
GET "graphics.b"

LET start() = VALOF
{ LET argv = VEC 50

  stdout := output()
  tostream := 0
  debug := 0
  title := 0

  writef("playgraph entered*n")

  UNLESS rdargs("FROM,TO/K,X/N,Y/N,TEXT/K", argv, 50) DO
  { writef("Bad arguments for playgraph*n")
    RESULTIS 0
  }

  fromname := "gdata"
  toname   := "pic.bmp"
  xsize := 1000
  ysize :=  600

  // Default estimated play line
  oer, oem, erate := 0, 0, 1_000

  IF argv!0 DO fromname := argv!0      // FROM       graphdata
  IF argv!1 DO toname   := argv!1      // TO/K       The bmp file name
  IF argv!2 DO xsize    := !(argv!2)   // X/N
  IF argv!3 DO ysize    := !(argv!3)   // Y/N
  IF argv!4 DO title    := argv!4      // TEXT/K

  sawritef("*nConverting %s to %s (%nx%n)*n", fromname, toname, xsize, ysize)

  UNLESS opengraphics(xsize, ysize, mode8bit) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  drawgraph(xsize, ysize)

fin:
sawritef("*nfin: reached*n")
  IF tostream DO endstream(tostream)
  IF canvas DO freevec(canvas)
  selectoutput(stdout)
  //writef("return code = %n*n", 0)

  RESULTIS 0
}

AND colour(ch) = VALOF SWITCHON ch INTO
{ DEFAULT:  RESULTIS col_black

  CASE '+': RESULTIS col_black
  CASE '-': RESULTIS col_black-5
  CASE 'B': RESULTIS col_black-10
  CASE 'S': RESULTIS col_black-20

  CASE 'M': RESULTIS col_red
  CASE 'N': RESULTIS col_green
  CASE 'G': RESULTIS col_blue+20
  CASE 'E': RESULTIS col_blue
  CASE 'C': RESULTIS col_majenta
}

AND scangraphdata(name, firstpass) BE
{ LET rt, mt, weight = 0, 0, weight
  LET now, rate = 0, 0
  LET pos = 0

  LET fromstream = findinput(name)
  UNLESS fromstream DO
  { writef("Unable to open file: %s*n", name)
    RETURN
  }

  selectinput(fromstream)

  // Process statements of the form:
  // #T text
  // #B rt mt weight
  // #S rt mt weight
  // #M rt mt weight
  // #A rt note amp
  // #N rt mt weight notestr
  // #+ oer oem erate
  // #- oer oem erate
  // #E oer oem erate
  

  { LET ch = rdch()
sw:
    SWITCHON ch INTO
    { DEFAULT:
        pos := pos + 1
        LOOP

      CASE endstreamch:
        BREAK

      CASE '*n':
      CASE '*p':
        pos := 0
        LOOP

      CASE '#':
        pos := pos+1
        IF pos=1 DO
        { ch := rdch()
//UNLESS firstpass DO sawritef("#%c ", ch)
          SWITCHON ch INTO
          { DEFAULT:
              GOTO sw

            CASE 'T':  // #T text
              { ch := rdch()
                IF ch='*n' | ch=endstreamch BREAK
                UNLESS firstpass DO
                { drawch(ch)
//sawritef("#T ch='%c'*n", ch)
                }
              } REPEAT

              drawch('*n')
              GOTO sw

            CASE 'B':  // #B rt mt weight
            CASE 'S':  // #S rt mt weight
            CASE 'M':  // #M rt mt weight

               rt := readn()
               mt := readn() //- rt
               weight := readn()
               TEST firstpass
               THEN { TEST flag
                      THEN { minrt, maxrt := rt, rt
                             minmt, maxmt := mt, mt
                             flag := FALSE
                           }
                      ELSE { IF rt<minrt DO minrt := rt
                             IF rt>maxrt DO maxrt := rt
                             IF mt<minmt DO minmt := mt
                             IF mt>maxmt DO maxmt := mt
                           }
                   }
               ELSE { currcolour := colour(ch)
	              drawpoint33(rtscale(rt), mtscale(mt))
                    }
               LOOP
                        
            CASE 'A':  // #A rt note amp
            {  LET note, amp = ?, ?
               rt   := readn()
               note := readn()
               amp  := readn()
               TEST firstpass
               THEN { TEST flag
                      THEN { //minrt, maxrt := rt, rt
                             //flag := FALSE
                           }
                      ELSE { //IF rt<minrt DO minrt := rt
                             //IF rt>maxrt DO maxrt := rt
                           }
                   }
               ELSE { amp := amp/50
                      IF amp>255 DO amp := 255
		      currcolour := amp
                      drawpoint33(rtscale(rt), notescale(note))
                    }
               LOOP
            }
                        
            CASE 'N':  // #N rt mt weight notestr
               rt := readn()
               mt := readn()
               weight := readn()
               TEST firstpass
               THEN { TEST flag
                      THEN { minrt, maxrt := rt, rt
                             minmt, maxmt := mt, mt
                             flag := FALSE
                           }
                      ELSE { IF rt<minrt DO minrt := rt
                             IF rt>maxrt DO maxrt := rt
                             IF mt<minmt DO minmt := mt
                             IF mt>maxmt DO maxmt := mt
                           }
                   }
               ELSE { LET x  = rtscale(rt)
                      LET y  = mtscale(mt)
		      currcolour := colour(ch)
                      drawpoint33(x,  y)
                    }
               LOOP
                        
            CASE '+':  // #+ oer oem erate
            CASE '-':  // #- oer oem erate

            CASE 'E':  // #E oer oem erate
               // We have a new estimated play line
               oer   := readn()
               oem   := readn()
               erate := readn()

               TEST firstpass
               THEN { TEST flag
                      THEN { minrt, maxrt := oer, oer
                             minmt, maxmt := oem, oem
                             flag := FALSE
                           }
                      ELSE { IF oer<minrt DO minrt := oer
                             IF oer>maxrt DO maxrt := oer
                             IF oem<minmt DO minmt := oem
                             IF oem>maxmt DO maxmt := oem
                           }
                   }
               ELSE { LET r,m = rtscale(oer), mtscale(oem)
	              //currcolour := colour('E')
                      //drawpoint33(r, m+20)
                      IF ch='+' DO { currcolour := colour(ch)
		                     drawpoint33(r, m+30)
				   }
                      IF ch='-' DO { currcolour := colour(ch)
                                     drawpoint33(r, m+10)
				   }
                    }
               LOOP
          }
        }
    }

  } REPEAT
  endstream(fromstream)
}

AND rtscale(rt) = VALOF
{ LET res = rtscale1(rt)
  //sawritef("rtscale: rt=%n minrt=%n maxrt=%n => %n*n", rt, minrt, maxrt, res)
  RESULTIS res
}
AND rtscale1(rt) = muldiv(rt-minrt, xsize, rtrange)

AND mtscale(mt) = VALOF
{ LET res = mtscale1(mt)
  //sawritef("mtscale: mt=%n minmt=%n maxmt=%n => %n*n", mt, minmt, maxmt, res)
  RESULTIS res
}
AND mtscale1(mt) = muldiv(mt-minmt, ysize, mtrange)

AND notescale(note) = (ysize*note)/127

AND drawgraph(xsize, ysize) BE
{ currcolour := col_black
  FOR x = 0 TO xsize-1 DO
  { drawpoint(x, 0)
    drawpoint(x, 1)
    drawpoint(x, ysize-1)
    drawpoint(x, ysize-2)
  }
  FOR y = 0 TO ysize-1 DO
  { drawpoint(0, y)
    drawpoint(1, y)
    drawpoint(xsize-1, y)
    drawpoint(xsize-2, y)
  }

  moveto(10, 260); currcolour := colour('+'); drawch('+')
  moveto(10, 240); currcolour := colour('-'); drawch('-')
  moveto(10, 220); currcolour := colour('B'); drawch('B')
  moveto(10, 200); currcolour := colour('S'); drawch('S')
  moveto(10, 180); currcolour := colour('M'); drawch('M')
  moveto(10, 160); currcolour := colour('N'); drawch('N')
  moveto(10, 140); currcolour := colour('G'); drawch('G')
  moveto(10, 120); currcolour := colour('E'); drawch('E')
  moveto(10, 100); currcolour := colour('C'); drawch('C')

  FOR x = 0 TO xsize DO
  { currcolour := 255*x/xsize
    drawpoint33(x, 1)
    drawpoint33(x, 4)
  }

  currcolour := col_red
  moveto(10, ysize-20)

  scangraphdata(fromname, TRUE)

  minrt, maxrt := minrt-10, maxrt+10
  minmt, maxmt := minmt-200, maxmt+200
  rtrange := maxrt - minrt
  mtrange := maxmt - minmt

  currcolour := col_red
  moveto(10, ysize-20)

  scangraphdata(fromname, FALSE)
//abort(1000)

  IF title DO drawstr(title)

  //FOR c = 32 TO 127 DO
  //{ IF c='A' | c='a' | c='0' DO drawch('*n')
  //  drawch(c)
  //}
  //plostr("*nHello World*nLast line*n")

  wrgraph(toname) //canvas, pixeldatasize, xsize, ysize)
}

AND r2m_msecs(real_msecs, or, om, rate) = VALOF
{ // Convert real time msecs to midi msecs
  // rate is the number of midi msecs per real second
  // (or, om) are the coordinates of a point on the play line.
  LET mt = om + muldiv(real_msecs-or, rate, 1000)
sawritef("r2m: rt=%9.3d or=%9.3d om=%9.3d rate=%9.3d => %9.3d*n",
          real_msecs, or, om, rate, mt)
  RESULTIS mt
}

AND m2r_msecs(midi_msecs, or, om, rate) = VALOF
{ // Convert midi msecs to real time
  // rate is the number of midi msecs per real second
  // (or, om) are the coordinates of a point on the play line.
  LET rt = or + muldiv(midi_msecs-om, 1000, rate)
  RESULTIS rt
}

