/* Table to map an 8 bit number to its lowest bit */
static const unsigned char  gc_lowest_bit[256] =
{
	0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0,
	4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0
};

/* Compute lowest set bit number of an integer (assume there is one) */
static inline jvm_uint_t gc_lowest(jvm_uint_t x)
{
	return
    ( (((x) & 0xffff) != 0)
	  ? ( (((x) >> 0) & 0xff)
		  ? (gc_lowest_bit[((x) >>  0) & 0xff] +  0)    /* Index  0 to  7 */
		  : (gc_lowest_bit[((x) >>  8) & 0xff] +  8))   /* Index  8 to 15 */
	  : ( (((x) >> 16) & 0xff)
		  ? (gc_lowest_bit[((x) >> 16) & 0xff] + 16)    /* Index 16 to 23 */
		  : (gc_lowest_bit[((x) >> 24) & 0xff] + 24))); /* Index 24 to 31 */
}

