GET "libhdr"

LET start() = VALOF
{ LET v = VEC 1000
  LET n = 0
  FOR i = 0 TO 1000 DO v!i := -1
  writes("Testing an integer square routine function*n")

  { LET count = instrcount(sqrt, n)
    LET r = result2
    LET t = r*r - n
    IF t>0                DO writef("srqt(%n) => %n  -- too large*n", n, r)
    IF t + r + r + 1 <= 0 DO writef("srqt(%n) => %n  -- too small*n", n, r)
    IF t>0 | t+r+r+1<=0   DO abort(1000)
    IF n REM 100_000_000 = 0 DO writef("n = %n_000_000*n", n/1_000_000)
    IF 0<=count<=1000 & v!count<0 DO
    { writef("sqrt(%iB) => %i6 -- takes %i3 instructions*n", n, result2, count)
      v!count := n
    }
    n := n+1
  } REPEATUNTIL n=maxint
  RESULTIS 0
}

AND sqrt(x) = VALOF
{ LET xn = ?
  LET t = TABLE
      0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61,
     64, 65, 67, 69, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 87, 89,
     90, 91, 93, 94, 96, 97, 98, 99,101,102,103,104,106,107,108,109,
    110,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,
    128,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,
    143,144,144,145,146,147,148,149,150,150,151,152,153,154,155,155,
    156,157,158,159,160,160,161,162,163,163,164,165,166,167,167,168,
    169,170,170,171,172,173,173,174,175,176,176,177,178,178,179,180,
    181,181,182,183,183,184,185,185,186,187,187,188,189,189,190,191,
    192,192,193,193,194,195,195,196,197,197,198,199,199,200,201,201,
    202,203,203,204,204,205,206,206,207,208,208,209,209,210,211,211,
    212,212,213,214,214,215,215,216,217,217,218,218,219,219,220,221,
    221,222,222,223,224,224,225,225,226,226,227,227,228,229,229,230,
    230,231,231,232,232,233,234,234,235,235,236,236,237,237,238,238,
    239,240,240,241,241,242,242,243,243,244,244,245,245,246,246,247,
    247,248,248,249,249,250,250,251,251,252,252,253,253,254,254,255

  IF x>= #x1_0000 DO
  { IF x>=#x100_0000 DO
    { TEST x>=#x1000_0000 THEN TEST x>=#x4000_0000 THEN xn := t!(x>>24)<<8
                                                   ELSE xn := t!(x>>22)<<7
                          ELSE TEST x>= #x400_0000 THEN xn := t!(x>>20)<<6
                                                   ELSE xn := t!(x>>18)<<5
      xn := (x/xn + xn + 1)>>1
      xn := (x/xn + xn + 1)>>1
      RESULTIS xn + (xn*xn-x>0) // Care with overflow
    }

    TEST x>=#x10_0000 THEN TEST x>=#x40_0000 THEN xn := t!(x>>16)<<4
                                             ELSE xn := t!(x>>14)<<3
                      ELSE TEST x>= #x4_0000 THEN xn := t!(x>>12)<<2
                                             ELSE xn := t!(x>>10)<<1
    xn := (x/xn + xn + 1)>>1
    RESULTIS xn + (xn*xn>x)
  }
  // x is < #x10000
  IF x>=#x100 DO
  { TEST x>=#x1000 THEN TEST x>=#x4000 THEN xn :=  t!(x>>8)     + 1
                                       ELSE xn := (t!(x>>6)>>1) + 1
                   ELSE TEST x>= #x400 THEN xn := (t!(x>>4)>>2) + 1
                                       ELSE xn := (t!(x>>2)>>3) + 1
    RESULTIS xn + (xn*xn>x)
  }
  // x is < #x100
  IF x>=0 RESULTIS t!x>>4
  RESULTIS -1
}
