{ *************************************************************************
  *                                                                       *
  *                        U n i v e r s a l                              *
  *                                                                       *
  *                       T r a n s l a t o r                             *
  *                                                                       *
  *                               for                                     *
  *                                                                       *
  *                         S e m a n t i c                               *
  *                                                                       *
  *                         G r a m m a r s                               *
  *                                                                       *
  *************************************************************************}
{5 Jan 88: replaced select->selector}
{Modified to produce code for A. Norman's SKIM machine}
{To do:
  simplify (IF x THEN y ELSE z FI s) -> IF x THEN y s ELSE z s FI
  delete 'substTrivial'?
  count variables within FIX the same as usual
  better commenting
  }
program ut(input,		{terminal input}
	   output,		{terminal output}
	   ldf,			{language description file to read}
	   source,		{source program to read}
	   object,		{object file of instructions to write}
	   listing);	  	{source listing to write}

const
    eofTerm = 1;               {terminal index for eof-token "*eof"}
    nameTerm = 2;              {terminal index for names "*name"}
    numberTerm = 3;            {terminal index for numbers "*number"}
    maxLineLen = 80;           {max source line length}
    maxLines = 3000;           {max number of lines in source programs}

    hashLimit = 199;           {size of terminal hash table}
    maxStrings = 199;          {size of string hash table}
    maxParseStack = 200;       {size of parser stack}

    maxApplics = 20;           {number of operands in an application}

    maxTableSize = 14000;      {combined limit of all parse tables}
    maxRefs = 63;              {max reference count stored}
    varTableLimit = 10;        {number of predefined vars}

    maxErrors = 500;           {max number of semantic errors in program}

    maxArgs = 30000;           {max total args of dag nodes}

    {**2****ga/ut common constants**************************************}
    tabChar = 11b;             {char code for tab}
    alfaleng = 15;             {max length of var names, keywords, etc.}
    defUname = 1;              {index of 'uniquename' in def}
    maxLambdaDepth = 31;       {nesting limit of lambda-expressions}
    maxDefs = 80;              {max number of definitions}
    maxDoms = 80;              {max number of domain definitions}
    maxSelectors = 60;         {max number of selectors for sum domains}

    maxKernels = 300;          {maximum number of kernels}
    maxNonterms = 80;          {max number of nonterminal symbols}
    maxTerms = 100;            {max number of terminal symbols}
    maxRules = 200;            {max number of semantic rules}
    {*******************************************************************}

type

    {**3****ga/ut common types******************************************}
    xKind = (namedX,attrX,varX,fixX,lambdaX,propX,caseX,
              injX,projX,isX,
              stringX,intX,boolX,botX,              {constants}
              leftX,rightX,notX,                     {unary ops}
              plusX,minusX,timesX,divX,modX,       {binary ops}
              ltX,eqX,applicX,pairX,
              condX,alterX,                           {ternary ops}
              nilX,int2X,stopX);                     {delimeters}

    xPost = packed
    record case kind: xKind of
                namedX,varX,injX,isX,boolX,
                intX: (int: 0..99999999);
                stringX,fixX,lambdaX: (ch1,ch2,ch3,ch4: char);
                int2X,attrX,caseX,projX: (int1,int2: 0..999)
    end;

    {*******************************************************************}


    {***must match the corresponding segment of xKind!}
    operator = (leftOp,rightOp,notOp,
                plusOp,minusOp,timesOp,divOp,modOp,ltOp,eqOp);

    hashIndex = 0..hashLimit;
    argIndex = 0..maxArgs;

    alfa = packed array [1..alfaleng] of char;  {string type}

    colIndex = 0..maxLineLen;  lineIndex = 0..maxLines;
    lineCol = packed record line: lineIndex; col: colIndex end;

    termIndex = 0..maxTerms;          {terminal symbols}
    nontermIndex = 0..maxNonterms;    {nonterminal symbols}

    expression = ^expNode; {nil represents forward-defined expressions}

    attrList = ^attrNode;             {list of attributes}
    semanList = ^semanNode;           {list of attribute expressions}

    semanNode = packed record
                            fn: expression;     {semantic function}
                            dom: 0..maxDoms;   {domain of semantics}
                            nt: nontermIndex;  {symbol containing attr}
                            pos,                {position in rule}
                            attrCnt: 0..30;    {number of attrs used}
                            attrs: attrList;   {attributes used}
                            next: semanList
                        end;


    {hash table entries: keywords, delimeters, and identifiers}
    entryPtr = ^entryType;
    entryType = packed record name: alfa; idx: 0..99999; link: entryPtr end;


    stringEntry = ^stringNode;
    stringNode = packed record
                             name: alfa;
                             val: expression;
                             next: stringEntry
                         end;

    defIndex = 1..maxDefs;
    selIndex = 1..maxSelectors;

    caseList = ^caseNode;

    boundVar = packed record name: ^alfa; propagate: boolean end;


    {defined attribute positions:
      left-hand-side inherited
      right-hand-side synthesized
      pseudo attributes (with clause)  }
    attrKind = (lhsAttr, rhsAttr, pseudoAttr);

    attrNode = packed record
                           atKind: attrKind;
                           offset: 0..999;
                           next: attrList
                       end;


    constKind = (bot,           {bottom element of domain in lattice}
                  int,          {integer constant, a number}
                  bool,         {boolean constant, true or false}
                  string);      {string constant, a string of characters}

    valueType = record  {representation of constant values}
                     case kind: constKind of
                          int: (i: integer);
                          bool: (b: boolean);
                          string: (s: ^alfa; key: 0..99999)
                 end;

    {kinds of expressions}
    expKind = (unusedExp,       {element of freelist; illegal in expressions}
                dagNode,        {node of dag: function with args}
                linkNode,       {placeholder}
                sharedNode,     {shared node in final dag}
                namedExp,       {reference to defined expression}
                variable,       {reference to bound var by depth, 0 = local}
                constant,       {constant value}
                fixExp,         {fixedpoint; fix x.y denotes fix(\x.y)}
                lambdaExp,      {abstraction of the body over the bound var}
                applic,         {application of an operator to an operand}
                cond,           {conditional expression}
                caseExp,        {case expression for sum domains}
                pair,           {ordered pair of exprs; element of product}
                unOp,           {unary operator applied to argument}
                binOp,          {infix operator applied to arguments}
                alterExp,       {alteration of function at a point}
                inject,         {coercion from summand to sum domain}
                project,        {coercion from sum to summand domain}
                isExp);         {test that sum belongs to specified summand}

    expNode = packed
    record {expressions}
        next: expression;        {link in free/used list}
        refs: 0..maxRefs;        {reference count}
        free: 0..maxLambdaDepth; {deepest free variable in the expression}
        visited: boolean;        {used to split final dag into a forest}
        case kind: expKind of
             dagNode:   (sem: semanList;        {semantic function for node}
                         argIdx: argIndex;      {index into dagArg}
                         expanded: boolean;     {detects cycles in graph}
                         col: colIndex;         {column in source program}
                         line: lineIndex);      {line in program}
             linkNode:  (link: expression);
             sharedNode:(shi: integer);         {number of shared node}
             namedExp:  (di: defIndex);
             variable:  (depth: integer);
             constant:  (v: valueType);
             lambdaExp,
             fixExp:    (bv: boundVar; body: expression);
             applic:    (rator,rand: expression);
             cond:      (ifx,thenx,elsex: expression);
             caseExp:   (index: expression; cases: caseList);
             pair:      (l,r: expression);
             unOp:      (uop: operator; u1: expression);
             binOp:     (bop: operator; b1,b2: expression);
             alterExp:  (t1,t2,t3: expression);         {[t1->t2]t3}
             inject,project,
             isExp:     (si: selIndex;         {tag for operation}
                         silent: boolean;       {project-- signal no errors}
                         exp: expression)
    end;

    caseNode = packed record  {component of a case expression}
                           free: 0..maxLambdaDepth;
                           si: selIndex;
                           bv: boundVar;
                           body: expression;
                           next: caseList
                       end;


    expList = ^expListNode;  {list of expressions}
    expListNode = packed record exp: expression; next: expList end;


    byte = 0..511;      {can be stored 4 per word; holds states and rulenums}

    {parse tables are indexed by kernels (states), but since identical rows
      are folded, an extra level of indirection is necessary to map kernels
      to the proper row.}
    parseTable =
    record
        map: packed array [1..maxKernels] of byte;
        rowWidth,rowCount,base: integer
    end;


    errorKind = (lineTooLong,nameTooLong,eofInComment,
                  illChar,illToken);


    {representation of semantic error -- type def needed for sorting}
    semanErrKind = (undefAttr, circAttr, badConstraint);

    errorRec = packed
    record
        loc: lineCol;          {location of error in program}
        sem: semanList;        {attribute causing the error}
        kind: semanErrKind
    end;


    struct = ^integer;  {dummy definition for type instruction}

    {**9**ut/sm common types*******************************************}
    instKind = (haltI,returnI,ldBotI,ldConstI,ldPosI,
                 ldCloseI,ldNcloseI,applyI,applyIntI,pairI,
                 injectI,projectI,isI,alterI,alterIntI,
                 leftI,rightI,notI,plusI,minusI,timesI,divI,modI,
                 eqI,ltI,jumpI,fjumpI,callzI,pushEnvI,popEnvI,
                 labelI,ldIntI);


    instruction = packed
    record
        case kind: instKind of
             ldConstI: (str: struct);
             injectI,projectI,isI,          {arg is selector}
             applyIntI,alterIntI,
             ldPosI,ldIntI: (int: integer); {arg is integer}
             labelI,ldCloseI,ldNcloseI,jumpI,
             fjumpI,callzI:  (pc,level: 0..99999)
    end;
    {***************************************************************}


var
    dagListing,                {option to list the simplified dag}
    codeListing,               {option to list object instructions}
    defsListing,               {option to list the defs read in}
    genTagfields: boolean;     {generate inject/project instructions}


    {variables for reading characters}
    ch: char;                   {current character being scanned}
    endOfFile: boolean;       {at end of source file}

    {the current input line}
    line: record
              count,                    {number of lines so far}
              prevLen,                 {length of previous line}
              col,                      {column last scanned}
              len: integer;             {length of current line}
              prev,                     {previous line}
              buf: packed               {current line}
              array [1..maxLineLen] of char
          end;


    {variables for lexical scanning}
    lexErrs: boolean;          {the source program contains lexical errors}
    delims: set of char;        {holds all non-alfanumeric chars}
    tokenCount: integer;
    curLoc: lineCol;          {location of current token}

    {info about current token}
    token: record
               val: expression;           {numbers and strings}
               ti: termIndex             {corresponding terminal}
           end;


    {parse tables}
    kernelCount: integer;      {number of lr(0) kernels or parser states}
    table: record
               action,     {holds 2-bit entries error,shift,reduce,accept}
               term,       {holds shift nextstates and reduce rules}
               nonterm: parseTable;   {holds reduce nextstates}
               elemCount: integer;    {combined size of parse tables}
               {storage pool for the three tables}
               elem: packed array [0..maxTableSize] of byte
           end;


    {Program source and listing files}
    source,listing: text;


    {Language Description File:
     contains definitions, selectors, attributes, symbols, parse tables}
    ldf: file of xPost;

    ruleCount: integer;			{number of syntax rules}
    rule: array [1..maxRules] of
    record
        attrs,                          {applied attribute expressions}
        pseudos,                        {values of pseudo-attributes}
        constraints: semanList;        {constraints of the rule}
        nPseudo,                       {number of pseudo-attributes}
        length: integer;                {length of rule's right side}
        lhs: integer            	{goal symbol of rule -- a nonterminal}
    end;


    termCount: integer;                {number of terminals in the grammar}
    termTable: array[hashIndex] of entryPtr;


    {maps each terminal to its corresponding hash entry}
    tokenIndex: array[termIndex] of entryPtr;


    {table of domain names}
    domCount: integer;
    domn: array [1..maxDoms] of alfa;


    {table of selector names}
    selectCount: integer;
    selector: array [selIndex] of alfa;


    {table of nonterminal symbols}
    nontermCount: integer;
    nonterm: array [1..maxNonterms] of
    record
        name: alfa;
        nInh,nSyn: integer
    end;


    {table of definitions}
    recurCount,                        	{number of recursive definitions}
    defCount: integer;             	{total number of definitions}
    def: array [1..maxDefs] of record name: alfa; value: expression end;


    {expressions for 'true' and 'false'}
    boolExp: array [boolean] of expression;

    errorExp,                          {'bot' where error was recorded}
    botExp: expression;                {expression for 'bot'}

    stringCount: integer;              {number of distinct strings}
    stringTable: packed array [0..maxStrings] of stringEntry;


    {commonly used variables, indexed by depth}
    preVarCount: integer;
    preVar: array [0..varTableLimit] of expression;


    {variables for garbage collection}

    freeList,                  {list of deallocated expression nodes}
    usedList: expression;      {list of currently used expression nodes}

    freeCaseList: caseList;  {deallocated case list nodes}
    freeExpList: expList;    {deallocated exp list nodes}


    {storage and runtime statistics}
    expCount: array [expKind] of integer;
    usedCount,                         {total of nodes in use}
    maxUsed,                           {max ever used at one time}
    totalFreed: integer;               {total nodes freed by gc}
    tableSize: integer;                {nodes used by attribute tables}

    {current runtime at the following computation stages:}
    rtime: record
               start,          {at start of program}
               init,           {after initization: reading ldf}
               parse,          {after parsing/dag construction}
               simp,           {after dag simplification}
               comp: integer   {after code generation}
           end;


    opAlfa: array [operator] of alfa;  {print names for operators}

    uniqueNum: integer;                {used to generate unique idents}



    {arguments of semantic functions in dag}
    dagArgCount: integer;
    dagArg: packed array [1..maxArgs] of expression;

    dag: expression;                    {semantic dag of parsed program}

    constraints: expList;              {accumulated constraints of program}

    {semantic errors detected in dag}
    errorCount: integer;
    error: array [0..maxErrors]        {elem 0 needed only for sort}
    of errorRec;


    object: file of instruction;          {object file of secd instructions}

    objectFileName: alfa;		  {name of object file}
    listFileName: alfa;                   {name of listing file (for heading)}



function simpDepth
    (argCount: integer; args: expList; x: expression; offset: integer)
    : expression; forward;



function hash(name: alfa): integer;          {machine dependent}
    {Hash function for looking up keywords of the source language}
    var sum,i: integer;
    begin
    sum := 0;
    for i := 1 to alfaleng do sum := sum + sum + ord(name[i]);
    hash := sum
    end {hash};



procedure linkEntry(name: alfa; idx: integer; var e: entryPtr);
    {map the name to the idx in the hash table}
    var h: hashIndex;
    begin
    h := hash(name) mod hashLimit;
    new(e);
    e^.name := name;  e^.idx := idx;  e^.link := termTable[h];
    termTable[h] := e
    end {linkEntry};



procedure lookup(name: alfa;  var idx: integer);
    {look up the name in the hash table; return its code 'idx'}
    var h: integer;  e: entryPtr;
    begin
    h := hash(name) mod hashLimit;
    e := termTable[h];  idx := 0;
    while (e <> nil) and (idx=0) do begin
        if e^.name = name then idx := e^.idx;
        e := e^.link
        end
    end {lookup};



procedure makeLc(var name: alfa; var len: integer);
    {convert the name to lower case; return length of non-blank prefix}
    var i: integer;  ch: char;
    begin
    i := 0;
    repeat
        i := i+1;
        ch := name[i];
        if ('a' <= ch) and (ch <= 'z')
        then name[i] := chr(ord(ch) + ord('a') - ord('a'))
    until (i=alfaleng) or (ch=' ');
    if ch=' ' then len := i-1
    else len := alfaleng
    end {makeLc};



function renumber(offset: integer; x: expression): expression;
    {renumber all the free variables of 'x' by adding 'offset' to them}
    begin
    if offset = 0 then renumber := x
    else renumber := simpDepth(0,nil,x,offset)
    end {renumber};



function simplify(x: expression): expression;
    begin
    if x=nil then simplify := nil
    else simplify := simpDepth(0,nil,x,0)
    end {simplify};



function max(i,j: integer): integer;
    begin
    if i>j then max := i
    else max := j
    end {max};



function min(i,j: integer): integer;
    begin
    if i<j then min := i
    else min := j
    end {min};



procedure incRefs(x: expression);
    {increment the reference count of x, unless it is the maximum.
      if count reaches the max then x will never be deallocated.}
    begin
    if x<>nil then
        with x^ do begin
            assert(kind <> unusedExp);
            if refs <> maxRefs then refs := refs+1
	    end
    end {incRefs};



procedure decRefs(x: expression);
    {decrement the reference count of x, unless it is the maximum.}
    begin
    if x<>nil then
        with x^ do if refs <> maxRefs then refs := refs-1
    end {decRefs};



procedure decSubRefs(x: expression);
    var c,nxt: caseList;  i: integer;
    begin
    with x^ do
        case kind of
            sharedNode,namedExp,variable,constant: {do nothing};
            dagNode:
                for i := argIdx to argIdx + sem^.attrCnt - 1 do begin
                    decRefs(dagArg[i]); dagArg[i] := nil
                    end;
            linkNode: decRefs(link);
            fixExp,lambdaExp: decRefs(body);
            applic: begin decRefs(rator); decRefs(rand) end;
            cond: begin
                decRefs(ifx);
                decRefs(thenx);
                decRefs(elsex)
                end;
            caseExp:
                begin
                decRefs(index); c := cases;
                while c<>nil do begin
                    decRefs(c^.body);
                    nxt := c^.next;
                    c^.next := freeCaseList;
                    freeCaseList := c;
                    c := nxt
                    end
                end;
            pair: begin decRefs(l); decRefs(r) end;
            unOp: decRefs(u1);
            binOp: begin decRefs(b1); decRefs(b2) end;
            alterExp: begin decRefs(t1); decRefs(t2); decRefs(t3) end;
            inject,project,isExp: decRefs(exp)
            end {case};
    expCount[x^.kind] := expCount[x^.kind] - 1
    end {decSubRefs};



procedure garbageCollect;
    {scan allocated expression nodes and delete those with a reference
      count of zero.  decrement the reference count of the children of each
      node deleted.  since a node usually preceeds its children in the
      used-list, entire structures can be deallocated in a single pass over the
      used-list.  }
    var x,last,nxt: expression;   usedBefore,saving: integer;
    begin
    x := usedList;   last := nil;   usedBefore := usedCount;
    while x <> nil do begin
        nxt := x^.next;
        if x^.refs = 0 then begin {deallocate the node}
            usedCount := usedCount - 1;
            decSubRefs(x);
            {place onto free list}
            x^.kind := unusedExp; x^.next := freeList; freeList := x;
            {delete from used list}
            if last = nil then usedList := nxt
            else last^.next := nxt
            end
        else last := x;
        {last node still on usedList}
        x := nxt
        end {x<>nil};
    if usedBefore <> 0 then begin
        maxUsed := max(usedBefore,maxUsed);
        totalFreed := totalFreed + usedBefore - usedCount;
        saving := 100*(usedBefore-usedCount) div usedBefore;
        writeln(listing, 'gc ',usedBefore:1, '  ', usedCount:1,
                '  ', saving:1, '%')
        end
    end {garbageCollect};



function consX(free: integer; kind: expKind): expression;
    {construct an expression node-- from free list if possible, else from the
      heap.  put onto used-list.  initialize its top-level fields.}
    var x: expression;
    begin
    if freeList = nil then new(x)
    else begin x := freeList; freeList := freeList^.next end;
    x^.kind := kind; x^.refs := 0; x^.free := free;
    x^.visited := false;
    {enter into used list}
    x^.next := usedList; usedList := x;
    expCount[kind] := expCount[kind] + 1;
    usedCount := usedCount+1;
    consX := x
    end {consX};



function decFree(free: integer): integer;
    {decrement free variable depth for exiting a scope.  upper limit
      represents 'infinity'.}
    begin
    if (free=0) or (free=maxLambdaDepth) then decFree := free
    else decFree := free - 1
    end {decFree};



function improper(x: expression): boolean;
    {'true' if x = bot }
    begin improper := (x^.kind = constant) and (x^.v.kind = bot) end;



function consDagNode
    (sem: semanList;  argIdx: integer; loc: lineCol): expression;
    var x: expression;
    begin
    x := consX(0,dagNode);
    x^.sem := sem;  x^.argIdx := argIdx;
    x^.expanded := false;
    x^.col := loc.col;  x^.line := loc.line;
    consDagNode := x
    end {consDagNode};



function consNExp(di: defIndex): expression;
    {construct named expression}
    var x: expression;
    begin x := consX(0,namedExp); x^.di := di; consNExp := x end;



function consConst(c: constKind): expression;
    {construct constant expression.}
    var x: expression;
    begin x := consX(0,constant); x^.v.kind := c; consConst := x end;



function consIntConst(i:integer): expression;
    {construct integer constant of value 'i'}
    var x: expression;
    begin
    x := consConst(int); x^.v.i := i;
    consIntConst := x
    end {consIntConst};



function consStringConst(name: alfa): expression;
    var x: expression;  h: integer;  se: stringEntry;
    begin
    h := hash(name) mod maxStrings;
    se := stringTable[h];  x := nil;
    while (se <> nil) and (x=nil) do begin
        if se^.name = name then x := se^.val;
        se := se^.next
        end;
    if x=nil then begin
        stringCount := stringCount+1;
        x := consConst(string);
        new(x^.v.s);  x^.v.s^ := name;
        x^.v.key := stringCount;
        incRefs(x);
        new(se);  se^.name := name;  se^.val := x;
        se^.next := stringTable[h];
        stringTable[h] := se
        end;
    consStringConst := x
    end {consStringConst};



function consVar(depth: integer): expression;
    {construct variable using predefined expression if possible}
    var x: expression;
    begin
    if depth <= preVarCount then consVar := preVar[depth]
    else begin
        x := consX(min(depth+1,maxLambdaDepth), variable);
        x^.depth := depth;
        consVar := x
        end
    end {consVar};



function consFix(bv: boundVar; body: expression): expression;
    {construct fixed point expression.}
    var x: expression;
    begin
    incRefs(body);
    x := consX(decFree(body^.free),fixExp);
    x^.bv := bv; x^.body := body;
    consFix := x
    end {consFix};



function consLambda(bv: boundVar; body: expression): expression;
    {construct lambda expression}
    var x: expression;
    begin
    incRefs(body);
    x := consX(decFree(body^.free), lambdaExp);
    x^.bv := bv; x^.body := body;
    consLambda := x
    end {consLambda};



function consApplic(rator,rand: expression): expression;
    {construct application}
    var x: expression;
    begin
    incRefs(rator); incRefs(rand);
    x := consX(max(rator^.free,rand^.free), applic);
    x^.rator := rator; x^.rand := rand;
    consApplic := x
    end {consApplic};



function consCond(ifx,thenx,elsex: expression): expression;
    {construct conditional}
    var x: expression;
    begin
    incRefs(ifx); incRefs(thenx); incRefs(elsex);
    x := consX(max(ifx^.free, max(thenx^.free,elsex^.free)), cond);
    x^.ifx := ifx; x^.thenx := thenx; x^.elsex := elsex;
    consCond := x
    end {consCond};



function consCase(index: expression; cases: caseList)
    : expression;
    {construct a case expression, given its arms.}
    var x: expression;
    begin
    incRefs(index);
    x := consX(max(index^.free, decFree(cases^.free)), caseExp);
    x^.index := index; x^.cases := cases;
    consCase := x
    end {consCase};



function consPair(l,r: expression): expression;
    {construct a pair : an element of a product domain.}
    var x: expression;
    begin
    incRefs(l); incRefs(r);
    x := consX(max(l^.free,r^.free), pair); x^.l := l; x^.r := r;
    consPair := x
    end {consPair};



function consUnOp(uop: operator; u1: expression): expression;
    {construct a unary operation.}
    var x: expression;
    begin
    incRefs(u1);
    x := consX(u1^.free, unOp);  x^.uop := uop;  x^.u1 := u1;
    consUnOp := x
    end {consUnOp};



function consBinOp(bop: operator; b1,b2: expression): expression;
    var x: expression;
    begin
    incRefs(b1); incRefs(b2);
    x := consX(max(b1^.free,b2^.free), binOp);
    x^.bop := bop; x^.b1 := b1; x^.b2 := b2;
    consBinOp := x
    end {consBinOp};



function consAlter(t1,t2,t3: expression): expression;
    var x: expression;
    begin
    incRefs(t1); incRefs(t2); incRefs(t3);
    x := consX(max(t1^.free, max(t2^.free,t3^.free)), alterExp);
    x^.t1 := t1; x^.t2 := t2; x^.t3 := t3;
    consAlter := x
    end {consAlter};



function consInject(si: selIndex; exp: expression): expression;
    {construct an injection into a sum domain.}
    var x: expression;
    begin
    incRefs(exp);
    x := consX(exp^.free, inject); x^.si := si;  x^.exp := exp;
    x^.silent := false;
    consInject := x
    end {consInject};



function consProject(si: selIndex; silent: boolean; exp: expression)
    : expression;
    {construct a projection (projection) from a sum domain to a summand.}
    var x: expression;
    begin
    incRefs(exp);
    x := consX(exp^.free, project); x^.si := si; x^.exp := exp;
    x^.silent := silent;
    consProject := x
    end {consProject};



function consIsExp(si: selIndex; exp: expression): expression;
    {construct a test that 'exp' belongs to summand 'si'}
    var x: expression;
    begin
    incRefs(exp);
    x := consX(exp^.free,isExp); x^.si := si; x^.exp := exp;
    x^.silent := false;
    consIsExp := x
    end {consIsExp};



function consCaseList
    (si: selIndex; bv: boundVar; body: expression; next: caseList)
    : caseList;
    {'cons' a new element to the front of the case-list 'next'}
    var c: caseList;
    begin
    incRefs(body);
    if freeCaseList = nil then new(c)
    else begin
        c := freeCaseList;  freeCaseList := freeCaseList^.next
        end;
    if next = nil then c^.free := body^.free
    else c^.free := max(body^.free, next^.free);
    c^.si := si; c^.bv := bv; c^.body := body; c^.next := next;
    consCaseList := c
    end {consCaseList};



function consExpList(exp: expression;  next: expList): expList;
    var l: expList;
    begin
    incRefs(exp);
    if freeExpList = nil then new(l)
    else begin
        l := freeExpList;  freeExpList := freeExpList^.next
        end;
    l^.exp := exp; l^.next := next; consExpList := l
    end {consExpList};



procedure dispExpList(xl: expList);
    {dispose an expression list, freeing the nodes and their elements}
    var next: expList;
    begin
    while xl <> nil do begin
        decRefs(xl^.exp);
        next := xl^.next;
        xl^.next := freeExpList;
        freeExpList := xl;
        xl := next
        end
    end {dispExpList};



function consAtList
    (at: attrKind;  off: integer;  next: attrList): attrList;
    var l: attrList;
    begin
    new(l); l^.atKind := at;  l^.offset := off;  l^.next := next;
    consAtList := l
    end {consAtList};



function consSemanList
    (fn: expression; dom,nt,pos,attrCnt: integer; attrs: attrList;
     next: semanList): semanList;
    var l: semanList;
    begin
    incRefs(fn);
    new(l);  l^.fn := fn;
    l^.dom := dom;  l^.nt := nt;  l^.pos := pos;
    l^.attrCnt := attrCnt;
    l^.attrs := attrs;  l^.next := next;
    consSemanList := l
    end {consSemanList};



function selectArg(args: expList; depth: integer): expression;
    {index into the list of arguments to the 'depth' specified}
    var a: expList;  i: integer;
    begin
    a := args;
    for i := 1 to depth do a := a^.next;
    selectArg := a^.exp
    end {selectArg};



procedure printExp(var f: text; x: expression; args: expList);
    {uses pretty printing algorithm from:  Oppen, Derek C., "Pretty Printing",
      STAN-CS-79-770, Stanford U.  Also in TOPLAS, October 1980, P. 465.
      altered to print only the outer structure down to the depth pStackLen}
    const
        margin = 80; queueLen = 260;
        sStackLen = 80;
        pStackLen = 40;               {depth limit for printing}
        infinity = 999999;
    type
        queueIndex = 0..queueLen;
        sStackIndex = 0..sStackLen;  

        tokenSize = integer;
        tokenKind = (stringTk,breakTk,beginTk,endTk);
        token = record
                    case kind: tokenKind of
                         stringTk: (str: alfa; len: 0..alfaleng);
                         breakTk: (blankSpace, offset: integer);
                         beginTk: (indent: integer)
                end;
        breakType = (fits,consistent);

        alfa5 = packed array [1..5] of char;

    var
        bVarDepth: integer;
        bVar: array [1..maxLambdaDepth] of boundVar;

        space,leftotal,rightotal: integer;
        queue: record   {tokens to be printed}
                   left,right: queueIndex;
                   stream: array [queueIndex] of token;
                   size: array [queueIndex] of tokenSize
               end;

        sStack: record
                     top,bottom: sStackIndex;
                     data: array [0..sStackLen] of queueIndex
                 end;

        {stack of phrases to be printed}
        pFull: boolean;                        {too many 'begins'}
        pNesting,                              {nesting of 'begins'}
        pStackTop: integer;
        pStack: array [1..pStackLen] of
        record bt: breakType; offset: integer end;



    procedure print(x: expression);forward;



    procedure printToken(t: token; s: tokenSize);
        begin
        case t.kind of
            stringTk: begin write(f,t.str:s); space := space-s end;
            beginTk:
                begin
                pStackTop := pStackTop+1;
                with pStack[pStackTop] do begin
                    offset := space - t.indent;
                    if s>space then bt := consistent
                    else bt := fits
                    end
                end;
            endTk: pStackTop := pStackTop-1;
            breakTk:
                with pStack[pStackTop] do
                    if bt = consistent then begin
                        space := offset - t.offset;
                        writeln(f);  
			if margin>space then write(f, ' ': margin-space)
                        end
                    else begin
                        space := space - t.blankSpace;
                        if t.blankSpace > 0 then write(f, ' ': t.blankSpace)
                        end
            end {case}
        end {printToken};



        {***********************************************}
        {*       operations for the 'scan stack'       *}
        {***********************************************}



    procedure sPush(qi: queueIndex);
        begin
        with sStack do begin
            top := (top+1) mod sStackLen;
            assert(top <> bottom);      {stack overflow?}
            data[top] := qi
            end
        end {sPush};



    procedure sPop(var qi: queueIndex);
        begin
        with sStack do begin
            assert(top <> bottom);      {popping empty stack?}
            qi := data[top];
            top := (sStackLen + top-1) mod sStackLen
            end
        end {sPop};



    function sEmpty : boolean;
        begin
        with sStack do sEmpty := top = bottom
        end {sEmpty};



    function sTop : queueIndex;
        begin
        with sStack do begin assert(top<>bottom); sTop := data[top] end
        end {sTop};



    procedure sPopbottom(var qi: queueIndex);
        begin
        with sStack do begin
            assert(top <> bottom);      {popping empty stack?}
            bottom := (bottom+1) mod sStackLen;
            qi := data[bottom]
            end
        end {sPopbottom};



        {**********************************************}
        {*          operations for the queue          *}
        {**********************************************}



    procedure enqueue(t: token; s: tokenSize; len: integer);
        begin
        rightotal := rightotal + len;
        with queue do begin
            right := (right+1) mod queueLen;
            assert(right<>left);        {full queue?}
            stream[right] := t; size[right] := s
            end
        end {enqueue};



    procedure advanceLeft;
        var t: token;  s: tokenSize;



        function nextLeft : queueIndex;
            begin
            nextLeft := (queue.left+1) mod queueLen
            end {nextLeft};

        begin
        with queue do begin
            while (left <> right) and (size[nextLeft] >= 0) do begin
                left := nextLeft;
                t := stream[left];  s := size[left];
                printToken(t,s);
                case t.kind of
                    breakTk: leftotal := leftotal + t.blankSpace;
                    stringTk: leftotal := leftotal + s;
                    beginTk, endTk:
                    end {case}
                end {while}
            end {with}
        end {advanceLeft};



    procedure clearQueue;
        begin
        leftotal := 1; rightotal := 1;
        queue.left := 0;  queue.right := 0
        end {clearQueue};



    procedure setTokenSize;


        function tokenNotBegin : boolean;
            begin
            if sEmpty then tokenNotBegin := false
            else tokenNotBegin := queue.stream[sTop].kind <> beginTk
            end {tokenNotBegin};


        procedure setSize(s: tokenSize);
            var qi: queueIndex;
            begin sPop(qi); queue.size[qi] := s end;

        begin
        if not sEmpty then begin
            case queue.stream[sTop].kind of
                beginTk:  {do nothing};
                endTk:
                    begin
                    setSize(1);
                    while tokenNotBegin do setTokenSize;
                    if not sEmpty then {must be 'begin'}
                        setSize(queue.size[sTop] + rightotal)
                    end;
                stringTk,breakTk:
                    setSize(queue.size[sTop] + rightotal)
                end {case}
            end {if}
        end {setTokenSize};



        {**********************************************}
        {*     c o n t r o l    p r o c e d u r e s   *}
        {**********************************************}



    procedure pString(str: alfa; len: integer);
        var t: token;  qi: queueIndex;
        begin
        if pNesting <= pStackLen then begin
            pFull := false;
            t.kind := stringTk;  t.str := str;  t.len := len;
            if sEmpty then printToken(t,len)
            else begin
                enqueue(t,len,len);
                while (queue.left<>queue.right) and (rightotal-leftotal>space)
                and not sEmpty do begin
                    sPopbottom(qi); queue.size[qi] := infinity; advanceLeft
                    end
                end
            end
        end {pString};



    procedure pStr(s: alfa5; len: integer);
        {print short string}
        var str: alfa;  i: integer;
        begin
        str := '               ';
        for i := 1 to 5 do str[i] := s[i];
        pString(str,len)
        end {pStr};



    procedure pChar(ch: char);
        var str: alfa;
        begin
        str := '               '; str[1] := ch; pString(str,1)
        end {pChar};



    procedure pBegin(indent: integer);
        var t: token;
        begin
        if pNesting >= pStackLen then begin
            {pStack exceeded, can't print any deeper}
            if not pFull then pStr('...  ',3);
            pFull := true
            end
        else begin
            t.kind :=beginTk;  t.indent := indent;
            if sEmpty then clearQueue;
            enqueue(t, -rightotal, 0);
            sPush(queue.right)
            end;
        {pNesting is incremented at end instead of at beginning so that
          pStr will work}
        pNesting := pNesting+1
        end {pBegin};



    procedure pEnd;
        var t: token;
        begin
        if pNesting <= pStackLen then begin
            t.kind := endTk;
            if sEmpty then printToken(t,0)
            else begin enqueue(t,-1,0); sPush(queue.right) end
            end;
        pNesting := pNesting - 1
        end {pEnd};



    procedure pBreak(blankSpace,offset: integer);
        var t: token;
        begin
        if pNesting <= pStackLen then begin
            t.kind := breakTk; t.blankSpace := blankSpace;
            t.offset := offset;
            if sEmpty then clearQueue;
            setTokenSize;
            enqueue(t, -rightotal, blankSpace);
            sPush(queue.right)
            end
        end {pBreak};



    procedure init;
        begin
        clearQueue;
        space := margin;
        with sStack do begin top := 0; bottom := 0 end;
        pStackTop := 0; pNesting := 0; pFull := false
        end {init};



    procedure terminate;
        begin setTokenSize; advanceLeft end;



        {**********************************************}
        {*    p r i n t i n g   p r o c e d u r e s   *}
        {**********************************************}



    procedure printName(name: alfa);
        {print an identifier or string without trailing blanks}
        var len: integer;
        begin
        if name = '               ' then len := 0
        else begin
            len := alfaleng;
            while name[len] = ' ' do len := len-1
            end;
        pString(name,len)
        end {printName};



    procedure leftChar(ch: char);
        {print a left bracket, parenthesis, or whatever, and open new
          printing level.}
        begin pChar(ch); pBegin(0) end {leftChar};



    procedure rightChar(ch: char);
        {print a right bracket, parenthesis, or whatever, and close current
          printing level.}
        begin pEnd; pChar(ch) end {rightChar};



    procedure printLr(x: expression; left,right: boolean);
        {left and right help avoid printing redundant parentheses.
          left is true when the expression already has a delimeter to
          its left.  likewise for right.}



        procedure pushBoundVar(bv: boundVar);
            {push a bound variable onto the stack 'bVar'}
            begin
            bVarDepth := bVarDepth+1;
            bVar[bVarDepth] := bv
            end {pushBoundVar};



        procedure pushPrtBv(bv: boundVar);
            {push bound variable and print its name}
            begin
            bVarDepth := bVarDepth+1;  bVar[bVarDepth] := bv;
            printName(bv.name^);
            end {pushPrtBv};



        procedure printInt(i: integer);
            begin
            if i<0 then begin pChar('-');  i := -i end;
            if i>9 then printInt(i div 10);
            pChar(chr(ord('0') + i mod 10))
            end {printInt};



        procedure printConst(v: valueType);
            begin
            case v.kind of
                bot: pStr('bot  ',3);
                int: printInt(v.i);
                bool: if v.b then pStr('true ',4)
                      else pStr('false',5);
                string:
                    begin pChar('"'); printName(v.s^); pChar('"') end
                end {case}
            end {printConst};



        procedure printFix(x: expression);
            begin
            if not right then leftChar('(');
            pStr('fix  ',4); pushPrtBv(x^.bv);
            pChar('.'); pBreak(0,0); print(x^.body);
            if not right then rightChar(')');
            bVarDepth := bVarDepth-1
            end {printFix};



        procedure printLambda(x: expression);
            var ch: char;  oldDepth: integer;
            begin
            oldDepth := bVarDepth;
            if not right then leftChar('(');
            ch := '\';
            while x^.kind = lambdaExp do begin
                pChar(ch); ch := ' '; pushPrtBv(x^.bv); x := x^.body end;
            pChar('.'); pBreak(0,0); print(x);
            if not right then rightChar(')');
            bVarDepth := oldDepth
            end {printLambda};



        procedure printApplic(x: expression);
            {print an expression of the form
              (\bvn ... bvm . rat) randn ... rand1
              as
              ((let bvn = randn
              inl ...
              inl bvm = randm
              in rat)
              rand(m-1) ... rand1)
              where m=1 and m>n (no lambdas) are special cases}
            var wrap: boolean;  i,j,oldBvd: integer;  y: expression;
                rands: array [1..maxApplics] of expression;
                let: alfa5;
            begin
            i := 0;
            while x^.kind = applic do
                begin i := i+1; rands[i] := x^.rand; x := x^.rator end;
            y := x;  j := i;
            while y^.kind = lambdaExp do begin j := j-1; y := y^.body end;
            wrap := j>0;
            if wrap and not left then leftChar('(');
            if x^.kind = lambdaExp then begin
                if wrap then leftChar('(');
                y := x;  j := i;  let := 'let  ';
                while (y^.kind = lambdaExp) and (j <> 0) do begin
                    pStr(let,4); printName(y^.bv.name^);
                    pChar('='); pBreak(0,3);
                    print(rands[j]);
                    pBreak(1,0);  let := 'inl  ';
                    j := j-1; y := y^.body
                    end;
                pStr('in   ',3);
                y := x;  j := i;  oldBvd := bVarDepth;
                while (y^.kind = lambdaExp) and (j <> 0) do
                    begin pushBoundVar(y^.bv); j := j-1; y := y^.body end;
                printLr(y,true,wrap);
                bVarDepth := oldBvd;
                if wrap then rightChar(')')
                end
            else begin printLr(x,true,false);  j := i end;
            while j <> 0 do begin
                pBreak(1,0); printLr(rands[j],false,false); j := j-1 end;
            if wrap and not left then rightChar(')')
            end {printApplic};



        procedure printCase(x: expression);
            var c: caseList;


            procedure pCase(var c: caseList);
                begin
                pBreak(1,0); pBegin(2);
                printName(selector[c^.si]);
                pushBoundVar(c^.bv);
                if c^.bv.name^ <> 'void           ' then begin
                    leftChar('['); printName(c^.bv.name^); rightChar(']')
                    end;
                pChar('.'); pBreak(0,1);
                print(c^.body); bVarDepth := bVarDepth-1;
                pEnd; c := c^.next
                end {pCase};

            begin
            pBegin(2); pStr('case ',5);
            print(x^.index); pStr(' of  ',3);
            c := x^.cases; pCase(c);
            while c <> nil do begin pChar(';'); pCase(c) end;
            pEnd; pBreak(1,0); pStr('esac ',4)
            end {printCase};



        procedure printBinOp(opName: alfa; b1,b2: expression);
            var wrap: boolean;
            begin
            wrap := not (left and right);
            if wrap then leftChar('(');
            printLr(b1,true,false); pBreak(1,0);
            printName(opName);
            pChar(' '); printLr(b2,false,true);
            if wrap then rightChar(')')
            end {printBinOp};



        procedure printPair(x: expression);
            begin
            while x^.kind = pair do
                begin print(x^.l); pChar(','); pBreak(0,0); x := x^.r end;
            print(x)
            end {printPair};



        procedure printAlter(x: expression);
            {print a function defined by update-expressions}
            begin
            if not right then leftChar('(');
            while x^.kind = alterExp do begin
                leftChar('['); print(x^.t1);
                pStr('->   ',2); pBreak(0,0); print(x^.t2);
                rightChar(']'); pBreak(0,0);
                x := x^.t3
                end;
            print(x);
            if not right then rightChar(')')
            end {printAlter};

        begin {printLr}
        pBegin(0);
        if x=nil then pStr('nil  ',3)
        else if bVarDepth >= maxLambdaDepth then
            {prevent overflow of bound variable table}
            pStr(' ... ',5)
        else with x^ do
            case kind of
                linkNode: printLr(link,left,right);
                sharedNode:
                    begin
                    pString('shared         ',7);
                    printInt(shi)
                    end;
                namedExp: printName(def[di].name);
                variable:
                    if depth < bVarDepth then {bound variable}
                        printName(bVar[bVarDepth - depth].name^)
                    else  {free variable}
                        printLr(selectArg(args, depth - bVarDepth),
                                 left, right);
                constant: printConst(v);
                fixExp: printFix(x);
                lambdaExp: printLambda(x);
                applic:  printApplic(x);
                cond: {also conditional boolean operators}
                    if thenx = boolExp[true] then
                        printBinOp('or             ',ifx,elsex)
                    else if elsex = boolExp[false] then
                        printBinOp('and            ',ifx,thenx)
                    else begin
                        pStr('if   ',3); print(ifx); pBreak(1,0);
                        pStr('then ',5); print(thenx); pBreak(1,0);
                        pStr('else ',5); print(elsex); pBreak(1,0);
                        pStr('fi   ',2)
                        end;
                caseExp: printCase(x);
                pair: begin leftChar('('); printPair(x); rightChar(')') end;
                unOp:
                    if (uop = notOp)
                        and (u1^.kind = binOp) and (u1^.bop = ltOp) then
                        printBinOp('ge             ',u1^.b1,u1^.b2)
                    else begin
                        if not right then leftChar('(');
                        printName(opAlfa[uop]); pBreak(1,0); print(u1);
                        if not right then rightChar(')')
                        end;
                binOp:  printBinOp(opAlfa[bop], b1, b2);
                alterExp:  printAlter(x);
                inject:
                    begin
                    printName(selector[si]);
                    if exp <> botExp then begin
                        leftChar('['); printPair(exp); rightChar(']')
                        end
                    end;
                project,isExp:
                    begin
                    if not left then leftChar('(');
                    printLr(exp,true,false); pBreak(1,0);
                    if kind = project then pChar('|')
                    else pStr('is   ',3);
                    printName(selector[si]);
                    if not left then rightChar(')')
                    end
                end {case};
        pEnd
        end {printLr};



    procedure print {(x: expression)};
        begin printLr(x,true,true) end;

    begin
    bVarDepth := 0; 
    init;  print(x);  terminate;
    writeln(f);  writeln(f)
    end {printExp};



function refsVar(x: expression; limit: integer): boolean;
    {checks if 'x' uses the 0-level bound var 'limit' or more times.
      uses within a fix count as multiple use.}
    var bvd,         {depth of bound vars}
        fd: integer; {fixedpoint depth}



    function rv(x: expression): integer;
        var rvx,oldBvd: integer;



        procedure rvCase(cases: caseList);
            begin
            bvd := bvd+1;
            while (cases <> nil) and (rvx<limit) do
                begin rvx := rvx + rv(cases^.body); cases := cases^.next end;
            bvd := bvd-1
            end {rvCase};

        begin
        oldBvd := bvd;  rvx := 0;
        while (x^.free <> 0) and (rvx<limit)
        and (x^.kind in [lambdaExp,applic,unOp]) do begin
            while x^.kind = lambdaExp do
                begin bvd := bvd+1;  x := x^.body end;
            while (x^.kind = applic) and (rvx<limit) do begin
                rvx := rvx + rv(x^.rand);  x := x^.rator
                end;
            while x^.kind=unOp do x := x^.u1
            end;
        if (rvx<limit) and (x^.free <> 0) then begin
            with x^ do
                case kind of
                    linkNode,sharedNode,namedExp,constant: {skip};
                    variable: if depth = bvd then rvx := rvx + 1 + fd;
                    fixExp:
                        begin
                        bvd := bvd+1;  fd := fd+1;
                        rvx := rv(body);
                        fd := fd-1;    bvd := bvd-1
                        end;
                    cond: rvx := rvx + rv(ifx) + rv(thenx) + rv(elsex);
                    caseExp: begin rvx := rvx + rv(index); rvCase(cases) end;
                    pair: rvx := rvx + rv(l) + rv(r);
                    binOp: rvx := rvx + rv(b1) + rv(b2);
                    alterExp: rvx := rvx + rv(t1) + rv(t2) + rv(t3);
                    inject,project,isExp: rvx := rvx + rv(exp)
                    end {case}
            end;
        bvd := oldBvd;  rv := rvx
        end {rv};

    begin
    fd := 0;  bvd := 0; refsVar := rv(x) >= limit
    end {refsVar};



function simpDepth
    {(argCount: integer; args: expList;  x: expression; offset: integer)
    : expression};
    {simplify the expression; if   arg <> nil    then
      substitute the 'args' for the free variables of depths 0 .. argCount - 1
      thruout 'x'; simultaneously add 'offset' to the other free variables}
    var
        bVarDepth: integer;   {nesting depth of bound variables}
        simpDesired: boolean;  {purpose: simplify or just substitute?}

        substTrivial: boolean; {the substitution for 'args' is trivial}
        substIndex: integer;


    procedure checkTrivial;
        {see if the substitution is trivial & can be skipped}
        var a: expList;
        begin
        substTrivial := true;  substIndex := 0;   a := args;
        while (a<>nil) and substTrivial do begin
            substTrivial :=
            substTrivial and (a^.exp = preVar[substIndex]);
            substIndex := substIndex+1;
            a := a^.next
            end
        end {checkTrivial};



    function simpDeeper(x: expression): expression;forward;



    function simp(x: expression): expression;
        var simpx: expression;
            accessCount: integer;
            left: packed array [1..30] of boolean;



        function simpCond(i,t,e: expression): expression; forward;



        function simpFix(bv: boundVar; body: expression): expression;
            {fix x.y  -->  y      if y does not use x}
            begin
            if refsVar(body,1) then simpFix := consFix(bv,body)
            else simpFix := renumber(-1,body)
            end {simpFix};



        function eq(v1,v2: valueType): boolean;
            {are v1 and v2 equal values?}
            begin
            assert(v1.kind = v2.kind);  assert(v1.kind <> bot);
            case v1.kind of
                int: eq := v1.i = v2.i;
                bool: eq := v1.b = v2.b;
                string: eq := v1.s^ = v2.s^
                end {case}
            end {eq};



        function simpApplic(x: expression): expression;
            {simplify an application of the form:
              rator randn ... rand1
              the main simplifications occur when the rator is a lambda-
              or alter-expression.}



            var randCount: integer;
                rands: array [1..maxApplics] of expression;

                rator: expression;
                done: boolean;



            procedure pushRand(rand: expression);
                begin
                randCount := randCount+1;
                rands[randCount] := rand
                end {pushRand};



            procedure simpNamed(link,rand: expression);
                {handles expansion of recursive functions, which may loop.
                  functions, recursive or not, are treated like macros--
                  expanded over their arguments.  to prevent expansion of
                  recursive macros from looping, the argument is checked to
                  be a constant, for expanding recursive structures.
                  note: non-recursive 'named-exps' are expanded in main body
                  of simpDepth and never reach here.}
                begin
                if (rand^.free = 0) and (link<>nil) then rator := link
                else done := true
                end {simpNamed};



            procedure simpBeta;
                {do beta-reductions; rator has the form
                  \bv ... bv . rat
                  the bv's are matched with the corresponding rands and
                  substituted in the body.
                  beta-reduction does not occur if it would require duplicating
                  large expressions.  in that case we continue on to the next
                  possible reduction rather than quitting entirely.}
                var
                    {stack of disallowed beta-reductions}
                    failedCount: integer;
                    failed: array [1..maxLambdaDepth] of
                    record
                        bv: boundVar;
                        rand: expression
                    end;


                    args: expList;  argCount: integer;
                    rand,rat: expression;



                function simple(arg: expression): boolean;
                    {check that 'arg' is simple enough to duplicate when
                      reducing an abstraction where the bound var is used
                      more than once.  necessary to prevent blow-up of exprs.}
                    begin
                    simple := (arg^.free = 0) or (arg^.kind = variable)
                    end {simple};



                function okToReduce(rator,rand: expression): boolean;
                    {see if beta-reduction is allowable for rator and rand.}
                    begin
                    assert(rator^.kind = lambdaExp);
                    if rator^.bv.propagate then okToReduce := true
                    else if simple(rand) then okToReduce := true
                    else okToReduce := not refsVar(rator^.body,2)
                    end {okToReduce};

                begin
                rat := rator;  failedCount := 0;
                args := nil;  argCount := 0;
                while (randCount<>0) and (rat^.kind = lambdaExp) do begin
                    rand := rands[randCount];
                    if okToReduce(rat,rand) then begin
                        args := consExpList
                        (renumber(failedCount,rand), args);
                        argCount := argCount+1;
                        rat := rat^.body;
                        randCount := randCount-1
                        end
                    else if argCount<>0 then begin
                        rat :=
                        simpDepth(argCount,args,rat,-argCount);
                        dispExpList(args);
                        args := nil;  argCount := 0
                        end
                    else begin
                        failedCount := failedCount+1;
                        failed[failedCount].bv := rat^.bv;
                        failed[failedCount].rand := rand;
                        rat := rat^.body;
                        randCount := randCount-1
                        end
                    end;
                if argCount<>0 then begin
                    rat :=
                    simpDepth(argCount,args,rat,-argCount);
                    dispExpList(args)
                    end;
                done := failedCount <> 0;
                while failedCount<>0 do begin
                    {put back the things that couldn't be reduced}
                    rat := consLambda(failed[failedCount].bv, rat);
                    pushRand(failed[failedCount].rand);
                    failedCount := failedCount-1
                    end;
                rator := rat
                end {simpBeta};



            procedure simpAlter(rand: expression);
                {  ([a -> b]f) rand   where rand is constant, is:
                  if a=rand then b else (f rand) fi  }
                begin
                if improper(rand) then begin
                    {propagate improper value}
                    rator := rand;  randCount := 0
                    end
                else if (rand^.kind=constant)
                    and (rator^.t1^.kind=constant) then
                    if eq(rator^.t1^.v, rand^.v) then begin
                        rator := rator^.t2; randCount := randCount-1
                        end
                    else rator := rator^.t3
                else done := true
                end {simpAlter};

            begin
            rator := x;  randCount := 0;
            while rator^.kind = applic do begin
                pushRand(simp(rator^.rand));
                rator := rator^.rator
                end;
            rator := simp(rator);
            done := false;
            repeat
                case rator^.kind of
                    namedExp:
                        simpNamed(def[rator^.di].value, rands[randCount]);
                    constant:
                        begin
                        {propagate top or bot; other consts can't be funcs}
                        assert(improper(rator));
                        randCount := 0
                        end;
                    unusedExp,linkNode,pair,inject,
                    isExp: assert(false);           {can't occur}
                    variable,fixExp,applic,cond,caseExp,unOp,binOp,
                    project: done := true;     {can't simplify further}
                    lambdaExp: simpBeta;
                    alterExp: simpAlter(rands[randCount])
                    end {case}
            until done or (randCount=0);
            while randCount <> 0 do begin
                rator := consApplic(rator,rands[randCount]);
                randCount := randCount-1
                end;
            simpApplic := rator
            end {simpApplic};



        function simpCond{(i,t,e:expression):expression};
            {simplify conditional.  if exp then true else false fi => exp.
              if exp then \x.f else \y.g fi => \x.if exp then f else g fi.
              domain checking assures that dom(x)=dom(y) and dom(f)=dom(g)}
            begin
            if (t = boolExp[true]) and (e = boolExp[false])
            then simpCond := i
            else if (t^.kind = lambdaExp) and (e^.kind = lambdaExp)
            then simpCond := consLambda
                (t^.bv,simpCond(renumber(1,i),t^.body,e^.body))
            else simpCond := consCond(i,t,e)
            end {simpCond};



        function foldCond(i,t,e: expression): expression;
            {attempts to 'fold' constant conditionals.
              'i' has been simplified but not t or e!}
            begin
            if improper(i) then foldCond := i
            else if i^.kind = constant then
                if i^.v.b then foldCond := simp(t)
                else           foldCond := simp(e)
            else foldCond := simpCond(i, simp(t), simp(e))
            end {foldCond};



        function simpCase(index:expression;
                           cases: caseList): expression;
            {simplify a case, 'folding' it to a single arm if possible.
              the index is already simplified, but not the 'cases'.}
            var found: boolean;  c: caseList;



            function sCases(cases: caseList): caseList;
                {simplify an entire case list}
                begin
                if cases = nil then sCases := nil
                else with cases^ do
                    sCases := 
			consCaseList(si,bv,simpDeeper(body),sCases(next))
                end {sCases};

            begin
            if index^.kind = inject then begin
                {select case arm corresponding to injection}
                c := cases;  found := false;
                while (c <> nil) and not found do begin
                    if c^.si = index^.si then found := true
                    else c := c^.next
                    end;
                assert(found);
                simpCase :=
                simpApplic
                (consApplic(consLambda(c^.bv,c^.body), index^.exp))
                end
            else if improper(index) then simpCase := index
            else simpCase := consCase(index, sCases(cases))
            end {simpCase};



        function simpUnOp(uop: operator; u1: expression): expression;
            begin
            assert(uop = notOp);
            if improper(u1) then simpUnOp := u1
            else if u1^.kind = constant then
                simpUnOp := boolExp[not u1^.v.b]
            else simpUnOp := consUnOp(uop,u1)
            end {simpUnOp};



        function simpBinOp(bop: operator; b1,b2: expression): expression;
            {simplify binary operator:
              propagate 'error' and 'bottom' elements
              fold constants
              simplify x eq y
              special purpose simplification:  for any operator $,
              .          if x then y else z fi $ u
              . ->       if x then y$u else z$u fi
              needed for pascal representation of false=0, true=1:
              .          (if p then 1 else 0 fi) eq 1   ->   p   }



            function foldConst
                (bop: operator; val1,val2: valueType): expression;
                {perform operations on constants: 8+5  ->  13  }
                begin
                case bop of
                    plusOp: foldConst := consIntConst(val1.i + val2.i);
                    minusOp: foldConst := consIntConst(val1.i - val2.i);
                    timesOp: foldConst := consIntConst(val1.i * val2.i);
                    divOp: foldConst := consIntConst(val1.i div val2.i);
                    modOp: foldConst := consIntConst(val1.i mod val2.i);
                    ltOp: foldConst := boolExp[val1.i < val2.i];
                    eqOp: foldConst := boolExp[eq(val1,val2)]
                    end
                end {foldConst};



            function compare(x1,x2: expression): expression;
                {compare two expressions for equality,
                  recursively descending their structures.
                  may return a truth value or a simpler expression.}
                begin
                if x1=x2 then   compare := boolExp[true]
                else if x1^.kind=x2^.kind then
                    if x1^.kind = constant
                    then        compare := boolExp[eq(x1^.v, x2^.v)]
                    else if x1^.kind = inject then
                        if x1^.si = x2^.si
                        then    compare := compare(x1^.exp, x2^.exp)
                        else    compare := boolExp[false]
                    else if x1^.kind = pair
                    then        compare := foldCond(compare(x1^.l, x2^.l),
                                                     compare(x1^.r, x2^.r),
                                                     boolExp[false])
                    else        compare := consBinOp(eqOp,x1,x2)
                else            compare := consBinOp(eqOp,x1,x2)
                end {compare};

            begin
            if (b1=errorExp) or (b2=errorExp)  then simpBinOp := errorExp
            else if (b1=botExp) or (b2=botExp) then simpBinOp := botExp
            else if (b1^.kind=constant) and (b2^.kind=constant)
            then   simpBinOp := foldConst(bop, b1^.v, b2^.v)
            else if (b1^.kind=cond) and (b2^.kind=constant)
            then simpBinOp :=
                simpCond(b1^.ifx,
                          simpBinOp(bop,b1^.thenx,b2),
                          simpBinOp(bop,b1^.elsex,b2))
            else if (b1^.free=0) and (b2^.free=0)
            then simpBinOp := compare(b1,b2)
            else simpBinOp := consBinOp(bop,b1,b2)
            end {simpBinOp};



        function simpInject(si: selIndex; exp: expression): expression;
            begin
            if (exp^.kind = project) and (si = exp^.si)
            then simpInject := exp^.exp
            else simpInject := consInject(si,exp)
            end {simpInject};



        function simpProject
            (si: selIndex; silent: boolean; exp: expression): expression;
            begin
            if exp^.kind = inject then
                if si = exp^.si then    simpProject := exp^.exp
                else if silent then     simpProject := errorExp
                else                    simpProject := botExp
            else if improper(exp) then  simpProject := exp
            else                        simpProject
                := consProject(si,silent,exp)
            end {simpProject};



        function simpIsExp(si: selIndex; exp: expression): expression;
            begin
            if exp^.kind = inject then simpIsExp := boolExp[si = exp^.si]
            else if improper(exp) then simpIsExp := exp
            else simpIsExp := consIsExp(si,exp)
            end {simpIsExp};



        function simpVar: expression;
            var argNo: integer;
                {simplify variable:  possibly substitute args or renumber}
            begin
            argNo := x^.depth - bVarDepth;
            if argNo >= 0 then  {free variable}
                if argNo < argCount
                then simpVar := renumber(bVarDepth,selectArg(args,argNo))
                else simpVar := consVar(x^.depth + offset)
            else     simpVar := x
            end {simpVar};

        begin
        simpx := nil;
        while x^.kind = linkNode do x := x^.link;
        if not simpDesired then
            if x^.kind <> namedExp then
                if x^.free=0 then simpx := x
                else if substTrivial
                then if (x^.free=substIndex) or (offset=0)
                     then simpx := x;
        if simpx = nil then begin
            accessCount := 0;
            while (x^.kind=unOp) and (x^.uop in [leftOp,rightOp]) do
                begin
                accessCount := accessCount+1;
                left[accessCount] := x^.uop = leftOp;
                x := x^.u1
                end;
            with x^ do
                case kind of
                    namedExp:
                        if (di <= recurCount) or (def[di].value = nil)
                        then    simpx := x
                        else    simpx := def[di].value;
                    sharedNode,
                    constant:   simpx := x;
                    variable:   simpx := simpVar;
                    fixExp:    simpx := simpFix(bv,simpDeeper(body));
                    lambdaExp: simpx := consLambda(bv,simpDeeper(body));
                    applic:     simpx := simpApplic(x);
                    cond:       simpx := foldCond(simp(ifx),thenx,elsex);
                    caseExp:   simpx := simpCase(simp(index),cases);
                    pair:       simpx := consPair(simp(l), simp(r));
                    unOp:      simpx := simpUnOp(uop, simp(u1));
                    binOp:     simpx := simpBinOp(bop,simp(b1),simp(b2));
                    alterExp:  simpx :=
                        consAlter(simp(t1),simp(t2),simp(t3));
                    inject:     simpx := simpInject(si, simp(exp));
                    project:    simpx := simpProject(si, silent, simp(exp));
                    isExp:     simpx := simpIsExp(si, simp(exp))
                    end {case};
            {put left and right back onto simplified result}
            while accessCount <> 0 do begin
                if simpx^.kind = pair then begin     {cancel:  left(l,r) -> l}
                    if left[accessCount] then simpx := simpx^.l
                    else simpx := simpx^.r
		    end
                else	{ignore bottom, since left bot -> bot}
                    if not improper(simpx) then begin 
                        if left[accessCount]
                        then simpx := consUnOp(leftOp,simpx)
                        else simpx := consUnOp(rightOp,simpx)
		    	end;
                accessCount := accessCount - 1
                end
            end;
        simp := simpx
        end {simp};



    function simpDeeper {(x: expression): expression} ;
        begin
        bVarDepth := bVarDepth+1; simpDeeper := simp(x);
        bVarDepth := bVarDepth-1
        end {simpDeeper};

    begin
    simpDesired := (args=nil) and (offset=0);
    checkTrivial;
    bVarDepth := 0; simpDepth := simp(x)
    end {simpDepth};


    procedure heading(var f: text);
        var  datetxt,timetxt: packed array[1..10] of char;
        begin
        date(datetxt);
	time(timetxt);
        page(f);
        writeln(f, 'from file  ', listFileName, '  on  ',datetxt,'  ',timetxt)
        end {heading};



procedure pointError(var f: text; col: integer);
    {point at an error in the desired column of the current line}
    var i,c: integer;
    begin
    c := 0;          {space skipped by tabs}
    for i := 1 to col-1 do
        if line.buf[i] = chr(tabChar) then c := 8* (1 + c div 8)
        else c := c+1;
    if c > 0 then write(f, ' ': c);
    writeln(f, '^')
    end;



procedure lexError(ek: errorKind);
    begin
    lexErrs := true;
    with line do begin
        writeln(output,'lexical error in line ', count:1);
        writeln(output,prev: prevLen);
        writeln(output,buf: len);
        pointError(output, col-1);
        case ek of
            lineTooLong: writeln(output, 'line longer than ', maxLineLen:1,
                                   ' characters');
            nameTooLong: writeln(output, 'name longer than ', alfaleng:1,
                                   ' characters');
            eofInComment: writeln(output, 'end of file in comment');
            illChar: writeln(output, 'illegal character');
            illToken: writeln(output, 'no such symbol in language')
            end
        end
    end {lexError};




procedure readLine;
    {read another source line}
    begin
    endOfFile := eof(source);
    with line do begin
        prev := buf;  prevLen := len;  count := count+1;
        buf :=
        '                                                                                ';
        col := 1;
        if eof(source) then len := maxLineLen
        else begin
            len := 1;
            while not eoln(source) and not eof(source) do begin
                if len <= maxLineLen then buf[len] := source^;
                get(source); len := len+1
                end;
            readln(source);
            if len > maxLineLen then begin
                len := maxLineLen;
                lexError(lineTooLong)
                end
            end
        end;
    {line.len is one greater than actual input line}
    end {readLine};



procedure nextChar;
    {read the next character from the line buffer}
    {MACHINE DEPENDENT -- assumes ascii character set}
    begin
    if line.col > line.len then readLine;
    ch := line.buf[line.col]; line.col := line.col+1;
    if ord(ch) = tabChar then ch := ' '        {change tabs to blanks}
    else if ('A' <= ch) and (ch <= 'Z') then    {translate to lower case}
        ch := chr(ord(ch) + ord('a') - ord('A'))
    else if ch < ' ' then begin lexError(illChar); ch := ' ' end
    end {nextChar};



procedure skipLine;
    {skip the rest of the line (for comment processing)}
    begin line.col := line.len+1; nextChar end {skipLine};



procedure nextSy;
    {seperates and identifies tokens from the source}
    var
        length,                 {length of current token}
        int: integer;           {value of integer constant}
        name: alfa;             {characters in token}
        ti: integer;            {index of current token}

        {for delimeter scanning:}
        lastTi: termIndex;    {previous terminal}
        wentPast: boolean;     {scanned too many characters}

    begin
    repeat
        while (ch = ' ') and not endOfFile do nextChar;
        if ch = '{' then begin          {bracketed comment}
            repeat nextChar until (ch = '}') or endOfFile;
            if ch='}' then nextChar
            else lexError(eofInComment)
            end;
        while ch = '#' do skipLine     {end-of-line comment}
    until endOfFile or not (ch in [' ', '#', '{']);
    ti := 0;  token.val := nil;
    name := '               ';
    case ch of
        ' ': ti := eofTerm;             {end of file returns blanks}
        'a','b','c','d','e','f','g','h','i',
        'j','k','l','m','n','o','p','q','r',
        's','t','u','v','w','x','y',
        'z': begin  {identifiers or reserved words}
            length := 0;
            repeat
                length := length+1;
                if length <= alfaleng then name[length] := ch;
                nextChar
            until not (ch in ['a'..'z','0'..'9','_']);
            if length > alfaleng then lexError(nameTooLong);
            lookup(name, ti);
            if ti = 0 then begin   {not a reserved word, must be identifier}
                ti := nameTerm;
                token.val := consStringConst(name)
                end
            end;
        '0','1','2','3','4','5','6','7','8',
        '9':
            begin       {integer constant:  compute its value}
            int := 0;
            repeat
                int := 10*int + ord(ch) - ord('0');
                nextChar
            until not (ch in ['0'..'9']);
            token.val := consIntConst(int);
            ti := numberTerm
            end;
        '!','@','#','%','$','^','&','*','(',')','-','=','+',
        '[',']','\',';',':','"',',','.','/','<','>','?',
        '''':  {delimeter: scan as many chars as needed but don't scan
                 past a known symbol to an unknown one}
            begin
            length := 0;
            repeat
                if length <> 0 then nextChar;
                lastTi := ti;          {symbol scanned so far}
                length := length+1;
                name[length] := ch;
                lookup(name, ti);
                wentPast := (ti = 0) and (lastTi <> 0)
            until wentPast or not (ch in delims);
            if wentPast then ti := lastTi     {backtrack one char}
            else begin
                nextChar;
                if ti = 0 then begin lexError(illToken);  ti := eofTerm end
                end
            end
    end;
    curLoc.line := line.count;  curLoc.col := line.col-2;
    token.ti := ti;
    tokenCount := tokenCount+1
    end {nextSy};



procedure initNextSy;
    {initiate lexical analysis}
    begin
    delims := ['!','@','#','%','$','^','&','*','(',')','-','=','+',
               '[',']','\',';',':','"',',','.','/','<','>','?',
               ''''];
    with line do begin
        count := 0; prevLen := 0; col := 1; len := 0
        end;
    tokenCount := 0;
    nextChar; nextSy
    end {initNextSy};



procedure initGc;
    var ek: expKind;
    begin
    writeln(listing, '**initializing garbage collection statistics.');
    usedList := nil;
    usedCount := 0;  maxUsed := 0;  totalFreed := 0;
    for ek := unusedExp to isExp do expCount[ek] := 0
    end {initGc};



procedure printExpCount;
    var ek: expKind;
        expAlfa: array [expKind] of alfa;
    begin
    expAlfa[unusedExp] :=      'unusedExp      ';
    expAlfa[dagNode] :=        'dagNode        ';
    expAlfa[linkNode] :=       'linkNode       ';
    expAlfa[sharedNode] :=     'sharedNode     ';
    expAlfa[namedExp] :=       'namedExp       ';
    expAlfa[variable] :=       'variable       ';
    expAlfa[constant] :=       'constant       ';
    expAlfa[fixExp] :=         'fixExp         ';
    expAlfa[lambdaExp] :=      'lambdaExp      ';
    expAlfa[applic] :=         'applic         ';
    expAlfa[cond] :=           'cond           ';
    expAlfa[caseExp] :=        'caseExp        ';
    expAlfa[pair] :=           'pair           ';
    expAlfa[unOp] :=           'unOp           ';
    expAlfa[binOp] :=          'binOp          ';
    expAlfa[alterExp] :=       'alterExp       ';
    expAlfa[inject] :=         'inject         ';
    expAlfa[project] :=        'project        ';
    expAlfa[isExp] :=          'isExp          ';
    maxUsed := max(maxUsed, usedCount);
    writeln(listing);  writeln(listing,'kind          used');
    for ek := unusedExp to isExp do
        if expCount[ek]<>0 then
            writeln(listing, expAlfa[ek]:12, expCount[ek]:6, '    ',
                    ' ********************':
                    trunc(1.5 + 20*expCount[ek] / usedCount));
    writeln(listing);  writeln(listing,'total     ', usedCount:8);
    writeln(listing, 'max nodes used at any time: ', maxUsed:1);
    writeln(listing, 'total freed by garbage collection: ', totalFreed:1)
    end {printExpCount};



procedure parse;
    {parse the source program and produce its semantic dag.  this shift-reduce
      lr parser is augmented with the attribute grammar evaluator described in
      o. l. madsen, "on defining semantics by means of extended attribute
      grammars", in niel jones, "semantics-directed compiler generation",
      springer-verlag, 1980.}

    type
        parserState = integer;
        parseActions = (errAct,shift,reduce,accept);

    var

        {parse stack}
        syntaxTop: integer;
        syntax: array[0..maxParseStack] of
        packed record
                   syn,inh: integer;       {stack tops for synth and inher}
                   loc: lineCol;          {location of symbol at this state}
                   st: parserState        {state}
               end;


        {stack of synthesized attributes-- dags}
        synthTop: integer;
        synth: array [1..maxParseStack] of expression;


        {stack of inherited attributes-- fixup lists}
        inherTop: integer;
        inher: array [1..maxParseStack] of expression;


        state: parserState;    {current state on top of stack}
        act: parseActions;     {current action based on state and lookahead}



    procedure initParser;
        begin
        dagArgCount := 0;  errorCount := 0;
        constraints := nil;
        syntaxTop := 0;  synthTop := 0;  inherTop := 0
        end {initParser};



    procedure pushSyntax(s: parserState; lc: lineCol);
        begin
        syntaxTop := syntaxTop+1;
        with syntax[syntaxTop] do begin
            loc := lc;  st := s;  syn := synthTop; inh := inherTop
            end
        end {pushSyntax};



    function action(kernel: parserState; t: termIndex): parseActions;
        {extract an action from the parse table.  elements two bits each,
          packed 4 per byte: 00112233.  t is the terminal index.}
        var row,byte: integer;
        begin
        with table do begin
            row := action.map[kernel];
            byte := elem[action.base + row * action.rowWidth + t div 4];
            end;
        case t mod 4 of
            0:  byte := byte div 64;
            1:  byte := byte div 16;
            2:  byte := byte div 4;
            3:  {do nothing}
        end;
        case byte mod 4 of
            0: action := errAct;
            1: action := shift;
            2: action := reduce;
            3: action := accept
            end {case}
        end {action};



    function tnext(kernel: parserState; t: termIndex): integer;
        {look up into terminal goto table--nextstate (shift), ruleno (reduce)}
        var row: integer;
        begin
        with table do begin
            row := term.map[kernel];
            tnext := elem[term.base + row * term.rowWidth + t - 1]
            end
        end {tnext};



    function nnext(kernel: parserState; r: integer): parserState;
        {index into nonterminal goto table using lhs of rule r}
        var lhs,row: integer;
        begin
        with table do begin
            lhs := rule[r].lhs;
            row := nonterm.map[kernel];
            nnext := elem[nonterm.base + row * nonterm.rowWidth + lhs - 1]
            end
        end {nnext};



    procedure doReduce;
        {execute a reduce action.  build dag.}

        var ruleNo: integer;                   {rule causing reduction}
            topLoc: lineCol;                  {lineCol of stack top}
            lhs: nontermIndex;                 {symbol being rewritten}

            {attributes of the lhs nonterminal}
            nPseudo,
            nInh,nSyn: integer;               {number of attributes}
            pseudo,
            leftInher,leftSynth: array [1..20] of expression;

            newTop: integer;           {top stack element below handle}
            i: integer;


            {machine dependent hack to convert between pointers and integers
              needed so dagArg can store both expressions and indexes}
            expDirt: record case boolean of
                                  true:  (x: expression);
                                  false: (i: integer)
                      end;


            {currently, pseudo-attributes are represented the same as
              synthesized attributes: as dags.  they could instead be
              represented the same as inherited attributes: as fixup-lists.
              this would allow pseudo-attributes to depend on each other,
              even circularly, but would make the dag about 10% bigger.}


        function expToInt(x: expression): integer;
            {obtain the integer value of the pointer x}
            begin
            expDirt.x := x;  expToInt := expDirt.i
            end {expToInt};



        function intToExp(i: integer): expression;
            {convert an integer value into a pointer}
            begin
            expDirt.i := i;  intToExp := expDirt.x
            end {intToExp};



        function copySem(sem: semanList): expression;
            {link the semantic function 'sem' with the attributes it needs.
              creates a new dag node unless 'sem' is the identity operation.}
            var al: attrList;  oldDac,idx: integer;



            function genUnique: expression;
                {generate a unique name for the pseudo-nonterm 'uniquename'}
                var name: alfa;  u,i: integer;
                begin
                uniqueNum := uniqueNum+1;
                name := '$              ';
                u := uniqueNum;
                for i := 7 downto 2 do begin
                    name[i] := chr(ord('0') + u mod 10);
                    u := u div 10
                    end;
                genUnique := consStringConst(name)
                end {genUnique};



            procedure addArg(a: attrList);
                {add an argument to the dag node being built}
                var arg: expression;
                begin
                case a^.atKind of
                    lhsAttr:
                        begin
                        {link into the fixup list}
                        arg := leftInher[a^.offset];
                        leftInher[a^.offset] := intToExp(dagArgCount+1)
                        end;
                    rhsAttr:
                        begin
                        arg := synth[syntax[newTop].syn + a^.offset];
                        incRefs(arg)
                        end;
                    pseudoAttr:
                        begin
                        arg := pseudo[a^.offset];
                        incRefs(arg)
                        end
                    end {case};
                dagArgCount := dagArgCount+1;
                dagArg[dagArgCount] := arg
                end {addArg};

            begin
            with sem^ do begin
                if attrs = nil then     {no dependence on attributes}
                    if (fn^.kind = namedExp) and (fn^.di = defUname)
                    then copySem := genUnique
                    else copySem := fn
                else if (fn = preVar[0])       {simple copy of an attribute}
                    and (attrs^.atKind <> lhsAttr) then
                    if attrs^.atKind = rhsAttr
                    then copySem := synth[syntax[newTop].syn + attrs^.offset]
                    else copySem := pseudo[attrs^.offset]
                else begin
                    {create new dag node}
                    oldDac := dagArgCount;
                    al := attrs;    {get the attributes it needs}
                    while al<>nil do begin addArg(al);  al := al^.next end;
                    {find out which grammar symbol contains these semantics
                      and note line/column of program producing this}
                    if pos = 0 then idx := syntaxTop
                    else idx := newTop + pos;
                    copySem := consDagNode(sem, oldDac+1, syntax[idx].loc)
                    end
                end
            end {copySem};



        procedure patchDag(xl: expression;  s: semanList);
            {patch the inherited attribute fixup list (xl) with 's'.
              if s is just another inherited attribute, then combine
              'xl' with the list for that attribute.  otherwise, expand x
              and put the result into every element of 'xl'.
              fixuplists are stored in 'dagArg'; each cell hold the index
              of its successor in the list.  since 'dagArg' officially
              holds pointers, we need machine-dependent conversion functions
              to store integer indexes there.}

            var next,css: expression;   xli: integer;



            procedure combine(var fixup: expression);
                {put xl onto the front of fixup, eliminating xl.}
                var xli: integer;  next: expression;
                begin
                while xl<>nil do begin
                    xli := expToInt(xl);
                    next := dagArg[xli];
                    dagArg[xli] := fixup;
                    fixup := xl;
                    xl := next
                    end
                end {combine};

            begin
            with s^ do
                if fn = preVar[0] then
                    if attrs^.atKind = lhsAttr then
                        combine(leftInher[attrs^.offset]);
            if xl<> nil then begin
                css := copySem(s);     {expand out the attribute}
                while xl<>nil do begin  {patch it into the fixup list}
                    xli := expToInt(xl);
                    next := dagArg[xli];       {really an integer}
                    dagArg[xli] := css;        {a valid pointer}
                    incRefs(css);
                    xl := next
                    end
                end
            end {patchDag};



        procedure evalAttrs;
            {evaluate attributes and constraints for rule}
            var i: integer;  attr,con: semanList;
            begin
            {create empty fixup lists for lhs inherited attributes (defined)}
            nInh := nonterm[lhs].nInh;
            for i := 1 to nInh do leftInher[i] := nil;
            nPseudo := rule[ruleNo].nPseudo;
            {now compute pseudo attributes}
            attr := rule[ruleNo].pseudos;
            for i := nPseudo downto 1 do begin
                pseudo[i] := copySem(attr);
                attr := attr^.next
                end;
            assert(attr=nil);
            {accumulate constraints}
            con := rule[ruleNo].constraints;
            while con<>nil do begin
                constraints := consExpList(copySem(con), constraints);
                con := con^.next
                end;
            {copy rhs inherited attributes (applied) into dag}
            attr := rule[ruleNo].attrs;
            for i := inherTop downto syntax[newTop].inh+1 do begin
                patchDag(inher[i], attr);
                attr := attr^.next
                end;
            {compute lhs synthesized attributes (applied)}
            nSyn := nonterm[lhs].nSyn;
            for i := nSyn downto 1 do begin
                leftSynth[i] := copySem(attr);
                attr := attr^.next
                end;
            assert(attr=nil)
            end {evalAttrs};

        begin
        ruleNo := tnext(state,token.ti);
        lhs := rule[ruleNo].lhs;
        newTop := syntaxTop - rule[ruleNo].length;
        evalAttrs;
        {pop rhs entries from both attribute stacks}
        inherTop := syntax[newTop].inh;
        synthTop := syntax[newTop].syn;
        {push lhs attributes onto stacks}
        for i := 1 to nInh do begin
            inherTop := inherTop+1;  inher[inherTop] := leftInher[i]
            end;
        for i := 1 to nSyn do begin
            synthTop := synthTop+1;  synth[synthTop] := leftSynth[i]
            end;
        topLoc := syntax[syntaxTop].loc;
        syntaxTop := newTop;
        pushSyntax(nnext(syntax[syntaxTop].st,ruleNo), topLoc)
        end {doReduce};



    procedure flagError(var f: text; k: parserState);
        {reports a syntax error in the program}
        var t: termIndex;
        begin
        with line do begin
            writeln(f,'syntax error in line ', count:1);
            writeln(f, prev: prevLen);  writeln(f, buf: len);
            pointError(f, curLoc.col)
            end;
        writeln(f,'expected one of: ');
        for t := 1 to termCount do
            if action(k,t) <> errAct then
                writeln(f, tokenIndex[t]^.name);
        writeln(f, 'parser state ', k:1)
        end {flagError};

    begin
    initParser; initNextSy; pushSyntax(1,curLoc);
    repeat
        state := syntax[syntaxTop].st;
        act := action(state,token.ti);
        case act of
            errAct:
                begin
                dag := nil;
                flagError(output,state); flagError(listing,state)
                end;
            shift:
                begin
                if token.val<>nil then begin
                    {push semantics of names and numbers}
                    synthTop := synthTop+1;
                    synth[synthTop] := token.val
                    end;
                pushSyntax(tnext(state,token.ti), curLoc);
                nextSy
                end;
            reduce: doReduce;
            accept:
                begin
                heading(listing);
                writeln(listing,'program parsed.  ', tokenCount:1, ' tokens');
                writeln(output,'program parsed.');
                if synthTop = 0 then dag := nil  {start symbol has no attrs}
                else dag := synth[synthTop];
                incRefs(dag);
                garbageCollect;
                printExpCount;
                writeln(listing, 'dag arguments: ', dagArgCount:1)
                end
            end {case}
    until act in [errAct,accept];
    rtime.parse := clock
    end {parse};



procedure initialize;



    procedure openFiles;
        {read in a program name of the form prog.lang
          and open the files prog.lang, prog.lst, prog.obj, and lang.ldf}
        var line,prog,lang,objProg: alfa;
            progLen,langLen,lineLen,i: integer;
            ext: packed array [1..4] of char;
        begin
        writeln(output, 'Universal Translator'); writeln(output);
        write(output, 'program: ');
        prog := '               ';
        lang := '               ';
        line := '               ';
	lineLen := 0;
	while not eoln(input) do
	    begin  lineLen := lineLen+1;  read(input, line[lineLen])  end;
        {extract program name}
        i := 1;
        while not (line[i] in ['.',' ']) do
            begin prog[i] := line[i]; i := i+1 end;
        progLen := i-1;
        {extract language name}
        i := i+1; langLen := 0;
        while line[i]<> ' ' do begin
            langLen := langLen+1;
            lang[langLen] := line[i];
            i := i+1
            end;
        {form file name prog.lst}
        ext := '.lst';
        for i := 1 to 4 do prog[progLen+i] := ext[i];
        {form file name prog.cod}
        objProg := prog;
        ext := '.obj';
        for i := 1 to 4 do objProg[progLen+i] := ext[i];
        {form file name lang.ldf}
        ext := '.ldf';
        for i := 1 to 4 do lang[langLen+i] := ext[i];
        listFileName := prog;  objectFileName := objProg;
        reset(source,line);  reset(ldf,lang);  rewrite(listing,prog);
        rewrite(object,objProg);
        heading(listing)
        end {openFiles};



    procedure initOpAlfa;
        begin
        opAlfa[leftOp]    := 'left           ';
        opAlfa[rightOp]   := 'right          ';
        opAlfa[notOp]     := 'not            ';
        opAlfa[plusOp]    := '+              ';
        opAlfa[minusOp]   := '-              ';
        opAlfa[timesOp]   := '*              ';
        opAlfa[divOp]     := 'div            ';
        opAlfa[modOp]     := 'mod            ';
        opAlfa[ltOp]      := 'lt             ';
        opAlfa[eqOp]      := 'eq             ';
        end {initOpAlfa};



    procedure makePredefined;
        {create the predefined expressions prevent the creation of multiple
          copies of common constants, variables, etc.}
        var i: integer;
        begin
        {indicate that tables are not initialized yet}
        preVarCount := -1;
        for i := 0 to varTableLimit do preVar[i] := consVar(i);
        {indicate that tables are initialized}
        preVarCount := varTableLimit;
        errorExp := consConst(bot);   botExp := consConst(bot);
        boolExp[false] := consConst(bool);  boolExp[false]^.v.b := false;
        boolExp[true] := consConst(bool);  boolExp[true]^.v.b := true;
        initGc            {protect predefined expressions from gc}
        end {makePredefined};



    procedure initStrings;
        var i: integer;
        begin
        stringCount := 0;
        for i := 0 to maxStrings do stringTable[i] := nil
        end {initStrings};

    begin
    uniqueNum := 0;  lexErrs := false;
    openFiles;
    freeExpList := nil; freeCaseList := nil; freeList := nil;
    initGc;  makePredefined;  initStrings;
    initOpAlfa
    end {initialize};



procedure readSeman;
    {read in tables from semantic file}
    var i,len: integer;  stringSet: set of xKind;
        xop: array [xKind] of operator;

        {inverse of ord for attrKind}
        atKind: array [-5..10] of attrKind;
        firstTime: boolean;            {for readShortInt}
        dummyBv: boundVar;            {dummy bv for abstract}


    procedure readShortInt(var int: integer);
        {read short integers packed two per file element to save space}
        begin
        assert(ldf^.kind=int2X);
        if firstTime then int := ldf^.int1
        else begin int := ldf^.int2; get(ldf) end;
        firstTime := not firstTime
        end {readShortInt};



    procedure beginShort;
        {initiate reading of short integers}
        begin firstTime := true end;



    procedure endShort;
        {terminate reading of short integers}
        begin if not firstTime then get(ldf)
        end;



    procedure readInt(var int: integer);
        {read an integer from seman}
        begin
        assert(ldf^.kind = intX);
        int := ldf^.int; get(ldf)
        end {readInt};



    procedure readInt2(var int1,int2: integer);
        begin
        assert(ldf^.kind = int2X);
        int1 := ldf^.int1;  int2 := ldf^.int2; get(ldf)
        end {readInt2};



    procedure readString(var name: alfa);
        var s: array [1..30] of char;   {2 times alfaleng}
            i,j: integer;
        begin
        i := 0;
        repeat
            i := i+4;
            assert(ldf^.kind in stringSet);
            s[i-3] := ldf^.ch1;
            s[i-2] := ldf^.ch2;
            s[i-1] := ldf^.ch3;
            s[i]   := ldf^.ch4;
            get(ldf)
        until s[i]=' ';
        name := '               ';
        if i>alfaleng then i := alfaleng;
        for j := 1 to i do name[j] := s[j]
        end {readString};



    procedure readExp(var x: expression; var dom: integer);
        {read and simplify an expression from the input file.
          encoding is postfix, terminated by the token 'stopX',
          followed by the domain index of the expression.}

        const stackMax = 50;
        var stack: array [1..stackMax] of expression;
            s: 0..stackMax;
            bv: boundVar;  x1,x2,x3: expression;
            cases: caseList;  initial: xKind;   len: integer;
            name: alfa;



        procedure push(x: expression);
            begin s := s+1; stack[s] := x end;



        procedure pop(var x: expression);
            begin x := stack[s]; s := s-1 end;



        procedure readCases(nc,firstSi: integer; var cases: caseList);
            {given number of cases and first si, read a list of cases}
            var si: integer; x: expression;
            begin
            cases := nil;
            si := firstSi + nc - 1;    {last si}
            while si >= firstSi do begin
                pop(x); assert(x^.kind = lambdaExp);
                cases := consCaseList(si,x^.bv,x^.body,cases);
                si := si-1
                end
            end {readCases};



        function foldPair(l,r: expression): expression;
            var ans,ll,rr: expression;  changed: boolean;
                {simplify  (left a, right a)  ->   a
                  where 'a' is a variable or attribute prefixed by
                  lefts and rights}
            begin
            ans := nil;
            if (l^.kind = unOp) and (l^.uop = leftOp)
                and (r^.kind = unOp) and (r^.uop = rightOp) then
                begin
                ll := l^.u1;  rr := r^.u1;
                repeat
                    changed := false;
                    while (ll^.kind = unOp) and (rr^.kind = unOp)
                    and (ll^.uop = rr^.uop) do begin
                        ll := ll^.u1;  rr := rr^.u1; changed := true
                        end;
                    while (ll^.kind = project) and (rr^.kind = project)
                    and (ll^.si = rr^.si) do begin
                        ll := ll^.exp;  rr := rr^.exp; changed := true
                        end
                until not changed;
                {identical variable or attribute?}
                if ll = rr then ans := l^.u1
                end;
            if ans=nil then foldPair := consPair(l,r)
            else foldPair := ans
            end {foldPair};



        function abstract(x: expression): expression;
            {convert a tuple of functions into a function of abstractions:
              every function is given the form \x.f x
              needed to make the body of fix into a lambda-abstraction}
            begin
            if x^.kind = pair then
                abstract := consPair(abstract(x^.l), abstract(x^.r))
            else if x^.kind = lambdaExp then abstract := x
            else abstract :=
                consLambda(dummyBv, consApplic(renumber(1,x), preVar[0]))
            end {abstract};

        begin
        s := 0;
        while ldf^.kind <> stopX do
            with ldf^ do begin
                initial := kind;
                case kind of
                    namedX: push(consNExp(int));
                    varX: push(consVar(int));
                    fixX,lambdaX,propX:
                        begin
                        bv.propagate := kind = propX;
                        new(bv.name);
                        readString(bv.name^); makeLc(bv.name^,len);
                        pop(x1);
                        if initial=fixX
                        then push(consFix(bv,abstract(x1)))
                        else push(consLambda(bv,x1))
                        end;
                    caseX:
                        begin
                        pop(x1); readCases(int1,int2,cases);
                        push(consCase(x1,cases))
                        end;
                    injX: begin pop(x1); push(consInject(int,x1)) end;
                    projX:
                        begin
                        pop(x1);
                        push(consProject(int1, int2=ord(true), x1))
                        end;
                    isX: begin pop(x1); push(consIsExp(int,x1)) end;
                    stringX:
                        begin
                        readString(name);
                        push(consStringConst(name))
                        end;
                    intX: push(consIntConst(int));
                    boolX: push(boolExp[int = ord(true)]);
                    botX: push(botExp);
                    leftX,rightX,notX:
                        begin pop(x1); push(consUnOp(xop[kind],x1)) end;
                    plusX,minusX,timesX,divX,modX,ltX,eqX:
                        begin pop(x2); pop(x1);
                        push(consBinOp(xop[kind],x1,x2)) end;
                    applicX:
                        begin pop(x2); pop(x1); push(consApplic(x1,x2)) end;
                    pairX:
                        begin pop(x2); pop(x1); push(foldPair(x1,x2)) end;
                    condX:
                        begin pop(x3); pop(x2); pop(x1);
                        push(consCond(x1,x2,x3)) end;
                    alterX:
                        begin pop(x3); pop(x2); pop(x1);
                        push(consAlter(x1,x2,x3)) end;
                    nilX: push(nil);
                    int2X,stopX: assert(false)
                    end {case};
                if not (initial in stringSet) then get(ldf)
                end {while};
        pop(x); assert(s=0);
        x := simplify(x);
        get(ldf);
        readInt(dom)
        end {readExp};



    procedure readRules;
        {read semantic and syntactic info about rules from input file}
        var i,r,n: integer;

            {data from unsorted rules to be put into sorted table}
            attrs,              {applied attribute expressions}
            pseudos,            {pseudo-attributes}
            cons:               {constraints}
            array [1..maxRules] of semanList;

            {number of pseudo-attributes of each rule}
            nPseudo:   array [1..maxRules] of integer;



        procedure readSemanList(var n: integer; var l: semanList);
            {read a list of semantic expressions from the file into 'l';
              return its length in 'n';
              read the domain, attributes, etc. of each expression}

            var i: integer;
                x: expression;          {semantic expression}
                attrs: attrList;       {attributes it references}
                attrCnt,               {count of attributes}
                dom,                    {domain of expression}
                pos,                    {position of semantics in rule}
                nt: integer;            {nonterminal containing semantics}
            begin
            readInt(n); l := nil;
            for i := 1 to n do begin
                readExp(x,dom);
                attrCnt := 0;  attrs := nil;
                while ldf^.kind = attrX do begin
                    attrs := consAtList
                    (atKind[ldf^.int1], ldf^.int2, attrs);
                    attrCnt := attrCnt+1;
                    get(ldf)
                    end;
                readInt2(pos,nt);
                l := consSemanList(x,dom,nt,pos,attrCnt,attrs,l)
                end
            end {readSemanList};

        begin
        i := 1;
        {rule 1 (before sorting) is goal rule}
        attrs[1] := nil; cons[1] := nil; nPseudo[1] := 0;
        {get semantic info; rule are unsorted}
        while ldf^.kind<>stopX do begin
            i := i+1;
            readSemanList(n,attrs[i]);
            readSemanList(nPseudo[i], pseudos[i]);
            readSemanList(n,cons[i])
            end;
        get(ldf);             {skip over the stop}
        readInt(ruleCount);  assert(ruleCount=i);
        beginShort;
        {get syntactic info; rules are sorted}
        for r := 1 to ruleCount do begin
            readShortInt(rule[r].length);
            readShortInt(i);
            rule[r].attrs := attrs[i];
            rule[r].pseudos := pseudos[i];
            rule[r].constraints := cons[i];
            rule[r].nPseudo := nPseudo[i];
            readShortInt(rule[r].lhs)
            end;
        endShort
        end {readRules};



    procedure readParseTable(var tab: parseTable);
        {read a parse table from the input file}
        var i,size,k,barf: integer;
        begin
        readInt2(tab.rowWidth, tab.rowCount);
        beginShort;
        for k := 1 to kernelCount do begin
            readShortInt(barf);  tab.map[k] := barf
            end;
        size := tab.rowWidth * tab.rowCount;
        tab.base := table.elemCount;
        for i := table.elemCount to table.elemCount+size-1 do begin
            readShortInt(barf); table.elem[i] := barf
            end;
        table.elemCount := table.elemCount + size;
        endShort
        end {readParseTable};



    procedure readTerminals;
        {initialize the hash table with the terminals of the grammar}
        var  name: alfa;  t: termIndex;      i: integer;
        begin
        for i := 0 to hashLimit do termTable[i] := nil;
        readInt(termCount);
        for t := 1 to termCount do begin
            readString(name);
            linkEntry(name, t, tokenIndex[t])
            end
        end {readTerminals};



    procedure readDefs;
        {read expression definitions from file.}
        var  i,dom: integer;
        begin
        readInt(recurCount);  readInt(defCount);
        {initialize definition table to nil to catch forward references}
        {otherwise, simplifier would process garbage}
        for i := 1 to defCount do def[i].value := nil;
        for i := 1 to defCount do
            with def[i] do begin
                readString(name);
                readExp(value,dom);
                incRefs(value)
                end;
        if defsListing then   {list definitions}
            for i := 1 to defCount do
                with def[i] do begin
                    makeLc(name,len);
                    write(listing,'(', i:1, ') ', name:len, '=');
                    printExp(listing,value,nil); 
                    end
        end {readDefs};



    procedure init;
        var k: xKind;  op: operator;   a: attrKind;
        begin
        reset(ldf);
        {set up dummy bound variable}
        new(dummyBv.name);  dummyBv.name^ := 'x              ';
        dummyBv.propagate := false;
        {set up machine dependent integer->attrKind mapping}
        for a := lhsAttr to pseudoAttr do atKind[ord(a)] := a;
        {set up xKind->operator mapping}
        k := pred(leftX);
        for op := leftOp to eqOp do begin k := succ(k); xop[k] := op end;
        stringSet := [stringX,lambdaX,propX,fixX]
        end {init};

    begin
    init;
    readInt(domCount);
    for i := 1 to domCount do readString(domn[i]);
    readInt(selectCount);
    for i := 1 to selectCount do readString(selector[i]);
    readDefs;
    readInt(nontermCount);
    for i := 1 to nontermCount do
        with nonterm[i] do
            begin readString(name); readInt2(nInh,nSyn) end;
    readRules;
    readInt(kernelCount);
    table.elemCount := 0;
    readParseTable(table.action);
    readParseTable(table.term);
    readParseTable(table.nonterm);
    readTerminals;
    garbageCollect;
    printExpCount;            {size of semantic information}
    tableSize := usedCount;   {record the size}
    initGc;                    {protect semantic expressions from gc}
    writeln(output, 'tables read.');
    rtime.init := clock
    end {readSeman};



procedure processSemantics(var dag: expression);
    {process and print dag, etc.}
    var oldag: expression;
        lastUsed: integer;




    function expandDag(x: expression; con: boolean): expression;
        {expand dag nodes into attribute expressions, filling in arguments.
          if 'con' is true, then this part of the dag is a constraint.
          record semantic errors found in dag.}
        var args: expList;  start,i: integer;   val: expression;



        procedure recordError(x: expression;  kind: semanErrKind);
            {record a semantic error for the dag node 'x'.}
            begin
            errorCount := errorCount+1;
            error[errorCount].sem := x^.sem;
            error[errorCount].kind := kind;
            error[errorCount].loc.col  := x^.col;
            error[errorCount].loc.line := x^.line
            end {recordError};

        begin
        if x^.kind = dagNode then
            if x^.expanded then begin
                recordError(x,circAttr);  expandDag := errorExp
                end
            else begin
                x^.expanded := true;        {detect cycle in graph}
                args := nil;
                start := x^.argIdx + x^.sem^.attrCnt - 1;
                for i := start downto x^.argIdx do begin
                    args := consExpList(expandDag(dagArg[i], false), args);
                    decRefs(dagArg[i]);
                    dagArg[i] := nil
                    end;
                val := simpDepth(x^.sem^.attrCnt, args, x^.sem^.fn, 0);
                dispExpList(args);
                if val<>errorExp then      {check for errors}
                    if improper(val) then begin
                        recordError(x,undefAttr);
                        val := errorExp    {prevent error cascade}
                        end
                    else if con and (val<>boolExp[true]) then
                        recordError(x,badConstraint);
                {plug value into dag}
                expCount[dagNode] := expCount[dagNode] - 1;
                expCount[linkNode] := expCount[linkNode] + 1;
                x^.kind := linkNode;  x^.link := val;  incRefs(val);
                if usedCount > 1.2*lastUsed then begin
                    garbageCollect;  lastUsed := usedCount
                    end;
                expandDag := val
                end
        else begin
            while x^.kind = linkNode do x := x^.link;
            expandDag := x
            end
        end {expandDag};



    procedure checkConstraints(c: expList);
        {simplify, check, and garbage collect the constraints.}
        var i: integer;   scon: expression;
        begin
        i := 0;
        heading(listing);  writeln(listing, 'checking constraints');
        while c <> nil do begin
            i := i+1;
            scon := expandDag(c^.exp, true);
            decRefs(c^.exp);  c^.exp := nil;
            c := c^.next
            end;
        garbageCollect;  printExpCount;
        writeln(listing, i:1, ' constraints total.')
        end {checkConstraints};



    begin
    lastUsed := usedCount;
    checkConstraints(constraints);
    oldag := dag;
    dag := expandDag(dag,false);
    incRefs(dag); decRefs(oldag);
    heading(listing);
    garbageCollect; garbageCollect;
    printExpCount;
    rtime.simp := clock
    end {processSemantics};



procedure compile(dag: expression);
    const
        maxLambdas = 60;  {limit of lambda-exprs to be compiled later}
        maxShared = 30;   {number of shared parts of dag}

    type
        labelType = integer;
        labelTree = ^labelNode;
        environ = ^envNode;

        labelNode = record  {labels of components of structured fixedpoints}
                         case leaf: boolean of
                              true: (lab: labelType);
                              false: (l,r: labelTree)
                     end;

        {environs -- represent the context of an expression}
        envNode = record
                       bvName: alfa;           {name of bound var}
                       labels: labelTree;      {fixedpoint info}
                       dummy: boolean;          {this bv will not exist}
                       next: environ            {next element}
                   end;



    var
        ht: char;                       {horizontal tab}

        labelCount: integer;           {number of labels generated}

        {lamda-expressions awaiting compilation}
        lambdaCount: integer;
        lambda: array [1..maxLambdas] of
        record lab: labelType; x: expression; env: environ end;
        env: environ;

        opInst: array [operator] of instKind;

        sharedCount: integer;
        shared: array [1..maxShared] of labelType;

        root,start: labelType;

        addr: integer;                  {address of current instruction}

        {printing names for the op codes}
        instChars: array [instKind] of packed array [1..10] of char;



    procedure compExp(x: expression;  addPopEnv,returnFollows: boolean);
        forward;



    procedure comp(x: expression);
        begin compExp(x,false,false) end;



    function consEnv
        (bvName: alfa; labels: labelTree; dummy: boolean; next: environ)
        : environ;
        var e: environ;
        begin
        new(e);
        e^.bvName := bvName;
        e^.labels := labels;            {components of fixedpoint}
        e^.dummy := dummy;
        e^.next := next;
        consEnv := e
        end {consEnv};



    procedure pushBoundVar(bvName: alfa; labels: labelTree);
        begin
        env := consEnv(bvName, labels, labels<>nil, env)
        end {pushBoundVar};



    procedure popBoundVar;
        begin env := env^.next end;



    procedure makeLabel(var l: labelType);
        begin
        labelCount := labelCount+1;  l := labelCount
        end {makeLabel};



    procedure listCode(kind: instKind);
        {list instruction being generated}
        begin
        addr := addr+1;
        writeln(listing);
        write(listing, addr:1, ':', ht, instChars[kind])
        end {listCode};



    procedure gen(kind: instKind);
        begin
        if codeListing then listCode(kind);
        object^.kind := kind;  put(object)
        end {gen};



    procedure genInt(kind: instKind;  int: integer);
        begin
        if codeListing then
            begin listCode(kind);  write(listing, int:1, ht) end;
        object^.kind := kind;  object^.int := int;  put(object)
        end {genInt};



    procedure genPc(kind: instKind;  pc,level: integer);
        begin
        if codeListing then
            begin listCode(kind);  write(listing, pc:5, '  ', level:1) end;
        object^.kind := kind;
        object^.pc := pc;  object^.level := level;  put(object)
        end  {genPc};



    procedure defLabel(l: labelType);
        begin
        if codeListing then
            begin writeln(listing);  write(listing, '    ', l:1) end;
        object^.kind := labelI;  object^.pc := l;  object^.level := 0;
        put(object)
        end {defLabel};



    procedure compLambda(lab: labelType; bv: boundVar;  body: expression);
        {compile a lambda-expression using the given label.}
        begin
        defLabel(lab);
        pushBoundVar(bv.name^,nil);
        compExp(body,true,true);
        popBoundVar;
        gen(returnI)
        end {compLambda};



    procedure pushLambda(x: expression);
        var lab: labelType;
        begin
        makeLabel(lab);
        lambdaCount := lambdaCount+1;
        lambda[lambdaCount].lab := lab;
        lambda[lambdaCount].x := x;
        lambda[lambdaCount].env := env;
        if x^.free = 0 then genPc(ldNcloseI,lab,0)
        else genPc(ldCloseI,lab,0);
        if codeListing then write(listing, ht, x^.bv.name^)
        end {pushLambda};



    procedure popLambda(var lab: labelType;  var x: expression;
                         var env: environ);
        begin
        lab := lambda[lambdaCount].lab;
        x := lambda[lambdaCount].x;
        env := lambda[lambdaCount].env;
        lambdaCount := lambdaCount-1
        end {popLambda};



    procedure popBodies;
        var lab: labelType;  x: expression;  oldEnv: environ;
        begin
        oldEnv := env;
        while lambdaCount <> 0 do
            begin popLambda(lab,x,env); compLambda(lab, x^.bv, x^.body) end;
        env := oldEnv
        end {popBodies};



    procedure compExp{(x: expression; addPopEnv: boolean)};
        {addPopEnv says that 'x' contains the last use of the top-level
          bv and should delete it with 'popEnv' when done;
          returnFollows says that code for 'x' will immediately be followed by
          'return', allowing various optimizations.}
        var
            {left/rights preceeding expression}
            leftCount: integer;   left: array [1..30] of boolean;



        procedure accessLabel
            (bvName: alfa; lt: labelTree; level: integer);
            {compile reference to component of bound var of fixedpoint.
              cancel from 'left' the accesses that select the component.}
            begin
            while not lt^.leaf and (0<leftCount) do begin
                if left[leftCount] then lt := lt^.l
                else lt := lt^.r;
                leftCount := leftCount-1
                end;
            assert(lt^.leaf);           {proper fixedpoint structure?}
            genPc(ldCloseI,lt^.lab,level);
            if codeListing then write(listing, ht, bvName)
            end {accessLabel};



        procedure compVar(depth: integer);
            {compile bound variable.  may be lambda, case, or fixedpoint.}
            var i,skipped: integer;  e: environ;
            begin
            e := env;  skipped := 0;
            for i := 1 to depth do begin
                if e^.dummy then skipped := skipped+1;
                e := e^.next
                end;
            if e^.labels = nil
            then {lambda or case} begin
                genInt(ldPosI, depth-skipped);
                if codeListing then write(listing, ht, e^.bvName)
                end
            else {fixedpoint}
                accessLabel(e^.bvName, e^.labels, depth-skipped)
            end {compVar};



        function isIntConst(v: valueType): boolean;
            {does the value compile to an integer constant?}
            begin isIntConst := v.kind in [int,bool,string] end;



        procedure genIntConst(kind: instKind;  v: valueType);
            {convert v into an integer argument for the instruction}
            var intVal: integer;
            begin
            case v.kind of
                int:    intVal := v.i;
                bool:   intVal := ord(v.b);
                string: intVal := v.key

            end;
            genInt(kind,intVal);
            if codeListing then
                if v.kind = string then write(listing, ht, v.s^)
            end {genIntConst};



        procedure compConst(v: valueType);
            begin
            if v.kind = bot then gen(ldBotI)
            else if isIntConst(v) then genIntConst(ldIntI, v)
            else assert(false)
            end {compConst};



        procedure compCond(i,t,e: expression);
            var elseLab,fiLab: labelType;
            begin
            makeLabel(elseLab);  makeLabel(fiLab);
            comp(i);
            genPc(fjumpI,elseLab,0);
            compExp(t,addPopEnv,returnFollows);
            if returnFollows then gen(returnI)
            else genPc(jumpI,fiLab,0);
            defLabel(elseLab); compExp(e,addPopEnv,returnFollows);
            defLabel(fiLab);
            addPopEnv := false
            end {compCond};



        procedure compFix(bv: boundVar; body: expression);
            var labels: labelTree; skip: labelType;



            procedure assignLabels(var lt: labelTree; body: expression);
                {create a tree of labels matching the body.  each label
                  will head a recursive function representing that component
                  of the fixedpoint.}
                begin
                new(lt);  lt^.leaf := body^.kind <> pair;
                if lt^.leaf then makeLabel(lt^.lab)
                else begin
                    assignLabels(lt^.l, body^.l);
                    assignLabels(lt^.r, body^.r)
                    end
                end {assignLabels};



            procedure compileBody(lt: labelTree; body: expression);
                {compile the body into functions headed by the labels.
                  the body is a tree that matches 'lt'.}
                begin
                if lt^.leaf then begin
                    assert(body^.kind = lambdaExp);
                    compLambda(lt^.lab, body^.bv, body^.body)
                    end
                else begin  {body^.kind = pair}
                    compileBody(lt^.l,body^.l);
                    compileBody(lt^.r,body^.r)
                    end
                end {compileBody};

            begin
            assignLabels(labels,body);
            makeLabel(skip); genPc(jumpI,skip,0);
            pushBoundVar(bv.name^, labels);
            compileBody(labels,body);
            popBoundVar;
            defLabel(skip);
            accessLabel(bv.name^, labels, 0)
            end {compFix};



        procedure compApplic(rator,rand: expression);
            var cut: boolean;   oldEnv: environ;
            begin
            if (rand^.kind = constant) and isIntConst(rand^.v) then begin
                comp(rator);  genIntConst(applyIntI, rand^.v)
                end
            else begin
                cut := false;   {can we move up a 'popEnv'?}
                if addPopEnv then
                    if not refsVar(rator,1) then begin
                        cut := true;  addPopEnv := false
                        end;
                compExp(rand,cut,false);
                if cut then begin
                    oldEnv := env;
                    {flag the bound var as a dummy}
                    env := consEnv(env^.bvName, env^.labels, true,
                                    env^.next)
                    end;
                if rator^.kind = lambdaExp then begin
                    gen(pushEnvI);
                    pushBoundVar(rator^.bv.name^, nil);
                    compExp(rator^.body, true, returnFollows);
                    popBoundVar
                    end
                else begin comp(rator); gen(applyI) end;
                if cut then env := oldEnv      {restore environment}
                end
            end {compApplic};

        begin
        leftCount := 0;
        while (x^.kind = unOp) and (x^.uop in [leftOp,rightOp]) do begin
            leftCount := leftCount+1;
            left[leftCount] := x^.uop = leftOp;
            x := x^.u1
            end;

        with x^ do
            case kind of
                namedExp: assert(false);    {recursive or unspec}
                sharedNode: genPc(callzI, shared[shi], 0);
                variable: compVar(depth);
                constant: compConst(v);
                lambdaExp: pushLambda(x);
                fixExp: compFix(bv, body);
                applic: compApplic(rator,rand);
                cond: compCond(ifx, thenx, elsex);
                caseExp: assert(false);         {*****should compile*******}
                pair: begin comp(l); comp(r); gen(pairI) end;
                unOp: begin comp(u1); gen(opInst[uop]) end;
                binOp: begin comp(b1); comp(b2); gen(opInst[bop]) end;
                alterExp:
                    if (t1^.kind = constant) and isIntConst(t1^.v) then begin
                        comp(t2);  comp(t3);
                        genIntConst(alterIntI, t1^.v)
                        end
                    else begin comp(t1); comp(t2); comp(t3); gen(alterI) end;
                project:
                    begin
                    comp(exp);
                    if genTagfields then genInt(projectI, si)
                    end;
                inject:
                    begin
                    comp(exp);
                    if genTagfields then genInt(injectI, si)
                    end;
                isExp: if genTagfields then
                            begin comp(exp); genInt(isI, si) end
                        else assert(false)    {should print error message}
                end {case};
        while leftCount>0 do begin
            if left[leftCount] then gen(leftI)
            else gen(rightI);
            leftCount := leftCount-1
            end;
        if addPopEnv and not returnFollows then gen(popEnvI)
        end {comp};



    procedure segment(x: expression;  var l: labelType);
        {compile and list a shared subtree of the dag}
        begin
        if dagListing then printExp(listing,x,nil);
        makeLabel(l);
        defLabel(l);  compExp(x,false,true);  gen(returnI);
        popBodies
        end {segment};



    procedure splitDag(x: expression);
        var c: caseList;
        begin
        with x^ do
            if visited then begin
                if (free=0) and (kind in [lambdaExp,fixExp])
                then begin
                    sharedCount := sharedCount+1;
                    writeln(listing, 'shared',sharedCount:1,' = ');
                    segment(x, shared[sharedCount]);
                    kind := sharedNode;  shi := sharedCount
                    end
                end
            else begin
                visited := true;
                case kind of
                    linkNode: splitDag(link);
                    namedExp,variable,constant: {skip};
                    fixExp,lambdaExp: splitDag(body);
                    applic: begin splitDag(rator);  splitDag(rand) end;
                    cond:
                        begin
                        splitDag(ifx); splitDag(thenx); splitDag(elsex)
                        end;
                    caseExp:
                        begin
                        splitDag(index); c := cases;
                        while c<>nil do begin
                            splitDag(c^.body); c := c^.next
                            end
                        end;
                    pair: begin splitDag(l); splitDag(r) end;
                    unOp: splitDag(u1);
                    binOp: begin splitDag(b1); splitDag(b2) end;
                    alterExp:
                        begin splitDag(t1); splitDag(t2); splitDag(t3)
                        end;
                    inject,project,isExp: splitDag(exp)
                    end
                end
        end {splitDag};



    procedure initOpInst;
        begin
        opInst[leftOp]    := leftI;
        opInst[rightOp]   := rightI;
        opInst[notOp]     := notI;
        opInst[plusOp]    := plusI;
        opInst[minusOp]   := minusI;
        opInst[timesOp]   := timesI;
        opInst[divOp]     := divI;
        opInst[modOp]     := modI;
        opInst[ltOp]      := ltI;
        opInst[eqOp]      := eqI
        end {initOpInst};



    procedure initCode;
        begin
        instChars[haltI]          := 'halt      ';
        instChars[returnI]        := 'return    ';
        instChars[ldBotI]         := 'ldBot     ';
        instChars[ldConstI]       := 'ldConst   ';
        instChars[ldPosI]         := 'ldPos     ';
        instChars[ldCloseI]       := 'ldClose   ';
        instChars[ldNcloseI]      := 'ldNclose  ';
        instChars[applyI]         := 'apply     ';
        instChars[applyIntI]      := 'applyInt  ';
        instChars[pairI]          := 'pair      ';
        instChars[injectI]        := 'inject    ';
        instChars[projectI]       := 'project   ';
        instChars[isI]            := 'is        ';
        instChars[alterI]         := 'alter     ';
        instChars[alterIntI]      := 'alterInt  ';
        instChars[leftI]          := 'left      ';
        instChars[rightI]         := 'right     ';
        instChars[notI]           := 'not       ';
        instChars[plusI]          := 'plus      ';
        instChars[minusI]         := 'minus     ';
        instChars[timesI]         := 'times     ';
        instChars[divI]           := 'div       ';
        instChars[modI]           := 'mod       ';
        instChars[eqI]            := 'eq        ';
        instChars[ltI]            := 'lt        ';
        instChars[jumpI]          := 'jump      ';
        instChars[fjumpI]         := 'fjump     ';
        instChars[callzI]         := 'callz     ';
        instChars[pushEnvI]       := 'pushEnv   ';
        instChars[popEnvI]        := 'popEnv    ';
        instChars[labelI]         := 'label     ';
        instChars[ldIntI]         := 'ldInt     '
        end {initCode};

    begin
    sharedCount := 0;  addr := 0;  ht := chr(tabChar);
    labelCount := 0; env := nil; lambdaCount := 0;
    initOpInst;  initCode;
    heading(listing);
    splitDag(dag);
    if dagListing then begin
        writeln(listing);  writeln(listing);  writeln(listing, 'root of dag:')
        end;
    segment(dag,root);
    makeLabel(start);
    defLabel(start);
    genPc(callzI,root,0); gen(applyI); gen(haltI);
    genPc(jumpI,start,0);              {indicate start address}
    writeln(listing);
    rtime.comp := clock
    end {compile};



procedure printErrors;
    {report all the semantic errors in the program}
    var i,errNo,limit: integer;



    procedure sortErrors;
        {sort errors by line and column}
        var ej: errorRec;  i,j: integer;


        function gt(loc1,loc2: lineCol): boolean;
            begin
            if loc1.line = loc2.line then gt := loc1.col > loc2.col
            else gt := loc1.line > loc2.line
            end {gt};

        begin
        for j := 2 to errorCount do begin
            i := j;  ej := error[j];
            while (i>=2) and gt(error[i-1].loc, ej.loc) do begin
                error[i] := error[i-1];  i := i-1
                end;
            error[i] := ej
            end
        end {sortErrors};



    procedure reportError(var f: text;  er: errorRec);
        {compose and print an error message, including the name of the
          nonterminal, the domain of any undefined attribute, and information
          about any violated constraint.}
        begin
        pointError(f, er.loc.col);
        write(f, 'semantic error: ');
        if er.sem^.nt <> 0 then write(f, nonterm[er.sem^.nt].name);
        writeln(f);
        case er.kind of
            undefAttr:
                begin
                write(f, 'undefined attribute ');
                if er.sem^.dom<>0 then write(f, domn[er.sem^.dom]);
                writeln(f)
                end;
            circAttr:
                begin
                write(f, 'circularly defined attribute ');
                if er.sem^.dom<>0 then write(f, domn[er.sem^.dom]);
                writeln(f)
                end;
            badConstraint:
                begin
                with er.sem^.fn^ do
                    if kind = isExp
                    then writeln(f, 'should be ', selector[si])
                    else if (kind = binOp) and (bop = eqOp)
                    then writeln(f, 'attribute mismatch')
                    else if kind = applic then
                        if rator^.kind = namedExp
                        then writeln(f, 'failed check: ', def[rator^.di].name)
                end
            end {case};
        writeln(f)
        end {reportError};

    begin
    sortErrors;  heading(listing);
    errNo := 1;  error[errorCount+1].loc.line := maxLines;
    reset(source);  line.count := 0;
    repeat
        limit := error[errNo].loc.line;
        while not eof(source) and (line.count<limit) do begin
            readLine;
            if line.count > limit-2 then begin
                writeln(output, line.buf: line.len);
                writeln(listing,    line.buf: line.len)
                end
            end;
        while error[errNo].loc.line = line.count do begin
            reportError(output,error[errNo]);
            reportError(listing,   error[errNo]);
            errNo := errNo+1
            end
    until eof(source);
    for i := errNo to errorCount do begin
        reportError(output,error[i]);
        reportError(listing,   error[i])
        end
    end {printErrors};



procedure printStatistics;
    var total: integer;
    begin
    writeln(output, errorCount:1, ' semantic errors in program');
    writeln(listing);
    writeln(listing, errorCount:1, ' semantic errors in program');
    writeln(listing);
    total := tableSize + maxUsed;
    writeln(listing, 'total storage required: ', total:1);
    writeln(listing, 100*tableSize div total, '%   attribute tables');
    writeln(listing, 100*maxUsed div total, '%   semantic dag');
    with rtime do begin
        total := comp - start;
        writeln(listing, 'compile time: ', total div 1000 :1, ' seconds.');
        writeln(listing, 100*(init-start) div total, '%   reading ldf');
        writeln(listing, 100*(parse-init) div total, '%   parsing program');
        writeln(listing, 100*(simp-parse) div total, '%   simplifying dag');
        writeln(listing, 100*(comp-simp)  div total, '%   generating code');
        writeln(listing);
        writeln(listing, 'per ',tokenCount:1, ' tokens:  runtime ',
                (comp-init) div tokenCount : 1, ' msec.',
                '    max nodes ', maxUsed/tokenCount :4:2)
        end
    end {printStatistics};

begin
rtime.start := clock;
dagListing := true;            {option to list simplified dag}
codeListing := false;          {option to list object instructions}
defsListing := false;          {option to list the defs read in}
genTagfields := false;         {generate inject/project instructions}
initialize; readSeman; parse;
if not lexErrs and (dag <> nil) then begin     {no syntax errors}
    processSemantics(dag);
    compile(dag);
    if errorCount <> 0 then begin 
	printErrors; 
	rewrite(object,objectFileName) 		{delete object file}
	end;
    printStatistics
    end
end.
