{ relic, from ut.p }


procedure printSkim(var f: text;  x: expression);
{Print the expression in a format acceptable to the SKIM machine}
    var 
        varNum: integer;	{for generating variable names}
	
	bVarDepth: integer;	{stack of bound variable names}
	bvar: array [1..maxLambdaDepth] of integer;
	
        opAlfa: array [operator] of alfa;  {print names for operators}



    procedure print(x: expression); forward;
    
    procedure printLambda(body: expression);
    {generate a name for the bound variable and stack it}
        begin
	varNum := varNum+1;
	bVarDepth := bVarDepth+1;
	bVar[bVarDepth] := varNum;
	write(f, '\x', varNum:1);  print(body);
	bVarDepth := bVarDepth-1
	end {printLambda};



    procedure print{ (x: expression) };
        begin
	write(f, '(');
	with x^ do 
	    case kind of
	      linkNode: print(link);
	      sharedNode: write(f, 'shared', shi:1);
	      namedExp: write(f, def[di].name);
	      variable: write(f, 'x', bVar[bVarDepth - depth] : 1);
	      constant:
	        case v.kind of
		  bot:  write(f, 'bottom');
		  int:  write(f, v.i:1);
		  bool:  write(f, v.b:5);
		  string:  write(f, v.key:1)
		end {case};
	      fixExp:  
	        begin
		write(f, 'fix(');  printLambda(body);  write(f, ')')
		end;
	      lambdaExp:  printLambda(body);
	      applic: begin print(rator);  print(rand) end;
	      cond:  
	        begin  
		write(f, 'if');  print(ifx);
		write(f, 'then');  print(thenx);
		write(f, 'else');  print(elsex);
		write(f, 'fi')
		end;
	      caseExp: assert(false);
	      pair:  begin  print(l);  write(f, '.');  print(r)  end;
	      unOp:  begin  write(f, opAlfa[uop]:5);  print(u1)  end;
	      binOp: 
	        begin
		write(f, opAlfa[bop]:5);  print(b1);  print(b2)
		end;
	      alterExp:
	        begin
		write(f, 'alterFunction');
		print(t1);  print(t2);  print(t3)
		end;
	      inject:  begin  write(f, si:1, ' . ');  print(exp)  end;
	      project:  
	        begin  write(f, 'projectUnion ', si:1);  print(exp) end;
	      isExp:  
	        begin  write(f, 'isTagUnion ', si:1);  print(exp) end
	    end {case};
	write(f, ')')
	end {print};

    begin
    opAlfa[leftOp]    := 'left           ';
    opAlfa[rightOp]   := 'right          ';
    opAlfa[notOp]     := 'not            ';
    opAlfa[plusOp]    := 'plus           ';
    opAlfa[minusOp]   := 'minus          ';
    opAlfa[timesOp]   := 'times          ';
    opAlfa[divOp]     := 'div            ';
    opAlfa[modOp]     := 'mod            ';
    opAlfa[ltOp]      := 'lt             ';
    opAlfa[eqOp]      := 'eq             ';
    varNum := 0;  bVarDepth := 0;
    print(x);  writeln(f);  writeln(f)
    end {printSkim};



