(*  Title:      HOL/ex/BinEx.ML
    ID:         $Id: BinEx.ML,v 1.7 1998/10/23 16:47:55 paulson Exp $
    Author:     Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1998  University of Cambridge

Examples of performing binary arithmetic by simplification

Also a proof that binary arithmetic on normalized operands 
yields normalized results. 
*)

set proof_timing;

(** Addition **)

Goal "#13  +  #19 = #32";
by (Simp_tac 1);
result();

Goal "#1234  +  #5678 = #6912";
by (Simp_tac 1);
result();

Goal "#1359  +  #-2468 = #-1109";
by (Simp_tac 1);
result();

Goal "#93746 +  #-46375 = #47371";
by (Simp_tac 1);
result();

(** Negation **)

Goal "- #65745 = #-65745";
by (Simp_tac 1);
result();

Goal "- #-54321 = #54321";
by (Simp_tac 1);
result();


(** Multiplication **)

Goal "#13  *  #19 = #247";
by (Simp_tac 1);
result();

Goal "#-84  *  #51 = #-4284";
by (Simp_tac 1);
result();

Goal "#255  *  #255 = #65025";
by (Simp_tac 1);
result();

Goal "#1359  *  #-2468 = #-3354012";
by (Simp_tac 1);
result();

Goal "#89 * #10 ~= #889";  
by (Simp_tac 1); 
result();

Goal "#13 < #18 - #4";  
by (Simp_tac 1); 
result();

Goal "#-345 < #-242 + #-100";  
by (Simp_tac 1); 
result();

Goal "#13557456 < #18678654";  
by (Simp_tac 1); 
result();

Goal "#999999 <= (#1000001 + #1)-#2";  
by (Simp_tac 1); 
result();

Goal "#1234567 <= #1234567";  
by (Simp_tac 1); 
result();


(** Testing the cancellation of complementary terms **)

Goal "y + (x + -x) = #0 + y";
by (Simp_tac 1);
result();

Goal "y + (-x + (- y + x)) = #0";
by (Simp_tac 1);
result();

Goal "-x + (y + (- y + x)) = #0";
by (Simp_tac 1);
result();

Goal "x + (x + (- x + (- x + (- y + - z)))) = #0 - y - z";
by (Simp_tac 1);
result();

Goal "x + x - x - x - y - z = #0 - y - z";
by (Simp_tac 1);
result();

Goal "x + y + z - (x + z) = y - #0";
by (Simp_tac 1);
result();

Goal "x+(y+(y+(y+ (-x + -x)))) = #0 + y - x + y + y";
by (Simp_tac 1);
result();

Goal "x+(y+(y+(y+ (-y + -x)))) = y + #0 + y";
by (Simp_tac 1);
result();

Goal "x + y - x + z - x - y - z + x < #1";
by (Simp_tac 1);
result();


Addsimps normal.intrs;

Goal "(w BIT b): normal ==> (w BIT b BIT c): normal";
by (case_tac "c" 1);
by Auto_tac;
qed "normal_BIT_I";

Addsimps [normal_BIT_I];

Goal "w BIT b: normal ==> w: normal";
by (etac normal.elim 1);
by Auto_tac;
qed "normal_BIT_D";

Goal "w : normal --> NCons w b : normal";
by (induct_tac "w" 1);
by (auto_tac (claset(), simpset() addsimps [NCons_Pls, NCons_Min]));
qed_spec_mp "NCons_normal";

Addsimps [NCons_normal];

Goal "NCons w True ~= Pls";
by (induct_tac "w" 1);
by Auto_tac;
qed "NCons_True";

Goal "NCons w False ~= Min";
by (induct_tac "w" 1);
by Auto_tac;
qed "NCons_False";

Goal "w: normal ==> bin_succ w : normal";
by (etac normal.induct 1);
by (exhaust_tac "w" 4);
by (auto_tac (claset(), simpset() addsimps [NCons_True, bin_succ_BIT]));
qed "bin_succ_normal";

Goal "w: normal ==> bin_pred w : normal";
by (etac normal.induct 1);
by (exhaust_tac "w" 3);
by (auto_tac (claset(), simpset() addsimps [NCons_False, bin_pred_BIT]));
qed "bin_pred_normal";

Addsimps [bin_succ_normal, bin_pred_normal];

Goal "w : normal --> (ALL z. z: normal --> bin_add w z : normal)";
by (induct_tac "w" 1);
by (Simp_tac 1);
by (Simp_tac 1);
by (rtac impI 1);
by (rtac allI 1);
by (induct_tac "z" 1);
by (ALLGOALS (asm_simp_tac (simpset() addsimps [bin_add_BIT])));
by (safe_tac (claset() addSDs [normal_BIT_D]));
by (ALLGOALS Asm_simp_tac);
qed_spec_mp "bin_add_normal";

Goal "w: normal ==> (w = Pls) = (integ_of w = #0)";
by (etac normal.induct 1);
by Auto_tac;
qed "normal_Pls_eq_0";

Goal "w : normal ==> bin_minus w : normal";
by (etac normal.induct 1);
by (ALLGOALS (asm_simp_tac (simpset() addsimps [bin_minus_BIT])));
by (resolve_tac normal.intrs 1);
by (assume_tac 1);
by (asm_full_simp_tac (simpset() addsimps [normal_Pls_eq_0]) 1);
by (asm_full_simp_tac 
    (simpset_of Int.thy addsimps [integ_of_minus, iszero_def, 
				  zminus_exchange]) 1);
qed "bin_minus_normal";

Goal "w : normal ==> z: normal --> bin_mult w z : normal";
by (etac normal.induct 1);
by (ALLGOALS
    (asm_simp_tac (simpset() addsimps [bin_minus_normal, bin_mult_BIT])));
by (safe_tac (claset() addSDs [normal_BIT_D]));
by (asm_simp_tac (simpset() addsimps [bin_add_normal]) 1);
qed_spec_mp "bin_mult_normal";

