(*  Title: 	ZF/pair
    Author: 	Martin D Coen, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Ordered pairs in Zermelo-Fraenkel Set Theory 
*)

(** Lemmas for showing that <a,b> uniquely determines a and b **)

val doubleton_lemma = prove_goal ZF_Rule.thy
    "[| {a,b} <= C; [| a : C;  b : C |] ==> P |] ==> P"
 (fn prems=>
  [ (cut_facts_tac prems 1),
    (REPEAT (etac subsetD 1 
     ORELSE ares_tac (prems@[consI1,consI2]) 1)) ]);

val doubleton_iff = prove_goal ZF_Rule.thy
    "{a,b} = {c,d} <-> (a=c & b=d) | (a=d & b=c)"
 (fn prems=>
  [ (resolve_tac [extension RS iff_trans] 1),
    (fast_tac (upair_cs addEs [doubleton_lemma]) 1) ]);

val doubleton_equality = prove_goal ZF_Rule.thy
    "[| {a,b} = {c,d};  \
\       [| a=c; b=d |] ==> P; [| a=d; b=c |] ==> P |] ==> \
\    P"
 (fn major::prems=>
  [ (rtac (major RS (doubleton_iff RS iffD1 RS disjE)) 1),
    (REPEAT (eresolve_tac ([asm_rl, conjE] @ prems) 1)) ]);

val Pair_inject1 = prove_goalw ZF_Rule.thy [Pair_def] "<a,b> = <c,d> ==> a=c"
 (fn prems=>
  [ (cut_facts_tac prems 1),
    (REPEAT (atac 1 ORELSE etac doubleton_equality 1)) ]);

val Pair_inject2 = prove_goalw ZF_Rule.thy [Pair_def] "<a,b> = <c,d> ==> b=d"
 (fn prems=>
  [ (cut_facts_tac prems 1),
    (fast_tac (upair_cs addEs [doubleton_equality]) 1) ]);

val Pair_inject = prove_goal ZF_Rule.thy
    "[| <a,b> = <c,d>;  [| a=c; b=d |] ==> P |] ==> P"
 (fn [major,minor]=>
  [ (rtac minor 1),
    (rtac (major RS Pair_inject1) 1),
    (rtac (major RS Pair_inject2) 1) ]);

val Pair_neq_0 = prove_goalw ZF_Rule.thy [Pair_def] "<a,b>=0 ==> P"
 (fn [major]=>
  [ (rtac (major RS equalityD1 RS subsetD RS emptyE) 1),
    (rtac consI1 1) ]);


(*** Disjoint union of a family of sets - Sigma ***)

val SigmaI = prove_goalw ZF_Rule.thy [Sigma_def]
    "[| a:A;  b:B(a) |] ==> <a,b> : Sigma(A,B)"
 (fn prems=>
  [ (fast_tac (upair_cs addIs prems) 1) ]);

(*The general elimination rule*)
val SigmaE = prove_goalw ZF_Rule.thy [Sigma_def]
    "[| c: Sigma(A,B);  \
\       !!x y.[| x:A;  y:B(x);  c=<x,y> |] ==> P \
\    |] ==> P"
 (fn major::prems=>
  [ (cut_facts_tac [major] 1),
    (REPEAT (eresolve_tac [UN_E, singletonE] 1 ORELSE ares_tac prems 1)) ]);

(** Elimination of <a,b>:A*B -- introduces no eigenvariables **)
val SigmaD1 = prove_goal ZF_Rule.thy "<a,b> : Sigma(A,B) ==> a : A"
 (fn [major]=>
  [ (rtac (major RS SigmaE) 1),
    (REPEAT (eresolve_tac [asm_rl,Pair_inject,ssubst] 1)) ]);

val SigmaD2 = prove_goal ZF_Rule.thy "<a,b> : Sigma(A,B) ==> b : B(a)"
 (fn [major]=>
  [ (rtac (major RS SigmaE) 1),
    (REPEAT (eresolve_tac [asm_rl,Pair_inject,ssubst] 1)) ]);

(*Now obsolete?  could be derived from previous two*)
val SigmaE2 = prove_goal ZF_Rule.thy
    "[| <a,b> : Sigma(A,B);    \
\       [| a:A;  b:B(a) |] ==> P   \
\    |] ==> P"
 (fn prems=>
  [ (rtac SigmaE 1),
    (REPEAT (ares_tac prems 1 ORELSE eresolve_tac [Pair_inject,ssubst] 1)) ]);

val Sigma_cong = prove_goalw ZF_Rule.thy [Sigma_def]
    "[| A=A';  !!x. x:A' ==> B(x)=B'(x) |] ==> \
\    Sigma(A,B) = Sigma(A',B')"
 (fn prems=>
  [ (prove_cong_tac (prems@[RepFun_cong]) 1) ]);

val Sigma_empty1 = prove_goal ZF_Rule.thy "Sigma(0,B) = 0"
 (fn _ =>
  [ (REPEAT (eresolve_tac [SigmaE,emptyE] 1
     ORELSE ares_tac [equalityI,subsetI] 1)) ]);

val Sigma_empty2 = prove_goal ZF_Rule.thy "A*0 = 0"
 (fn _ =>
  [ (REPEAT (eresolve_tac [SigmaE,emptyE] 1
     ORELSE ares_tac [equalityI,subsetI] 1)) ]);


(*** Eliminator - split ***)

val split_conv = prove_goalw ZF_Rule.thy [split_def]
    "split(<a,b>, %x y.c(x,y)) = c(a,b)"
 (fn _ =>
  [ (fast_tac (upair_cs addIs [the_equality] addEs [Pair_inject]) 1) ]);

val split_type = prove_goal ZF_Rule.thy
    "[|  p:Sigma(A,B);   \
\        !!x y.[| x:A; y:B(x) |] ==> c(x,y):C(<x,y>) \
\    |] ==> split(p, %x y.c(x,y)) : C(p)"
 (fn major::prems=>
  [ (rtac (major RS SigmaE) 1),
    (etac ssubst 1),
    (REPEAT (ares_tac (prems @ [split_conv RS ssubst]) 1)) ]);

(*This congruence rule uses typing information...*)
val split_cong = prove_goalw ZF_Rule.thy [split_def] 
    "[| p=p';  !!x y.c(x,y) = c'(x,y) |] ==> \
\    split(p, %x y.c(x,y)) = split(p', %x y.c'(x,y))"
 (fn prems=>
  [ (prove_cong_tac (prems@[the_cong]) 1) ]);


(*** fst and snd ***)

val fst_conv = prove_goalw ZF_Rule.thy [fst_def] "fst(<a,b>) = a"
 (fn prems=>
  [ (rtac split_conv 1) ]);

val snd_conv = prove_goalw ZF_Rule.thy [snd_def] "snd(<a,b>) = b"
 (fn prems=>
  [ (rtac split_conv 1) ]);


val pair_cs = upair_cs 
    addSIs [SigmaI]
    addSEs [SigmaE2, SigmaE, Pair_inject, make_elim succ_inject,
	    Pair_neq_0, sym RS Pair_neq_0, succ_neq_0, sym RS succ_neq_0];
