(*  Title: 	POLY
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Compatibility file for Poly/ML (AHL release 1.88)
*)

open PolyML ExtendedIO;  

(*A conditional timing function: applies f to () and, if the flag is true,
  prints its runtime. *)
fun cond_timeit flag f =
  if flag then
    let val before = System.processtime()
	val result = f()
	val both = real(System.processtime() - before) / 10.0
    in  output(std_out, "Process time (incl GC): "^ 
	                 makestring both ^ " secs\n");
	result
    end
  else f();

(*Unconditional timing function*)
val timeit = cond_timeit true;


(* Here is a workaround structure to implement zero length arrays.
   It will certainly not be as fast as the 'real' implementation,
   but it should be semantically equivalent. -- Mike Crawley, AHL
   NEEDED FOR Poly/ML 1.88 AND EARLIER VERSIONS *)

structure Array = struct

  datatype 'a array = Empty | NonEmpty of 'a Array.array ;

  fun array (0,_) = Empty
  |   array (n,a) = NonEmpty (Array.array (n,a)) ;

  exception Subscript = Array.Subscript ;
  
  fun update (Empty     ,_,_) = raise Subscript
  |   update (NonEmpty a,n,x) = Array.update (a,n,x) ;
  
  fun sub (Empty     ,_) = raise Subscript
  |   sub (NonEmpty a,n) = Array.sub (a,n) ;
  
  fun arrayoflist [] = Empty
  |   arrayoflist L  = NonEmpty (Array.arrayoflist L) ;
  
  fun length (Empty) = 0
  |   length (NonEmpty a) = Array.length a ;

end ;
