(*  Title: 	CTT/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Adds Constructive Type Theory to a database containing pure Isabelle. 
Should be executed in the subdirectory CTT.
*)

writeln"Root file for Constructive Type Theory";

print_depth 1;  

use "syntax.ML";
use ".rules.ML";
use "resolve.ML";

print_depth 1;  
structure CTT_Syntax =  CTT_SyntaxFun();
structure CTT_Rule = CTT_RuleFun(CTT_Syntax);
structure CTT_Resolve = CTT_ResolveFun(CTT_Rule);

open CTT_Resolve CTT_Rule;

use "../Provers/typedsimp.ML";
use "rew.ML";

use "arith.ML";
use "bool.ML";

print_depth 8;  

(* Set up automatic printing of theorems -- works in Poly/ML only *)
install_pp (K print_thm);

