(*  Title: 	NJ/ruleshell
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Natural Deduction Rules for Intuitionistic first-order logic 

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"   
*)


signature NJ_RULE =
  sig
  structure Thm : THM
  val sign: Thm.Sign.sg
  val thy: Thm.theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  end;


functor NJ_RuleFun (structure NJ_Syntax: NJ_SYNTAX and Thm: THM
	sharing NJ_Syntax.Syntax = Thm.Sign.Syntax) : NJ_RULE = 
struct
structure Thm = Thm;


val thy = Thm.enrich_theory Thm.pure_thy "NJ"
    (["exp","form","prop"],  NJ_Syntax.const_decs,  NJ_Syntax.syn) 
[
  (*Equality*)

  ("refl",   "[| a=a |]"  ),

  ("sym",  "[| a=b |] ==> [| b=a |]"  ),

  ("trans",  "[| a=b |] ==> [| b=c |] ==> [| a=c |]"),


  (*Propositional logic*)

  ("conj_intr",  "[| P |] ==> [| Q |] ==> [| P&Q |]"  ),

  ("conjunct1", "[| P&Q |] ==> [| P |]"),

  ("conjunct2", "[| P&Q |] ==> [| Q |]"),


  ("disj_intr1",   "[| P |] ==> [| P|Q |]"  ),

  ("disj_intr2",   "[| Q |] ==> [| P|Q |]"  ),

  ("disj_elim",  
   "[| P|Q |] ==> ([| P |] ==> [| R |]) ==> ([| Q |] ==> [| R |]) ==> [| R |]"),


  ("imp_intr",  "([| P |] ==> [| Q |]) ==> [| P-->Q |]"),

  ("mp", "[| P-->Q |] ==> [| P |] ==> [| Q |]"),


  ("False_elim",   "[| False |] ==> [| P |]" ),


  ("iff_def",  "P<->Q == (P-->Q) & (Q-->P)"),


  (*Quantifiers*)

  ("all_intr",  "(!(y) [| P(y) |]) ==> [| ALL x.P(x) |]"  ),

  ("spec", "[| ALL x.P(x) |] ==> [| P(a) |]"),


  ("exists_intr",  "[| P(a) |] ==> [| EXISTS x.P(x) |]"  ),

  ("exists_elim",
   "[| EXISTS x.P(x) |] ==> (!(y)[| P(y) |] ==> [| R |]) ==> [| R |]")
];

val sign = Thm.sign_of thy;

val ax = Thm.get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)

end;
