(*  Title: 	tt-ex-equal
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge
*)

read_goal TypeThy "split(p,pair) = p : Sum(A,B')  [H]";
expand (resolve_tac [Eq_elim] 1);
expand (rsubst_tac ("p","Sum(A,B')") 1);
expand (depth_resolve_tac (determ_choose (elim0_rls, 1)));
expand simp_tac; 



read_goal TypeThy "when(p,inl,inr) = p : A + B  [H]";
expand (resolve_tac [Eq_elim] 1);
expand (rsubst_tac ("p","A+B") 1);
expand (depth_resolve_tac (determ_choose (elim0_rls, 1)));
expand simp_tac; 


(*in the "rec" formulation of addition, 0+n=n *)
read_goal TypeThy "rec(p,0, %(y,z)succ(y)) = p : N  [H]";
expand (rN_elim_tac "p" 1);
expand simp_tac;


(*the harder version, n+0=n: recursive, uses induction hypothesis*)
read_goal TypeThy "rec(p,0, %(y,z)succ(z)) = p : N  [H]";
expand (rN_elim_tac "p" 1);
expand simp_tac;


(*Associativity of addition?*)
read_goal TypeThy
   "rec(rec(a, b, %(x,y)succ(y)), c, %(x,y)succ(y)) = \
\   rec(a, rec(b, c, %(x,y)succ(y)), %(x,y)succ(y)) : N [H]";
expand (rN_elim_tac "a" 1);
expand presimp_tac;
expand simp_tac;  (*11 secs*)


(*Martin-Lof (1984) page 62: pairing is surjective
  verifying one assumption requires BACKTRACKING ON UNIFIER?
    --projection gives the wrong assignment, clobbering a later goal*)
read_goal TypeThy
   "<split(p,%(x,y)x), split(p,%(x,y)y)>  =  p  : Sum(A,B')  [H]";
expand (resolve_tac [Eq_elim] 1);
expand (rsubst_tac ("p","Sum(A,B')") 1);
expand (depth_resolve_tac (determ_choose (elim0_rls, 1)));
expand eqintr_tac;
(*equality reasoning but no assumption solving: that requires care here*)
expand (determ_resolve_tac(reduction_rls@subconv_rls@[refl_elem,refl_red], 4));
expand (resolve_tac assume_rls 10);
(*do the problem case first*)
expand determ_assume_tac;
expand merge_premises_tac;


read_goal TypeThy 
  "(lam u. split(u, %(v,w)<w,v>)) ` <a,b> = <b,a> : B*A [H]";
expand (unfold_goal_tac ["*"]);
expand simp_tac;


(*a contrived, complicated simplication, requires sum-elimination also*)
read_goal TypeThy
   "(lam f. lam x. f`(f`x)) ` (lam u. split(u, %(v,w)<w,v>)) =  \
\     lam x. x  :  N*N ==> N*N          [H]";
expand (unfold_goal_tac ["*","==>"]);
expand (resolve_tac reduction_rls 1);
expand (resolve_tac intr_long_rls 3);
expand (resolve_tac [ Eq_elim RES Sum_elim0 ] 4);  (*split N*N*)
expand simp_tac;  (*7 secs*)
