(*  Title: 	symtab
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge
*)

(*Unbalanced binary trees indexed by strings
 No way to delete an entry
 could generalize alist_of_symtab to a traversal functional
*)


(*symbol table errors, such as from supdate_new*)
exception symbol_table : string list;

abstype 'a symbol_table = 
    tip
  | branch of (string * 'a * 'a symbol_table * 'a symbol_table)
  with

    val null_symtab = tip;

    fun slookup (symtab: 'a symbol_table, key: string) : 'a option = 
      let fun look  tip  = None
	    | look (branch (key',entry,left,right)) =
		if      key < key' then look left
		else if key' < key then look right
		else  Some entry
      in look symtab end;

    (*update, allows overwriting of an entry*)
    fun supdate ((key: string, entry: 'a), symtab : 'a symbol_table)
      : 'a symbol_table =
      let fun upd  tip  = branch (key,entry,tip,tip)
	    | upd (branch(key',entry',left,right)) =
		if      key < key' then branch (key',entry', upd left, right)
		else if key' < key then branch (key',entry',left, upd right)
		else                    branch (key,entry,left,right)
      in  upd symtab  end;

    (*Like supdate but fails if key is already defined in table.
      Allows symtab_of_alist, etc. to detect multiple definitions*)
    fun supdate_new ((key: string, entry: 'a), symtab : 'a symbol_table)
      : 'a symbol_table =
      let fun upd tip = branch (key,entry,tip,tip)
	    | upd (branch(key',entry',left,right)) =
		if      key < key' then branch (key',entry', upd left, right)
		else if key' < key then branch (key',entry',left, upd right)
		else  raise symbol_table with ["supdate_new", key]
      in  upd symtab  end;

    (*conversion of symbol table to association list*)
    fun alist_of_symtab (symtab : 'a symbol_table) : (string * 'a) list =
      let fun ali (symtab,cont) = case symtab of
      	      tip => cont
	    | branch (key,entry,left,right) =>
	        ali(left, (key,entry) :: ali(right,cont))
      in  ali (symtab,[])  end
  end;


(*conversion from association list to symbol table*)
fun symtab_of_alist (al : (string * 'a) list) : 'a symbol_table =
    itlist_right supdate_new (al, null_symtab);

(*a "declaration" associates the same entry with a list of keys;
  does not allow overwriting of an entry*)
fun decl_supdate_new ((keys : string list, entry: 'a), symtab)
  : 'a symbol_table =
  let fun decl (key,symtab) = supdate_new((key,entry), symtab)
  in  itlist_right decl (keys, symtab)  end;

(*conversion from a list of declarations to a symbol table*)
fun symtab_of_declist (dl : (string list * 'a) list) : 'a symbol_table =
    itlist_right decl_supdate_new (dl, null_symtab);

