(*  Title: 	set-ex-unint
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1986  University of Cambridge

Set Theory examples: Union and Intersection
*)



(*  ?R [ ?H, ?G, ~ ?a : ?A, ~ ?a : ?B ]     
    -----------------------------------
       ?R [ ?H, ~ ?a : ?A Un ?B, ?G ]  	*)
read_goal SetThy "R [ H, ~ a : A Un B, G ]";
expand (unfold_goal_tac ["Un"]);
expand (rcut_tac "(~ a : A) & (~ a : B)" 1);
expand (SELECT_GOAL set_tac 1);
expand (resolve_tac [conj_elimh] 1);
expand (resolve_tac [thin] 1);
val Un_right = ttop_rule();

(*or else...
  expand (resolve_tac [Union_right_nothin] 1);
  expand (resolve_tac [setcons_right] 1);
  expand (resolve_tac [setcons_right] 1);
  expand (rconstrain_res_tac [("?a","?B")] refl_right 1);
  expand (resolve_tac [Union_right] 1);
  expand (resolve_tac [setcons_right] 1);
  expand (resolve_tac [refl_right] 1);  *)



(*  ?Q [ ?H, ?G, ?a : ?A ]     ?Q [ ?H, ?G, ?a : ?B ]     
    -------------------------------------------------
	    ?Q [ ?H, ?a : ?A Un ?B, ?G ]  	*)
read_goal SetThy "Q [ H, a: A Un B, G ]";
expand (unfold_goal_tac ["Un"]);
expand (determ_resolve_tac ([Union_elimh, setcons_elimh, nullset_elimh], 3));
expand (resolve_tac [cut RES member_cong RES refl] 2);
expand (resolve_tac [assume] 3);
expand (resolve_tac [sym RES assume] 2);
expand (resolve_tac [cut RES member_cong RES refl] 1);
expand (resolve_tac [assume] 2);
expand (resolve_tac [sym RES assume] 1);
expand (resolve_tac [thin RES thin] 1);
expand (resolve_tac [thin RES thin] 2);
val Un_elimh = ttop_rule();



read_goal SetThy "A: Inter(C)  <=>  (~ C=0 & ALL B. B:C ==> A:B) [H]";
expand (unfold_goal_tac ["Inter", "<=>"]);
expand (new_set_tac ([equal_right, equal_elimh],[]));
(*5 secs*)


(*  ?R [ ?H, ?G, ?C = 0 ]     ?R [ ?H, ?G, y4: ?C, ~ ?A: y4 ]     
    ---------------------------------------------------------
		?R [ ?H, ~ ?A : Inter(?C), ?G ] 
    PROVISO y4> ?A ?C ?G ?H ?R  	*)
read_goal SetThy "R [ H, ~ A: Inter(C), G ]";
expand (unfold_goal_tac ["Inter"]);
expand (rcut_tac "C=0  |  EXISTS B. B:C  &  ~ A:B" 1);
expand (resolve_tac [disj_elimh] 2);
expand (resolve_tac [exists_elimh] 3);
expand (resolve_tac [conj_elimh] 3);
expand (resolve_tac [thin] 2);
expand (resolve_tac [thin] 3);
expand (SELECT_GOAL (new_set_tac ([equal_right],[])) 1);
val Inter_right = ttop_rule();


(*  ?R [ ?H, ?G, ~ ?C=0, ~ ?B: ?C ]     ?R [ ?H, ?G, ~ ?C=0, ?A: ?B ]     
    -----------------------------------------------------------------
		?R [ ?H, ?A : Inter(?C), ?G ]	  *)
read_goal SetThy "R [ H, A: Inter(C), G ]";
expand (unfold_goal_tac ["Inter"]);
expand (rcut_tac "~ C=0  &  (B: C ==> A: B)" 1);
expand (SELECT_GOAL (new_set_tac ([equal_elimh],[])) 1);
expand (resolve_tac [thin] 1);
expand (resolve_tac [conj_elimh] 1);
expand (cases_imp_tac 1);
val Inter_elimh = ttop_rule();


(*  ?R [ ?H, ?G, ~ ?a: ?A ]     ?R [ ?H, ?G, ~ ?a: ?B ]     
    ---------------------------------------------------
	     ?R [ ?H, ~ ?a : ?A Int ?B, ?G ]	  *)
read_goal SetThy "R [ H, ~ a: A Int B, G ]";
expand (unfold_goal_tac ["Int"]);
expand (resolve_tac [Inter_right] 1);
expand (SELECT_GOAL (new_set_tac ([equal_elimh],[])) 1);
expand (rcut_tac "~ a: A  |  ~ a: B" 1);
expand (SELECT_GOAL (new_set_tac ([equal_elimh],[])) 1);
(*25 secs...BRUTE FORCE method of handling equality assumptions!!!*)
expand (resolve_tac [thin RES thin] 1);
expand (resolve_tac [disj_elimh] 1);
val Int_right = ttop_rule();


(*  ?R [ ?H, ?G, ?a : ?A, ?a : ?B ]     
    -------------------------------
     ?R [ ?H, ?a : ?A Int ?B, ?G ]  	*)
read_goal SetThy "R [ H, a: A Int B, G ]";
expand (unfold_goal_tac ["Int"]);
expand (rcut_tac "a: A  &  a: B" 1);
expand (resolve_tac [F_elim] 1);
expand (SELECT_GOAL (new_set_tac ([], [Inter_elimh])) 1);
expand (resolve_tac [thin] 1);
expand (resolve_tac [conj_elimh] 1);
val Int_elimh = ttop_rule();



val set1_rls = quicksort ruleseq
    [Un_right, Un_elimh, Inter_right, Int_right, Int_elimh];


(*Rules that introduce a new variable must be used last of all!*)
val var_set1_rls = [Inter_elimh];


fun new_set1_step_tac (rls1,rls2) =
  new_set_step_tac (rls1@set1_rls, rls2@var_set1_rls);

fun new_set1_tac (rls1,rls2) =
  new_set_tac (rls1@set1_rls, rls2@var_set1_rls);

val set1_step_tac = new_set1_step_tac ([],[]);
val set1_tac = new_set1_tac ([],[]);

 
val set2_step_tac = new_set1_step_tac ([equal_right],[]);
val set2_tac = new_set1_tac ([equal_right], []);


(*absorptive laws of Int and Un *)

read_goal SetThy "A Int A = A  [ H ]";
expand set2_tac;
val Int_absorptive = ttop_rule();


read_goal SetThy "A Un A = A  [ H ]";
expand set2_tac;
val Un_absorptive = ttop_rule();

(*commutative laws of Int and Un *)

read_goal SetThy "A Int B  =  B Int A  [ H ]";
expand set2_tac;
val Int_commute = ttop_rule();


read_goal SetThy "A Un B  =  B Un A  [ H ]";
expand set2_tac;
val Un_commute = ttop_rule();


(*associative laws of Int and Un *)

read_goal SetThy "(A Int B) Int C  =  A Int (B Int C)  [ H ]";
expand set2_tac;
val Int_assoc = ttop_rule();


read_goal SetThy "(A Un B) Un C  =  A Un (B Un C)  [ H ]";
expand set2_tac;
val Un_assoc = ttop_rule();


(*distributive laws of Int and Un *)
read_goal SetThy "(A Int B) Un C  = (A Un C) Int (B Un C)  [ H ]";
expand set2_tac;  (*3 secs*)
val Un_distrib = ttop_rule();


read_goal SetThy "(A Un B) Int C  = (A Int C) Un (B Int C)  [ H ]";
expand set2_tac;  (*3 secs*)
val Int_distrib = ttop_rule();


read_goal SetThy "(ALL B. B: C ==> B <= A)  <=>  Union(C) <= A";
expand (unfold_goal_tac ["<=>"]);
expand set_tac;   (*3 secs*)


read_goal SetThy "(EXISTS B. B: C  &  A <= B)  ==>  A <= Union(C)";
expand set_tac;


read_goal SetThy "~ C=0  &  (ALL B. B: C ==> A <= B)  ==>  A <= Inter(C)";
expand set1_tac;  (*2 secs*)


read_goal SetThy "(EXISTS B. B: C  &  B <= A)  ==>  Inter(C) <= A";
expand set1_tac;   (*3 secs*)


(*Halmos, page 20*)
read_goal SetThy "Pow(A) Int Pow(B)  =  Pow(A Int B)  [ H ]";
expand set2_tac;  (*4 secs*)
val Pow_Int = ttop_rule();


read_goal SetThy "Pow(A) Un Pow(B)  <=  Pow(A Un B)  [ H ]";
expand set1_tac;  (*2 secs*)
val Pow_Un = ttop_rule();


read_goal SetThy "Pow(A) <= Pow(B)  ==>  A<=B  [ H ]";
expand set_tac;
val Pow_inverse_mono_imp = ttop_rule();


read_goal SetThy "Q [ H, Pow(A) <= Pow(B), G ]";
expand (use_imp_tac Pow_inverse_mono_imp);
val Pow_inverse_mono = ttop_rule();


read_goal SetThy "Pow(A) = Pow(B)  ==>  A=B  [ H ]";
expand (new_set_tac([Pow_inverse_mono, equal_right, equal_elimh], []));
val Pow_injective_imp = ttop_rule();

read_goal SetThy "Q [ H, Pow(A) = Pow(B), G ]";
expand (use_imp_tac Pow_injective_imp);
val Pow_injective = ttop_rule();



(*The set consisting of Pow(B) for all B in C *)
read_goal SetThy "B:C  ==>   Pow(B) :   \
\	Collect(Pow(Pow(Union(C))), %(y) EXISTS x. x: C & y=Pow(x))  [ H ]";
expand set_tac;  (*2 secs*)


(*CANNOT BE PROVED
  read_goal SetThy "B:C  <=>   Pow(B) :   \
  \	Collect(Pow(Pow(Union(C))), %(y) EXISTS x. x: C & y=Pow(x))  [ H ]";
  expand (unfold_goal_tac ["<=>"]);
  expand set_tac;  
*)


read_goal SetThy "Union(Collect(Pow(Pow(Union(C))), %(y) EXISTS x. x: C & y=Pow(x))) <= Pow(Union(C))  [ H ]";
expand set_tac;  (*2 secs*)


(*CANNOT BE PROVED, NEEDS DERIVED RULES FOR {Pow(B)|B:C}
  read_goal SetThy "~ C=0 ==>   \
  \ Inter(Collect(Pow(Pow(Union(C))), %(y) EXISTS x. x: C & y=Pow(x)))  \
  \     = Pow(Inter(C))  [ H ]";
   *)


(*Clumsy rules for using equality assumptions*)
read_goal SetThy "R [ H, ~ a:A, G]";
expand (rcut_tac "~ b:B" 1);
expand (resolve_tac [imp_intr] 1); 
expand (resolve_tac [imp_elimh RES member_cong ] 1); 
expand (resolve_tac [assume] 3); 
expand (resolve_tac [thin] 3); 
val neg_memb_assume_set = ttop_rule()  RES  refl  RES  assume;
val neg_memb_assume_elem = ttop_rule()  RES  assume  RES  refl;


read_goal SetThy "R [ H, a:A, G]";
expand (rcut_tac "a:B" 1);
expand (resolve_tac [ member_cong RES refl ] 1); 
expand (resolve_tac [assume] 2); 
expand (resolve_tac [thin] 2); 
expand (resolve_tac [sym] 1); 
val memb_assume = ttop_rule()  RES  assume;  (*NOTE!!!*)


(*Fundamental property of the Cartesian product*)
read_goal SetThy "c : A*B  <=>   \
\	EXISTS a. EXISTS b. a: A  &  b: B  &  c = <a,b>  [H]";
expand (unfold_goal_tac ["Pair","*","<=>"]);
expand (new_set1_tac([], [memb_assume, neg_memb_assume_elem]));
(*17 secs*)
val cartesian_iff = ttop_rule();


read_goal SetThy "a: Domain(C)  <=>   EXISTS b. <a,b> : C  [H]";
expand (unfold_goal_tac ["Pair","Domain","<=>"]);
expand set1_tac;  (*4 secs*)
val Domain_iff = ttop_rule();


read_goal SetThy "b: Range(C)  <=>   EXISTS a. <a,b> : C  [H]";
expand (unfold_goal_tac ["Pair","Range","<=>"]);
expand set1_tac;  (*5 secs*)
val Range_iff = ttop_rule();



read_goal SetThy "Domain(A*B) <= A  [H]";
expand (unfold_goal_tac ["Domain","*"]);
expand (new_set1_tac([pairing_injective], [neg_memb_assume_elem]));
val Domain_subset = ttop_rule();


read_goal SetThy "R [H, a: Domain(C), G ]";
expand (rcut_tac "EXISTS b. <a,b> : C" 1);
expand (SELECT_GOAL (unfold_goal_tac ["Pair","Domain","<=>"]) 1);
expand (SELECT_GOAL set1_tac 1);
expand (resolve_tac [exists_elimh] 1);
expand (resolve_tac [thin] 1);
val Domain_elimh = ttop_rule();


read_goal SetThy "R [H, ~ a: Domain(C), G ]";
expand (rcut_tac "~ <a,b> : C" 1);
expand (SELECT_GOAL (unfold_goal_tac ["Pair","Domain","<=>"]) 1);
expand (SELECT_GOAL set1_tac 1);
expand (resolve_tac [thin] 1);
val Domain_right = ttop_rule();


read_goal SetThy "R [H, ~ A=0, G ]";
expand (rcut_tac "EXISTS x. x:A" 1);
expand (resolve_tac [exists_elimh] 2);
expand (resolve_tac [equal_right] 1);
expand (SELECT_GOAL set_tac 1);
expand (SELECT_GOAL set_tac 1);
expand (resolve_tac [thin] 1);
val empty_right = ttop_rule();



(*NOT PROVED*)
read_goal SetThy "~ B=0  ==>  A <= Domain(A*B)  [H]";
expand F_elim_tac;
expand (set_step_tac 1);
expand (resolve_tac [empty_right] 1);
expand (set_step_tac 1);
expand (resolve_tac [Domain_right] 1);
expand (unfold_goal_tac ["Pair","*"]);
