/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import ise.plugin.nav.NavHistoryList;
import ise.plugin.nav.NavPosition;
import ise.plugin.nav.Navigator;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

class NavHistoryPopup
extends JPopupMenu {
    private JList list;
    private View view;
    private boolean numberKeyProcessed = false;
    private NavHistoryList historyList = null;
    private boolean useCSS = false;
    private boolean showGutter = false;

    public NavHistoryPopup(View view, Navigator navigator, Collection<NavPosition> positions) {
        this(view, navigator, positions, null);
    }

    public NavHistoryPopup(View view, Navigator navigator, Collection<NavPosition> positions, NavPosition currentPosition) {
        if (positions == null || positions.size() == 0) {
            return;
        }
        this.view = view;
        this.historyList = new NavHistoryList(view, navigator, positions, currentPosition);
        this.list = this.historyList.list;
        this.add(this.historyList);
        KeyHandler keyHandler = new KeyHandler();
        this.addKeyListener(keyHandler);
        this.historyList.addKeyListener(keyHandler);
        this.view.setKeyEventInterceptor((KeyListener)keyHandler);
        this.historyList.addMouseListener(new MouseHandler());
        this.pack();
        this.setLocation();
        this.setVisible(true);
    }

    @Override
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, super.getPreferredSize().height);
    }

    public void setLocation() {
        JEditTextArea textArea = this.view.getTextArea();
        int caretLine = textArea.getCaretLine();
        textArea.getLineStartOffset(caretLine);
        Rectangle rect = this.view.getGraphicsConfiguration().getBounds();
        Dimension d = this.getSize();
        Point location = new Point(rect.x + (rect.width - d.width) / 2, rect.y + (rect.height - d.height) / 2);
        Dimension screenSize = rect.getSize();
        if (location.x + d.width > screenSize.width) {
            location.x = d.width >= screenSize.width ? rect.x : rect.x + rect.width - d.width - 200;
        }
        if (location.y + d.height > screenSize.height) {
            location.y = screenSize.height - d.height;
        }
        this.setLocation(location);
        textArea = null;
        location = null;
        d = null;
        screenSize = null;
    }

    public void dispose() {
        jEdit.setBooleanProperty((String)"code2html.use-css", (boolean)this.useCSS);
        jEdit.setBooleanProperty((String)"code2html.show-gutter", (boolean)this.showGutter);
        this.view.setKeyEventInterceptor(null);
        this.setVisible(false);
        this.view.getTextArea().requestFocus();
    }

    private void selected() {
        this.historyList.jump();
        this.dispose();
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            NavHistoryPopup.this.selected();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if ((evt = KeyEventWorkaround.processKeyEvent((KeyEvent)evt)) == null) {
                return;
            }
            switch (evt.getKeyChar()) {
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (NavHistoryPopup.this.numberKeyProcessed) {
                        return;
                    }
                    int selected = Character.getNumericValue(evt.getKeyChar()) - 1;
                    if (selected >= 0 && selected < NavHistoryPopup.this.list.getModel().getSize()) {
                        NavHistoryPopup.this.list.setSelectedIndex(selected);
                        NavHistoryPopup.this.selected();
                        NavHistoryPopup.this.numberKeyProcessed = true;
                    }
                    evt.consume();
                }
            }
            evt = null;
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if ((evt = KeyEventWorkaround.processKeyEvent((KeyEvent)evt)) == null) {
                return;
            }
            switch (evt.getKeyCode()) {
                case 9: 
                case 10: {
                    NavHistoryPopup.this.selected();
                    evt.consume();
                    break;
                }
                case 27: {
                    NavHistoryPopup.this.dispose();
                    evt.consume();
                    break;
                }
                case 38: {
                    int selected = NavHistoryPopup.this.list.getSelectedIndex();
                    selected = selected == 0 ? NavHistoryPopup.this.list.getModel().getSize() - 1 : --selected;
                    NavHistoryPopup.this.list.setSelectedIndex(selected);
                    NavHistoryPopup.this.list.ensureIndexIsVisible(selected);
                    evt.consume();
                    break;
                }
                case 40: {
                    int selected = NavHistoryPopup.this.list.getSelectedIndex();
                    selected = selected == NavHistoryPopup.this.list.getModel().getSize() - 1 ? 0 : ++selected;
                    NavHistoryPopup.this.list.setSelectedIndex(selected);
                    NavHistoryPopup.this.list.ensureIndexIsVisible(selected);
                    evt.consume();
                    break;
                }
                case 32: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    evt.consume();
                    break;
                }
                case 33: 
                case 34: {
                    break;
                }
                default: {
                    NavHistoryPopup.this.dispose();
                    evt.consume();
                }
            }
            evt = null;
        }
    }
}

