/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import ise.plugin.nav.NavigatorPlugin;
import ise.plugin.nav.NumberTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;

public class OptionPanel
extends AbstractOptionPane {
    public static final String NAME = "navigator";
    private JCheckBox useNavigatorGoToLine = null;
    private JCheckBox showOnToolbar = null;
    private JCheckBox groupByFile = null;
    private JCheckBox groupByLine = null;
    private JCheckBox showLineText = null;
    private JCheckBox showLineTextSyntax = null;
    private JCheckBox showStripes = null;
    private JCheckBox showPath = null;
    private JCheckBox showLineNumber = null;
    private JCheckBox showCaretOffset = null;
    private JRadioButton viewScope = null;
    private NumberTextField listSize = null;
    private NumberTextField maxStackSize = null;

    public OptionPanel() {
        super(NAME);
    }

    public void _init() {
        this.installComponents();
        this.installListeners();
    }

    private void installComponents() {
        this.setName(NAME);
        this.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        this.addSeparator("navigator.options.separator1.label");
        this.useNavigatorGoToLine = new JCheckBox(jEdit.getProperty((String)"navigator.useNavigatorGoToLine.label", (String)"Use Navigator's 'Go to line' dialog"));
        this.useNavigatorGoToLine.setSelected(jEdit.getBooleanProperty((String)"navigator.useNavigatorGoToLine", (boolean)false));
        this.addComponent(this.useNavigatorGoToLine);
        this.addSeparator("navigator.options.separator2.label");
        this.viewScope = new JRadioButton(jEdit.getProperty((String)"navigator.options.viewScope.label", (String)"View scope"));
        this.viewScope.setName("viewScope");
        JRadioButton editPaneScope = new JRadioButton(jEdit.getProperty((String)"navigator.options.editPaneScope.label", (String)"EditPane scope"));
        editPaneScope.setName("editPaneScope");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.viewScope);
        buttonGroup.add(editPaneScope);
        this.addComponent(this.viewScope);
        this.addComponent(editPaneScope);
        int scope = NavigatorPlugin.getScope();
        this.viewScope.setSelected(scope == 1);
        editPaneScope.setSelected(scope == 2);
        this.addComponent(Box.createVerticalStrut(11));
        this.addSeparator("navigator.options.separator3.label");
        this.showPath = new JCheckBox(jEdit.getProperty((String)"navigator.options.showPath.label", (String)"Show path"));
        this.showPath.setSelected(jEdit.getBooleanProperty((String)"navigator.showPath", (boolean)true));
        this.addComponent(this.showPath);
        this.showLineNumber = new JCheckBox(jEdit.getProperty((String)"navigator.options.showLineNumber.label", (String)"Show line number"));
        this.showLineNumber.setSelected(jEdit.getBooleanProperty((String)"navigator.showLineNumber", (boolean)true));
        this.addComponent(this.showLineNumber);
        this.showCaretOffset = new JCheckBox(jEdit.getProperty((String)"navigator.options.showCaretOffset", (String)"Show caret offset"));
        this.showCaretOffset.setSelected(jEdit.getBooleanProperty((String)"navigator.showCaretOffset", (boolean)true));
        this.addComponent(this.showCaretOffset);
        this.showOnToolbar = new JCheckBox(jEdit.getProperty((String)"navigator.options.showOnToolbar.label"));
        this.showOnToolbar.setName("showOnToolbar");
        this.showOnToolbar.setSelected(NavigatorPlugin.showOnToolBars());
        this.addComponent(this.showOnToolbar);
        this.groupByFile = new JCheckBox(jEdit.getProperty((String)"navigator.options.groupByFile.label"));
        this.groupByFile.setName("groupByFile");
        this.groupByFile.setSelected(NavigatorPlugin.groupByFile());
        this.addComponent(this.groupByFile);
        this.groupByLine = new JCheckBox(jEdit.getProperty((String)"navigator.options.groupByLine.label"));
        this.groupByLine.setName("groupByLine");
        this.groupByLine.setSelected(NavigatorPlugin.groupByLine());
        this.addComponent(this.groupByLine);
        this.showLineText = new JCheckBox(jEdit.getProperty((String)"navigator.options.showLineText.label", (String)"Show line text in history list"));
        this.showLineText.setName("showLineText");
        this.showLineText.setSelected(jEdit.getBooleanProperty((String)"navigator.showLineText", (boolean)true));
        this.addComponent(this.showLineText);
        this.showLineTextSyntax = new JCheckBox(jEdit.getProperty((String)"navigator.options.showLineTextSyntax.label", (String)"Show syntax highlighting in history list"));
        this.showLineTextSyntax.setName("showLineTextSyntax");
        this.showLineTextSyntax.setSelected(jEdit.getBooleanProperty((String)"navigator.showLineText", (boolean)true) && jEdit.getBooleanProperty((String)"navigator.showLineTextSyntax", (boolean)true));
        JPanel syntaxPanel = new JPanel();
        syntaxPanel.add(Box.createHorizontalStrut(11));
        syntaxPanel.add(this.showLineTextSyntax);
        this.addComponent(syntaxPanel);
        this.showStripes = new JCheckBox(jEdit.getProperty((String)"navigator.options.showStripes.label", (String)"Show stripes in history list"));
        this.showStripes.setName("showStripes");
        this.showStripes.setSelected(jEdit.getBooleanProperty((String)"navigator.showStripes", (boolean)true));
        this.addComponent(this.showStripes);
        this.addComponent(Box.createVerticalStrut(11));
        this.listSize = new NumberTextField();
        this.listSize.setName("listSize");
        this.listSize.setMinValue(1);
        this.listSize.setValue(jEdit.getIntegerProperty((String)"listSize", (int)10));
        this.addComponent(jEdit.getProperty((String)"navigator.options.listSize.label", (String)"Visible rows in history list:"), this.listSize);
        this.addComponent(Box.createVerticalStrut(11));
        this.maxStackSize = new NumberTextField();
        this.maxStackSize.setName("maxStackSize");
        this.maxStackSize.setMinValue(1);
        this.maxStackSize.setValue(jEdit.getIntegerProperty((String)"maxStackSize", (int)512));
        this.addComponent(jEdit.getProperty((String)"navigator.options.maxStackSize.label", (String)"Maximum history size:"), this.maxStackSize);
    }

    private void installListeners() {
        this.showLineText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                OptionPanel.this.showLineTextSyntax.setEnabled(OptionPanel.this.showLineText.isSelected());
            }
        });
    }

    public void _save() {
        jEdit.setBooleanProperty((String)"navigator.useNavigatorGoToLine", (boolean)this.useNavigatorGoToLine.isSelected());
        jEdit.setBooleanProperty((String)"navigator.groupByFile", (boolean)this.groupByFile.isSelected());
        jEdit.setBooleanProperty((String)"navigator.groupByLine", (boolean)this.groupByLine.isSelected());
        jEdit.setBooleanProperty((String)"navigator.showOnToolbar", (boolean)this.showOnToolbar.isSelected());
        jEdit.setBooleanProperty((String)"navigator.showLineText", (boolean)this.showLineText.isSelected());
        jEdit.setBooleanProperty((String)"navigator.showLineTextSyntax", (boolean)this.showLineTextSyntax.isSelected());
        jEdit.setBooleanProperty((String)"navigator.showStripes", (boolean)this.showStripes.isSelected());
        jEdit.setIntegerProperty((String)"navigator.listSize", (int)this.listSize.getValue());
        jEdit.setIntegerProperty((String)"navigator.maxStackSize", (int)this.maxStackSize.getValue());
        int scope = this.viewScope.isSelected() ? 1 : 2;
        jEdit.setIntegerProperty((String)"navigator.scope", (int)scope);
        jEdit.setBooleanProperty((String)"navigator.showPath", (boolean)this.showPath.isSelected());
        jEdit.setBooleanProperty((String)"navigator.showLineNumber", (boolean)this.showLineNumber.isSelected());
        jEdit.setBooleanProperty((String)"navigator.showCaretOffset", (boolean)this.showCaretOffset.isSelected());
    }
}

