/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManagerTableModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.IntegerArray;

public class HighlightOverview
extends JPanel
implements HighlightChangeListener {
    private final IntegerArray items;
    private final JEditTextArea textArea;
    private static final int ITEM_HEIGHT = 4;
    private static final int OVERVIEW_WIDTH = 12;
    private static final int ITEM_BORDER = 2;
    private static final int ITEM_WIDTH = 8;
    private static final int Y_OFFSET = 16;
    private static final Dimension preferredSize = new Dimension(12, 0);
    private Color color;

    public HighlightOverview(final JEditTextArea textArea) {
        Font ff = this.getFont();
        Font f = new Font(ff.getName(), 1, 8);
        this.setFont(f);
        this.textArea = textArea;
        this.items = new IntegerArray(32);
        this.setRequestFocusEnabled(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int lineCount = textArea.getLineCount();
                int line = HighlightOverview.this.yToLine(e.getY(), lineCount);
                textArea.setFirstLine(Math.max(line - textArea.getVisibleLines() / 2, 0));
            }
        });
    }

    @Override
    public void highlightUpdated(boolean highlightEnabled) {
        int counter;
        int end;
        this.items.clear();
        if (!highlightEnabled || !HighlightManagerTableModel.currentWordHighlight.isEnabled() && !HighlightManagerTableModel.selectionHighlight.isEnabled()) {
            this.repaint();
            return;
        }
        JEditBuffer buffer = this.textArea.getBuffer();
        boolean endOfLine = buffer.getLineEndOffset(buffer.getLineOfOffset(end = buffer.getLength())) - 1 == end;
        SearchMatcher matcher = HighlightManagerTableModel.selectionHighlight.isEnabled() ? HighlightManagerTableModel.selectionHighlight.getSearchMatcher() : HighlightManagerTableModel.currentWordHighlight.getSearchMatcher();
        try {
            int offset = 0;
            int lastResult = -1;
            counter = 0;
            while (true) {
                boolean startOfLine = buffer.getLineStartOffset(buffer.getLineOfOffset(offset)) == offset;
                SearchMatcher.Match match = null;
                try {
                    match = matcher.nextMatch(buffer.getSegment(offset, end - offset), startOfLine, endOfLine, counter == 0, false);
                }
                catch (PatternSyntaxException ignored) {
                    // empty catch block
                }
                if (match != null) {
                    int nextLine;
                    int newLine = buffer.getLineOfOffset(offset + match.start);
                    if (lastResult != newLine) {
                        this.items.add(newLine);
                        lastResult = newLine;
                    }
                    if ((nextLine = newLine + 1) < buffer.getLineCount()) {
                        offset = buffer.getLineStartOffset(nextLine);
                        ++counter;
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException ie) {
            return;
        }
        View view = this.textArea.getView();
        if (view.isActive() && view.getTextArea() == this.textArea) {
            view.getStatus().setMessage(counter + " lines contains the current word");
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics gfx) {
        super.paintComponent(gfx);
        if (this.items.getSize() == 0) {
            return;
        }
        int lineCount = this.textArea.getLineCount();
        if (this.color != null) {
            gfx.setColor(this.color);
        } else if (HighlightManagerTableModel.selectionHighlight.isEnabled()) {
            gfx.setColor(HighlightManagerTableModel.selectionHighlight.getColor());
        } else {
            gfx.setColor(HighlightManagerTableModel.currentWordHighlight.getColor());
        }
        for (int i = 0; i < this.items.getSize(); ++i) {
            int y = this.lineToY(this.items.get(i), lineCount);
            gfx.fillRect(2, y, 8, 4);
        }
    }

    private int lineToY(int line, int lineCount) {
        return 16 + (this.getHeight() - 32) * line / lineCount - 2;
    }

    private int yToLine(int y, int lineCount) {
        return (y + 2 - 16) * lineCount / (this.getHeight() - 32);
    }

    @Override
    public Dimension getPreferredSize() {
        return preferredSize;
    }

    public void setOverviewColor(Color color) {
        this.color = color;
    }
}

