/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bibtex;
import isabelle.Bibtex$Parsers$;
import isabelle.Bibtex$Token$Kind$;
import isabelle.Completion;
import isabelle.Completion$;
import isabelle.Document;
import isabelle.File$;
import isabelle.Isabelle_System$;
import isabelle.Library$;
import isabelle.Line$;
import isabelle.Long_Name$;
import isabelle.Markup$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Position$;
import isabelle.Position$Line_File$;
import isabelle.Rendering;
import isabelle.Scan$;
import isabelle.Symbol$;
import isabelle.Text;
import isabelle.Value$Int$;
import isabelle.Word$;
import isabelle.XML;
import isabelle.XML$Encode$;
import isabelle.YXML$;
import isabelle.package$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.input.CharSequenceReader;
import scala.util.parsing.input.Reader;

public final class Bibtex$ {
    public static Bibtex$ MODULE$;
    private final List<String> months;
    private final List<String> commands;
    private final List<Bibtex.Entry> known_entries;
    private final Bibtex.Delimited Closed;
    private final List<Tuple2<String, String>> output_styles;

    static {
        new Bibtex$();
    }

    public boolean is_bibtex(String name) {
        return name.endsWith(".bib");
    }

    public List<String> bibtex_errors(Path dir, String root_name) {
        Nil$ nil$;
        Path log_path = dir.$plus(Path$.MODULE$.explode(root_name).ext("blg"));
        if (log_path.is_file()) {
            Regex Error1 = new StringOps(Predef$.MODULE$.augmentString("^(I couldn't open database file .+)$")).r();
            Regex Error2 = new StringOps(Predef$.MODULE$.augmentString("^(.+)---line (\\d+) of file (.+)")).r();
            nil$ = (List)Line$.MODULE$.logical_lines(File$.MODULE$.read(log_path)).flatMap((Function1 & Serializable & scala.Serializable)line -> {
                Iterable iterable;
                String string = line;
                Option option = Error1.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String msg = (String)((LinearSeqOptimized)option.get()).apply(0);
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new StringBuilder(14).append("Bibtex error: ").append(msg).toString()));
                }
                Option option2 = Error2.unapplySeq((CharSequence)string);
                if (option2.isEmpty()) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                if (option2.get() == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                if (((LinearSeqOptimized)option2.get()).lengthCompare(3) != 0) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String msg = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String string2 = (String)((LinearSeqOptimized)option2.get()).apply(1);
                String file = (String)((LinearSeqOptimized)option2.get()).apply(2);
                Option<Object> option3 = Value$Int$.MODULE$.unapply(string2);
                if (option3.isEmpty()) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                int l = BoxesRunTime.unboxToInt((Object)option3.get());
                String path = File$.MODULE$.standard_path(file);
                if (Path$.MODULE$.is_wellformed(path)) {
                    List<Tuple2<String, String>> pos = Position$Line_File$.MODULE$.apply(l, dir.$plus(Path$.MODULE$.explode(path)).canonical().implode());
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new StringBuilder(16).append("Bibtex error").append(Position$.MODULE$.here(pos, Position$.MODULE$.here$default$2())).append(":\n  ").append(msg).toString()));
                    return iterable;
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, List$.MODULE$.canBuildFrom());
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public Tuple2<List<Tuple2<String, List<Tuple2<String, String>>>>, List<Tuple2<String, List<Tuple2<String, String>>>>> check_database(String database) {
        List<Bibtex.Chunk> chunks = this.parse(Line$.MODULE$.normalize(database));
        ObjectRef chunk_pos = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ListBuffer tokens = new ListBuffer();
        IntRef line = IntRef.create((int)1);
        IntRef offset = IntRef.create((int)1);
        chunks.foreach((Function1 & Serializable & scala.Serializable)chunk -> {
            Bibtex$.$anonfun$check_database$2(chunk_pos, tokens, line, offset, chunk);
            return BoxedUnit.UNIT;
        });
        return (Tuple2)Isabelle_System$.MODULE$.with_tmp_dir("bibtex", (Function1 & Serializable & scala.Serializable)tmp_dir -> {
            Tuple2 tuple2;
            Tuple2 tuple22;
            List<String> lines;
            File$.MODULE$.write(tmp_dir.$plus(Path$.MODULE$.explode("root.bib")), (CharSequence)tokens.iterator().map((Function1 & Serializable & scala.Serializable)p -> ((Bibtex.Token)p._1()).source()).mkString("", "\n", "\n"));
            File$.MODULE$.write(tmp_dir.$plus(Path$.MODULE$.explode("root.aux")), (CharSequence)"\\bibstyle{plain}\n\\bibdata{root}\n\\citation{*}");
            Isabelle_System$.MODULE$.bash("\"$ISABELLE_BIBTEX\" root", tmp_dir.file(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9());
            Regex Error2 = new StringOps(Predef$.MODULE$.augmentString("^(.*)---line (\\d+) of file root.bib$")).r();
            Regex Warning = new StringOps(Predef$.MODULE$.augmentString("^Warning--(.+)$")).r();
            Regex Warning_Line = new StringOps(Predef$.MODULE$.augmentString("--line (\\d+) of file root.bib$")).r();
            Regex Warning_in_Chunk = new StringOps(Predef$.MODULE$.augmentString("^Warning--(.+) in (.+)$")).r();
            Path log_file = tmp_dir.$plus(Path$.MODULE$.explode("root.blg"));
            List<String> list = lines = log_file.is_file() ? Line$.MODULE$.logical_lines(File$.MODULE$.read(log_file)) : Nil$.MODULE$;
            if (lines.isEmpty()) {
                tuple22 = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
            } else {
                List list2 = (List)lines.tail();
                tuple22 = tuple2 = ((TraversableLike)((List)lines.zip((GenIterable)new .colon.colon((Object)"", (List)Nil$.MODULE$).$colon$colon$colon(list2), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    String string;
                    Option option;
                    String string2;
                    Option option2;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null && !(option2 = Error2.unapplySeq((CharSequence)(string2 = (String)tuple2._1()))).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                        String msg = (String)((LinearSeqOptimized)option2.get()).apply(0);
                        String string3 = (String)((LinearSeqOptimized)option2.get()).apply(1);
                        Option<Object> option3 = Value$Int$.MODULE$.unapply(string3);
                        if (!option3.isEmpty()) {
                            int l = BoxesRunTime.unboxToInt((Object)option3.get());
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)msg, (Object)Bibtex$.get_line_pos$1(l, tokens)))));
                        }
                    }
                    if (tuple2 != null && !(option = Warning_in_Chunk.unapplySeq((CharSequence)(string = (String)tuple2._1()))).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                        String msg = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String name = (String)((LinearSeqOptimized)option.get()).apply(1);
                        if (((Map)chunk_pos$1.elem).isDefinedAt((Object)name)) {
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)Word$.MODULE$.capitalize(new StringBuilder(10).append(msg).append(" in entry ").append(package$.MODULE$.quote().apply((Object)name)).toString()), ((Map)chunk_pos$1.elem).apply((Object)name)))));
                        }
                    }
                    if (tuple2 != null) {
                        String string4 = (String)tuple2._1();
                        String string5 = (String)tuple2._2();
                        Option option4 = Warning.unapplySeq((CharSequence)string4);
                        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
                            String string6;
                            Option<Object> option5;
                            String msg = (String)((LinearSeqOptimized)option4.get()).apply(0);
                            Option option6 = Warning_Line.unapplySeq((CharSequence)string5);
                            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(1) == 0 && !(option5 = Value$Int$.MODULE$.unapply(string6 = (String)((LinearSeqOptimized)option6.get()).apply(0))).isEmpty()) {
                                int l = BoxesRunTime.unboxToInt((Object)option5.get());
                                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)Word$.MODULE$.capitalize(msg), (Object)Bibtex$.get_line_pos$1(l, tokens)))));
                            }
                        }
                    }
                    if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    String string7 = (String)tuple2._1();
                    Option option7 = Warning.unapplySeq((CharSequence)string7);
                    if (option7.isEmpty()) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    if (option7.get() == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    if (((LinearSeqOptimized)option7.get()).lengthCompare(1) != 0) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    String msg = (String)((LinearSeqOptimized)option7.get()).apply(0);
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)Word$.MODULE$.capitalize(msg), Position$.MODULE$.none()))));
                }, List$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4._1$mcZ$sp()));
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List errors = (List)tuple2._1();
            List warnings = (List)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)errors, (Object)warnings);
            Tuple2 tuple24 = tuple23;
            List errors2 = (List)tuple24._1();
            List warnings2 = (List)tuple24._2();
            return new Tuple2(errors2.map((Function1 & Serializable & scala.Serializable)x$6 -> (Tuple2)x$6._2(), List$.MODULE$.canBuildFrom()), warnings2.map((Function1 & Serializable & scala.Serializable)x$7 -> (Tuple2)x$7._2(), List$.MODULE$.canBuildFrom()));
        });
    }

    public String check_database_yxml(String database) {
        return YXML$.MODULE$.string_of_body((List<XML.Tree>)((List)XML$Encode$.MODULE$.pair(XML$Encode$.MODULE$.list(XML$Encode$.MODULE$.pair(XML$Encode$.MODULE$.string(), XML$Encode$.MODULE$.properties())), XML$Encode$.MODULE$.list(XML$Encode$.MODULE$.pair(XML$Encode$.MODULE$.string(), XML$Encode$.MODULE$.properties()))).apply(this.check_database(database))));
    }

    public List<Text.Info<String>> entries(String text) {
        ListBuffer result = new ListBuffer();
        IntRef offset = IntRef.create((int)0);
        this.parse(text).foreach((Function1 & Serializable & scala.Serializable)chunk -> {
            Bibtex$.$anonfun$entries$1(result, offset, chunk);
            return BoxedUnit.UNIT;
        });
        return result.toList();
    }

    public <A, B extends Document.Model> Iterator<Text.Info<Tuple2<String, B>>> entries_iterator(Map<A, B> models) {
        return models.iterator().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Bibtex$.$anonfun$entries_iterator$1(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Document.Model model = (Document.Model)tuple2._2();
            Iterator iterator = model.bibtex_entries().iterator().map((Function1 & Serializable & scala.Serializable)info -> info.map((Function1 & Serializable & scala.Serializable)x$8 -> new Tuple2(x$8, (Object)model)));
            return iterator;
        });
    }

    public <A, B extends Document.Model> Option<Completion.Result> completion(Completion.History history, Rendering rendering, int caret, Map<A, B> models) {
        return rendering.citation(rendering.before_caret_range(caret)).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Bibtex$.$anonfun$completion$1(check$ifrefutable$2))).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
            Text.Info info = x$16;
            if (info == null) {
                throw new MatchError((Object)info);
            }
            Text.Range r = info.range();
            String name = (String)info.info();
            Option option = Completion$.MODULE$.clean_name(name).flatMap((Function1 & Serializable & scala.Serializable)name1 -> rendering.model().get_text(r).flatMap((Function1 & Serializable & scala.Serializable)original -> Completion$.MODULE$.clean_name(Library$.MODULE$.perhaps_unquote((String)original)).map((Function1 & Serializable & scala.Serializable)original1 -> {
                List entries = MODULE$.entries_iterator(models).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)Bibtex$.$anonfun$completion$6(check$ifrefutable$3))).withFilter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Bibtex$.$anonfun$completion$7(name1, original1, x$10))).map((Function1 & Serializable & scala.Serializable)x$11 -> {
                    String entry;
                    Tuple2 tuple2;
                    Text.Info info = x$11;
                    if (info == null || (tuple2 = (Tuple2)info.info()) == null) {
                        throw new MatchError((Object)info);
                    }
                    String string = entry = (String)tuple2._1();
                    return string;
                }).toList();
                return new Tuple2(original1, (Object)entries);
            }).withFilter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)Bibtex$.$anonfun$completion$9(x$12))).map((Function1 & Serializable & scala.Serializable)x$14 -> {
                Tuple2 tuple2 = x$14;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List entries = (List)tuple2._2();
                List items = ((List)((SeqLike)((List)entries.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    String string = x0$2;
                    String full_name = Long_Name$.MODULE$.qualify(Markup$.MODULE$.CITATION(), string);
                    .colon.colon description = new .colon.colon((Object)string, (List)new .colon.colon((Object)"(BibTeX entry)", (List)Nil$.MODULE$));
                    String replacement = (String)package$.MODULE$.quote().apply((Object)string);
                    Completion.Item item = new Completion.Item(r, (String)original, full_name, (List<String>)description, replacement, 0, false);
                    return item;
                }, List$.MODULE$.canBuildFrom())).sorted(history.ordering())).take(rendering.options().int().apply("completion_limit"));
                Tuple2 tuple22 = new Tuple2((Object)tuple2, (Object)items);
                return tuple22;
            }).map((Function1 & Serializable & scala.Serializable)x$15 -> {
                List items;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x$15;
                        if (tuple2 == null) break block2;
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        items = (List)tuple2._2();
                        if (tuple22 != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                Completion.Result result = new Completion.Result(r, (String)original, false, (List<Completion.Item>)items);
                return result;
            })));
            return option;
        });
    }

    private List<String> months() {
        return this.months;
    }

    public boolean is_month(String s) {
        return this.months().contains((Object)s.toLowerCase());
    }

    private List<String> commands() {
        return this.commands;
    }

    public boolean is_command(String s) {
        return this.commands().contains((Object)s.toLowerCase());
    }

    public List<Bibtex.Entry> known_entries() {
        return this.known_entries;
    }

    public Option<Bibtex.Entry> get_entry(String kind) {
        return this.known_entries().find((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)Bibtex$.$anonfun$get_entry$1(kind, entry)));
    }

    public boolean is_entry(String kind) {
        return this.get_entry(kind).isDefined();
    }

    public Bibtex.Delimited Closed() {
        return this.Closed;
    }

    public Bibtex.Token isabelle$Bibtex$$token(Enumeration.Value kind, String source) {
        return new Bibtex.Token(kind, source);
    }

    public Bibtex.Token isabelle$Bibtex$$keyword(String source) {
        return new Bibtex.Token(Bibtex$Token$Kind$.MODULE$.KEYWORD(), source);
    }

    public List<Bibtex.Chunk> parse(CharSequence input) {
        List list;
        Parsers.ParseResult parseResult = Bibtex$Parsers$.MODULE$.parseAll(Bibtex$Parsers$.MODULE$.rep((Function0 & Serializable & scala.Serializable)() -> Bibtex$Parsers$.MODULE$.chunk()), (Reader<Object>)Scan$.MODULE$.char_reader(input));
        if (parseResult instanceof Parsers.Success) {
            List result;
            Parsers.Success success = (Parsers.Success)parseResult;
            list = result = (List)success.result();
        } else {
            list = (List)package$.MODULE$.error().apply((Object)new StringBuilder(35).append("Unexpected failure to parse input:\n").append(((Object)input).toString()).toString());
        }
        return list;
    }

    public Tuple2<List<Bibtex.Chunk>, Bibtex.Line_Context> parse_line(CharSequence input, Bibtex.Line_Context context) {
        CharSequenceReader in = Scan$.MODULE$.char_reader(input);
        ListBuffer chunks = new ListBuffer();
        Bibtex.Line_Context ctxt = context;
        while (!in.atEnd()) {
            Option option;
            BoxedUnit boxedUnit;
            Parsers.ParseResult<Tuple2<Bibtex.Chunk, Bibtex.Line_Context>> parseResult = Bibtex$Parsers$.MODULE$.parse(Bibtex$Parsers$.MODULE$.chunk_line(ctxt), (Reader<Object>)in);
            if (parseResult instanceof Parsers.Success) {
                Parsers.Success success = (Parsers.Success)parseResult;
                Tuple2 tuple2 = (Tuple2)success.result();
                Reader rest = success.next();
                if (tuple2 != null) {
                    Bibtex.Chunk x = (Bibtex.Chunk)tuple2._1();
                    Bibtex.Line_Context c = (Bibtex.Line_Context)tuple2._2();
                    chunks.$plus$eq((Object)x);
                    ctxt = c;
                    in = rest;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (!(option = Bibtex$Parsers$.MODULE$.NoSuccess().unapply(parseResult)).isEmpty()) {
                Reader rest = (Reader)((Tuple2)option.get())._2();
                boxedUnit = (BoxedUnit)package$.MODULE$.error().apply((Object)new StringBuilder(34).append("Unepected failure to parse input:\n").append(((Object)rest.source()).toString()).toString());
                continue;
            }
            throw new MatchError(parseResult);
        }
        return new Tuple2((Object)chunks.toList(), (Object)ctxt);
    }

    private List<Tuple2<String, String>> output_styles() {
        return this.output_styles;
    }

    public String html_output(List<Path> bib, String title, boolean body, List<String> citations, String style, boolean chronological) {
        return (String)Isabelle_System$.MODULE$.with_tmp_dir("bibtex", (Function1 & Serializable & scala.Serializable)tmp_dir -> {
            String string;
            List bib_files = (List)bib.map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.drop_ext(), List$.MODULE$.canBuildFrom());
            List names0 = (List)bib_files.map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.file_name(), List$.MODULE$.canBuildFrom());
            List bib_names = Library$.MODULE$.duplicates(names0, Library$.MODULE$.duplicates$default$2()).isEmpty() ? names0 : (List)((List)names0.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$26 -> {
                Tuple2 tuple2 = x0$26;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                String string = new StringBuilder(1).append(((Object)BoxesRunTime.boxToInteger((int)(i + 1))).toString()).append("-").append(name).toString();
                return string;
            }, List$.MODULE$.canBuildFrom());
            ((TraversableLike)bib_files.zip((GenIterable)bib_names, List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)Bibtex$.$anonfun$html_output$5(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$35 -> {
                Bibtex$.$anonfun$html_output$6(tmp_dir, x$35);
                return BoxedUnit.UNIT;
            });
            Option option = MODULE$.output_styles().toMap(Predef$.MODULE$.$conforms()).get((Object)style);
            if (option instanceof Some) {
                Some some = (Some)option;
                String base = (String)some.value();
                string = new StringBuilder(4).append(base).append((Object)(chronological ? "c" : "")).append(".bst").toString();
            } else if (None$.MODULE$.equals(option)) {
                string = (String)package$.MODULE$.error().apply((Object)new StringBuilder(47).append("Bad style for bibtex HTML output: ").append(package$.MODULE$.quote().apply((Object)style)).append("\n(expected: ").append(package$.MODULE$.commas_quote().apply(MODULE$.output_styles().map((Function1 & Serializable & scala.Serializable)x$36 -> (String)x$36._1(), List$.MODULE$.canBuildFrom()))).append(")").toString());
            } else {
                throw new MatchError((Object)option);
            }
            String bst = string;
            File$.MODULE$.copy(Path$.MODULE$.explode("$BIB2XHTML_HOME/bst").$plus(Path$.MODULE$.explode(bst)), (Path)tmp_dir);
            Path in_file = Path$.MODULE$.explode("bib.aux");
            Path out_file = Path$.MODULE$.explode("bib.html");
            File$.MODULE$.write(tmp_dir.$plus(in_file), (CharSequence)new StringBuilder(0).append(bib_names.mkString("\\bibdata{", ",", "}\n")).append(((TraversableOnce)citations.map((Function1 & Serializable & scala.Serializable)cite -> new StringBuilder(12).append("\\citation{").append((String)cite).append("}\n").toString(), List$.MODULE$.canBuildFrom())).mkString()).toString());
            String string2 = title;
            String string3 = "";
            Isabelle_System$.MODULE$.bash(new StringBuilder(66).append("\"$BIB2XHTML_HOME/main/bib2xhtml.pl\" -B \"$ISABELLE_BIBTEX\" -u -s ").append(Bash$.MODULE$.string((String)((Option)package$.MODULE$.proper_string().apply((Object)style)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "empty"))).append((Object)(chronological ? " -c" : "")).append((Object)((string2 == null ? string3 != null : !string2.equals(string3)) ? new StringBuilder(5).append(" -h ").append(Bash$.MODULE$.string(title)).append(" ").toString() : "")).append(" ").append(File$.MODULE$.bash_path(in_file)).append(" ").append(File$.MODULE$.bash_path(out_file)).toString(), tmp_dir.file(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9()).check();
            String html = File$.MODULE$.read(tmp_dir.$plus(out_file));
            return body ? (String)package$.MODULE$.cat_lines().apply((Object)((List)package$.MODULE$.split_lines().apply((Object)html)).dropWhile((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)Bibtex$.$anonfun$html_output$10(line))).reverse().dropWhile((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)Bibtex$.$anonfun$html_output$11(line))).reverse()) : html;
        });
    }

    public String html_output$default$2() {
        return "Bibliography";
    }

    public boolean html_output$default$3() {
        return false;
    }

    public List<String> html_output$default$4() {
        return new .colon.colon((Object)"*", (List)Nil$.MODULE$);
    }

    public String html_output$default$5() {
        return "";
    }

    public boolean html_output$default$6() {
        return false;
    }

    private static final List make_pos$1(int length, IntRef line$1, IntRef offset$1) {
        List<Tuple2<String, String>> list = Position$.MODULE$.Offset().apply(offset$1.elem);
        List<Tuple2<String, String>> list2 = Position$.MODULE$.End_Offset().apply(offset$1.elem + length);
        return Position$.MODULE$.Line().apply(line$1.elem).$colon$colon$colon(list2).$colon$colon$colon(list);
    }

    public static final /* synthetic */ void $anonfun$check_database$1(IntRef line$1, IntRef offset$1, String s) {
        if (Symbol$.MODULE$.is_newline(s)) {
            ++line$1.elem;
        }
        ++offset$1.elem;
    }

    private static final void advance_pos$1(Bibtex.Token tok, IntRef line$1, IntRef offset$1) {
        Symbol$.MODULE$.iterator(tok.source()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            Bibtex$.$anonfun$check_database$1(line$1, offset$1, s);
            return BoxedUnit.UNIT;
        });
    }

    private static final List get_line_pos$1(int l, ListBuffer tokens$1) {
        return 0 < l && l <= tokens$1.length() ? (List)((Tuple2)tokens$1.apply(l - 1))._2() : Position$.MODULE$.none();
    }

    public static final /* synthetic */ void $anonfun$check_database$3(ListBuffer tokens$1, IntRef line$1, IntRef offset$1, Bibtex.Token tok) {
        String x$43 = tok.source().replace("\n", " ");
        Enumeration.Value x$44 = tok.copy$default$1();
        tokens$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tok.copy(x$44, x$43)), (Object)Bibtex$.make_pos$1(tok.source().length(), line$1, offset$1)));
        Bibtex$.advance_pos$1(tok, line$1, offset$1);
    }

    public static final /* synthetic */ void $anonfun$check_database$2(ObjectRef chunk_pos$1, ListBuffer tokens$1, IntRef line$1, IntRef offset$1, Bibtex.Chunk chunk) {
        String name;
        String string = name = chunk.name();
        String string2 = "";
        if ((string == null ? string2 != null : !string.equals(string2)) && !((Map)chunk_pos$1.elem).isDefinedAt((Object)name)) {
            chunk_pos$1.elem = ((Map)chunk_pos$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)Bibtex$.make_pos$1(chunk.heading_length(), line$1, offset$1)));
        }
        chunk.tokens().foreach((Function1 & Serializable & scala.Serializable)tok -> {
            Bibtex$.$anonfun$check_database$3(tokens$1, line$1, offset$1, tok);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$entries$1(ListBuffer result$1, IntRef offset$2, Bibtex.Chunk chunk) {
        int end_offset = offset$2.elem + chunk.source().length();
        String string = chunk.name();
        String string2 = "";
        Object object = (string == null ? string2 != null : !string.equals(string2)) && !chunk.is_command() ? result$1.$plus$eq(new Text.Info<String>(new Text.Range(offset$2.elem, end_offset), chunk.name())) : BoxedUnit.UNIT;
        offset$2.elem = end_offset;
    }

    public static final /* synthetic */ boolean $anonfun$entries_iterator$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$completion$1(Text.Info check$ifrefutable$2) {
        Text.Info info = check$ifrefutable$2;
        boolean bl = info != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$completion$6(Text.Info check$ifrefutable$3) {
        Tuple2 tuple2;
        Text.Info info = check$ifrefutable$3;
        boolean bl = info != null && (tuple2 = (Tuple2)info.info()) != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$completion$7(String name1$1, String original1$1, Text.Info x$10) {
        Text.Info info = x$10;
        if (info == null) throw new MatchError((Object)info);
        Tuple2 tuple2 = (Tuple2)info.info();
        if (tuple2 == null) throw new MatchError((Object)info);
        String entry = (String)tuple2._1();
        if (!new StringOps(Predef$.MODULE$.augmentString(entry.toLowerCase())).containsSlice((GenSeq)Predef$.MODULE$.wrapString(name1$1.toLowerCase()))) return false;
        String string = entry;
        String string2 = original1$1;
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$completion$9(Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List entries = (List)tuple2._2();
        boolean bl = entries.nonEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$get_entry$1(String kind$1, Bibtex.Entry entry) {
        String string = entry.kind().toLowerCase();
        String string2 = kind$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$html_output$5(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$html_output$6(Path tmp_dir$1, Tuple2 x$35) {
        Tuple2 tuple2 = x$35;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path a = (Path)tuple2._1();
        String b = (String)tuple2._2();
        File$.MODULE$.copy(a.ext("bib"), tmp_dir$1.$plus(Path$.MODULE$.basic(b).ext("bib")));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$html_output$10(String line) {
        return !line.startsWith("<!-- BEGIN BIBLIOGRAPHY");
    }

    public static final /* synthetic */ boolean $anonfun$html_output$11(String line) {
        return !line.startsWith("<!-- END BIBLIOGRAPHY");
    }

    private Bibtex$() {
        MODULE$ = this;
        this.months = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"}));
        this.commands = new .colon.colon((Object)"preamble", (List)new .colon.colon((Object)"string", (List)Nil$.MODULE$));
        this.known_entries = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bibtex.Entry[]{new Bibtex.Entry("Article", (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"title", (List)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)"journal", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)"volume", (List)new .colon.colon((Object)"number", (List)new .colon.colon((Object)"pages", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"note", (List)Nil$.MODULE$)))))), new Bibtex.Entry("InProceedings", (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"title", (List)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)"booktitle", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$)), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"editor", "volume", "number", "series", "pages", "month", "address", "organization", "publisher", "note"}))), new Bibtex.Entry("InCollection", (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"title", (List)new .colon.colon((Object)"booktitle", (List)Nil$.MODULE$))), (List<String>)new .colon.colon((Object)"publisher", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$)), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"editor", "volume", "number", "series", "type", "chapter", "pages", "edition", "month", "address", "note"}))), new Bibtex.Entry("InBook", (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"editor", (List)new .colon.colon((Object)"title", (List)new .colon.colon((Object)"chapter", (List)Nil$.MODULE$)))), (List<String>)new .colon.colon((Object)"publisher", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$)), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"volume", "number", "series", "type", "address", "edition", "month", "pages", "note"}))), new Bibtex.Entry("Proceedings", (List<String>)new .colon.colon((Object)"title", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$)), (List<String>)Nil$.MODULE$, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booktitle", "editor", "volume", "number", "series", "address", "month", "organization", "publisher", "note"}))), new Bibtex.Entry("Book", (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"editor", (List)new .colon.colon((Object)"title", (List)Nil$.MODULE$))), (List<String>)new .colon.colon((Object)"publisher", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)"volume", (List)new .colon.colon((Object)"number", (List)new .colon.colon((Object)"series", (List)new .colon.colon((Object)"address", (List)new .colon.colon((Object)"edition", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"note", (List)Nil$.MODULE$)))))))), new Bibtex.Entry("Booklet", (List<String>)new .colon.colon((Object)"title", (List)Nil$.MODULE$), (List<String>)Nil$.MODULE$, (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"howpublished", (List)new .colon.colon((Object)"address", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"year", (List)new .colon.colon((Object)"note", (List)Nil$.MODULE$))))))), new Bibtex.Entry("PhdThesis", (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"title", (List)new .colon.colon((Object)"school", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$)))), (List<String>)Nil$.MODULE$, (List<String>)new .colon.colon((Object)"type", (List)new .colon.colon((Object)"address", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"note", (List)Nil$.MODULE$))))), new Bibtex.Entry("MastersThesis", (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"title", (List)new .colon.colon((Object)"school", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$)))), (List<String>)Nil$.MODULE$, (List<String>)new .colon.colon((Object)"type", (List)new .colon.colon((Object)"address", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"note", (List)Nil$.MODULE$))))), new Bibtex.Entry("TechReport", (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"title", (List)new .colon.colon((Object)"institution", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$)))), (List<String>)Nil$.MODULE$, (List<String>)new .colon.colon((Object)"type", (List)new .colon.colon((Object)"number", (List)new .colon.colon((Object)"address", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"note", (List)Nil$.MODULE$)))))), new Bibtex.Entry("Manual", (List<String>)new .colon.colon((Object)"title", (List)Nil$.MODULE$), (List<String>)Nil$.MODULE$, (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"organization", (List)new .colon.colon((Object)"address", (List)new .colon.colon((Object)"edition", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"year", (List)new .colon.colon((Object)"note", (List)Nil$.MODULE$)))))))), new Bibtex.Entry("Unpublished", (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"title", (List)new .colon.colon((Object)"note", (List)Nil$.MODULE$))), (List<String>)Nil$.MODULE$, (List<String>)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"year", (List)Nil$.MODULE$))), new Bibtex.Entry("Misc", (List<String>)Nil$.MODULE$, (List<String>)Nil$.MODULE$, (List<String>)new .colon.colon((Object)"author", (List)new .colon.colon((Object)"title", (List)new .colon.colon((Object)"howpublished", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"year", (List)new .colon.colon((Object)"note", (List)Nil$.MODULE$)))))))}));
        this.Closed = new Bibtex.Delimited(false, 0);
        this.output_styles = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"html-n"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plain"), (Object)"html-n"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alpha"), (Object)"html-a"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"named"), (Object)"html-n"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paragraph"), (Object)"html-n"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsort"), (Object)"html-u"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsortlist"), (Object)"html-u"), (List)Nil$.MODULE$)))))));
    }
}

