/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.print.Paper;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.gjt.sp.jedit.print.BufferPrinter1_7;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrintPreviewPane;
import org.gjt.sp.jedit.print.PrintPreviewPaneUI;

public class BasicPrintPreviewPaneUI
extends PrintPreviewPaneUI
implements ChangeListener {
    private PrintPreviewPane printPreviewPane = null;
    private JScrollPane scrollPane = null;
    private PrintPreviewRenderer printPreviewRenderer = null;

    public static ComponentUI createUI(JComponent c) {
        return new BasicPrintPreviewPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.printPreviewPane = (PrintPreviewPane)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void installDefaults() {
        this.printPreviewPane.setLayout(this.createLayoutManager());
    }

    public void installComponents() {
        this.printPreviewRenderer = new PrintPreviewRenderer();
        this.scrollPane = new JScrollPane(this.printPreviewRenderer);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.printPreviewPane.add((Component)this.scrollPane, "Center");
    }

    public void installListeners() {
        this.printPreviewPane.addChangeListener(this);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.printPreviewPane = null;
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
        this.printPreviewRenderer = null;
    }

    public void uninstallListeners() {
        this.printPreviewPane.removeChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.printPreviewRenderer != null) {
            this.printPreviewRenderer.setSize(this.printPreviewRenderer.getPreferredSize());
            this.printPreviewRenderer.repaint();
        }
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    public class PrintPreviewRenderer
    extends JPanel {
        public Dimension getPaperSize() {
            PrintPreviewModel model = BasicPrintPreviewPaneUI.this.printPreviewPane.getModel();
            if (model != null) {
                PrintRequestAttributeSet attributes = model.getAttributes();
                float zoomLevel = model.getZoomLevel();
                Media media = (Media)attributes.get(Media.class);
                MediaSize mediaSize = null;
                if (media instanceof MediaSizeName) {
                    MediaSizeName name = (MediaSizeName)media;
                    mediaSize = MediaSize.getMediaSizeForName(name);
                    int units = 25400;
                    float dpi = 72.0f * zoomLevel;
                    float paperWidth = mediaSize.getX(units) * dpi;
                    float paperHeight = mediaSize.getY(units) * dpi;
                    Dimension newSize = new Dimension();
                    newSize.setSize(paperWidth, paperHeight);
                    OrientationRequested orientationRequested = (OrientationRequested)attributes.get(OrientationRequested.class);
                    if ((OrientationRequested.LANDSCAPE.equals(orientationRequested) || OrientationRequested.REVERSE_LANDSCAPE.equals(orientationRequested)) && paperWidth < paperHeight) {
                        newSize.setSize(newSize.getHeight(), newSize.getWidth());
                    }
                    return newSize;
                }
                Paper paper = model.getPaper();
                Dimension defaultSize = new Dimension(new Double(paper.getWidth() * (double)zoomLevel).intValue(), new Double(paper.getHeight() * (double)zoomLevel).intValue());
                return defaultSize;
            }
            return this.getSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getPaperSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paintComponent(Graphics gfx) {
            PrintPreviewModel model = BasicPrintPreviewPaneUI.this.printPreviewPane.getModel();
            if (model == null) {
                return;
            }
            super.paintComponent(gfx);
            Dimension currentSize = this.getPaperSize();
            double width = currentSize.getWidth();
            double height = currentSize.getHeight();
            gfx.setColor(Color.WHITE);
            gfx.fillRect(0, 0, new Double(width).intValue(), new Double(height).intValue());
            this.updateModel();
            model.setGraphics(gfx);
            BufferPrinter1_7.printPage(model);
            BasicPrintPreviewPaneUI.this.scrollPane.revalidate();
            BasicPrintPreviewPaneUI.this.printPreviewPane.revalidate();
            BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
        }

        private void updateModel() {
            PrintPreviewModel pageFormat = BasicPrintPreviewPaneUI.this.printPreviewPane.getModel();
            if (pageFormat == null) {
                return;
            }
            PrintRequestAttributeSet attributes = pageFormat.getAttributes();
            float zoomLevel = pageFormat.getZoomLevel();
            MediaPrintableArea mpa = (MediaPrintableArea)attributes.get(MediaPrintableArea.class);
            int units = 25400;
            double dpi = 72.0 * (double)zoomLevel;
            double x = (double)mpa.getX(units) * dpi;
            double y = (double)mpa.getY(units) * dpi;
            double w = (double)mpa.getWidth(units) * dpi;
            double h = (double)mpa.getHeight(units) * dpi;
            Paper paper = new Paper();
            Dimension paperSize = this.getPaperSize();
            paper.setSize(paperSize.getWidth(), paperSize.getHeight());
            int orientation = 1;
            OrientationRequested or = (OrientationRequested)attributes.get(OrientationRequested.class);
            if (OrientationRequested.LANDSCAPE.equals(or)) {
                paper.setSize(paperSize.getHeight(), paperSize.getWidth());
                orientation = 0;
            } else if (OrientationRequested.REVERSE_LANDSCAPE.equals(or)) {
                paper.setSize(paperSize.getHeight(), paperSize.getWidth());
                orientation = 2;
            }
            paper.setImageableArea(x, y, w, h);
            pageFormat.setPaper(paper);
            pageFormat.setOrientation(orientation);
        }
    }
}

