/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.tray;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditServer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.tray.JEditTrayIcon;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.util.StringList;

public class JEditSwingTrayIcon
extends JEditTrayIcon
implements EBComponent {
    private boolean restore;
    private String userDir;
    private String[] args;

    public JEditSwingTrayIcon() {
        super(GUIUtilities.getEditorIcon(), "jEdit");
        this.setImageAutoSize(true);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem newViewItem = new JMenuItem(jEdit.getProperty("tray.newView.label"));
        JMenuItem newPlainViewItem = new JMenuItem(jEdit.getProperty("tray.newPlainView.label"));
        JMenuItem exitItem = new JMenuItem(jEdit.getProperty("tray.exit.label"));
        popup.add(newViewItem);
        popup.add(newPlainViewItem);
        popup.addSeparator();
        popup.add(exitItem);
        MyActionListener actionListener = new MyActionListener(newViewItem, newPlainViewItem, exitItem);
        newViewItem.addActionListener(actionListener);
        newPlainViewItem.addActionListener(actionListener);
        exitItem.addActionListener(actionListener);
        this.setMenu(popup);
        this.addMouseListener(new MyMouseAdapter());
    }

    @Override
    public void handleMessage(EBMessage message) {
        if (message instanceof EditPaneUpdate && ((EditPaneUpdate)message).getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
            StringList sl = new StringList();
            for (View v : jEdit.getViews()) {
                sl.add(v.getTitle());
            }
            this.setToolTip(sl.join(" | "));
        }
    }

    @Override
    void setTrayIconArgs(boolean restore, String userDir, String[] args) {
        this.restore = restore;
        this.userDir = userDir;
        this.args = args;
    }

    private static class MyActionListener
    implements ActionListener {
        private final JMenuItem newViewItem;
        private final JMenuItem newPlainViewItem;
        private final JMenuItem exitItem;

        MyActionListener(JMenuItem newViewItem, JMenuItem newPlainViewItem, JMenuItem exitItem) {
            this.newViewItem = newViewItem;
            this.newPlainViewItem = newPlainViewItem;
            this.exitItem = exitItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.newViewItem) {
                jEdit.newView(null);
            } else if (e.getSource() == this.newPlainViewItem) {
                jEdit.newView(null, null, true);
            } else if (e.getSource() == this.exitItem) {
                jEdit.exit(null, true);
            }
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private final Map<Window, Boolean> windowState = new HashMap<Window, Boolean>();

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (jEdit.getViewCount() == 0) {
                EditServer.handleClient(JEditSwingTrayIcon.this.restore, true, false, JEditSwingTrayIcon.this.userDir, JEditSwingTrayIcon.this.args);
            } else {
                boolean newVisibilityState;
                boolean bl = newVisibilityState = !jEdit.getActiveView().isVisible();
                if (newVisibilityState) {
                    for (Window window : Window.getOwnerlessWindows()) {
                        if (this.skipWindow(window)) continue;
                        Boolean previousState = this.windowState.get(window);
                        if (previousState == null) {
                            window.setVisible(true);
                            continue;
                        }
                        if (!previousState.booleanValue()) continue;
                        window.setVisible(previousState);
                    }
                    this.windowState.clear();
                    if (jEdit.getActiveView().getState() == 1) {
                        jEdit.getActiveView().setState(0);
                    }
                    jEdit.getActiveView().toFront();
                } else {
                    for (Window window : Window.getOwnerlessWindows()) {
                        if (this.skipWindow(window)) continue;
                        this.windowState.put(window, window.isVisible());
                        window.setVisible(false);
                    }
                }
            }
        }

        private boolean skipWindow(Window window) {
            return window.getClass().getName().contains("Tray");
        }
    }
}

