/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class VFSDirectoryEntryTableModel
extends AbstractTableModel {
    Entry[] files;
    private List<ExtendedAttribute> extAttrs = new ArrayList<ExtendedAttribute>();
    private int sortColumnIndex = 0;
    private boolean ascending = true;

    public void setRoot(VFS vfs, List<VFSFile> list) {
        this.extAttrs.clear();
        this.addExtendedAttributes(vfs);
        this.files = new Entry[list.size()];
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i] = new Entry(list.get(i), 0);
        }
        Arrays.sort(this.files, new EntryCompare(this.getSortAttribute(this.sortColumnIndex), this.ascending));
        this.fireTableStructureChanged();
    }

    public int expand(VFS vfs, Entry entry, List<VFSFile> list) {
        int startIndex = -1;
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] != entry) continue;
            startIndex = i;
        }
        if (startIndex != -1) {
            this.collapse(vfs, startIndex);
        }
        this.addExtendedAttributes(vfs);
        entry.expanded = true;
        if (list != null) {
            Entry[] newFiles = new Entry[this.files.length + list.size()];
            Entry[] subdirFiles = new Entry[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                subdirFiles[i] = new Entry(list.get(i), entry.level + 1, entry);
            }
            Arrays.sort(subdirFiles, new EntryCompare(this.getSortAttribute(this.sortColumnIndex), this.ascending));
            int nextIndex = startIndex + 1;
            System.arraycopy(this.files, 0, newFiles, 0, nextIndex);
            System.arraycopy(subdirFiles, 0, newFiles, nextIndex, list.size());
            System.arraycopy(this.files, nextIndex, newFiles, nextIndex + list.size(), this.files.length - nextIndex);
            this.files = newFiles;
        }
        this.fireTableStructureChanged();
        return startIndex;
    }

    public void collapse(VFS vfs, int index) {
        int lastIndex;
        Entry entry = this.files[index];
        if (!entry.expanded) {
            return;
        }
        entry.expanded = false;
        for (lastIndex = index + 1; lastIndex < this.files.length; ++lastIndex) {
            Entry e = this.files[lastIndex];
            if (e.level <= entry.level) break;
            if (!e.expanded) continue;
            this.removeExtendedAttributes(VFSManager.getVFSForPath(e.dirEntry.getPath()));
        }
        this.removeExtendedAttributes(vfs);
        Entry[] newFiles = new Entry[this.files.length - lastIndex + index + 1];
        System.arraycopy(this.files, 0, newFiles, 0, index + 1);
        System.arraycopy(this.files, lastIndex, newFiles, index + 1, this.files.length - lastIndex);
        this.files = newFiles;
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return 1 + this.extAttrs.size();
    }

    @Override
    public int getRowCount() {
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return jEdit.getProperty("vfs.browser.name");
        }
        return jEdit.getProperty("vfs.browser." + this.getExtendedAttribute(col));
    }

    public Class getColumnClass(int col) {
        return Entry.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.files == null) {
            return null;
        }
        return this.files[row];
    }

    public boolean getAscending() {
        return this.ascending;
    }

    public int getSortColumnIndex() {
        return this.sortColumnIndex;
    }

    public String getSortAttribute(int column) {
        return column == 0 ? "name" : this.getExtendedAttribute(column);
    }

    public boolean sortByColumn(int columnIndex) {
        this.ascending = this.sortColumnIndex != columnIndex || !this.ascending;
        String sortBy = this.getSortAttribute(columnIndex);
        if (sortBy == "status") {
            return false;
        }
        Arrays.sort(this.files, new EntryCompare(sortBy, this.ascending));
        this.sortColumnIndex = columnIndex;
        this.fireTableStructureChanged();
        return true;
    }

    public String getExtendedAttribute(int index) {
        return this.extAttrs.get((int)(index - 1)).name;
    }

    public int getColumnWidth(int index) {
        String extAttr = this.getExtendedAttribute(index);
        return jEdit.getIntegerProperty("vfs.browser." + extAttr + ".width", 100);
    }

    public void saveColumnWidth(int index, int w) {
        String extAttr = this.getExtendedAttribute(index);
        jEdit.setIntegerProperty("vfs.browser." + extAttr + ".width", w);
    }

    protected void columnMoved(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        if (fromIndex < 1 || fromIndex > this.getColumnCount()) {
            return;
        }
        if (toIndex < 1 || toIndex > this.getColumnCount()) {
            return;
        }
        ExtendedAttribute ea = this.extAttrs.remove(fromIndex - 1);
        this.extAttrs.add(toIndex - 1, ea);
        if (this.sortColumnIndex == fromIndex) {
            this.sortColumnIndex = toIndex;
        } else if (this.sortColumnIndex == toIndex) {
            this.sortColumnIndex = fromIndex;
        }
    }

    public VFSFile[] getFiles() {
        VFSFile[] f = new VFSFile[this.files.length];
        for (int i = 0; i < f.length; ++i) {
            f[i] = this.files[i].dirEntry;
        }
        return f;
    }

    private void addExtendedAttributes(VFS vfs) {
        String[] attrs = vfs.getExtendedAttributes();
        block0: for (int i = 0; i < attrs.length; ++i) {
            for (ExtendedAttribute attr : this.extAttrs) {
                if (!attrs[i].equals(attr.name)) continue;
                ++attr.ref;
                continue block0;
            }
            this.extAttrs.add(new ExtendedAttribute(attrs[i]));
        }
    }

    private void removeExtendedAttributes(VFS vfs) {
        String[] attrs = vfs.getExtendedAttributes();
        block0: for (int i = 0; i < attrs.length; ++i) {
            Iterator<ExtendedAttribute> iter = this.extAttrs.iterator();
            while (iter.hasNext()) {
                ExtendedAttribute attr = iter.next();
                if (!attrs[i].equals(attr.name)) continue;
                if (--attr.ref != 0) continue block0;
                iter.remove();
                continue block0;
            }
            Log.log(7, this, "We forgot about " + attrs[i]);
        }
    }

    static class EntryCompare
    implements Comparator<Entry> {
        private boolean sortIgnoreCase;
        private boolean sortMixFilesAndDirs = jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs");
        private boolean sortAscending;
        private String sortAttribute;

        EntryCompare(String sortBy, boolean ascending) {
            this.sortIgnoreCase = jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase");
            this.sortAscending = ascending;
            this.sortAttribute = sortBy;
        }

        @Override
        public int compare(Entry entry1, Entry entry2) {
            if (entry1.level < entry2.level) {
                return this.compare(entry1, entry2.parent);
            }
            if (entry1.level > entry2.level) {
                return this.compare(entry1.parent, entry2);
            }
            if (entry1.parent != entry2.parent) {
                return this.compare(entry1.parent, entry2.parent);
            }
            VFSFile file1 = entry1.dirEntry;
            VFSFile file2 = entry2.dirEntry;
            if (!this.sortMixFilesAndDirs && file1.getType() != file2.getType()) {
                return file2.getType() - file1.getType();
            }
            int result = this.sortAttribute == "modified" ? Long.valueOf(file1.getModified()).compareTo(file2.getModified()) : (this.sortAttribute == "size" ? Long.valueOf(file1.getLength()).compareTo(file2.getLength()) : (this.sortAttribute == "type" ? StandardUtilities.compareStrings(entry1.extension, entry2.extension, this.sortIgnoreCase) : StandardUtilities.compareStrings(file1.getName(), file2.getName(), this.sortIgnoreCase)));
            return this.sortAscending ? result : -result;
        }
    }

    static class ExtendedAttribute {
        int ref;
        String name;

        ExtendedAttribute(String name) {
            this.name = name;
            this.ref = 1;
        }
    }

    static class Entry {
        VFSFile dirEntry;
        boolean expanded;
        int level;
        Entry parent;
        String extension;

        Entry(VFSFile dirEntry, int level, Entry parent) {
            this(dirEntry, level);
            this.parent = parent;
        }

        Entry(VFSFile dirEntry, int level) {
            this.dirEntry = dirEntry;
            this.level = level;
            this.extension = MiscUtilities.getFileExtension(dirEntry.getName());
        }
    }
}

