/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.jEdit;

public class AbstractOptionPane
extends JPanel
implements OptionPane {
    protected boolean initialized;
    protected GridBagLayout gridBag;
    protected int y;
    private final String name;

    public AbstractOptionPane(String internalName) {
        this.name = internalName;
        this.gridBag = new GridBagLayout();
        this.setLayout(this.gridBag);
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public final void init() {
        if (!this.initialized) {
            this.initialized = true;
            this._init();
        }
    }

    @Override
    public final void save() {
        if (this.initialized) {
            this._save();
        }
    }

    public JLabel newLabel(String label, Component comp) {
        JLabel retval = new JLabel(label);
        try {
            JComponent jc = (JComponent)comp;
            String tttext = jc.getToolTipText();
            retval.setToolTipText(tttext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public void addComponent(String label, Component comp) {
        JLabel l = this.newLabel(label, comp);
        l.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
        this.addComponent(l, comp, 1);
    }

    public void addComponent(String label, Component comp, int fill) {
        JLabel l = this.newLabel(label, comp);
        l.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
        this.addComponent(l, comp, fill);
    }

    public void addComponent(Component comp1, Component comp2) {
        this.addComponent(comp1, comp2, 1);
    }

    public void addComponent(Component comp1, Component comp2, int fill) {
        AbstractOptionPane.copyToolTips(comp1, comp2);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.insets = new Insets(6, 0, 0, 6);
        cons.fill = 1;
        this.gridBag.setConstraints(comp1, cons);
        this.add(comp1);
        cons.fill = fill;
        cons.gridx = 1;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(comp2, cons);
        this.add(comp2);
    }

    public void addComponent(Component comp) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = new Insets(6, 0, 0, 0);
        this.gridBag.setConstraints(comp, cons);
        this.add(comp);
    }

    public void addComponent(Component comp, int fill) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = fill;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = new Insets(6, 0, 0, 0);
        this.gridBag.setConstraints(comp, cons);
        this.add(comp);
    }

    private static void copyToolTips(Component c1, Component c2) {
        JComponent jc2;
        String tooltip2;
        if (!(c1 instanceof JComponent) || !(c2 instanceof JComponent)) {
            return;
        }
        JComponent jc1 = (JComponent)c1;
        String tooltip = jc1.getToolTipText();
        int tooltips = 0;
        if (tooltip != null && !tooltip.isEmpty()) {
            ++tooltips;
        }
        if ((tooltip2 = (jc2 = (JComponent)c2).getToolTipText()) != null && !tooltip2.isEmpty()) {
            tooltip = tooltip2;
            ++tooltips;
        }
        if (tooltips == 1) {
            jc1.setToolTipText(tooltip);
            jc2.setToolTipText(tooltip);
        }
    }

    public void addSeparator() {
        this.addComponent(Box.createVerticalStrut(6));
        JSeparator sep = new JSeparator(0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 1;
        cons.anchor = 17;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(sep, cons);
        this.add(sep);
        this.addComponent(Box.createVerticalStrut(6));
    }

    public void addSeparator(String label) {
        if (this.y != 0) {
            this.addComponent(Box.createVerticalStrut(6));
        }
        Box box = new Box(0);
        Box box2 = new Box(1);
        box2.add(Box.createGlue());
        box2.add(new JSeparator(0));
        box2.add(Box.createGlue());
        box.add(box2);
        JLabel l = new JLabel(jEdit.getProperty(label));
        l.setMaximumSize(l.getPreferredSize());
        box.add(l);
        Box box3 = new Box(1);
        box3.add(Box.createGlue());
        box3.add(new JSeparator(0));
        box3.add(Box.createGlue());
        box.add(box3);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 1;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = new Insets(6, 0, 0, 0);
        this.gridBag.setConstraints(box, cons);
        this.add(box);
    }

    protected void _init() {
    }

    protected void _save() {
    }
}

